/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleInputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleOutputInterface;
import com.sas.graphics.components.pfd.ui.PFDDialogUtil;
import com.sas.graphics.components.pfd.ui.PFDNodeSelectorPanel;
import com.sas.graphics.components.pfd.ui.PFDTable;
import com.sas.graphics.components.pfd.ui.RB;
import com.sas.swing.util.EnableHelpUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PFDNodeConnectionsPanel
extends JPanel
implements ListSelectionListener,
FocusListener {
    private static final String RB_KEY = "PFDNodeConnectionsPanel.";
    private PFDAbstractNode connectionNode;
    private JButton okButton;
    private JButton cancelButton;
    private JTable inputTable;
    private JTable outputTable;
    private Hashtable originalInputLinks;
    private Hashtable originalOutputLinks;
    private NodeConnectionsModel inputModel;
    private NodeConnectionsModel outputModel;
    private static final int defaultNumRowsVisible = 12;
    private static final int defaultTableWidth = 300;
    private static final int maxPortColumnWidth = 100;
    private static final Color gridColor = new Color(211, 211, 185);
    private static final int rowHeight = 21;
    private static final int cellPadding = 2;
    private final Color portColumnBackgroundColor = new Color(243, 243, 243);
    private PFDView view;
    public static final String CLOSE_VALUE_PROPERTY = "closeValue";
    public static final String UNINITIALIZED_VALUE = "valueUninitialized";
    public static final String OK_VALUE = "valueOK";
    public static final String CANCEL_VALUE = "valueCancel";
    private String closeValue = "valueUninitialized";
    private static final String ACTION_KEY_ENTER = "PFDNodeConnectionsPanel.actionKeyEnter";

    public PFDNodeConnectionsPanel(PFDView view) {
        this.view = view;
        this.init();
    }

    public void setSASJavaHelp(String docProd, String id) {
        if (docProd != null) {
            EnableHelpUtil.enableHelpKey((Component)this, (String)docProd, (String)id, (String)"version");
        } else {
            this.getInputMap().put(KeyStroke.getKeyStroke(156, 0), null);
            this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), null);
        }
    }

    public String getCloseValue() {
        return this.closeValue;
    }

    public void setCloseValue(String closeValue) {
        String oldValue = this.closeValue;
        this.closeValue = closeValue;
        this.firePropertyChange(CLOSE_VALUE_PROPERTY, oldValue, closeValue);
    }

    private void init() {
        this.originalInputLinks = new Hashtable();
        this.originalOutputLinks = new Hashtable();
        this.createGui();
        this.initKeyBindings();
    }

    private void initKeyBindings() {
        this.inputTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_KEY_ENTER);
        this.inputTable.getActionMap().put(ACTION_KEY_ENTER, new EnterKeyAction());
        this.outputTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_KEY_ENTER);
        this.outputTable.getActionMap().put(ACTION_KEY_ENTER, new EnterKeyAction());
    }

    public void setConnectionNode(PFDAbstractNode connectionNode) {
        this.connectionNode = connectionNode;
        this.initFromSource();
    }

    public PFDAbstractNode getConnectionNode() {
        return this.connectionNode;
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainTablesPanel(), "Center");
        this.add((Component)this.getButtonsPanel(), "South");
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setHgap(6);
        layout.setVgap(0);
        panel.setLayout(layout);
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PFDNodeConnectionsPanel.this.setCloseValue(PFDNodeConnectionsPanel.OK_VALUE);
            }
        };
        okAction.putValue("Name", PFDDialogUtil.getOKButtonText());
        this.okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PFDNodeConnectionsPanel.this.setCloseValue(PFDNodeConnectionsPanel.CANCEL_VALUE);
            }
        };
        cancelAction.putValue("Name", PFDDialogUtil.getCancelButtonText());
        this.cancelButton = new JButton(cancelAction);
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        panel.setBorder(new EmptyBorder(11, 0, 11, 5));
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)new JPanel(), "Center");
        buttonsPanel.add((Component)panel, "East");
        return buttonsPanel;
    }

    private JPanel getMainTablesPanel() {
        JPanel panel = new JPanel();
        GridLayout layout = new GridLayout(1, 2);
        layout.setHgap(6);
        panel.setLayout(layout);
        panel.add(this.getInputsPanel());
        panel.add(this.getOutputsPanel());
        EmptyBorder border = new EmptyBorder(11, 11, 11, 11);
        panel.setBorder(border);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "Center");
        panel2.add((Component)PFDDialogUtil.getSeperatorComponent(), "South");
        return panel2;
    }

    private JPanel getInputsPanel() {
        JPanel inputsPanel = new JPanel(new BorderLayout());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        JLabel title = new JLabel(RB.getStringResource(RB_KEY, "inputPortsTableTitle.txt"));
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)new JPanel(), "Center");
        inputsPanel.add((Component)titlePanel, "North");
        inputsPanel.add((Component)this.getInputPortsScrollPane(), "Center");
        return inputsPanel;
    }

    private JPanel getOutputsPanel() {
        JPanel outputsPanel = new JPanel(new BorderLayout());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        JLabel title = new JLabel(RB.getStringResource(RB_KEY, "outputPortsTableTitle.txt"));
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)new JPanel(), "Center");
        outputsPanel.add((Component)titlePanel, "North");
        outputsPanel.add((Component)this.getOutputPortsScrollPane(), "Center");
        return outputsPanel;
    }

    private JScrollPane getInputPortsScrollPane() {
        this.inputModel = new NodeConnectionsModel(0);
        this.inputTable = this.createNewTable(this.inputModel);
        JScrollPane scroll = new JScrollPane(this.inputTable);
        return scroll;
    }

    private JScrollPane getOutputPortsScrollPane() {
        this.outputModel = new NodeConnectionsModel(1);
        this.outputTable = this.createNewTable(this.outputModel);
        JScrollPane scroll = new JScrollPane(this.outputTable);
        return scroll;
    }

    private JTable createNewTable(TableModel tm) {
        PFDTable table = new PFDTable();
        ((JTable)table).setModel(tm);
        table.setDefaultRenderer(NodeCellEntry.class, new PFDNodeCellRenderer());
        table.setDefaultEditor(NodeCellEntry.class, new PFDNodeCellEditor());
        DefaultTableCellRenderer portCellRenderer = new DefaultTableCellRenderer();
        portCellRenderer.setBackground(this.portColumnBackgroundColor);
        table.getColumnModel().getColumn(0).setCellRenderer(portCellRenderer);
        table.setColumnBackground(this.portColumnBackgroundColor, 0);
        table.addMouseMotionListener(new TableEditorMouseMotionListener(table));
        table.setSelectionMode(0);
        table.setGridColor(gridColor);
        table.setRowHeight(21);
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.getSelectionModel().addListSelectionListener(this);
        table.addFocusListener(this);
        table.setAutoResizeMode(3);
        return table;
    }

    private void initTableSizes() {
        TableColumnModel inColModel = this.inputTable.getColumnModel();
        TableColumnModel outColModel = this.outputTable.getColumnModel();
        TableColumn inPortColumn = inColModel.getColumn(0);
        TableColumn outPortColumn = outColModel.getColumn(0);
        int inPortColPrefWidth = this.getPortColumnWidth(this.inputTable);
        int outPortColPrefWidth = this.getPortColumnWidth(this.outputTable);
        inPortColPrefWidth = Math.min(inPortColPrefWidth, 100);
        outPortColPrefWidth = Math.min(outPortColPrefWidth, 100);
        inPortColumn.setPreferredWidth(inPortColPrefWidth);
        outPortColumn.setPreferredWidth(outPortColPrefWidth);
        TableColumn inNodeColumn = inColModel.getColumn(1);
        TableColumn outNodeColumn = outColModel.getColumn(1);
        inNodeColumn.setPreferredWidth(300 - inPortColPrefWidth);
        outNodeColumn.setPreferredWidth(300 - outPortColPrefWidth);
        int prefHeight = 252;
        int prefWidth = 300;
        this.inputTable.setPreferredScrollableViewportSize(new Dimension(prefWidth, prefHeight));
        this.outputTable.setPreferredScrollableViewportSize(new Dimension(prefWidth, prefHeight));
    }

    private int getPortColumnWidth(JTable table) {
        TableModel model = table.getModel();
        TableCellRenderer renderer = table.getDefaultRenderer(model.getColumnClass(0));
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        TableColumn column = table.getColumnModel().getColumn(0);
        Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        int headerWidth = comp.getPreferredSize().width;
        int cellWidth = 0;
        for (int j = 0; j < table.getRowCount(); ++j) {
            comp = renderer.getTableCellRendererComponent(table, model.getValueAt(j, 0), false, false, j, 0);
            cellWidth = Math.max(cellWidth, comp.getPreferredSize().width + 2);
        }
        return Math.max(headerWidth, cellWidth);
    }

    private void initFromSource() {
        this.setCloseValue(UNINITIALIZED_VALUE);
        this.initOriginalLinks();
        this.initInputTableFromSource(false);
        this.initOutputTableFromSource(false);
        if (this.inputTable.getRowCount() > 0) {
            this.inputTable.setRowSelectionInterval(0, 0);
        } else if (this.outputTable.getRowCount() > 0) {
            this.outputTable.setRowSelectionInterval(0, 0);
        }
        this.initTableSizes();
        this.inputTable.requestFocusInWindow();
    }

    private void initInputTableFromSource(boolean retainSelection) {
        int selection = this.inputTable.getSelectedRow();
        if (this.inputTable.isEditing()) {
            this.inputTable.removeEditor();
        }
        this.inputModel.updateData();
        if (retainSelection && selection >= 0) {
            this.inputTable.setRowSelectionInterval(selection, selection);
        }
    }

    private void initOutputTableFromSource(boolean retainSelection) {
        int selection = this.outputTable.getSelectedRow();
        if (this.outputTable.isEditing()) {
            this.outputTable.removeEditor();
        }
        this.outputModel.updateData();
        if (retainSelection && selection >= 0) {
            this.outputTable.setRowSelectionInterval(selection, selection);
        }
    }

    private void removeLink(PFDLink link) {
        if (link == null || this.view == null || this.view.getModel() == null) {
            return;
        }
        PFDAbstractNode fromNode = link.getFromPort().getParentNode();
        this.view.getModel().removePrimitive(link);
        if (this.connectionNode == fromNode) {
            this.initOutputTableFromSource(true);
        } else {
            this.initInputTableFromSource(true);
        }
    }

    private void createLink(PFDPort fromPort, PFDPort toPort) {
        if (fromPort == null || toPort == null || this.view == null) {
            return;
        }
        this.view.createLink(fromPort, toPort, null);
        if (this.connectionNode == fromPort.getParentNode()) {
            this.initOutputTableFromSource(true);
        } else {
            this.initInputTableFromSource(true);
        }
    }

    private void redirectLinkTo(PFDLink link, PFDPort toPort) {
        if (this.view != null) {
            this.view.redirectLinkTo(link, toPort);
            this.initOutputTableFromSource(true);
        }
    }

    private void redirectLinkFrom(PFDLink link, PFDPort fromPort) {
        if (this.view != null) {
            this.view.redirectLinkFrom(link, fromPort);
            this.initInputTableFromSource(true);
        }
    }

    private void initOriginalLinks() {
        PFDPort p;
        int i;
        this.originalInputLinks.clear();
        this.originalOutputLinks.clear();
        if (this.connectionNode == null) {
            return;
        }
        if (this.connectionNode instanceof PFDMultipleInputInterface) {
            PFDMultipleInputInterface mii = (PFDMultipleInputInterface)((Object)this.connectionNode);
            for (i = 0; i < mii.getNumInputPorts(); ++i) {
                p = mii.getInputPort(i);
                this.addOriginalInputLinks(p);
            }
        } else {
            this.addOriginalInputLinks(this.connectionNode.getInputPort());
        }
        if (this.connectionNode instanceof PFDMultipleOutputInterface) {
            PFDMultipleOutputInterface moi = (PFDMultipleOutputInterface)((Object)this.connectionNode);
            for (i = 0; i < moi.getNumOutputPorts(); ++i) {
                p = moi.getOutputPort(i);
                this.addOriginalOutputLinks(p);
            }
        } else {
            this.addOriginalOutputLinks(this.connectionNode.getOutputPort());
        }
    }

    private void addOriginalInputLinks(PFDPort toPort) {
        if (toPort == null) {
            return;
        }
        Vector links = toPort.getToLinks();
        if (links == null || links.isEmpty()) {
            return;
        }
        Vector<PFDLink> originalLinks = new Vector<PFDLink>();
        Vector<PFDPort> originalPorts = new Vector<PFDPort>();
        for (int i = 0; i < links.size(); ++i) {
            PFDLink l = (PFDLink)links.get(i);
            originalLinks.add(l);
            originalPorts.add(l.getFromPort());
        }
        this.originalInputLinks.put(toPort, new List[]{originalLinks, originalPorts});
    }

    private void addOriginalOutputLinks(PFDPort fromPort) {
        if (fromPort == null) {
            return;
        }
        Vector links = fromPort.getFromLinks();
        if (links == null || links.isEmpty()) {
            return;
        }
        Vector<PFDLink> originalLinks = new Vector<PFDLink>();
        Vector<PFDPort> originalPorts = new Vector<PFDPort>();
        for (int i = 0; i < links.size(); ++i) {
            PFDLink l = (PFDLink)links.get(i);
            originalLinks.add(l);
            originalPorts.add(l.getToPort());
        }
        this.originalOutputLinks.put(fromPort, new List[]{originalLinks, originalPorts});
    }

    public void restoreOriginalLinks() {
        PFDPort p;
        int i;
        if (this.connectionNode == null) {
            return;
        }
        if (this.connectionNode instanceof PFDMultipleInputInterface) {
            PFDMultipleInputInterface mii = (PFDMultipleInputInterface)((Object)this.connectionNode);
            for (i = 0; i < mii.getNumInputPorts(); ++i) {
                p = mii.getInputPort(i);
                this.restoreOriginalInputLinks(p);
            }
        } else {
            this.restoreOriginalInputLinks(this.connectionNode.getInputPort());
        }
        if (this.connectionNode instanceof PFDMultipleOutputInterface) {
            PFDMultipleOutputInterface moi = (PFDMultipleOutputInterface)((Object)this.connectionNode);
            for (i = 0; i < moi.getNumOutputPorts(); ++i) {
                p = moi.getOutputPort(i);
                this.restoreOriginalOutputLinks(p);
            }
        } else {
            this.restoreOriginalOutputLinks(this.connectionNode.getOutputPort());
        }
    }

    private void restoreOriginalInputLinks(PFDPort toPort) {
        if (toPort == null) {
            return;
        }
        Vector currentLinks = toPort.getToLinks();
        Object o = this.originalInputLinks.get(toPort);
        if (!(o instanceof List[])) {
            this.removeLinks(currentLinks);
        } else {
            List originalLinks = ((List[])o)[0];
            List originalFromPorts = ((List[])o)[1];
            for (int i = 0; i < originalLinks.size(); ++i) {
                PFDLink originalLink = (PFDLink)originalLinks.get(i);
                int currentLinkIndex = currentLinks.indexOf(originalLink);
                if (currentLinkIndex < 0) {
                    this.view.createLink((PFDPort)originalFromPorts.get(i), toPort, originalLink);
                    continue;
                }
                this.view.redirectLinkFrom(originalLink, (PFDPort)originalFromPorts.get(i));
                currentLinks.remove(currentLinkIndex);
            }
            this.removeLinks(currentLinks);
        }
    }

    private void restoreOriginalOutputLinks(PFDPort fromPort) {
        if (fromPort == null) {
            return;
        }
        Vector currentLinks = fromPort.getFromLinks();
        Object o = this.originalOutputLinks.get(fromPort);
        if (!(o instanceof List[])) {
            this.removeLinks(currentLinks);
        } else {
            List originalLinks = ((List[])o)[0];
            List originalToPorts = ((List[])o)[1];
            for (int i = 0; i < originalLinks.size(); ++i) {
                PFDLink originalLink = (PFDLink)originalLinks.get(i);
                int currentLinkIndex = currentLinks.indexOf(originalLink);
                if (currentLinkIndex < 0) {
                    this.view.createLink(fromPort, (PFDPort)originalToPorts.get(i), originalLink);
                    continue;
                }
                this.view.redirectLinkTo(originalLink, (PFDPort)originalToPorts.get(i));
                currentLinks.remove(currentLinkIndex);
            }
            this.removeLinks(currentLinks);
        }
    }

    private void removeLinks(List links) {
        if (links == null || links.isEmpty() || this.view == null || this.view.getModel() == null) {
            return;
        }
        for (int i = 0; i < links.size(); ++i) {
            Object o = links.get(i);
            if (!(o instanceof PFDLink)) continue;
            this.view.getModel().removePrimitive((PFDLink)o);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int editRow;
        JTable sourceTable;
        ListSelectionModel sourceModel = (ListSelectionModel)e.getSource();
        JTable jTable = sourceTable = sourceModel == this.inputTable.getSelectionModel() ? this.inputTable : this.outputTable;
        if (sourceTable.isEditing() && (editRow = sourceTable.getEditingRow()) >= e.getFirstIndex() && editRow <= e.getLastIndex()) {
            sourceTable.editCellAt(editRow, sourceTable.getEditingColumn());
        }
        if (sourceModel.getMinSelectionIndex() >= 0) {
            if (sourceTable == this.inputTable) {
                this.outputTable.clearSelection();
            } else {
                this.inputTable.clearSelection();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        JTable table = (JTable)e.getSource();
        if (table.getRowCount() == 0) {
            return;
        }
        int focusRow = table.getSelectionModel().getLeadSelectionIndex();
        if (focusRow < 0 || focusRow >= table.getRowCount()) {
            table.setRowSelectionInterval(0, 0);
        } else {
            table.setRowSelectionInterval(focusRow, focusRow);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTable table = (JTable)e.getSource();
        table.getSelectionModel().setLeadSelectionIndex(-1);
    }

    private class EnterKeyAction
    extends AbstractAction {
        private EnterKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int focusRow;
            JTable table = (JTable)e.getSource();
            NodeCellEntry entry = (NodeCellEntry)table.getValueAt(focusRow = table.getSelectionModel().getLeadSelectionIndex(), 1);
            Action action = entry.getAction();
            if (action != null) {
                action.actionPerformed(e);
            }
        }
    }

    private class NodeConnectionsModel
    extends AbstractTableModel {
        public static final int TYPE_INPUT = 0;
        public static final int TYPE_OUTPUT = 1;
        public static final int PORT_COLUMN = 0;
        public static final int NODE_COLUMN = 1;
        private List ports;
        private List connectedNodes;
        private List[] data;
        private String portHeader;
        private String connectedNodeHeader;
        private int type = 0;

        public NodeConnectionsModel(int type) {
            this.setType(type);
            this.ports = new Vector();
            this.connectedNodes = new Vector();
            this.data = new List[]{this.ports, this.connectedNodes};
            this.portHeader = RB.getStringResource(PFDNodeConnectionsPanel.RB_KEY, "portHeader.txt");
            this.connectedNodeHeader = this.getConnectedNodeHeader(type);
        }

        private String getConnectedNodeHeader(int type) {
            if (type == 0) {
                return RB.getStringResource(PFDNodeConnectionsPanel.RB_KEY, "inputNodeHeader.txt");
            }
            return RB.getStringResource(PFDNodeConnectionsPanel.RB_KEY, "outputNodeHeader.txt");
        }

        public void setType(int type) {
            if (type == 0 || type == 1) {
                this.type = type;
            }
        }

        public int getType() {
            return this.type;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return NodeCellEntry.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return this.portHeader;
            }
            return this.connectedNodeHeader;
        }

        @Override
        public int getColumnCount() {
            return this.data.length;
        }

        @Override
        public int getRowCount() {
            return this.ports.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List columnData;
            if (rowIndex < 0 || columnIndex < 0) {
                return null;
            }
            if (columnIndex < this.data.length && rowIndex < (columnData = this.data[columnIndex]).size()) {
                return columnData.get(rowIndex);
            }
            return null;
        }

        public void updateData() {
            this.ports.clear();
            this.connectedNodes.clear();
            if (PFDNodeConnectionsPanel.this.connectionNode != null) {
                if (this.type == 0) {
                    this.updateDataInput();
                } else {
                    this.updateDataOutput();
                }
            }
            this.fireTableDataChanged();
        }

        private void updateDataInput() {
            if (PFDNodeConnectionsPanel.this.connectionNode instanceof PFDMultipleInputInterface) {
                PFDMultipleInputInterface multiInputNode = (PFDMultipleInputInterface)((Object)PFDNodeConnectionsPanel.this.connectionNode);
                for (int i = 0; i < multiInputNode.getNumInputPorts(); ++i) {
                    PFDPort inputPort = multiInputNode.getInputPort(i);
                    List entries = this.getInputTableEntries(inputPort);
                    this.addData(entries);
                }
            } else {
                PFDPort inputPort = PFDNodeConnectionsPanel.this.connectionNode.getInputPort();
                List entries = this.getInputTableEntries(inputPort);
                this.addData(entries);
            }
        }

        private void updateDataOutput() {
            if (PFDNodeConnectionsPanel.this.connectionNode instanceof PFDMultipleOutputInterface) {
                PFDMultipleOutputInterface multiOutputNode = (PFDMultipleOutputInterface)((Object)PFDNodeConnectionsPanel.this.connectionNode);
                for (int i = 0; i < multiOutputNode.getNumOutputPorts(); ++i) {
                    PFDPort outputPort = multiOutputNode.getOutputPort(i);
                    List entries = this.getOutputTableEntries(outputPort);
                    this.addData(entries);
                }
            } else {
                PFDPort outputPort = PFDNodeConnectionsPanel.this.connectionNode.getOutputPort();
                List entries = this.getOutputTableEntries(outputPort);
                this.addData(entries);
            }
        }

        private void addData(List entries) {
            if (entries == null) {
                return;
            }
            for (int i = 0; i < entries.size(); ++i) {
                Object o = entries.get(i);
                if (!(o instanceof Object[])) continue;
                Object[] rowData = (Object[])o;
                for (int k = 0; k < rowData.length && k < this.data.length; ++k) {
                    this.data[k].add(rowData[k]);
                }
            }
        }

        private List getInputTableEntries(PFDPort port) {
            if (port == null || !port.isValidToPort() || !port.isValidInteractiveToPort()) {
                return null;
            }
            Vector<Object[]> entries = new Vector<Object[]>();
            String portName = PFDDialogUtil.getPortName(port);
            Vector links = port.getToLinks();
            for (int i = 0; i < links.size(); ++i) {
                PFDLink link = (PFDLink)links.get(i);
                if (link.isCollapsed()) continue;
                InputNodeCellEntry nodeData = new InputNodeCellEntry(port, link);
                Object[] rowData = new Object[]{portName, nodeData};
                entries.add(rowData);
            }
            if (port.canAcceptNewLink()) {
                InputNodeCellEntry nodeData = new InputNodeCellEntry(port, null);
                Object[] rowData = new Object[]{portName, nodeData};
                entries.add(rowData);
            }
            return entries;
        }

        private List getOutputTableEntries(PFDPort port) {
            if (port == null || !port.isValidFromPort() || !port.isValidInteractiveFromPort()) {
                return null;
            }
            Vector<Object[]> entries = new Vector<Object[]>();
            String portName = PFDDialogUtil.getPortName(port);
            Vector links = port.getFromLinks();
            for (int i = 0; i < links.size(); ++i) {
                PFDLink link = (PFDLink)links.get(i);
                if (link.isCollapsed()) continue;
                OutputNodeCellEntry nodeData = new OutputNodeCellEntry(port, link);
                Object[] rowData = new Object[]{portName, nodeData};
                entries.add(rowData);
            }
            if (port.canDragNewLink()) {
                OutputNodeCellEntry nodeData = new OutputNodeCellEntry(port, null);
                Object[] rowData = new Object[]{portName, nodeData};
                entries.add(rowData);
            }
            return entries;
        }
    }

    private abstract class NodeCellEntry {
        protected String description;
        protected Icon icon;
        protected Action action;

        private NodeCellEntry() {
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public Action getAction() {
            return this.action;
        }
    }

    private class PFDNodeCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label;
        private JButton button;
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public PFDNodeCellRenderer() {
            this.setLayout(new BorderLayout());
            this.label = new JLabel();
            this.label.setBorder(new EmptyBorder(0, 2, 0, 0));
            this.add((Component)this.label, "Center");
            this.button = new JButton();
            this.button.setPreferredSize(new Dimension(20, 20));
            this.button.setFocusable(false);
            this.add((Component)this.button, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background;
            Color foreground;
            if (isSelected) {
                foreground = table.getSelectionForeground();
                background = table.getSelectionBackground();
            } else {
                foreground = table.getForeground();
                background = table.getBackground();
            }
            super.setForeground(foreground);
            this.label.setForeground(foreground);
            super.setBackground(background);
            this.label.setBackground(background);
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            } else {
                this.setBorder(this.noFocusBorder);
            }
            this.setValue(value);
            return this;
        }

        private void setValue(Object value) {
            if (value instanceof NodeCellEntry) {
                NodeCellEntry nodeCell = (NodeCellEntry)value;
                this.label.setText(nodeCell.getDescription());
                this.label.setIcon(nodeCell.getIcon());
                Action action = nodeCell.getAction();
                this.button.setAction(action);
                if (action == null) {
                    this.button.setVisible(false);
                } else {
                    this.button.setVisible(true);
                }
            } else {
                this.label.setText(value == null ? "" : value.toString());
                this.label.setIcon(null);
                this.button.setAction(null);
            }
        }

        public JButton getButton() {
            return this.button;
        }

        public JLabel getLabel() {
            return this.label;
        }
    }

    private class PFDNodeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        PFDNodeCellRenderer renderer;
        JTable table;
        int editRow = -1;

        public PFDNodeCellEditor() {
            this.renderer = new PFDNodeCellRenderer();
            JButton editButton = this.renderer.getButton();
            JLabel label = this.renderer.getLabel();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PFDNodeCellEditor.this.stopCellEditing();
                }
            };
            editButton.addActionListener(actionListener);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PFDNodeCellEditor.this.table != null && PFDNodeCellEditor.this.editRow >= 0) {
                        PFDNodeCellEditor.this.table.addRowSelectionInterval(PFDNodeCellEditor.this.editRow, PFDNodeCellEditor.this.editRow);
                        PFDNodeCellEditor.this.table.requestFocusInWindow();
                    }
                }
            };
            editButton.addMouseListener(mouseListener);
            label.addMouseListener(mouseListener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.table = table;
            this.editRow = row;
            this.renderer.getButton().getModel().setRollover(false);
            return this.renderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private class TableEditorMouseMotionListener
    extends MouseMotionAdapter {
        private JTable table;

        public TableEditorMouseMotionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.editCell(e);
        }

        private void editCell(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
                return;
            }
            if ((this.table.getEditingRow() != row || this.table.getEditingColumn() != column) && this.table.isCellEditable(row, column)) {
                this.table.editCellAt(row, column, e);
            }
        }
    }

    private class OutputNodeCellEntry
    extends NodeCellEntry {
        public OutputNodeCellEntry(PFDPort fromPort, PFDLink link) {
            PFDPort toPort;
            if (fromPort != null && (link == null || link.isDraggable())) {
                this.setAction(new OutputEditAction(fromPort, link));
            }
            PFDPort pFDPort = toPort = link == null ? null : link.getToPort();
            if (toPort == null) {
                this.setDescription(PFDDialogUtil.getEmptyNodeName());
            } else {
                PFDAbstractNode toNode = toPort.getParentNode();
                this.setDescription(PFDDialogUtil.getInputNodePortDescription(toNode, toPort));
                this.setIcon(PFDDialogUtil.getNodeTypeIcon(toNode));
            }
        }
    }

    private class InputNodeCellEntry
    extends NodeCellEntry {
        public InputNodeCellEntry(PFDPort toPort, PFDLink link) {
            PFDPort fromPort;
            if (toPort != null && (link == null || link.isDraggable())) {
                this.setAction(new InputEditAction(toPort, link));
            }
            PFDPort pFDPort = fromPort = link == null ? null : link.getFromPort();
            if (fromPort == null) {
                this.setDescription(PFDDialogUtil.getEmptyNodeName());
            } else {
                PFDAbstractNode fromNode = fromPort.getParentNode();
                this.setDescription(PFDDialogUtil.getOutputNodePortDescription(fromNode, fromPort));
                this.setIcon(PFDDialogUtil.getNodeTypeIcon(fromNode));
            }
        }
    }

    private class EditIcon
    implements Icon {
        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.fillRect(x + 3, y + 11, 2, 2);
            g.fillRect(x + 7, y + 11, 2, 2);
            g.fillRect(x + 11, y + 11, 2, 2);
        }
    }

    private class OutputEditAction
    extends AbstractAction {
        private PFDPort port;
        private PFDLink link;

        public OutputEditAction(PFDPort port) {
            this(port, null);
        }

        public OutputEditAction(PFDPort port, PFDLink link) {
            this.port = port;
            this.link = link;
            this.putValue("SmallIcon", new EditIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PFDPort selectedPort = PFDNodeSelectorPanel.showNodeSelectorDialog(PFDNodeConnectionsPanel.this, PFDNodeConnectionsPanel.this.view, this.port, this.link, 1);
            if (selectedPort == PFDNodeSelectorPanel.EMPTY_PORT) {
                PFDNodeConnectionsPanel.this.removeLink(this.link);
            } else if (this.link == null) {
                PFDNodeConnectionsPanel.this.createLink(this.port, selectedPort);
            } else {
                PFDNodeConnectionsPanel.this.redirectLinkTo(this.link, selectedPort);
            }
        }
    }

    private class InputEditAction
    extends AbstractAction {
        private PFDPort port;
        private PFDLink link;

        public InputEditAction(PFDPort port) {
            this(port, null);
        }

        public InputEditAction(PFDPort port, PFDLink link) {
            this.port = port;
            this.link = link;
            this.putValue("SmallIcon", new EditIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PFDPort selectedPort = PFDNodeSelectorPanel.showNodeSelectorDialog(PFDNodeConnectionsPanel.this, PFDNodeConnectionsPanel.this.view, this.port, this.link, 0);
            if (selectedPort != null) {
                if (selectedPort == PFDNodeSelectorPanel.EMPTY_PORT) {
                    PFDNodeConnectionsPanel.this.removeLink(this.link);
                } else if (this.link == null) {
                    PFDNodeConnectionsPanel.this.createLink(selectedPort, this.port);
                } else {
                    PFDNodeConnectionsPanel.this.redirectLinkFrom(this.link, selectedPort);
                }
            }
        }
    }
}

