/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleInputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleOutputInterface;
import com.sas.graphics.components.pfd.ui.RB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PFDDialogUtil {
    private static final String RB_KEY = "PFDDialogUtil.";
    private static final String inputPortNameFormat = RB.getStringResource("PFDDialogUtil.", "inputPortName.fmt");
    private static final String outputPortNameFormat = RB.getStringResource("PFDDialogUtil.", "outputPortName.fmt");
    private static final String defaultInputPortName = RB.getStringResource("PFDDialogUtil.", "defaultInputPortName.txt");
    private static final String defaultOuputPortName = RB.getStringResource("PFDDialogUtil.", "defaultOutputPortName.txt");
    private static final String defaultNodeName = RB.getStringResource("PFDDialogUtil.", "defaultNodeName.txt");
    private static final String defaultNodeTypeName = RB.getStringResource("PFDDialogUtil.", "defaultNodeTypeName.txt");
    private static final String emptyNodeName = RB.getStringResource("PFDDialogUtil.", "emptyNodeName.txt");
    private static final String nodePortDescriptionFormat = RB.getStringResource("PFDDialogUtil.", "nodePortDescription.fmt");
    private static final String okButtonText = RB.getStringResource("PFDDialogUtil.", "ok.txt");
    private static final String cancelButtonText = RB.getStringResource("PFDDialogUtil.", "cancel.txt");
    private static final Icon defaultNodeIcon = null;
    public static final int MARGIN = 11;
    public static final int BUTTON_GAP = 6;
    public static final int COMP_GAP = 6;
    public static final int RELATED_COMP_GAP = 3;
    public static final int LABEL_GAP_VERT = 2;
    public static final int LABEL_GAP_HORIZ = 5;

    public static String getPortName(PFDPort port) {
        if (port == null) {
            return null;
        }
        PFDAbstractNode node = port.getParentNode();
        String name = port.getName();
        if (name == null) {
            int index = PFDDialogUtil.getInputPortNumber(port, node);
            if (index < 0) {
                index = PFDDialogUtil.getOutputPortNumber(port, node);
            }
            if (index < 0) {
                return null;
            }
            NumberFormat nf = NumberFormat.getIntegerInstance();
            name = nf.format(++index);
        }
        return name;
    }

    private static int getInputPortNumber(PFDPort port, PFDAbstractNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof PFDMultipleInputInterface) {
            return ((PFDMultipleInputInterface)((Object)node)).getInputPortIndex(port);
        }
        if (node.getInputPort() == port) {
            return 0;
        }
        return -1;
    }

    private static int getOutputPortNumber(PFDPort port, PFDAbstractNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof PFDMultipleOutputInterface) {
            return ((PFDMultipleOutputInterface)((Object)node)).getOutputPortIndex(port);
        }
        if (node.getOutputPort() == port) {
            return 0;
        }
        return -1;
    }

    public static String getInputPortName(PFDPort port) {
        if (port == null) {
            return null;
        }
        PFDAbstractNode node = port.getParentNode();
        String name = port.getName();
        if (name == null) {
            int index = PFDDialogUtil.getInputPortNumber(port, node);
            if (index < 0) {
                return null;
            }
            ++index;
            if (node instanceof PFDMultipleInputInterface) {
                MessageFormat message = new MessageFormat(inputPortNameFormat);
                name = message.format(new Object[]{new Integer(index)});
            } else {
                name = defaultInputPortName;
            }
        }
        return name;
    }

    public static String getOutputPortName(PFDPort port) {
        if (port == null) {
            return null;
        }
        PFDAbstractNode node = port.getParentNode();
        String name = port.getName();
        if (name == null) {
            int index = PFDDialogUtil.getOutputPortNumber(port, node);
            if (index < 0) {
                return null;
            }
            ++index;
            if (node instanceof PFDMultipleOutputInterface) {
                MessageFormat message = new MessageFormat(outputPortNameFormat);
                name = message.format(new Object[]{new Integer(index)});
            } else {
                name = defaultOuputPortName;
            }
        }
        return name;
    }

    public static String getNodeName(PFDAbstractNode node) {
        if (node == null || node.getName() == null) {
            return defaultNodeName;
        }
        return node.getName();
    }

    public static String getInputNodePortDescription(PFDAbstractNode node, PFDPort port) {
        MessageFormat message = new MessageFormat(nodePortDescriptionFormat);
        String description = message.format(new Object[]{PFDDialogUtil.getNodeName(node), PFDDialogUtil.getInputPortName(port)});
        return description;
    }

    public static String getOutputNodePortDescription(PFDAbstractNode node, PFDPort port) {
        MessageFormat message = new MessageFormat(nodePortDescriptionFormat);
        String description = message.format(new Object[]{PFDDialogUtil.getNodeName(node), PFDDialogUtil.getOutputPortName(port)});
        return description;
    }

    public static String getNodeTypeDescription(PFDAbstractNode node) {
        if (node == null) {
            return defaultNodeTypeName;
        }
        if (node.getNodeTypeDescription() != null) {
            return node.getNodeTypeDescription();
        }
        if (node.getNodeType() != null) {
            return node.getNodeType();
        }
        return defaultNodeTypeName;
    }

    public static Icon getNodeTypeIcon(PFDAbstractNode node) {
        if (node == null) {
            return defaultNodeIcon;
        }
        if (node.getNodeTypeIcon() != null) {
            return node.getNodeTypeIcon();
        }
        return defaultNodeIcon;
    }

    public static String getEmptyNodeName() {
        return emptyNodeName;
    }

    public static String getOKButtonText() {
        return okButtonText;
    }

    public static String getCancelButtonText() {
        return cancelButtonText;
    }

    static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return PFDDialogUtil.getWindowForComponent(parentComponent.getParent());
    }

    static JComponent getSeperatorComponent() {
        return new SeperatorComponent();
    }

    private static class SeperatorComponent
    extends JPanel {
        private SeperatorComponent() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 3);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            int width = size.width;
            int height = size.height;
            int midY = height / 2;
            Color bgColor = this.getBackground();
            g.setColor(bgColor.brighter());
            g.drawLine(0, midY + 1, width - 1, midY + 1);
            g.setColor(bgColor.darker());
            g.drawLine(0, midY, width - 1, midY);
        }
    }
}

