/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.ui.PFDZoomLabel;
import com.sas.graphics.components.pfd.ui.PFDZoomSlider;
import com.sas.graphics.components.pfd.ui.RB;
import com.sas.graphics.components.pfd.ui.SplitButton;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class PFDControlToolBar
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = -3769809698972346848L;
    private static final String RB_KEY = "PFDControlToolBar.";
    private PFDView view;
    private JToggleButton selectButton;
    private JToggleButton panButton;
    private JButton zoomDecreaseButton;
    private JButton zoomIncreaseButton;
    private JButton layoutButton;
    private JToggleButton overviewButton;
    private PFDZoomSlider zoomSlider;
    private PFDZoomLabel zoomCustomCombo;

    public PFDControlToolBar(PFDView v) {
        this.setFloatable(false);
        this.setRollover(true);
        this.attachView(v);
    }

    public void setFlowDirection(String flowDirection) {
        if (this.layoutButton != null) {
            this.configureLayoutButton(this.layoutButton);
        }
    }

    private JButton createButton(String actionCommand) {
        JButton button = new JButton(this.view.getAction(actionCommand));
        button.setText(null);
        return button;
    }

    private void configureLayoutButton(JButton button) {
        LayeredLayoutStrategy layout = (LayeredLayoutStrategy)this.view.getPFDLayout();
        Icon icon = null;
        if (layout != null && layout.getFlowDirection().equalsIgnoreCase("Down")) {
            button.setAction(this.view.getAction("ACTION_LAYOUT_DOWN"));
            icon = PFDIconManager.getIcon("AutoLayoutDown.gif");
        } else {
            button.setAction(this.view.getAction("ACTION_LAYOUT_RIGHT"));
            icon = PFDIconManager.getIcon("AutoLayoutRight.gif");
        }
        button.setText(null);
        button.setIcon(icon);
    }

    private JToggleButton createToggleButton(String actionCommand) {
        Action action = this.view.getAction(actionCommand);
        JToggleButton button = new JToggleButton(action);
        if (action instanceof PFDAbstractAction) {
            ((PFDAbstractAction)action).addButton(button);
        }
        button.setText(null);
        return button;
    }

    private JPopupMenu createLayoutPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        Icon leftToRightIcon = PFDIconManager.getIcon("AutoLayoutRight.gif");
        Icon topToDownIcon = PFDIconManager.getIcon("AutoLayoutDown.gif");
        JMenuItem leftToRightItem = new JMenuItem(this.view.getAction("ACTION_LAYOUT_RIGHT"));
        leftToRightItem.setIcon(leftToRightIcon);
        leftToRightItem.setText(RB.getStringResource(RB_KEY, "layout.leftToRight.txt"));
        popupMenu.add(leftToRightItem);
        leftToRightItem.addActionListener(this);
        JMenuItem topToDownItem = new JMenuItem(this.view.getAction("ACTION_LAYOUT_DOWN"));
        topToDownItem.setIcon(topToDownIcon);
        topToDownItem.setText(RB.getStringResource(RB_KEY, "layout.topToDown.txt"));
        popupMenu.add(topToDownItem);
        topToDownItem.addActionListener(this);
        return popupMenu;
    }

    public void attachView(PFDView v) {
        this.detachView();
        if (v == null) {
            return;
        }
        this.view = v;
        this.selectButton = this.createToggleButton("ACTION_MODE_SELECT");
        this.panButton = this.createToggleButton("ACTION_MODE_PAN");
        this.zoomDecreaseButton = this.createButton("ACTION_ZOOM_DECREASE");
        this.zoomIncreaseButton = this.createButton("ACTION_ZOOM_INCREASE");
        this.layoutButton = new JButton();
        this.configureLayoutButton(this.layoutButton);
        JPopupMenu popupMenu = this.createLayoutPopupMenu();
        SplitButton sb = new SplitButton(this.layoutButton, 5);
        sb.setMenu(popupMenu);
        this.overviewButton = this.createToggleButton("ACTION_TOGGLE_OVERVIEW");
        this.zoomSlider = new PFDZoomSlider(this.view);
        this.zoomCustomCombo = new PFDZoomLabel(this.view);
        this.addSeparator();
        this.add(this.selectButton);
        this.add(this.panButton);
        this.addSeparator();
        this.add(this.zoomDecreaseButton);
        this.add(this.zoomSlider);
        this.add(this.zoomIncreaseButton);
        this.add(this.zoomCustomCombo);
        this.addSeparator();
        this.add(sb);
        this.add(this.overviewButton);
    }

    public void detachView() {
        if (this.view == null) {
            return;
        }
        Action a = this.view.getAction("ACTION_MODE_SELECT");
        if (a instanceof PFDAbstractAction) {
            ((PFDAbstractAction)a).removeButton(this.selectButton);
        }
        if ((a = this.view.getAction("ACTION_MODE_PAN")) instanceof PFDAbstractAction) {
            ((PFDAbstractAction)a).removeButton(this.panButton);
        }
        if ((a = this.view.getAction("ACTION_TOGGLE_OVERVIEW")) instanceof PFDAbstractAction) {
            ((PFDAbstractAction)a).removeButton(this.overviewButton);
        }
        this.zoomSlider.detachView();
        this.zoomCustomCombo.detachView();
        this.selectButton = null;
        this.panButton = null;
        this.zoomDecreaseButton = null;
        this.zoomIncreaseButton = null;
        this.layoutButton = null;
        this.overviewButton = null;
        this.zoomSlider = null;
        this.zoomCustomCombo = null;
        this.removeAll();
        this.view = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)source;
            Action action = mi.getAction();
            if (action.isEnabled()) {
                this.layoutButton.setAction(action);
                this.layoutButton.setIcon(mi.getIcon());
                this.layoutButton.setText(null);
            }
            Container c = mi.getParent();
            c.setVisible(false);
        }
    }
}

