/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.ui.PFDDialogUtil;
import com.sas.graphics.components.pfd.ui.PFDNodeConnectionsPanel;
import com.sas.graphics.components.pfd.ui.RB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JDialog;

public class PFDConnectionsDialog
extends JDialog
implements PropertyChangeListener {
    private static final String RB_KEY = "PFDConnectionsDialog.";
    private static final String titleFormat = RB.getStringResource("PFDConnectionsDialog.", "title.fmt");
    private PFDView view;
    private PFDAbstractNode connectionNode;
    private PFDNodeConnectionsPanel connectionsPanel;
    private boolean firstTime = true;

    public PFDConnectionsDialog(PFDView view) {
        super((Frame)PFDDialogUtil.getWindowForComponent(view), null, true);
        this.view = view;
        this.init();
    }

    private void init() {
        this.setComponentOrientation(this.view.getComponentOrientation());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.connectionsPanel = new PFDNodeConnectionsPanel(this.view);
        contentPane.add((Component)this.connectionsPanel, "Center");
        this.setLocationRelativeTo(this.view);
        this.connectionsPanel.addPropertyChangeListener("closeValue", this);
        this.addWindowListener(new ConnectionsWindowAdapter());
    }

    private void initTitle() {
        if (this.connectionNode == null) {
            this.setTitle(null);
        } else {
            MessageFormat message = new MessageFormat(titleFormat);
            String title = message.format(new Object[]{PFDDialogUtil.getNodeName(this.connectionNode)});
            this.setTitle(title);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initFromSource();
        } else {
            this.connectionsPanel.setConnectionNode(null);
        }
        super.setVisible(b);
    }

    private void initFromSource() {
        this.initTitle();
        this.connectionsPanel.setConnectionNode(this.connectionNode);
        if (this.firstTime) {
            this.pack();
            this.firstTime = false;
        }
    }

    public void setConnectionNode(PFDAbstractNode connectionNode) {
        this.connectionNode = connectionNode;
    }

    public PFDAbstractNode getConnectionNode() {
        return this.connectionNode;
    }

    public void setSASJavaHelp(String docProd, String id) {
        this.connectionsPanel.setSASJavaHelp(docProd, id);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() == "valueUninitialized") {
            return;
        }
        if (evt.getNewValue() == "valueCancel") {
            this.connectionsPanel.restoreOriginalLinks();
        }
        this.setVisible(false);
    }

    private class ConnectionsWindowAdapter
    extends WindowAdapter {
        private ConnectionsWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            PFDConnectionsDialog.this.connectionsPanel.restoreOriginalLinks();
        }
    }
}

