/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPortGroup;
import com.sas.graphics.components.pfd.PFDWorkTablePort;
import com.sas.graphics.components.pfd.interfaces.PFDWorkTableIconInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;

public class PFDWorkTablePortGroup
extends PFDPortGroup {
    private static Icon DEFAULT_WORKTABLE_ICON = PFDIconManager.getIcon("PortWorktable.gif");
    private Vector worktablePorts = new Vector();
    private boolean worktablePortsVisible = true;
    private int numVisibleWorktablePorts = 0;
    private int numCenteredPorts = 0;

    public PFDWorkTablePortGroup() {
        this(1);
    }

    public PFDWorkTablePortGroup(int type) {
        super(type);
    }

    public boolean isWorktablePortsVisible() {
        return this.worktablePortsVisible;
    }

    public void setWorktablePortsVisible(boolean visible) {
        if (visible == this.worktablePortsVisible) {
            return;
        }
        this.worktablePortsVisible = visible;
        this.firePropertyChange("worktablePortsVisible");
    }

    public void addWorktablePort(PFDWorkTablePort p) {
        if (p != null) {
            this.worktablePorts.add(p);
            if (p.isVisible()) {
                ++this.numVisibleWorktablePorts;
            }
            p.addPropertyChangeListener(this);
            p.removeMouseListener(p);
            p.removeMouseMotionListener(p);
            this.firePropertyChange("worktablePorts");
        }
    }

    public void addWorktablePort(int index, PFDWorkTablePort p) {
        if (p != null) {
            this.worktablePorts.add(index, p);
            if (p.isVisible()) {
                ++this.numVisibleWorktablePorts;
            }
            p.addPropertyChangeListener(this);
            p.removeMouseListener(p);
            p.removeMouseMotionListener(p);
            this.firePropertyChange("worktablePorts");
        }
    }

    public boolean removeWorktablePort(PFDWorkTablePort p) {
        boolean contained = this.worktablePorts.remove(p);
        if (contained) {
            if (p.isVisible()) {
                --this.numVisibleWorktablePorts;
            }
            p.removePropertyChangeListener(this);
            this.firePropertyChange("ports");
        }
        return contained;
    }

    public PFDWorkTablePort removeWorktablePort(int index) {
        PFDWorkTablePort retVal = (PFDWorkTablePort)this.worktablePorts.remove(index);
        if (retVal != null) {
            if (retVal.isVisible()) {
                --this.numVisibleWorktablePorts;
            }
            retVal.removePropertyChangeListener(this);
            this.firePropertyChange("ports");
        }
        return retVal;
    }

    public void removeAllWorktablePorts() {
        for (int i = 0; i < this.worktablePorts.size(); ++i) {
            ((PFDWorkTablePort)this.worktablePorts.get(i)).removePropertyChangeListener(this);
        }
        this.numVisibleWorktablePorts = 0;
        this.worktablePorts.clear();
    }

    public int getNumWorktablePorts() {
        return this.worktablePorts.size();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("visible".equals(evt.getPropertyName()) && evt.getSource() instanceof PFDWorkTablePort) {
            PFDWorkTablePort port = (PFDWorkTablePort)evt.getSource();
            if (this.worktablePorts.contains(port)) {
                this.numVisibleWorktablePorts = port.isVisible() ? ++this.numVisibleWorktablePorts : --this.numVisibleWorktablePorts;
                this.layoutChildren();
            } else {
                super.propertyChange(evt);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    public boolean canShowPorts() {
        return this.getNumVisibleWorktablePorts() > 0 || super.canShowPorts();
    }

    @Override
    protected void loadVisiblePorts() {
        if (this.worktablePortsVisible) {
            PFDPort p;
            int i;
            int srm = this.getSuperRenderMode();
            this.visiblePorts.clear();
            this.numCenteredPorts = 0;
            for (i = 0; i < this.worktablePorts.size(); ++i) {
                p = (PFDPort)this.worktablePorts.get(i);
                if (!p.isVisible()) continue;
                this.visiblePorts.add(p);
                ++this.numCenteredPorts;
            }
            this.numVisiblePorts = 0;
            for (i = 0; i < this.ports.size(); ++i) {
                p = (PFDPort)this.ports.get(i);
                if (!p.isVisible()) continue;
                ++this.numVisiblePorts;
                if (!p.hasNoVisibleLinks()) {
                    this.visiblePorts.add(p);
                    ++this.numCenteredPorts;
                    continue;
                }
                if (srm != 2 || p.isFull()) continue;
                this.visiblePorts.add(p);
            }
        } else {
            super.loadVisiblePorts();
            this.numCenteredPorts = this.numVisiblePorts;
        }
    }

    @Override
    protected int getNumLayoutPorts() {
        return this.visiblePorts.size();
    }

    @Override
    protected int getNumCenteredPorts() {
        return this.numCenteredPorts;
    }

    @Override
    protected Iterator getPortIterator() {
        return new PortIterator();
    }

    private Icon getWTIcon(PFDCompositeNode wtNode) {
        Icon wtIcon = null;
        if (wtNode instanceof PFDWorkTableIconInterface) {
            wtIcon = ((PFDWorkTableIconInterface)((Object)wtNode)).getWorkTableIcon();
        }
        if (wtIcon == null) {
            wtIcon = DEFAULT_WORKTABLE_ICON;
        }
        return wtIcon;
    }

    @Override
    protected void drawPortAt(Graphics2D g2d, PFDPort port, int x, int y) {
        if (port instanceof PFDWorkTablePort) {
            PFDCompositeNode wtNode = ((PFDWorkTablePort)port).getWorkTableNode();
            Icon wtIcon = this.getWTIcon(wtNode);
            wtIcon.paintIcon(null, g2d, x, y);
            if (port == this.highlightPort) {
                Color c = new Color(0.0f, 0.0f, 0.0f, 0.075f);
                g2d.setColor(c);
                g2d.fillRoundRect(x + 1, y + 1, this.portSize.width - 2, this.portSize.height - 2, this.portCornerRadius, this.portCornerRadius);
            }
            if (this.theView != null && this.theView.isSelected(wtNode)) {
                this.selectionPen.apply(g2d);
                g2d.drawRoundRect(x, y, this.portSize.width - 1, this.portSize.height - 1, this.portCornerRadius, this.portCornerRadius);
            }
        } else {
            super.drawPortAt(g2d, port, x, y);
        }
    }

    @Override
    protected void portPressed(PFDPort port, MouseEvent e) {
        if (port == null || !(port instanceof PFDWorkTablePort)) {
            return;
        }
        PFDWorkTablePort wtPort = (PFDWorkTablePort)port;
        int mouseMode = this.theView.getMouseExtendedMode();
        PFDCompositeNode wtNode = wtPort.getWorkTableNode();
        if (wtNode == null) {
            return;
        }
        if (wtNode.isSelectable()) {
            if (mouseMode == 4) {
                if (!this.theView.isSelected(wtNode)) {
                    this.theView.clearSelections();
                    this.theView.selectPrimitive(wtNode);
                }
            } else if (mouseMode == 2) {
                if (this.theView.isSelected(wtNode)) {
                    this.theView.deselectPrimitive(wtNode);
                } else {
                    this.theView.selectPrimitive(wtNode);
                }
            } else if (!this.theView.isSelected(wtNode)) {
                this.theView.clearSelections();
                this.theView.selectPrimitive(wtNode);
            }
        }
    }

    @Override
    protected int getComputedRenderMode() {
        if (this.getNumVisibleWorktablePorts() > 0) {
            return 2;
        }
        return super.getComputedRenderMode();
    }

    private int getSuperRenderMode() {
        return super.getComputedRenderMode();
    }

    private int getNumVisibleWorktablePorts() {
        if (this.worktablePortsVisible) {
            return this.numVisibleWorktablePorts;
        }
        return 0;
    }

    @Override
    public boolean hasValidInteractivePort() {
        if (this.worktablePortsVisible) {
            for (int i = 0; i < this.worktablePorts.size(); ++i) {
                PFDPort port = (PFDPort)this.worktablePorts.elementAt(i);
                if (!port.isVisible() || !(this.portType == 0 ? port.isValidInteractiveToPort() : port.isValidInteractiveFromPort())) continue;
                return true;
            }
        }
        return super.hasValidInteractivePort();
    }

    private class PortIterator
    implements Iterator {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < PFDWorkTablePortGroup.this.ports.size() + PFDWorkTablePortGroup.this.worktablePorts.size();
        }

        public Object next() {
            int i;
            if ((i = this.index++) < PFDWorkTablePortGroup.this.worktablePorts.size()) {
                return PFDWorkTablePortGroup.this.worktablePorts.get(i);
            }
            return PFDWorkTablePortGroup.this.ports.get(i - PFDWorkTablePortGroup.this.worktablePorts.size());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

