/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDButtonGroup;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPortGroup;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDWorkTablePort;
import com.sas.graphics.components.pfd.PFDWorkTablePortGroup;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableNode;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;

public class PFDWorkTableGroupNode
extends PFDCompositeNode
implements PFDCollapsableNode {
    private boolean isCollapsed = true;
    private boolean forceShowPorts = false;
    private Vector workTableNodes;
    private Vector orderedNodes;
    private Hashtable worktablePortMap = new Hashtable();
    private static final Dimension innerNodeSpace = new Dimension(20, 10);
    private static final Dimension outerNodeSpace = new Dimension(75, 75);

    public PFDWorkTableGroupNode() {
        this.initialize();
    }

    private void initialize() {
        this.setEditable(true);
        this.setCustomSelection(true);
        this.setMovesWithChildren(true);
        this.setBreakable(false);
        this.workTableNodes = new Vector();
        this.orderedNodes = new Vector();
        this.orderedNodes.add(this);
    }

    @Override
    protected PFDPortGroup createOutputPortGroup() {
        return new PFDWorkTablePortGroup();
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        this.disableChangeUpdate();
        this.updateWorkTables();
        this.layoutWorkTables();
        this.layoutSelfLinks();
        this.outputPortGroup.layoutChildren();
        this.enableChangeUpdate();
        this.firePropertyChange("bbox");
    }

    @Override
    protected void detachView(PFDView v) {
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode p = (PFDCompositeNode)this.workTableNodes.elementAt(i);
            p.detachView(v);
        }
        super.detachView(v);
    }

    protected void layoutWorkTables() {
        int width;
        int height;
        Point p;
        int numWorkTables = this.workTableNodes.size();
        if (numWorkTables == 0) {
            return;
        }
        Dimension size = ((PFDCompositeNode)this.workTableNodes.get(0)).getPreferredSize();
        int xPos = 0;
        int yPos = 0;
        int deltaX = 0;
        int deltaY = 0;
        int spot = 0;
        if (this.flowDirection.equalsIgnoreCase("right")) {
            p = this.nodeShape.getSpotLocation(4, null);
            height = (numWorkTables - 1) * (size.height + PFDWorkTableGroupNode.innerNodeSpace.height);
            spot = 8;
            xPos = p.x + PFDWorkTableGroupNode.outerNodeSpace.width;
            yPos = p.y - height / 2;
            deltaY = size.height + PFDWorkTableGroupNode.innerNodeSpace.height;
        } else if (this.flowDirection.equalsIgnoreCase("left")) {
            p = this.nodeShape.getSpotLocation(8, null);
            height = (numWorkTables - 1) * (size.height + PFDWorkTableGroupNode.innerNodeSpace.height);
            spot = 4;
            xPos = p.x - PFDWorkTableGroupNode.outerNodeSpace.width;
            yPos = p.y - height / 2;
            deltaY = size.height + PFDWorkTableGroupNode.innerNodeSpace.height;
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            p = this.nodeShape.getSpotLocation(2, null);
            width = (numWorkTables - 1) * (size.width + PFDWorkTableGroupNode.innerNodeSpace.width);
            spot = 6;
            xPos = p.x - width / 2;
            yPos = p.y - PFDWorkTableGroupNode.outerNodeSpace.height;
            deltaX = size.width + PFDWorkTableGroupNode.innerNodeSpace.width;
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            p = this.nodeShape.getSpotLocation(6, null);
            width = (numWorkTables - 1) * (size.width + PFDWorkTableGroupNode.innerNodeSpace.width);
            spot = 2;
            xPos = p.x - width / 2;
            yPos = p.y + PFDWorkTableGroupNode.outerNodeSpace.height;
            deltaX = size.width + PFDWorkTableGroupNode.innerNodeSpace.width;
        }
        Point spotPoint = new Point();
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.workTableNodes.get(i);
            node.setFlowDirection(this.flowDirection);
            node.getSpotLocation(spot, spotPoint);
            int dx = xPos + deltaX * i - spotPoint.x;
            int dy = yPos + deltaY * i - spotPoint.y;
            node.setLocation(node.getX() + dx, node.getY() + dy);
        }
    }

    protected void drawWorkTableNodes(Graphics2D g, PFDView v) {
        if (this.isCollapsed) {
            return;
        }
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.workTableNodes.get(i);
            if (v.isSelected(node)) {
                node.renderSelected(g, v);
                continue;
            }
            node.paint(g, v);
        }
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("isCollapsed") || property.equals("workTableNode")) {
            if (this.getNumWorkTables() == 0 && this.outputPortGroup != null) {
                this.outputPortGroup.setHoldRenderMode(false);
                this.outputPortGroup.setRenderMode(0);
            }
            this.layoutChildren();
        }
        super.update(property, v);
    }

    private void updateWorkTables() {
        if (this.model == null) {
            return;
        }
        ((PFDWorkTablePortGroup)this.outputPortGroup).setWorktablePortsVisible(this.isCollapsed);
        boolean showWorktables = !this.isCollapsed;
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.workTableNodes.get(i);
            if (showWorktables) {
                if (!this.children.contains(node)) {
                    this.addPrimitive(node);
                }
                this.expandWorktable(node);
                continue;
            }
            this.collapseWorktable(node);
            if (!this.children.contains(node)) continue;
            this.myRemovePrimitive(node);
        }
    }

    private void expandWorktable(PFDCompositeNode node) {
        if (node == null) {
            return;
        }
        Vector inputLinks = node.getInputLinks();
        Vector outputLinks = node.getOutputLinks();
        PFDSubdiagram.expandOutLinks(outputLinks);
        for (int i = 0; i < inputLinks.size(); ++i) {
            PFDLink inLink = (PFDLink)inputLinks.get(i);
            if (inLink == null) continue;
            inLink.setVisible(true);
        }
        node.setVisible(true);
    }

    private void collapseWorktable(PFDCompositeNode node) {
        if (node == null) {
            return;
        }
        Vector inputLinks = node.getInputLinks();
        PFDPort wtPort = (PFDPort)this.worktablePortMap.get(node);
        if (wtPort == null) {
            return;
        }
        PFDSubdiagram.collapseOutputLinksToPort(node.getOutputLinks(), wtPort);
        for (int i = 0; i < inputLinks.size(); ++i) {
            PFDLink inLink = (PFDLink)inputLinks.get(i);
            if (inLink == null) continue;
            inLink.setVisible(false);
        }
        node.setVisible(false);
    }

    public boolean addWorkTable(PFDCompositeNode node) {
        return this.addWorkTable(this.workTableNodes.size(), node);
    }

    public boolean addWorkTable(int index, PFDCompositeNode node) {
        if (node == null || this.workTableNodes.contains(node) || index > this.workTableNodes.size()) {
            return false;
        }
        node.setParent(this);
        node.setNodeStyleContext("NodeStyleWorkTable");
        this.workTableNodes.add(index, node);
        this.orderedNodes.add(node);
        this.addPrimitive(node);
        this.addWorktablePort(index, node);
        this.firePropertyChange("workTableNode");
        return true;
    }

    public boolean removeWorkTable(PFDCompositeNode node) {
        boolean retVal = this.workTableNodes.remove(node);
        if (retVal) {
            node.setParent(null);
            this.orderedNodes.remove(node);
            if (this.model != null) {
                this.model.removePrimitive(node);
            } else {
                this.myRemovePrimitive(node);
            }
            this.removeWorktablePort(node);
            this.firePropertyChange("workTableNode");
        }
        return retVal;
    }

    public PFDCompositeNode removeWorkTable(int index) {
        PFDCompositeNode node = (PFDCompositeNode)this.workTableNodes.remove(index);
        if (node != null) {
            node.setParent(null);
            this.orderedNodes.remove(node);
            if (this.model != null) {
                this.model.removePrimitive(node);
            } else {
                this.myRemovePrimitive(node);
            }
            this.removeWorktablePort(node);
            this.firePropertyChange("workTableNode");
        }
        return node;
    }

    public void removeAllWorkTables() {
        if (this.workTableNodes.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.workTableNodes.get(i);
            p.setParent(null);
            this.myRemovePrimitive((PFDPrimitive)this.workTableNodes.get(i));
        }
        this.workTableNodes.clear();
        this.removeAllWorktablePorts();
        this.firePropertyChange("workTableNode");
    }

    public int getNumWorkTables() {
        return this.workTableNodes.size();
    }

    public PFDCompositeNode getWorkTable(int index) {
        return (PFDCompositeNode)this.workTableNodes.get(index);
    }

    public boolean isWorkTable(PFDCompositeNode node) {
        return this.workTableNodes.contains(node);
    }

    public int getWorkTableIndex(PFDCompositeNode node) {
        return this.workTableNodes.indexOf(node);
    }

    @Override
    public void setForceShowPorts(boolean visible) {
        if (this.forceShowPorts == visible) {
            return;
        }
        this.forceShowPorts = visible;
        this.inputPortGroup.setForceShowPorts(visible);
        this.outputPortGroup.setForceShowPorts(visible);
        this.outputPortGroup.setHoldRenderMode(false);
        this.outputPortGroup.setRenderMode(0, true);
    }

    @Override
    public boolean isForceShowPorts() {
        return this.forceShowPorts;
    }

    public void updateCollapsedLinks() {
        this.updateWorkTables();
        this.outputPortGroup.layoutChildren();
    }

    @Override
    public PFDPort getCollapsedOutputPort(PFDPort expandedPort) {
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDAbstractNode node = (PFDAbstractNode)this.workTableNodes.get(i);
            if (!node.isChild(expandedPort)) continue;
            return (PFDPort)this.worktablePortMap.get(node);
        }
        return null;
    }

    @Override
    public PFDPort getCollapsedInputPort(PFDPort expandedPort) {
        return null;
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        if (collapsed == this.isCollapsed) {
            return;
        }
        this.isCollapsed = collapsed;
        this.firePropertyChange("isCollapsed");
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    @Override
    public void updateCollapsed() {
        this.updateCollapsedLinks();
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        if (this.isCollapsed) {
            return super.getSpotLocation(spot, p);
        }
        if (p == null) {
            p = new Point();
        }
        Rectangle bounds = this.getLayoutBounds();
        switch (spot) {
            default: {
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y + bounds.height / 2;
                break;
            }
            case 1: 
            case 10: {
                p.x = bounds.x;
                p.y = bounds.y;
                break;
            }
            case 2: {
                if (this.flowDirection.equalsIgnoreCase("down")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y;
                break;
            }
            case 3: {
                p.x = bounds.x + bounds.width;
                p.y = bounds.y;
                break;
            }
            case 4: {
                if (this.flowDirection.equalsIgnoreCase("left")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x + bounds.width;
                p.y = bounds.y + bounds.height / 2;
                break;
            }
            case 5: {
                p.x = bounds.x + bounds.width;
                p.y = bounds.y + bounds.height;
                break;
            }
            case 6: {
                if (this.flowDirection.equalsIgnoreCase("up")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y + bounds.height;
                break;
            }
            case 7: {
                p.x = bounds.x;
                p.y = bounds.y + bounds.height;
                break;
            }
            case 8: {
                if (this.flowDirection.equalsIgnoreCase("right")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x;
                p.y = bounds.y + bounds.height / 2;
            }
        }
        return p;
    }

    private Rectangle getLayoutBounds() {
        if (this.isCollapsed) {
            return this.nodeShape.getBBox();
        }
        Rectangle bounds = this.nodeShape.getBBox();
        Point p = new Point();
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.workTableNodes.get(i);
            node.getSpotLocation(1, p);
            bounds = bounds.union(new Rectangle(p.x, p.y, node.getLayoutWidth(), node.getLayoutHeight()));
        }
        return bounds;
    }

    @Override
    public int getLayoutWidth() {
        return this.getLayoutBounds().width;
    }

    @Override
    public int getLayoutHeight() {
        return this.getLayoutBounds().height;
    }

    private boolean myRemovePrimitive(PFDPrimitive p) {
        return super.removePrimitive(p);
    }

    @Override
    public boolean removePrimitive(PFDPrimitive p) {
        if (this.workTableNodes.remove(p)) {
            this.orderedNodes.remove(p);
            this.removeWorktablePort((PFDCompositeNode)p);
        }
        return super.removePrimitive(p);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.nodeShape.renderOverview(g2d, v);
        this.inputPortGroup.renderOverview(g2d, v);
        this.outputPortGroup.renderOverview(g2d, v);
        if (!this.isCollapsed) {
            for (int i = 0; i < this.workTableNodes.size(); ++i) {
                ((PFDCompositeNode)this.workTableNodes.get(i)).renderOverview(g2d, v);
            }
        }
    }

    @Override
    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        if (this.isCollapsed) {
            this.drawRootNode(g, v, selected);
        } else {
            for (int i = 0; i < this.orderedNodes.size(); ++i) {
                PFDCompositeNode node = (PFDCompositeNode)this.orderedNodes.get(i);
                if (node == this) {
                    this.drawRootNode(g, v, selected);
                    continue;
                }
                node.paint(g, v);
            }
        }
    }

    @Override
    protected void drawGhosted(Graphics2D g, PFDView v, boolean selected) {
        if (this.isCollapsed) {
            this.drawRootNodeGhosted(g, v, selected);
        } else {
            for (int i = 0; i < this.orderedNodes.size(); ++i) {
                PFDCompositeNode node = (PFDCompositeNode)this.orderedNodes.get(i);
                if (node == this) {
                    this.drawRootNodeGhosted(g, v, selected);
                    continue;
                }
                node.paint(g, v);
            }
        }
    }

    private void drawRootNode(Graphics2D g, PFDView v, boolean selected) {
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        this.nodeShape.paint(g);
        this.titleText.paint(g);
        this.contentText.paint(g);
        this.inputPortGroup.paint(g);
        this.outputPortGroup.paint(g);
        if (selected) {
            this.drawSelection(g);
        }
        this.nodeIcon.paint(g);
        this.drawStatusButton(g);
        if (this.noteButton != null) {
            this.noteButton.paint(g);
        }
        this.buttonGroup.paint(g);
        this.drawNodeNumber(g);
        if (this.progressBar != null) {
            this.progressBar.paint(g);
        }
        this.drawNotesAndStatus(g);
    }

    protected void drawRootNodeGhosted(Graphics2D g, PFDView v, boolean selected) {
        if (selected) {
            this.drawSelection(g);
        }
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        Rectangle bounds = this.getVisualRBBox();
        BufferedImage ghostImage = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D ghostGraphics = ghostImage.createGraphics();
        ghostGraphics.setRenderingHints(g.getRenderingHints());
        ghostGraphics.translate(-bounds.x, -bounds.y);
        this.nodeShape.paint(ghostGraphics);
        this.titleText.paint(ghostGraphics);
        this.contentText.paint(ghostGraphics);
        this.inputPortGroup.paint(ghostGraphics);
        this.outputPortGroup.paint(ghostGraphics);
        this.nodeIcon.paint(ghostGraphics);
        if (this.noteButton != null) {
            this.noteButton.paint(ghostGraphics);
        }
        this.buttonGroup.paint(ghostGraphics);
        this.drawNodeNumber(ghostGraphics);
        ghostGraphics.dispose();
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.drawImage((Image)ghostImage, bounds.x, bounds.y, v);
        g.setComposite(oldComposite);
        this.drawStatusButton(g);
        if (this.progressBar != null) {
            this.progressBar.paint(g);
        }
        this.drawNotesAndStatus(g);
    }

    @Override
    public void selectArea(PFDView v, Rectangle area) {
        if (!this.isVisible() || !this.isSelectable()) {
            return;
        }
        super.selectArea(v, area);
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            ((PFDPrimitive)this.workTableNodes.get(i)).selectArea(v, area);
        }
    }

    @Override
    public void selectAll(PFDView v) {
        super.selectAll(v);
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.workTableNodes.get(i);
            p.selectAll(v);
        }
    }

    @Override
    public void bringToFront(PFDPrimitive p) {
        if (this.model == null || !this.children.contains(p)) {
            return;
        }
        if (this.orderedNodes.contains(p)) {
            this.orderedNodes.remove(p);
            this.orderedNodes.add(p);
            this.children.remove(p);
            this.children.add(p);
        } else {
            this.bringRootToFront();
        }
        super.bringToFront();
    }

    @Override
    public void bringToFront() {
        this.bringRootToFront();
        super.bringToFront();
    }

    private void bringRootToFront() {
        this.orderedNodes.remove(this);
        for (int i = 0; i < this.orderedNodes.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.orderedNodes.lastElement();
            this.orderedNodes.remove(p);
            this.orderedNodes.add(0, p);
            if (!this.children.remove(p)) continue;
            this.children.add(0, p);
        }
        this.orderedNodes.add(this);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDPort newPort;
        PFDPort oldPort;
        int i;
        PFDWorkTableGroupNode clone = new PFDWorkTableGroupNode();
        table.put(this, clone);
        this.copyObject(clone);
        clone.removeAllInputPorts();
        clone.removeAllOutputPorts();
        for (i = 0; i < this.inputPortGroup.getNumPorts(); ++i) {
            oldPort = this.inputPortGroup.getPort(i);
            newPort = (PFDPort)oldPort.cloneObject(table);
            clone.addInputPort(newPort);
        }
        for (i = 0; i < this.outputPortGroup.getNumPorts(); ++i) {
            oldPort = this.outputPortGroup.getPort(i);
            newPort = (PFDPort)oldPort.cloneObject(table);
            clone.addOutputPort(newPort);
        }
        for (i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode n = this.getWorkTable(i);
            PFDCompositeNode copy = (PFDCompositeNode)table.get(n);
            if (copy == null) {
                copy = (PFDCompositeNode)n.cloneObject(table);
            }
            clone.addWorkTable(copy);
        }
        PFDButtonGroup newButtons = (PFDButtonGroup)this.buttonGroup.cloneObject(table);
        for (int i2 = 0; i2 < newButtons.getNumButtons(); ++i2) {
            clone.getIndicatorButtons().addButton(newButtons.removeButton(i2));
        }
        return clone;
    }

    public void copyObject(PFDWorkTableGroupNode toObject) {
        super.copyObject(toObject);
        toObject.setCollapsed(this.isCollapsed());
    }

    @Override
    public void setGhosted(boolean b) {
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDCompositeNode wtNode = (PFDCompositeNode)this.workTableNodes.get(i);
            wtNode.setGhosted(b);
        }
        Vector outLinks = this.getOutputLinks();
        for (int i = 0; i < outLinks.size(); ++i) {
            PFDLink outLink = (PFDLink)outLinks.get(i);
            if (!this.workTableNodes.contains(outLink.getToNode())) continue;
            outLink.setGhosted(b);
        }
        super.setGhosted(b);
    }

    @Override
    public void accumulateNodes(Vector v) {
        if (v == null || this.workTableNodes == null) {
            return;
        }
        v.addAll(this.workTableNodes);
    }

    @Override
    protected void build(PFDView v) {
        for (int i = 0; i < this.workTableNodes.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.workTableNodes.get(i);
            p.build(v);
        }
        super.build(v);
    }

    @Override
    public void layoutSelfLinks() {
        boolean vertical = this.flowDirection.equalsIgnoreCase("up") || this.flowDirection.equalsIgnoreCase("down");
        Point pt = new Point();
        Point center = this.getSpotLocation(0, null);
        Point fromPoint = new Point();
        Point toPoint = new Point();
        int offset = 17;
        for (PFDLink link : this.getInputLinks()) {
            double inputDirection;
            double outputDirection;
            NodeLayoutInterface fromNode = link.getFromNode();
            PFDWorkTableGroupNode toNode = this;
            if (fromNode != this && !this.workTableNodes.contains(fromNode)) continue;
            link.setCustomBreakPointsUsed(true);
            link.removeAllBreakPoints();
            link.getFromLinkPoint(null, fromPoint);
            link.getToLinkPoint(null, toPoint);
            if (vertical) {
                outputDirection = fromNode.getOutputLinkDirection();
                if (!Double.isNaN(outputDirection)) {
                    fromPoint.y -= (int)((double)fromNode.getOutputEndSegmentLength() * Math.sin(outputDirection));
                }
                if (!Double.isNaN(inputDirection = toNode.getInputLinkDirection())) {
                    toPoint.y -= (int)((double)toNode.getInputEndSegmentLength() * Math.sin(Math.PI + inputDirection));
                }
                this.getSpotLocation(8, pt);
                fromPoint.x = pt.x - offset;
                toPoint.x = pt.x - offset;
            } else {
                outputDirection = fromNode.getOutputLinkDirection();
                if (!Double.isNaN(outputDirection)) {
                    fromPoint.x += (int)((double)fromNode.getOutputEndSegmentLength() * Math.cos(outputDirection));
                }
                if (!Double.isNaN(inputDirection = toNode.getInputLinkDirection())) {
                    toPoint.x += (int)((double)toNode.getInputEndSegmentLength() * Math.cos(Math.PI + inputDirection));
                }
                this.getSpotLocation(2, pt);
                fromPoint.y = pt.y - offset;
                toPoint.y = pt.y - offset;
            }
            link.addBreakPoint(new Point(fromPoint));
            link.addBreakPoint(new Point(toPoint));
        }
    }

    private PFDWorkTablePort createWorktablePort(PFDCompositeNode node) {
        PFDWorkTablePort port = new PFDWorkTablePort(node);
        port.setName("*******PFDWorkTablePort*******");
        return port;
    }

    private void addWorktablePort(int index, PFDCompositeNode node) {
        PFDWorkTablePort wtPort = new PFDWorkTablePort(node);
        wtPort.setName("*******PFDWorkTablePort*******");
        ((PFDWorkTablePortGroup)this.outputPortGroup).addWorktablePort(index, wtPort);
        this.worktablePortMap.put(node, wtPort);
    }

    private void removeWorktablePort(PFDCompositeNode node) {
        PFDWorkTablePort wtPort = (PFDWorkTablePort)this.worktablePortMap.get(node);
        ((PFDWorkTablePortGroup)this.outputPortGroup).removeWorktablePort(wtPort);
        this.worktablePortMap.remove(node);
    }

    private void removeAllWorktablePorts() {
        ((PFDWorkTablePortGroup)this.outputPortGroup).removeAllWorktablePorts();
        this.worktablePortMap.clear();
    }

    @Override
    public boolean isExpandedChild(PFDPrimitive primitive) {
        boolean retVal = super.isExpandedChild(primitive);
        if (retVal) {
            return true;
        }
        if (this.isCollapsed) {
            for (int i = 0; i < this.workTableNodes.size(); ++i) {
                PFDCompositeNode node = (PFDCompositeNode)this.workTableNodes.get(i);
                if (node == primitive) {
                    return true;
                }
                if (!node.isExpandedChild(primitive)) continue;
                return true;
            }
        }
        return false;
    }
}

