/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDEmptyPrimitive;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDIcon;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;

public abstract class PFDWindow
extends PFDGroup {
    private static final int cornerRadius = 8;
    protected static final int innerPadding = 4;
    protected static final int outerPadding = 7;
    protected static final int defaultIconSize = 12;
    protected static final BasicStroke seperatorStroke = new BasicStroke(1.0f);
    protected static final Color defaultFillColor = new Color(255, 255, 225);
    protected static final Color defaultOutlineColor = new Color(150, 150, 150);
    protected static final Color defaultCloseIconColor = new Color(132, 132, 132);
    protected PFDIcon windowIcon;
    protected PFDButton closeButton;
    protected PFDRoundRectangle backgroundRect;
    protected PFDText titleText;
    protected PFDEmptyPrimitive titleBar;
    protected Dimension preferredSize;
    protected Color outlineColor = defaultOutlineColor;
    protected Color lineColor = defaultOutlineColor;
    protected Polygon resizeHandle;
    protected static final int resizeHandleIndex = 4;
    protected PFDEmptyPrimitive resizeHotSpot;
    protected Dimension minWindowSize = new Dimension(100, 100);
    protected Dimension maxWindowSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Dimension defaultWindowSize = this.minWindowSize;

    public PFDWindow() {
        this.initialize();
    }

    private void initialize() {
        this.setEditable(false);
        this.setCustomSelection(true);
        this.resizeHandle = new Polygon();
        this.windowIcon = new PFDIcon();
        this.closeButton = new PFDButton();
        this.closeButton.setAction(this.createWindowCloseAction());
        this.titleText = new PFDText();
        this.titleText.setFontSize(11);
        this.titleText.setSelectable(false);
        this.preferredSize = new Dimension(this.defaultWindowSize);
        this.backgroundRect = new PFDRoundRectangle();
        this.backgroundRect.setArcHeight(8);
        this.backgroundRect.setArcWidth(8);
        this.backgroundRect.setSize(this.preferredSize);
        this.backgroundRect.getBrush().setColor(defaultFillColor);
        this.backgroundRect.getPen().setColor(defaultOutlineColor);
        this.backgroundRect.setShadowOn(true);
        this.titleBar = new PFDEmptyPrimitive();
        this.titleBar.addMouseListener(this);
        this.titleBar.addMouseMotionListener(this);
        this.resizeHotSpot = new PFDEmptyPrimitive();
        this.resizeHotSpot.addMouseListener(this);
        this.resizeHotSpot.addMouseMotionListener(this);
        this.addPrimitive(this.backgroundRect);
        this.addPrimitive(this.resizeHotSpot);
        this.addPrimitive(this.titleBar);
        this.addPrimitive(this.titleText);
        this.addPrimitive(this.closeButton);
        this.addPrimitive(this.windowIcon);
    }

    protected void closeWindow() {
        this.setVisible(false);
    }

    @Override
    public void setResizable(boolean aBoolean) {
        if (this.resizable == aBoolean) {
            return;
        }
        if (aBoolean) {
            this.resizeHotSpot.addMouseListener(this);
            this.resizeHotSpot.addMouseMotionListener(this);
        } else {
            this.resizeHotSpot.removeMouseListener(this);
            this.resizeHotSpot.removeMouseMotionListener(this);
        }
        super.setResizable(aBoolean);
    }

    @Override
    public void setDraggable(boolean aBoolean) {
        if (this.draggable == aBoolean) {
            return;
        }
        if (aBoolean) {
            this.titleBar.addMouseListener(this);
            this.titleBar.addMouseMotionListener(this);
        } else {
            this.titleBar.removeMouseListener(this);
            this.titleBar.removeMouseMotionListener(this);
        }
        super.setDraggable(aBoolean);
    }

    protected Action createWindowCloseAction() {
        return new WindowCloseAction(this);
    }

    protected void layoutChildren() {
        Point point = new Point();
        this.backgroundRect.setSize(this.preferredSize);
        int iconWidth = 0;
        int iconHeight = 0;
        this.windowIcon.setLocation(this.backgroundRect.getX() + 7, this.backgroundRect.getY() + 7);
        iconHeight = Math.max(12, this.windowIcon.getHeight());
        iconWidth = this.windowIcon.getWidth();
        this.titleBar.setBBox(this.backgroundRect.getX(), this.backgroundRect.getY(), this.backgroundRect.getWidth(), iconHeight + 7 + 4);
        this.backgroundRect.getSpotLocation(3, point);
        point.x -= this.closeButton.getWidth() + 7;
        point.y += 7 + iconHeight / 2 - this.closeButton.getHeight() / 2;
        this.closeButton.setLocation(point);
        int titleOffset = 7;
        if (iconWidth > 0) {
            titleOffset += iconWidth + 4;
        }
        int titleWidth = this.titleBar.getWidth() - titleOffset - 7 - 4 - this.closeButton.getWidth();
        Rectangle titleRect = new Rectangle(this.titleBar.getX() + titleOffset, this.titleBar.getY() + 7 + iconHeight / 2, titleWidth, iconHeight + 8);
        this.layoutTitle(titleRect);
        this.resizeHotSpot.setBBox(this.backgroundRect.getX() + this.backgroundRect.getWidth() - 7 - 1, this.backgroundRect.getY() + this.backgroundRect.getHeight() - 7 - 1, 8, 8);
        this.calculateBBox();
    }

    protected int getTitleBarHeight() {
        return Math.max(12, this.windowIcon.getHeight()) + 7 + 4;
    }

    protected Rectangle getContentBounds() {
        return new Rectangle(this.getContentLocation(this.backgroundRect.getLocation()), this.getContentSize(this.backgroundRect.getSize()));
    }

    protected Dimension getContentSize(Dimension windowSize) {
        return new Dimension(windowSize.width - 14, windowSize.height - this.getTitleBarHeight() - 1 - 4 - 7);
    }

    protected Point getContentLocation(Point windowLocation) {
        return new Point(windowLocation.x + 7, windowLocation.y + this.getTitleBarHeight() + 4 + 1);
    }

    protected Dimension getWindowSize(Dimension contentSize) {
        return new Dimension(contentSize.width + 14, contentSize.height + this.getTitleBarHeight() + 1 + 4 + 7);
    }

    protected void layoutTitle(Rectangle r) {
        this.titleText.setVerticalAlignment(0);
        this.titleText.setHorizontalAlignment(1);
        this.titleText.setMultiline(true);
        this.titleText.setWrapWidth(r.width);
        this.titleText.setClipHeight(r.height);
        this.titleText.setClipping(true);
        this.titleText.setBBox(r.x, r.y, 0, 0);
        this.titleText.forceUpdate();
    }

    protected abstract void draw(Graphics2D var1, PFDView var2, boolean var3);

    protected void drawSelection(Graphics2D g) {
        Rectangle bounds = this.backgroundRect.getRBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        if (g.hitClip(bounds.x - 4 - halfStrokeWidth, bounds.y - 4 - halfStrokeWidth, bounds.width + 8 + halfStrokeWidth * 2, bounds.height + 8 + halfStrokeWidth * 2)) {
            this.selectionPen.apply(g);
            g.drawRoundRect(bounds.x - 4, bounds.y - 4, bounds.width + 7, bounds.height + 7, 16, 16);
        }
    }

    @Override
    protected Rectangle getCustomSelectionBBox() {
        Rectangle bounds = this.backgroundRect.getBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        bounds.x -= 4 + halfStrokeWidth;
        bounds.y -= 4 + halfStrokeWidth;
        bounds.width += 8 + halfStrokeWidth * 2;
        bounds.height += 8 + halfStrokeWidth * 2;
        return bounds;
    }

    protected void drawSeperator(Graphics2D g) {
        int x2;
        int y;
        int x1 = this.titleBar.getX() + 7;
        if (g.hitClip(x1, y = this.titleBar.getY() + this.titleBar.getHeight(), (x2 = this.titleBar.getX() + this.titleBar.getWidth() - 7 - 1) - x1 + 1, 1)) {
            g.setColor(this.lineColor);
            g.setStroke(seperatorStroke);
            g.drawLine(x1, y, x2, y);
        }
    }

    protected void drawResizeHandle(Graphics2D g) {
        int xMin = this.bbox.x + this.bbox.width - 1 - 7;
        int yMin = this.bbox.y + this.bbox.height - 1 - 7;
        int xMax = this.bbox.x + this.bbox.width - 1;
        int yMax = this.bbox.y + this.bbox.height - 1;
        if (g.hitClip(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1)) {
            this.resizeHandle.reset();
            this.resizeHandle.addPoint(this.bbox.x + this.bbox.width - 1, this.bbox.y + this.bbox.height - 1);
            this.resizeHandle.addPoint(this.bbox.x + this.bbox.width - 1, this.bbox.y + this.bbox.height - 1 - 7);
            this.resizeHandle.addPoint(this.bbox.x + this.bbox.width - 1 - 7, this.bbox.y + this.bbox.height - 1);
            g.setColor(this.outlineColor);
            g.fill(this.resizeHandle);
        }
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        this.draw(g2d, v, false);
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        this.draw(g2d, v, true);
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.renderSelected(g2d, v);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
    }

    @Override
    public void setPreferredSize(Dimension d) {
        if (d == null) {
            return;
        }
        int w = Math.max(Math.min(d.width, this.maxWindowSize.width), this.minWindowSize.width);
        int h = Math.max(Math.min(d.height, this.maxWindowSize.height), this.minWindowSize.height);
        if (this.preferredSize.width == w && this.preferredSize.height == h) {
            return;
        }
        this.preferredSize.setSize(w, h);
        this.firePropertyChange("preferredSize");
    }

    public void setIcon(Icon icon) {
        if (icon == this.windowIcon.getIcon()) {
            return;
        }
        this.windowIcon.setIcon(icon);
        this.firePropertyChange("icon");
    }

    public Icon getIcon() {
        return this.windowIcon.getIcon();
    }

    public void setTitleText(String text) {
        if (text == null ? this.titleText.getText() == null : text.equals(this.titleText.getText())) {
            return;
        }
        this.titleText.setText(text);
        this.firePropertyChange("title");
    }

    public String getTitleText() {
        return this.titleText.getText();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    protected void setFillColor(Color clr) {
        if (clr == null || clr.equals(this.backgroundRect.getBrush().getColor())) {
            return;
        }
        this.backgroundRect.getBrush().setColor(clr);
        this.firePropertyChange("fillColor");
    }

    protected void setOutlineColor(Color clr) {
        if (clr == null || clr.equals(this.outlineColor)) {
            return;
        }
        this.outlineColor = clr;
        this.backgroundRect.getPen().setColor(this.outlineColor);
        this.firePropertyChange("outlineColor");
    }

    protected void setLineColor(Color clr) {
        if (clr == null || clr.equals(this.lineColor)) {
            return;
        }
        this.lineColor = clr;
        this.firePropertyChange("lineColor");
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        if (!this.resizable) {
            return;
        }
        x = Math.max(0, x);
        y = Math.max(0, y);
        this.backgroundRect.disableChangeUpdate();
        this.backgroundRect.setLocation(x, y);
        this.backgroundRect.enableChangeUpdate();
        this.setPreferredSize(new Dimension(w, h));
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children") || property.equals("preferredSize") || property.equals("all")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        block13: {
            int mouseMode;
            block12: {
                e.consume();
                mouseMode = this.theView.getMouseExtendedMode();
                this.theView.setMouseOverPrimitive(this, e);
                if (e.getSource() != this && e.getSource() != this.titleBar) break block12;
                if (!this.selectable) {
                    if (mouseMode != 2) {
                        this.theView.clearSelections();
                    }
                    return;
                }
                switch (mouseMode) {
                    case 4: {
                        if (!this.theView.isSelected(this)) {
                            this.theView.clearSelections();
                            this.theView.selectPrimitive(this);
                            break;
                        }
                        break block13;
                    }
                    case 2: {
                        if (this.theView.isSelected(this)) {
                            this.theView.deselectPrimitive(this);
                            break;
                        }
                        this.theView.selectPrimitive(this);
                        if (this.theView.isEditMode() && this.isDraggable() && e.getSource() == this.titleBar) {
                            this.theView.setDragMode(0);
                            break;
                        }
                        break block13;
                    }
                    default: {
                        if (!this.theView.isSelected(this)) {
                            this.theView.clearSelections();
                            this.theView.selectPrimitive(this);
                        }
                        if (this.theView.isEditMode() && this.isDraggable() && e.getSource() == this.titleBar) {
                            this.theView.setDragMode(0);
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            if (e.getSource() == this.resizeHotSpot && this.isResizable() && this.theView.isEditMode() && mouseMode == 0) {
                this.theView.setResizePrimitive(this, 4);
                this.theView.setDragMode(4);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
        if (e.getSource() == this.resizeHotSpot && this.isResizable() && this.theView.isEditMode()) {
            this.theView.setCursor(Cursor.getPredefinedCursor(5));
        } else if (e.getSource() == this.titleBar && this.isDraggable() && this.theView.isEditMode()) {
            this.theView.setCursor(1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
    }

    private class WindowCloseAction
    extends PFDAbstractAction {
        private PFDWindow window;

        public WindowCloseAction(PFDWindow messageWindow) {
            super((PFDView)null);
            this.window = messageWindow;
            this.putValue("SmallIcon", new CloseIcon());
            this.putValue("ShortDescription", RB.getStringResource("PFDWindow.WindowCloseAction.tip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.window.closeWindow();
        }
    }

    public class CloseIcon
    implements Icon {
        private int size = 8;

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(defaultCloseIconColor);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(x, y, x + this.size - 1, y + this.size - 1);
            g2d.drawLine(x, y + this.size - 1, x + this.size - 1, y);
        }
    }
}

