/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDAnnotateComponent;
import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDDragToolTipManager;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDHandle;
import com.sas.graphics.components.pfd.PFDHoldChangeUpdateInterface;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDKeyAdapter;
import com.sas.graphics.components.pfd.PFDLayer;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDLinkLabel;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDMultiLineToolTip;
import com.sas.graphics.components.pfd.PFDOverviewPanel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDPrimitiveButton;
import com.sas.graphics.components.pfd.PFDRepaintManager;
import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDShapeNode;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDUniversalPort;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDActionInterface;
import com.sas.graphics.components.pfd.interfaces.PFDAnnotateInterface;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsedPort;
import com.sas.graphics.components.pfd.interfaces.PFDHotspotInterface;
import com.sas.graphics.components.pfd.interfaces.PFDPopupMenuInterface;
import com.sas.graphics.components.pfd.interfaces.PFDUniqueItemInterface;
import com.sas.graphics.components.pfd.ui.PFDConnectionsDialog;
import com.sas.graphics.components.pfd.ui.PFDControlToolBar;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.pfd.ui.actions.PFDActionGroup;
import com.sas.graphics.components.pfd.ui.actions.PFDAddNoteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDCopyAction;
import com.sas.graphics.components.pfd.ui.actions.PFDCreateGroupAction;
import com.sas.graphics.components.pfd.ui.actions.PFDCutAction;
import com.sas.graphics.components.pfd.ui.actions.PFDDeleteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDGridStyleDotAction;
import com.sas.graphics.components.pfd.ui.actions.PFDGridStyleSolidAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutDownAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutLeftAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutRightAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutUpAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPageSetupAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPanModeAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPasteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPrintAction;
import com.sas.graphics.components.pfd.ui.actions.PFDRunLayoutAction;
import com.sas.graphics.components.pfd.ui.actions.PFDSaveAsImageAction;
import com.sas.graphics.components.pfd.ui.actions.PFDSelectModeAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleGridAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleOverviewAction;
import com.sas.graphics.components.pfd.ui.actions.PFDTogglePageBoundariesAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleSnapToGridAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleToolbarAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomCustomScaleAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomDecreaseAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomFitAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomFitHeightAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomFitWidthAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomIncreaseAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomModeAction;
import com.sas.graphics.components.pfd.ui.menu.PFDMenuUtil;
import com.sas.graphics.components.pfd.ui.menu.PFDPopupMenu;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.data.TemporarySourceInterface;
import com.sas.graphics.interfaces.LayeredLayoutStrategyInterface;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.encoder.GifEncoder;
import com.sas.visuals.image.encoder.ImageAdaptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;

public class PFDView
extends JPanel
implements PFDModelListener,
Printable,
ClipboardOwner,
MouseListener,
MouseMotionListener,
PFDHoldChangeUpdateInterface,
ItemSelectable,
Autoscroll,
PFDPopupMenuInterface,
PFDActionInterface,
PropertyInterface,
SourceInterface,
TemporarySourceInterface,
PFDUniqueItemInterface {
    private static final long serialVersionUID = 2992339815387692257L;
    public static final String RB_KEY = "PFDView.";
    private String id = null;
    public static final int GRID_LINES = 0;
    public final String GRID_LINES_STRING = "lines";
    public static final int GRID_DOTS = 1;
    public final String GRID_DOTS_STRING = "dots";
    public static final int RENDER_QUALITY_HIGH = 0;
    public static final int RENDER_QUALITY_LOW = 1;
    public static final int PRINT_ALL = 0;
    public static final int PRINT_PAGES = 1;
    public static final int CURSOR_POINTER = 0;
    public static final int CURSOR_MOVE = 1;
    public static final int CURSOR_PENCIL = 2;
    public static final int CURSOR_CROSSHAIR = 3;
    public static final int CURSOR_INVALID = 4;
    public static final int CURSOR_HAND = 5;
    public static final int CURSOR_PAN = 6;
    public static final int CURSOR_ZOOM = 7;
    public static final int CURSOR_ZOOM_IN = 8;
    public static final int CURSOR_ZOOM_OUT = 9;
    public static final int MOUSE_MODE_SELECT = 0;
    public static final int MOUSE_MODE_PAN = 1;
    public static final int MOUSE_MODE_ZOOM = 2;
    static final int RENDER_ALL = 0;
    static final int RENDER_CLEAN = 1;
    static final int RENDER_DIRTY = 2;
    protected PFDModel model = new PFDModel();
    protected PFDSelectionList selected = new PFDSelectionList();
    protected PFDAbstractNode lastSelectedNode = null;
    protected PFDAbstractNode selectedNode = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean scaleToFit = false;
    protected AffineTransform currentXfm = null;
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected double scale = 1.0;
    private double minZoomScale = 0.1;
    private double maxZoomScale = 2.0;
    private boolean holdDisplay = false;
    private static Clipboard clipboard = new Clipboard("PFD Clipboard");
    private PFDPopupMenu popupMenu = null;
    private boolean popupMenuEnabled = true;
    private boolean toolTipEnabled = true;
    private boolean mouseEnabled = true;
    private boolean keyboardEnabled = true;
    private PFDKeyAdapter keyAdapter = null;
    private boolean enableUpdate = true;
    private boolean gridVisible = false;
    private int gridType = 0;
    private Color gridColor = new Color(225, 225, 225);
    private int gridSpaceX = 33;
    private int gridSpaceY = 33;
    private boolean snapToGrid = false;
    private boolean pageDividerVisible = false;
    private Color pageDividerColor = Color.darkGray;
    private boolean printGridNumber = true;
    protected boolean zoomAtCenter = false;
    private Cursor pencilCursor;
    private Cursor invalidCursor;
    private Cursor panCursor;
    private Cursor zoomCursor;
    private Cursor zoomInCursor;
    private Cursor zoomOutCursor;
    private boolean cursorSet = false;
    BufferedImage cleanBuffer;
    BufferedImage backBuffer;
    int renderMode = 0;
    protected boolean cleanBufferDirty = false;
    int renderQuality = 0;
    boolean draggingAction = false;
    int printMode = 0;
    PageFormat pageFormat = null;
    int preferredOverviewWidth = 200;
    LayoutStrategyInterface layoutStrategy = null;
    static final int minViewWidth = 10;
    static final int minViewHeight = 10;
    private boolean holdCursor = false;
    private int toolTipMaxWidth = Integer.MAX_VALUE;
    private boolean lmbDown = false;
    private boolean rmbDown = false;
    private boolean dragSource = false;
    protected Point scrollPosition = null;
    private Insets autoscrollInsets = null;
    Cursor dragCursor = null;
    private Vector tabOrder = null;
    private boolean tabOrderDirty = true;
    private int tabOrderIndex = 0;
    protected PFDAnnotateComponent pfdAnnoComponent = null;
    protected PFDAnnotateInterface backLayerAnnotate = null;
    private int mouseMode = 0;
    private PFDOverviewPanel overviewPanel = null;
    protected PFDControlToolBar controlToolBar = null;
    private boolean backgroundClicked = false;
    private boolean controlVisible = true;
    private Hashtable childComponentTable;
    private List hotspots;
    private List mouseoverHotspots;
    private boolean isEditMode = true;
    private PFDConnectionsDialog connectionsDialog = null;
    private String dragTipText = null;
    private boolean linkSnapped = false;
    protected PropertyList pending = null;
    private final boolean default_pageBoundariesVisible = false;
    private final boolean default_toolbarVisible = true;
    private final boolean default_overviewVisible = false;
    private final int default_gridStyle = 0;
    private final boolean default_gridVisible = false;
    private final int default_gridWidth = 33;
    private final int default_gridHeight = 33;
    protected boolean isSGEditor = false;
    private boolean userSetScaleToFit = false;
    public boolean userSetAlwaysCropAndScaleToFit = false;
    private Point2D.Double p2dSrc = new Point2D.Double();
    private Point2D.Double p2dDst = new Point2D.Double();
    protected Rectangle userSetViewport = null;
    Hashtable cloneTable = new Hashtable();
    protected boolean showAnnotation = true;
    int clickedX;
    int clickedY;
    int prevx;
    int prevy;
    int initialOffsetX = 0;
    int initialOffsetY = 0;
    Point clickedModelPoint = new Point();
    protected PFDPrimitive mouseOverPrimitive = null;
    protected PFDPrimitive resizePrimitive = null;
    PFDLink redirectingLink = null;
    Vector newLinks = new Vector();
    PFDPort lastSnappedPort = null;
    PFDUniversalPort floatingPort = new PFDUniversalPort();
    private PFDPort dragPort = null;
    PFDPort oldFromPort = null;
    PFDPort newFromPort = null;
    PFDPort oldToPort = null;
    PFDPort newToPort = null;
    int resizeHandle = -1;
    PFDText editingText = null;
    JTextField textEditor = null;
    Rectangle prevXORbox = null;
    boolean fastRenderEnabled = false;
    public static final int MOUSE_NONE = 0;
    public static final int MOUSE_SHIFT_DOWN = 1;
    public static final int MOUSE_CONTROL_DOWN = 2;
    public static final int MOUSE_SHIFT_CONTROL_DOWN = 3;
    public static final int MOUSE_POPUP_TRIGGER = 4;
    public static final int MOUSE_MIDDLE_BUTTON = 5;
    public static final int MOUSE_ALT_DOWN = 6;
    protected int mouseExtendedMode = 0;
    static final int NONE_PICKED = 0;
    static final int HANDLE_PICKED = 1;
    static final int PORT_PICKED = 2;
    static final int LINK_PICKED = 3;
    static final int LINK_ENDS_PICKED = 4;
    static final int LINK_BREAKPOINT_PICKED = 5;
    static final int COMPONENT_PICKED = 6;
    static final int OTHER_PICKED = 7;
    int itemPicked = 0;
    public static final int DRAG_PRIMITIVE = 0;
    public static final int DRAG_LINK_TO = 1;
    public static final int DRAG_LINK_FROM = 2;
    public static final int DRAG_LINK_NEW = 3;
    public static final int DRAG_HANDLE = 4;
    public static final int DRAG_SELECTION = 5;
    public static final int DRAG_ZOOM = 6;
    public static final int DRAG_PAN = 7;
    public static final int DRAG_COMPONENT = 8;
    public static final int DRAG_NONE = 9;
    public static final int DRAG_ANNOTATION = 10;
    protected int dragMode = 9;
    static final float[] dash1 = new float[]{5.0f};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PFDView() {
        if (this.toolTipEnabled) {
            ToolTipManager tm = ToolTipManager.sharedInstance();
            tm.registerComponent(this);
            PFDDragToolTipManager dtm = PFDDragToolTipManager.sharedInstance();
            dtm.registerView(this);
        }
        if (this.mouseEnabled) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        if (this.keyboardEnabled) {
            this.keyAdapter = new PFDKeyAdapter();
            this.addKeyListener(this.keyAdapter);
        }
        this.model.addPFDModelListener(this);
        if (GraphicsEnvironment.isHeadless()) {
            this.setDoubleBuffered(false);
        } else {
            this.setDoubleBuffered(true);
        }
        this.setOpaque(true);
        this.setBackground(new Color(248, 248, 248));
        this.setLayout(null);
        if (!GraphicsEnvironment.isHeadless()) {
            this.createCustomCursors();
        }
        this.scrollPosition = new Point(0, 0);
        this.autoscrollInsets = new Insets(40, 40, 40, 40);
        this.tabOrder = new Vector();
        this.pfdAnnoComponent = this.createAnnotateComponent();
        this.backLayerAnnotate = this.createAnnotateObject(false);
        this.hotspots = new Vector();
        this.mouseoverHotspots = new Vector();
        this.initializeActions();
        RepaintManager currentRepaintManager = RepaintManager.currentManager(this);
        if (!(currentRepaintManager instanceof PFDRepaintManager)) {
            Class<RepaintManager> clazz = RepaintManager.class;
            // MONITORENTER : javax.swing.RepaintManager.class
            RepaintManager repaintManager = currentRepaintManager = RepaintManager.currentManager(this);
            // MONITORENTER : repaintManager
            if (!(currentRepaintManager instanceof PFDRepaintManager)) {
                currentRepaintManager.validateInvalidComponents();
                currentRepaintManager.paintDirtyRegions();
                RepaintManager.setCurrentManager(new PFDRepaintManager());
            }
            // MONITOREXIT : repaintManager
            // MONITOREXIT : clazz
        }
        if (GraphicsEnvironment.isHeadless()) {
            RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        }
        this.pending = new PropertyList();
    }

    public void dispose() {
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.dispose();
        }
        if (this.backLayerAnnotate != null) {
            this.backLayerAnnotate.dispose();
            this.backLayerAnnotate = null;
        }
        if (this.model != null) {
            this.detachModel(this.model);
            this.model.removePFDModelListener(this);
            this.model = null;
        }
        this.selected = null;
        this.lastSelectedNode = null;
        this.lastSelectedNode = null;
        this.listenerList = null;
        this.currentXfm = null;
        this.popupMenu = null;
        this.keyAdapter = null;
        this.gridColor = null;
        this.pageDividerColor = null;
        this.cleanBuffer = null;
        this.backBuffer = null;
        this.pageFormat = null;
        this.layoutStrategy = null;
        this.scrollPosition = null;
        this.autoscrollInsets = null;
        this.dragCursor = null;
        this.tabOrder = null;
        if (this.overviewPanel != null) {
            this.overviewPanel.dispose();
            this.overviewPanel = null;
        }
        this.controlToolBar = null;
        if (this.childComponentTable != null) {
            this.childComponentTable.clear();
            this.childComponentTable = null;
        }
        this.hotspots = null;
        this.mouseoverHotspots = null;
        this.connectionsDialog = null;
        if (this.toolTipEnabled) {
            ToolTipManager tm = ToolTipManager.sharedInstance();
            PFDDragToolTipManager dtm = PFDDragToolTipManager.sharedInstance();
            tm.unregisterComponent(this);
            dtm.unregisterView(this);
        }
    }

    private void createCustomCursors() {
        URL url = PFDView.class.getResource("res/PencilCursor.gif");
        Image pencilImg = Toolkit.getDefaultToolkit().getImage(url);
        url = PFDView.class.getResource("res/InvalidCursor.gif");
        Image invalidImg = Toolkit.getDefaultToolkit().getImage(url);
        url = PFDView.class.getResource("res/PanCursor.gif");
        Image panImg = Toolkit.getDefaultToolkit().getImage(url);
        url = PFDView.class.getResource("res/ZoomEndCursor.gif");
        Image zoomImg = Toolkit.getDefaultToolkit().getImage(url);
        url = PFDView.class.getResource("res/ZoomInCursor.gif");
        Image zoomInImg = Toolkit.getDefaultToolkit().getImage(url);
        url = PFDView.class.getResource("res/ZoomOutCursor.gif");
        Image zoomOutImg = Toolkit.getDefaultToolkit().getImage(url);
        MediaTracker imageTracker = new MediaTracker(this);
        imageTracker.addImage(pencilImg, 0);
        imageTracker.addImage(invalidImg, 1);
        imageTracker.addImage(panImg, 2);
        imageTracker.addImage(zoomImg, 3);
        imageTracker.addImage(zoomInImg, 4);
        imageTracker.addImage(zoomOutImg, 5);
        try {
            imageTracker.waitForAll();
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
        }
        this.pencilCursor = this.getToolkit().createCustomCursor(pencilImg, new Point(10, 24), "pencil");
        this.panCursor = this.getToolkit().createCustomCursor(panImg, new Point(16, 16), "pan");
        this.zoomCursor = this.getToolkit().createCustomCursor(zoomImg, new Point(12, 11), "zoom");
        this.zoomInCursor = this.getToolkit().createCustomCursor(zoomInImg, new Point(12, 11), "zoomIn");
        this.zoomOutCursor = this.getToolkit().createCustomCursor(zoomOutImg, new Point(12, 11), "zoomOut");
        this.invalidCursor = this.getToolkit().createCustomCursor(invalidImg, new Point(6, 22), "zoomOut");
    }

    protected PFDAnnotateComponent createAnnotateComponent() {
        return PFDAnnotateComponent.createInstance(this);
    }

    protected PFDAnnotateInterface createAnnotateObject(boolean useToolbar) {
        PFDAnnotateInterface anno = PFDAnnotateComponent.createAnnotationObject(this);
        if (anno != null) {
            anno.setUseToolbar(useToolbar);
            anno.setAnnotateComponent(this);
        }
        return anno;
    }

    private void initializeActions() {
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            actionMap = new ActionMap();
            this.setActionMap(actionMap);
        }
        actionMap.put("ACTION_MODE_SELECT", new PFDSelectModeAction(this));
        actionMap.put("ACTION_MODE_PAN", new PFDPanModeAction(this));
        actionMap.put("ACTION_MODE_ZOOM", new PFDZoomModeAction(this));
        actionMap.put("ACTION_ZOOM_DECREASE", new PFDZoomDecreaseAction(this));
        actionMap.put("ACTION_ZOOM_INCREASE", new PFDZoomIncreaseAction(this));
        actionMap.put("ACTION_RUN_LAYOUT", new PFDRunLayoutAction(this));
        actionMap.put("ACTION_LAYOUT_RIGHT", new PFDLayoutRightAction(this));
        actionMap.put("ACTION_LAYOUT_LEFT", new PFDLayoutLeftAction(this));
        actionMap.put("ACTION_LAYOUT_UP", new PFDLayoutUpAction(this));
        actionMap.put("ACTION_LAYOUT_DOWN", new PFDLayoutDownAction(this));
        actionMap.put("ACTION_TOGGLE_OVERVIEW", new PFDToggleOverviewAction(this));
        actionMap.put("ACTION_TOGGLE_GRID", new PFDToggleGridAction(this));
        actionMap.put("ACTION_TOGGLE_SNAP_TO_GRID", new PFDToggleSnapToGridAction(this));
        actionMap.put("ACTION_GRID_STYLE_SOLID", new PFDGridStyleSolidAction(this));
        actionMap.put("ACTION_GRID_STYLE_DOT", new PFDGridStyleDotAction(this));
        actionMap.put("ACTION_ZOOM_10", new PFDZoomCustomScaleAction(this, 0.1));
        actionMap.put("ACTION_ZOOM_25", new PFDZoomCustomScaleAction(this, 0.25));
        actionMap.put("ACTION_ZOOM_50", new PFDZoomCustomScaleAction(this, 0.5));
        actionMap.put("ACTION_ZOOM_75", new PFDZoomCustomScaleAction(this, 0.75));
        actionMap.put("ACTION_ZOOM_100", new PFDZoomCustomScaleAction(this, 1.0));
        actionMap.put("ACTION_ZOOM_150", new PFDZoomCustomScaleAction(this, 1.5));
        actionMap.put("ACTION_ZOOM_200", new PFDZoomCustomScaleAction(this, 2.0));
        actionMap.put("ACTION_ZOOM_NO_SELECTION", new PFDAbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        actionMap.put("ACTION_ZOOM_FIT", new PFDZoomFitAction(this));
        actionMap.put("ACTION_ZOOM_FIT_WIDTH", new PFDZoomFitWidthAction(this));
        actionMap.put("ACTION_ZOOM_FIT_HEIGHT", new PFDZoomFitHeightAction(this));
        actionMap.put("ACTION_ADD_NOTE", new PFDAddNoteAction(this));
        actionMap.put("ACTION_TOGGLE_TOOLBAR", new PFDToggleToolbarAction(this));
        actionMap.put("ACTION_CREATE_GROUP", new PFDCreateGroupAction(this));
        actionMap.put("ACTION_CUT", new PFDCutAction(this));
        actionMap.put("ACTION_COPY", new PFDCopyAction(this));
        actionMap.put("ACTION_PASTE", new PFDPasteAction(this));
        actionMap.put("ACTION_DELETE", new PFDDeleteAction(this));
        actionMap.put("ACTION_SAVE_AS_IMAGE", new PFDSaveAsImageAction(this));
        actionMap.put("ACTION_PRINT", new PFDPrintAction(this));
        actionMap.put("ACTION_PAGE_SETUP", new PFDPageSetupAction(this));
        actionMap.put("ACTION_TOGGLE_PAGE_BOUNDARIES", new PFDTogglePageBoundariesAction(this));
        PFDActionGroup selectModeGroup = new PFDActionGroup();
        selectModeGroup.addAction(actionMap.get("ACTION_MODE_SELECT"));
        selectModeGroup.addAction(actionMap.get("ACTION_MODE_PAN"));
        selectModeGroup.addAction(actionMap.get("ACTION_MODE_ZOOM"));
        actionMap.get("ACTION_MODE_SELECT").putValue("pfdAbstractAction.selected", Boolean.TRUE);
        PFDActionGroup layoutGroup = new PFDActionGroup();
        layoutGroup.addAction(actionMap.get("ACTION_LAYOUT_RIGHT"));
        layoutGroup.addAction(actionMap.get("ACTION_LAYOUT_LEFT"));
        layoutGroup.addAction(actionMap.get("ACTION_LAYOUT_UP"));
        layoutGroup.addAction(actionMap.get("ACTION_LAYOUT_DOWN"));
        actionMap.get("ACTION_LAYOUT_RIGHT").putValue("pfdAbstractAction.selected", Boolean.TRUE);
        PFDActionGroup zoomGroup = new PFDActionGroup();
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_10"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_25"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_50"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_75"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_100"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_150"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_200"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_FIT"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_FIT_WIDTH"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_FIT_HEIGHT"));
        zoomGroup.addAction(actionMap.get("ACTION_ZOOM_NO_SELECTION"));
        actionMap.get("ACTION_ZOOM_100").putValue("pfdAbstractAction.selected", Boolean.TRUE);
        Action toolbarAction = actionMap.get("ACTION_TOGGLE_TOOLBAR");
        toolbarAction.putValue("pfdAbstractAction.selected", Boolean.FALSE);
        toolbarAction.setEnabled(false);
        PFDActionGroup gridStyleGroup = new PFDActionGroup();
        gridStyleGroup.addAction(actionMap.get("ACTION_GRID_STYLE_SOLID"));
        gridStyleGroup.addAction(actionMap.get("ACTION_GRID_STYLE_DOT"));
        actionMap.get("ACTION_GRID_STYLE_SOLID").putValue("pfdAbstractAction.selected", Boolean.TRUE);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, w, h);
        if (w <= 0) {
            w = 1;
        }
        if (h <= 0) {
            h = 1;
        }
        this.backBuffer = (BufferedImage)this.createImage(w, h);
        this.cleanBuffer = (BufferedImage)this.createImage(w, h);
        this.setFastRenderEnabled(false);
        this.resetRenderMode();
        if (this.userSetViewport != null) {
            this.setViewRect(this.userSetViewport);
        } else {
            if (this.userSetAlwaysCropAndScaleToFit) {
                this.setHoldDisplay(true);
                this.disableChangeUpdate();
                this.model.normalizedAndCrop();
                this.enableChangeUpdate();
                this.setHoldDisplay(false);
                this.setScaleToFit(true);
                return;
            }
            if (this.userSetScaleToFit) {
                this.setScaleToFit(true);
                if (this.userSetScaleToFit) {
                    return;
                }
            } else {
                this.xfmChanged();
                this.repaint();
            }
        }
        this.fireViewChange(0, "size");
    }

    public void setMaxZoomScale(double newMaxZoomScale) {
        this.maxZoomScale = newMaxZoomScale;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.model == null) {
            return super.getPreferredSize();
        }
        if (this.userSetAlwaysCropAndScaleToFit) {
            return this.getSize();
        }
        return this.model.getSize();
    }

    public PFDModel getModel() {
        return this.model;
    }

    public void setModel(PFDModel m) {
        PFDModel oldVal = this.model;
        if (oldVal == m) {
            return;
        }
        if (this.model != null) {
            this.detachModel(this.model);
            this.model.removePFDModelListener(this);
        }
        this.model = m;
        this.model.addPFDModelListener(this);
        boolean updatesEnabled = this.model.isChangeUpdateEnabled();
        if (!updatesEnabled) {
            this.model.enableChangeUpdate();
        }
        this.buildRenderables();
        if (!updatesEnabled) {
            this.model.disableChangeUpdate();
        }
        this.repaint();
        if (this.layoutStrategy != null) {
            this.layoutStrategy.setModel(this.model);
        }
        this.firePropertyChange("model", oldVal, this.model);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateX(double tx) {
        double oldVal = this.translateX;
        if (oldVal == tx) {
            return;
        }
        this.translateX = tx;
        this.xfmChanged();
        this.repaint();
        this.firePropertyChange("translateX", oldVal, this.translateX);
        this.fireViewChange(0, "translate");
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslateY(double ty) {
        double oldVal = this.translateY;
        if (oldVal == ty) {
            return;
        }
        this.translateY = ty;
        this.xfmChanged();
        this.repaint();
        this.firePropertyChange("translateY", oldVal, this.translateY);
        this.fireViewChange(0, "translate");
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double s) {
        double oldVal = this.scale;
        if (oldVal == (s = Math.max(this.minZoomScale, Math.min(this.maxZoomScale, s)))) {
            return;
        }
        this.scale = s;
        this.updateSelectedScale();
        this.xfmChanged();
        this.repaint();
        this.firePropertyChange("scale", oldVal, this.scale);
        this.fireViewChange(0, "scale");
    }

    private void updateSelectedScale() {
        Action action = this.scale == 0.1 ? this.getAction("ACTION_ZOOM_10") : (this.scale == 0.25 ? this.getAction("ACTION_ZOOM_25") : (this.scale == 0.5 ? this.getAction("ACTION_ZOOM_50") : (this.scale == 0.75 ? this.getAction("ACTION_ZOOM_75") : (this.scale == 1.0 ? this.getAction("ACTION_ZOOM_100") : (this.scale == 1.5 ? this.getAction("ACTION_ZOOM_150") : (this.scale == 2.0 ? this.getAction("ACTION_ZOOM_200") : this.getAction("ACTION_ZOOM_NO_SELECTION")))))));
        if (action != null) {
            action.putValue("pfdAbstractAction.selected", Boolean.TRUE);
        }
    }

    public double getMinScale() {
        return this.minZoomScale;
    }

    public double getMaxScale() {
        return this.maxZoomScale;
    }

    public void increaseScale() {
        int inc = 10;
        if (this.scale >= 1.0) {
            inc = 25;
        }
        int zoomInt = (int)(100.0 * this.scale) + inc;
        zoomInt = zoomInt / inc * inc;
        this.setScale((double)zoomInt / 100.0);
    }

    public void decreaseScale() {
        int zoomInt;
        int dec = 10;
        if (this.scale > 1.0) {
            dec = 25;
        }
        zoomInt = (zoomInt = (int)(100.0 * this.scale)) % dec == 0 ? (zoomInt -= dec) : zoomInt / dec * dec;
        this.setScale((double)zoomInt / 100.0);
    }

    public void increaseScale(Point centerPoint) {
        if (this.scale >= this.maxZoomScale) {
            return;
        }
        int inc = 10;
        if (this.scale >= 1.0) {
            inc = 25;
        }
        int zoomInt = (int)(100.0 * this.scale) + inc;
        zoomInt = zoomInt / inc * inc;
        double newScale = Math.min(this.maxZoomScale, (double)zoomInt / 100.0);
        Dimension modelSize = this.model.getSize();
        Point center = new Point(centerPoint);
        this.ViewToModel(center);
        int width = (int)((double)this.getWidth() / newScale);
        int height = (int)((double)this.getHeight() / newScale);
        int x = Math.max(0, Math.min(modelSize.width - width, center.x - width / 2));
        int y = Math.max(0, Math.min(modelSize.height - height, center.y - height / 2));
        this.setViewRect(new Rectangle(x, y, width, height));
    }

    public void decreaseScale(Point centerPoint) {
        int zoomInt;
        if (this.scale <= this.minZoomScale) {
            return;
        }
        int dec = 10;
        if (this.scale > 1.0) {
            dec = 25;
        }
        zoomInt = (zoomInt = (int)(100.0 * this.scale)) % dec == 0 ? (zoomInt -= dec) : zoomInt / dec * dec;
        double newScale = Math.max(this.minZoomScale, (double)zoomInt / 100.0);
        Dimension modelSize = this.model.getSize();
        Point center = new Point(centerPoint);
        this.ViewToModel(center);
        int width = (int)((double)this.getWidth() / newScale);
        int height = (int)((double)this.getHeight() / newScale);
        int x = Math.max(0, Math.min(modelSize.width - width, center.x - width / 2));
        int y = Math.max(0, Math.min(modelSize.height - height, center.y - height / 2));
        this.setViewRect(new Rectangle(x, y, width, height));
    }

    public double getFitScale() {
        double sx = this.getFitScaleWidth();
        double sy = this.getFitScaleHeight();
        return Math.min(sx, sy);
    }

    public double getFitScaleWidth() {
        int vw = this.getWidth();
        Dimension ms = this.model.getSize();
        int w = ms.width + 1;
        double sx = (double)vw / (double)w;
        return Math.max(Math.min(sx, this.maxZoomScale), this.minZoomScale);
    }

    public double getFitScaleHeight() {
        int vh = this.getHeight();
        Dimension ms = this.model.getSize();
        int h = ms.height + 1;
        double sy = (double)vh / (double)h;
        return Math.max(Math.min(sy, this.maxZoomScale), this.minZoomScale);
    }

    public void deltaTranslate(double dtx, double dty) {
        this.translateX += dtx;
        this.translateY += dty;
        this.xfmChanged();
        this.repaint();
        this.firePropertyChange("translateX", this.translateX - dtx, this.translateX);
        this.firePropertyChange("translateY", this.translateY - dty, this.translateY);
        this.fireViewChange(0, "translate");
    }

    public void deltaScale(double ds) {
        this.scale += ds;
        this.xfmChanged();
        this.repaint();
        this.firePropertyChange("scale", this.scale - ds, this.scale);
        this.fireViewChange(0, "scale");
    }

    public boolean isScaleToFit() {
        return false;
    }

    public void setScaleToFit(boolean b) {
        if (!b) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            this.userSetScaleToFit = true;
            this.userSetViewport = null;
            return;
        }
        this.userSetScaleToFit = false;
        this.setScale(this.getFitScale());
        this.setViewPosition(new Point(0, 0));
    }

    public void scaleToSelected() {
        Rectangle r = this.selected.getBBox();
        double aspect = (double)this.getWidth() / (double)this.getHeight();
        if ((double)r.height * aspect < (double)r.width) {
            r.height = (int)((double)r.width / aspect);
        } else {
            r.width = (int)((double)r.height * aspect);
        }
        this.setViewRect(r);
    }

    public void panToPrimitive(PFDPrimitive p) {
        Rectangle r = p.getRBBox();
        Rectangle vr = this.getViewRect();
        Dimension ms = this.model.getSize();
        int x = vr.x;
        int y = vr.y;
        if (ms.width > vr.width) {
            x = r.x + r.width / 2 - vr.width / 2;
            if (x < 0) {
                x = 0;
            } else if (x + vr.width > ms.width) {
                x = ms.width - vr.width - 1;
            }
        }
        if (ms.height > vr.height) {
            y = r.y + r.height / 2 - vr.height / 2;
            if (y < 0) {
                y = 0;
            } else if (y + vr.height > ms.height) {
                y = ms.height - vr.height - 1;
            }
        }
        this.setViewPosition(new Point(x, y));
    }

    public void panToPrimitive(PFDPrimitive p, boolean center) {
        if (center) {
            this.panToPrimitiveCenterImpl(p);
        } else {
            this.panToPrimitiveImpl(p);
        }
    }

    private void panToPrimitiveCenterImpl(PFDPrimitive p) {
        Rectangle r = p.getRBBox();
        Rectangle vr = this.getViewRect();
        Dimension ms = this.model.getSize();
        int x = vr.x;
        int y = vr.y;
        if (ms.width > vr.width) {
            x = r.x + r.width / 2 - vr.width / 2;
            if (x < 0) {
                x = 0;
            } else if (x + vr.width > ms.width) {
                x = ms.width - vr.width - 1;
            }
        }
        if (ms.height > vr.height) {
            y = r.y + r.height / 2 - vr.height / 2;
            if (y < 0) {
                y = 0;
            } else if (y + vr.height > ms.height) {
                y = ms.height - vr.height - 1;
            }
        }
        this.setViewPosition(new Point(x, y));
    }

    private void panToPrimitiveImpl(PFDPrimitive p) {
        Rectangle bbox = p.getBBox();
        Rectangle viewRect = this.getViewRect();
        Dimension ms = this.model.getSize();
        if (viewRect.contains(bbox)) {
            return;
        }
        Point newViewPos = viewRect.getLocation();
        if (bbox.x < viewRect.x) {
            newViewPos.x = Math.max(0, bbox.x - this.gridSpaceX);
        } else if (bbox.x + bbox.width > viewRect.x + viewRect.width) {
            int maxX = Math.min(bbox.x + bbox.width + this.gridSpaceX, ms.width);
            newViewPos.x = Math.max(0, maxX - viewRect.width);
        }
        if (bbox.y < viewRect.y) {
            newViewPos.y = Math.max(0, bbox.y - this.gridSpaceY);
        } else if (bbox.y + bbox.height > viewRect.y + viewRect.height) {
            int maxY = Math.min(bbox.y + bbox.height + this.gridSpaceY, ms.height);
            newViewPos.y = Math.max(0, maxY - viewRect.height);
        }
        this.setViewPosition(newViewPos);
    }

    @Override
    public void disableChangeUpdate() {
        this.enableUpdate = false;
    }

    @Override
    public void enableChangeUpdate() {
        this.enableUpdate = true;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean b) {
        boolean oldVal = this.popupMenuEnabled;
        if (oldVal == b) {
            return;
        }
        this.popupMenuEnabled = b;
        this.firePropertyChange("popupMenuEnabled", oldVal, this.popupMenuEnabled);
    }

    public boolean isKeyboardEnabled() {
        return this.keyboardEnabled;
    }

    public void setKeyboardEnabled(boolean b) {
        boolean oldVal = this.keyboardEnabled;
        if (oldVal == b) {
            return;
        }
        this.keyboardEnabled = b;
        if (this.keyboardEnabled) {
            if (this.keyAdapter == null) {
                this.keyAdapter = new PFDKeyAdapter();
            }
            this.addKeyListener(this.keyAdapter);
        } else {
            this.removeKeyListener(this.keyAdapter);
        }
        this.firePropertyChange("keyboardEnabled", oldVal, this.keyboardEnabled);
    }

    public boolean isMouseEnabled() {
        return this.mouseEnabled;
    }

    public void setMouseEnabled(boolean b) {
        boolean oldVal = this.mouseEnabled;
        if (oldVal == b) {
            return;
        }
        this.mouseEnabled = b;
        if (this.mouseEnabled) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        this.firePropertyChange("mouseuEnabled", oldVal, this.mouseEnabled);
    }

    public boolean isZoomAtCenter() {
        return this.zoomAtCenter;
    }

    public void setZoomAtCenter(boolean b) {
        boolean oldVal = this.zoomAtCenter;
        if (oldVal == b) {
            return;
        }
        this.zoomAtCenter = b;
        this.xfmChanged();
        this.fireViewChange(0, "all");
        this.firePropertyChange("zoomAtCenter", oldVal, this.zoomAtCenter);
    }

    public boolean isToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void setToolTipEnabled(boolean b) {
        boolean oldVal = this.toolTipEnabled;
        if (oldVal == b) {
            return;
        }
        this.toolTipEnabled = b;
        ToolTipManager tm = ToolTipManager.sharedInstance();
        PFDDragToolTipManager dtm = PFDDragToolTipManager.sharedInstance();
        if (this.toolTipEnabled) {
            tm.registerComponent(this);
            dtm.registerView(this);
        } else {
            tm.unregisterComponent(this);
            dtm.unregisterView(this);
        }
        this.firePropertyChange("toolTipEnabled", oldVal, this.toolTipEnabled);
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean b) {
        boolean oldVal = this.gridVisible;
        if (oldVal == b) {
            return;
        }
        this.gridVisible = b;
        Action action = this.getAction("ACTION_TOGGLE_GRID");
        if (action != null) {
            action.putValue("pfdAbstractAction.selected", b);
        }
        this.repaint();
        this.firePropertyChange("gridVisible", oldVal, this.gridVisible);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color c) {
        Color oldVal = this.gridColor;
        if (oldVal.equals(c)) {
            return;
        }
        this.gridColor = c;
        this.repaint();
        this.firePropertyChange("gridColor", oldVal, this.gridColor);
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setGridType(int type) {
        int oldVal = this.gridType;
        if (oldVal == type) {
            return;
        }
        this.checkGridType(type);
        this.gridType = type;
        Action action = null;
        if (this.gridType == 1) {
            action = this.getAction("ACTION_GRID_STYLE_DOT");
        } else if (this.gridType == 0) {
            action = this.getAction("ACTION_GRID_STYLE_SOLID");
        }
        if (action != null) {
            action.putValue("pfdAbstractAction.selected", Boolean.TRUE);
        }
        this.repaint();
        this.firePropertyChange("gridType", oldVal, this.gridType);
    }

    private void checkGridType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "gridType.ex.txt"));
            }
        }
    }

    private int getGridTypeFromString(String type) {
        if (type == null) {
            return -1;
        }
        if (type.equalsIgnoreCase("solid")) {
            return 0;
        }
        if (type.equalsIgnoreCase("dot")) {
            return 1;
        }
        return -1;
    }

    private String getGridTypeString(int type) {
        switch (type) {
            case 0: {
                return "solid";
            }
            case 1: {
                return "dot";
            }
        }
        return null;
    }

    public int getGridSpaceX() {
        return this.gridSpaceX;
    }

    public void setGridSpaceX(int space) {
        int oldVal = this.gridSpaceX;
        if (oldVal == space) {
            return;
        }
        this.gridSpaceX = space;
        this.repaint();
        this.firePropertyChange("gridSpaceX", oldVal, this.gridSpaceX);
    }

    public int getGridSpaceY() {
        return this.gridSpaceY;
    }

    public void setGridSpaceY(int space) {
        int oldVal = this.gridSpaceY;
        if (oldVal == space) {
            return;
        }
        this.gridSpaceY = space;
        this.repaint();
        this.firePropertyChange("gridSpaceY", oldVal, this.gridSpaceY);
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean b) {
        boolean oldVal = this.snapToGrid;
        if (oldVal == b) {
            return;
        }
        this.snapToGrid = b;
        this.firePropertyChange("snapToGrid", oldVal, this.snapToGrid);
    }

    public boolean isPageDividerVisible() {
        return this.pageDividerVisible;
    }

    public void setPageDividerVisible(boolean b) {
        boolean oldVal = this.pageDividerVisible;
        if (oldVal == b) {
            return;
        }
        if (b) {
            if (this.pageFormat == null) {
                try {
                    this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
                }
                catch (Exception e) {
                    this.pageFormat = null;
                }
            }
            if (this.pageFormat == null) {
                return;
            }
        }
        this.pageDividerVisible = b;
        Action action = this.getAction("ACTION_TOGGLE_PAGE_BOUNDARIES");
        if (action != null) {
            action.putValue("pfdAbstractAction.selected", b);
        }
        this.repaint();
        this.firePropertyChange("pageDividerVisible", oldVal, this.pageDividerVisible);
    }

    public Color getPageDividerColor() {
        return this.pageDividerColor;
    }

    public void setPageDividerColor(Color c) {
        Color oldVal = this.pageDividerColor;
        if (oldVal.equals(c)) {
            return;
        }
        this.pageDividerColor = c;
        this.repaint();
        this.firePropertyChange("pageDividerColor", oldVal, this.pageDividerColor);
    }

    public int getPrintMode() {
        return this.printMode;
    }

    public void setPrintMode(int mode) {
        int oldVal = this.printMode;
        if (oldVal == mode) {
            return;
        }
        this.checkPrintMode(mode);
        this.printMode = mode;
        this.firePropertyChange("printMode", oldVal, this.printMode);
    }

    private void checkPrintMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "printMode.ex.txt"));
            }
        }
    }

    public PageFormat getPageFormat() {
        if (this.pageFormat == null) {
            try {
                this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
            }
            catch (Exception e) {
                this.pageFormat = null;
            }
        }
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pf) {
        PageFormat oldVal = this.pageFormat;
        if (oldVal == pf) {
            return;
        }
        this.pageFormat = pf;
        this.firePropertyChange("pageFormat", oldVal, this.pageFormat);
    }

    public boolean isGridNumberPrinted() {
        return this.printGridNumber;
    }

    public void setGridNumberPrinted(boolean b) {
        boolean oldVal = this.printGridNumber;
        if (oldVal == b) {
            return;
        }
        this.printGridNumber = b;
    }

    public boolean isHoldDisplay() {
        return this.holdDisplay;
    }

    public void setHoldDisplay(boolean b) {
        this.holdDisplay = b;
        if (!this.holdDisplay) {
            this.repaint();
        }
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(int quality) {
        int oldVal = this.renderQuality;
        if (oldVal == quality) {
            return;
        }
        this.checkRenderQuality(quality);
        this.renderQuality = quality;
        this.repaint();
        this.firePropertyChange("renderQuality", oldVal, this.renderQuality);
    }

    private void checkRenderQuality(int quality) {
        switch (quality) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "renderQuality.ex.txt"));
            }
        }
    }

    public int getPreferredOverviewWindowWidth() {
        return this.preferredOverviewWidth;
    }

    public void setPreferredOverviewWindowWidth(int width) {
        int oldVal = this.preferredOverviewWidth;
        if (oldVal == width) {
            return;
        }
        this.preferredOverviewWidth = width;
        this.firePropertyChange("preferredOverviewWindowWidth", oldVal, this.preferredOverviewWidth);
    }

    private boolean writeImageToFile(BufferedImage img, String encodingType, File file) {
        boolean retVal = false;
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(file);
            retVal = this.writeImageToStream(img, encodingType, fo);
        }
        catch (FileNotFoundException fne) {
            throw new RuntimeException(fne);
        }
        finally {
            try {
                if (fo != null) {
                    fo.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean writeImageToStream(BufferedImage img, String encodingType, OutputStream stream) {
        if (img == null || encodingType == null || stream == null) {
            return false;
        }
        try {
            if (encodingType.equalsIgnoreCase("GIF")) {
                this.writeImageToGif(img, stream);
            } else {
                ImageIO.write((RenderedImage)img, encodingType, stream);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean writeToGif(OutputStream out, double scale) {
        ImageIterator images = new ImageIterator(null, scale, false);
        if (!images.hasNext()) {
            return false;
        }
        BufferedImage img = (BufferedImage)images.next();
        return this.writeImageToStream(img, "gif", out);
    }

    public void saveToGif(File file) {
        int oldQuality = this.renderQuality;
        this.renderQuality = 1;
        Graphics bg = this.backBuffer.getGraphics();
        this.paint(bg);
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.paint(bg);
        }
        bg.dispose();
        this.renderQuality = oldQuality;
        this.writeImageToFile(this.backBuffer, "gif", file);
    }

    public void saveModelToGif(File file) {
        BufferedImage img = this.getModelAsImage();
        if (img == null) {
            return;
        }
        this.writeImageToFile(img, "gif", file);
    }

    public boolean writeToPng(OutputStream out, double scale) {
        ImageIterator images = new ImageIterator(null, scale, false);
        if (!images.hasNext()) {
            return false;
        }
        BufferedImage img = (BufferedImage)images.next();
        return this.writeImageToStream(img, "png", out);
    }

    public void saveToPng(File file) {
        Graphics bg = this.backBuffer.getGraphics();
        this.paint(bg);
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.paint(bg);
        }
        bg.dispose();
        this.writeImageToFile(this.backBuffer, "png", file);
    }

    public void saveModelToPng(File file) {
        BufferedImage img = this.getModelAsImage();
        if (img == null) {
            return;
        }
        this.writeImageToFile(img, "png", file);
    }

    public boolean writeToBitmap(OutputStream out, double scale) {
        ImageIterator images = new ImageIterator(null, scale, false);
        if (!images.hasNext()) {
            return false;
        }
        BufferedImage img = (BufferedImage)images.next();
        return this.writeImageToStream(img, "bmp", out);
    }

    public void saveToBitmap(String filename) {
        File file = new File(filename);
        this.saveToBitmap(file);
    }

    public void saveToBitmap(File file) {
        Graphics bg = this.backBuffer.getGraphics();
        this.paint(bg);
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.paint(bg);
        }
        bg.dispose();
        this.writeImageToFile(this.backBuffer, "bmp", file);
    }

    public void saveModelToBitmap(File file) {
        BufferedImage img = this.getModelAsImage();
        if (img == null) {
            return;
        }
        this.writeImageToFile(img, "bmp", file);
    }

    public void saveToBitmaps(File directory, String filePrefix, Dimension imageSize, double scale, boolean drawImageCoordinates) {
        String filePath = "";
        if (filePrefix != null) {
            filePath = filePath + filePrefix;
        }
        ImageIterator images = new ImageIterator(imageSize, scale, drawImageCoordinates);
        int numImages = images.getNumRows() * images.getNumCols();
        int imageCount = 0;
        while (images.hasNext()) {
            BufferedImage img = (BufferedImage)images.next();
            String filename = filePath + Integer.toString(imageCount) + ".bmp";
            File imgFile = new File(directory, filename);
            this.writeImageToFile(img, "bmp", imgFile);
            ++imageCount;
        }
    }

    private Image convertImageTo8bit(Image img) {
        if (img == null) {
            return null;
        }
        BufferedImage newImg = new BufferedImage(img.getWidth(null), img.getHeight(null), 13);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return newImg;
    }

    private boolean writeImageToGif(Image img, OutputStream out) {
        img = this.convertImageTo8bit(img);
        ImageAdaptor iAdp = new ImageAdaptor(img);
        boolean rc = false;
        try {
            rc = iAdp.setup();
        }
        catch (InterruptedException intE) {
            System.out.println(intE.getMessage());
        }
        catch (ImageFormatException imgE) {
            System.out.println(imgE.getMessage());
        }
        if (rc) {
            GifEncoder gifWriter = new GifEncoder(iAdp, out);
            try {
                gifWriter.encode();
            }
            catch (IOException iE) {
                System.out.println(iE.getMessage());
                rc = false;
            }
        }
        return rc;
    }

    public PFDPrimitive pickPrimitive(int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return this.model.pickPrimitive(pt.x, pt.y);
    }

    private PFDPort pickPort(int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        PFDPrimitive port = null;
        for (int i = this.model.getNumPrimitives() - 1; i >= 0; --i) {
            PFDPrimitive p = this.model.getPrimitive(i);
            if (!p.isVisible() || !p.contains(pt.x, pt.y)) continue;
            if (p instanceof PFDPort) {
                port = (PFDPort)p;
                break;
            }
            if (p instanceof PFDLink || !(p instanceof PFDGroup)) continue;
            port = (PFDPort)((PFDGroup)p).pickTopPrimitive(pt.x, pt.y, PFDPort.class);
            break;
        }
        if (port != null && port.isSelectable()) {
            return port;
        }
        return null;
    }

    public PFDText pickText(int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return (PFDText)this.model.pickPrimitive(pt.x, pt.y, PFDText.class);
    }

    public PFDImage pickImage(int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return (PFDImage)this.model.pickPrimitive(pt.x, pt.y, PFDImage.class);
    }

    public boolean isLinkStartAt(PFDLink link, int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return link.isStartPoint(pt.x, pt.y);
    }

    public boolean isLinkEndAt(PFDLink link, int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return link.isEndPoint(pt.x, pt.y);
    }

    public boolean isLinkBreakAt(PFDLink link, int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return link.isBreakPoint(pt.x, pt.y);
    }

    public void selectLinkBreakAt(PFDLink link, int x, int y, boolean toggleSelect) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        link.selectBreakPoint(pt.x, pt.y, toggleSelect);
    }

    public boolean isSelectedLinkBreakAt(PFDLink link, int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return link.isSelectedBreak(pt.x, pt.y);
    }

    public void selectArea(int x, int y, int w, int h) {
        this.setHoldDisplay(true);
        Rectangle r = new Rectangle(x, y, w, h);
        this.ViewToModel(r);
        for (int i = 0; i < this.model.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.model.getPrimitive(i);
            p.selectArea(this, r);
        }
        this.setHoldDisplay(false);
    }

    public void selectAll() {
        this.selected.removeAllPrimitives();
        for (int i = 0; i < this.model.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.model.getPrimitive(i);
            p.selectAll(this);
        }
        this.repaint();
    }

    public PFDSelectionList getSelectionList() {
        return this.selected;
    }

    public boolean isSelected(PFDPrimitive p) {
        return this.selected.indexOfPrimitive(p) >= 0;
    }

    public boolean isFocused(PFDPrimitive p) {
        return p == this.selected.getLastPrimitive();
    }

    public void selectPrimitive(PFDPrimitive p) {
        if (!p.isSelectable()) {
            return;
        }
        if (!this.isSelected(p)) {
            PFDGroup topParent = p.getTopLevelGroup();
            if (topParent instanceof PFDCollapsableNodeGroup && this.isSelected(topParent)) {
                return;
            }
            if (p instanceof PFDCollapsableNodeGroup && !this.selected.hasNoPrimitives()) {
                Vector<PFDPrimitive> removes = null;
                Enumeration e = this.selected.getAllPrimitives();
                while (e.hasMoreElements()) {
                    PFDPrimitive primitive = (PFDPrimitive)e.nextElement();
                    if (!((PFDGroup)p).isChild(primitive)) continue;
                    if (removes == null) {
                        removes = new Vector<PFDPrimitive>();
                    }
                    removes.add(primitive);
                }
                if (removes != null) {
                    e = removes.elements();
                    while (e.hasMoreElements()) {
                        this.selected.removePrimitive((PFDPrimitive)e.nextElement());
                    }
                }
            }
            this.selected.addPrimitive(p);
            if (this.isSGEditor) {
                PFDHandle handle = this.selected.getHandleFor(p);
                if (p instanceof PFDLink) {
                    handle.setHandleSize(15);
                    handle.setCustomEditorStyle(true);
                }
            }
            this.repaint();
            this.fireItemStateChanged(new ItemEvent(this, 701, p, 1));
        }
    }

    public void deselectPrimitive(PFDPrimitive p) {
        if (this.selected.containsPrimitive(p)) {
            this.selected.removePrimitive(p);
            this.repaint();
            this.fireItemStateChanged(new ItemEvent(this, 701, p, 2));
        }
    }

    public void clearSelections() {
        this.setHoldDisplay(true);
        PFDPrimitive p = this.selected.getLastPrimitive();
        while (p != null) {
            this.deselectPrimitive(p);
            if (p instanceof PFDLink) {
                ((PFDLink)p).clearSelectedBreaks();
            }
            p = this.selected.getLastPrimitive();
        }
        this.setHoldDisplay(false);
    }

    public PFDPrimitive[] getSelectedPrimitives() {
        int ns = this.selected.getNumPrimitives();
        PFDPrimitive[] pp = new PFDPrimitive[ns];
        for (int i = 0; i < ns; ++i) {
            pp[i] = this.selected.getPrimitive(i);
        }
        return pp;
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getSelectedPrimitives();
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    public void movePrimitive(PFDPrimitive p, int newX, int newY) {
        if (!p.isDraggable()) {
            return;
        }
        Point pt = new Point(newX, newY);
        this.ViewToModel(pt);
        Dimension ms = this.model.getSize();
        Dimension vs = this.getViewSize();
        pt.x = Math.max(pt.x, 0);
        pt.x = Math.min(pt.x, Math.max(ms.width - 1, vs.width - 1));
        pt.y = Math.max(pt.y, 0);
        pt.y = Math.min(pt.y, Math.max(ms.height - 1, vs.height - 1));
        p.setLocation(pt.x, pt.y);
    }

    public PFDPort getNearestPort(int x, int y) {
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        return this.model.getNearestPort(pt.x, pt.y);
    }

    public AffineTransform getCurrentXfm() {
        return this.currentXfm;
    }

    public void ModelToView(Point p) {
        if (this.getCurrentXfm() == null) {
            return;
        }
        this.p2dSrc.setLocation(p.x, p.y);
        this.getCurrentXfm().transform(this.p2dSrc, this.p2dDst);
        p.x = (int)this.p2dDst.getX();
        p.y = (int)this.p2dDst.getY();
    }

    public void ModelToView(Dimension d) {
        if (this.getCurrentXfm() == null) {
            return;
        }
        this.p2dSrc.setLocation(d.width, d.height);
        this.getCurrentXfm().deltaTransform(this.p2dSrc, this.p2dDst);
        d.width = (int)this.p2dDst.getX();
        d.height = (int)this.p2dDst.getY();
    }

    public void ModelToView(Rectangle r) {
        if (this.getCurrentXfm() == null) {
            return;
        }
        Point loc = r.getLocation();
        Dimension size = r.getSize();
        this.ModelToView(loc);
        this.ModelToView(size);
        r.setLocation(loc);
        r.setSize(size);
    }

    public void ViewToModel(Point p) {
        if (this.getCurrentXfm() == null) {
            return;
        }
        this.p2dSrc.setLocation(p.x, p.y);
        try {
            this.getCurrentXfm().inverseTransform(this.p2dSrc, this.p2dDst);
        }
        catch (NoninvertibleTransformException e) {
            return;
        }
        p.x = (int)this.p2dDst.getX();
        p.y = (int)this.p2dDst.getY();
    }

    public void ViewToModel(Dimension d) {
        if (this.getCurrentXfm() == null) {
            return;
        }
        AffineTransform inv = null;
        try {
            inv = this.getCurrentXfm().createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return;
        }
        this.p2dSrc.setLocation(d.width, d.height);
        inv.deltaTransform(this.p2dSrc, this.p2dDst);
        d.width = (int)this.p2dDst.getX();
        d.height = (int)this.p2dDst.getY();
    }

    public void ViewToModel(Rectangle r) {
        if (this.getCurrentXfm() == null) {
            return;
        }
        Point loc = r.getLocation();
        Dimension size = r.getSize();
        this.ViewToModel(loc);
        this.ViewToModel(size);
        r.setLocation(loc);
        r.setSize(size);
    }

    public Point getViewPosition() {
        Point p = new Point(0, 0);
        this.ViewToModel(p);
        return p;
    }

    public void setViewPosition(Point p) {
        Point current = this.getViewPosition();
        this.translateX += (double)(current.x - p.x);
        this.translateY += (double)(current.y - p.y);
        this.xfmChanged();
        this.repaint();
        this.fireViewChange(0, "translate");
    }

    public Rectangle getViewRect() {
        Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.ViewToModel(r);
        return r;
    }

    public void setViewRect(Rectangle r) {
        if (r.width <= 1 || r.height <= 1) {
            this.repaint();
            return;
        }
        double sx = (double)this.getWidth() / (double)r.width;
        double sy = (double)this.getHeight() / (double)r.height;
        if (sx == 0.0 || sy == 0.0) {
            this.userSetViewport = r;
            this.userSetScaleToFit = false;
            return;
        }
        this.userSetViewport = null;
        this.scale = Math.min(sx, sy);
        this.updateSelectedScale();
        this.xfmChanged();
        Point current = this.getViewPosition();
        this.translateX += (double)(current.x - r.x);
        this.translateY += (double)(current.y - r.y);
        this.xfmChanged();
        this.repaint();
        this.fireViewChange(0, "all");
    }

    private void setViewRect(Rectangle r, int w, int h) {
        if (r.width <= 1 || r.height <= 1) {
            this.repaint();
            return;
        }
        double sx = (double)w / (double)r.width;
        double sy = (double)h / (double)r.height;
        this.scale = Math.min(sx, sy);
        this.updateSelectedScale();
        this.xfmChanged();
        Point current = this.getViewPosition();
        this.translateX += (double)(current.x - r.x);
        this.translateY += (double)(current.y - r.y);
        this.xfmChanged();
        this.repaint();
        this.fireViewChange(0, "all");
    }

    public Dimension getViewSize() {
        Dimension size = this.getSize();
        this.ViewToModel(size);
        return size;
    }

    public Dimension getMinViewSize() {
        Dimension size = this.getSize();
        AffineTransform transform = new AffineTransform();
        transform.scale(1.0 / this.maxZoomScale, 1.0 / this.maxZoomScale);
        this.p2dSrc.setLocation(size.width, size.height);
        transform.deltaTransform(this.p2dSrc, this.p2dDst);
        size.width = (int)this.p2dDst.getX();
        size.height = (int)this.p2dDst.getY();
        return size;
    }

    public Dimension getMaxViewSize() {
        Dimension size = this.getSize();
        AffineTransform transform = new AffineTransform();
        transform.scale(1.0 / this.minZoomScale, 1.0 / this.minZoomScale);
        this.p2dSrc.setLocation(size.width, size.height);
        transform.deltaTransform(this.p2dSrc, this.p2dDst);
        size.width = (int)this.p2dDst.getX();
        size.height = (int)this.p2dDst.getY();
        return size;
    }

    public Clipboard getClipboard() {
        return clipboard;
    }

    public void copy() {
        PFDSelectionList clonedList = this.getClonedSelectionList(this.selected);
        if (clonedList == null) {
            return;
        }
        clipboard.setContents(clonedList, this);
        this.fireViewChange(5, this.selected.getAllPrimitives());
    }

    private PFDSelectionList getClonedSelectionList(PFDSelectionList selectList) {
        PFDLink ln;
        PFDPrimitive p;
        if (selectList.hasNoPrimitives()) {
            return null;
        }
        PFDSelectionList dupSelections = selectList.duplicate();
        Vector cloned = new Vector();
        this.cloneTable.clear();
        Enumeration en = dupSelections.getAllPrimitives();
        while (en.hasMoreElements()) {
            p = (PFDPrimitive)en.nextElement();
            if (p instanceof PFDLink) {
                ln = (PFDLink)p;
                if (ln.getFromNode() == null || !dupSelections.containsPrimitive((PFDPrimitive)((Object)ln.getFromNode())) || ln.getToNode() == null || !dupSelections.containsPrimitive((PFDPrimitive)((Object)ln.getToNode()))) continue;
                this.cloneLink(ln, cloned);
                continue;
            }
            this.clonePrimitive(p, cloned);
        }
        en = dupSelections.getAllPrimitives();
        while (en.hasMoreElements()) {
            p = (PFDPrimitive)en.nextElement();
            if (p instanceof PFDLink) {
                ln = (PFDLink)p;
                if (ln.getFromNode() == null || !dupSelections.containsPrimitive((PFDPrimitive)((Object)ln.getFromNode())) || ln.getToNode() == null || !dupSelections.containsPrimitive((PFDPrimitive)((Object)ln.getToNode()))) continue;
                if (ln.isCollapsed()) {
                    List linkList = PFDSubdiagram.getExpandedLinks(ln);
                    for (int i = 0; i < linkList.size(); ++i) {
                        PFDLink link = (PFDLink)linkList.get(i);
                        this.redirectClonedLink(link);
                        PFDLink copied = (PFDLink)this.cloneTable.get(link);
                        copied.setVisible(true);
                    }
                    continue;
                }
                this.redirectClonedLink(ln);
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            g.redirectLinks(this.cloneTable);
        }
        dupSelections.removeAllPrimitives();
        for (int i = 0; i < cloned.size(); ++i) {
            dupSelections.addPrimitive((PFDPrimitive)cloned.get(i));
        }
        return dupSelections;
    }

    public void copyImageToClipboard() {
        BufferedImage img = this.getModelAsImage();
        if (img == null) {
            return;
        }
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        systemClipboard.setContents(new ClipImage(img), this);
    }

    private BufferedImage getModelAsImage() {
        double sy;
        if (this.model == null) {
            return null;
        }
        Dimension vSize = this.getSize();
        Dimension mSize = this.model.getSize();
        ++mSize.width;
        ++mSize.height;
        double sx = vSize.getWidth() / mSize.getWidth();
        double imageScale = Math.min(1.0, Math.min(sx, sy = vSize.getHeight() / mSize.getHeight()));
        ImageIterator images = new ImageIterator(vSize, imageScale, false);
        if (!images.hasNext()) {
            return null;
        }
        BufferedImage img = (BufferedImage)images.next();
        return img;
    }

    public void cut() {
        PFDSelectionList clonedList = this.getClonedSelectionList(this.selected);
        if (clonedList == null) {
            return;
        }
        clipboard.setContents(clonedList, this);
        this.setHoldDisplay(true);
        PFDSelectionList duplicate = this.selected.duplicate();
        Enumeration en = this.selected.getAllPrimitives();
        while (en.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)en.nextElement();
            p.detachView(this);
            this.model.removePrimitive(p);
        }
        this.setHoldDisplay(false);
        this.fireViewChange(4, duplicate.getAllPrimitives());
    }

    public void paste() {
        this.paste(0, 0);
    }

    public void paste(int x, int y) {
        PFDSelectionList data;
        this.setHoldDisplay(true);
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        Transferable clipboardContent = clipboard.getContents(this);
        Vector<PFDPrimitive> pasted = new Vector<PFDPrimitive>();
        try {
            data = (PFDSelectionList)clipboardContent.getTransferData(PFDSelectionList.PFD_FLAVOR);
        }
        catch (Exception e) {
            this.setHoldDisplay(false);
            return;
        }
        if (data.hasNoPrimitives()) {
            return;
        }
        List primitives = data.getPrimitives();
        for (int i = 0; i < primitives.size(); ++i) {
            PFDPrimitive clone = (PFDPrimitive)primitives.get(i);
            this.model.addPrimitive(clone);
            if (clone instanceof PFDCollapsableNodeGroup) {
                ((PFDCollapsableNodeGroup)clone).resetCollapsedState();
            }
            pasted.add(clone);
        }
        Rectangle b = data.getBBox();
        int dx = pt.x - b.x;
        int dy = pt.y - b.y;
        for (int i = 0; i < primitives.size(); ++i) {
            PFDPrimitive clone = (PFDPrimitive)primitives.get(i);
            clone.move(dx, dy);
        }
        PFDSelectionList clonedList = this.getClonedSelectionList(data);
        clipboard.setContents(clonedList, this);
        this.setHoldDisplay(false);
        this.fireViewChange(6, pasted.elements());
    }

    private void cloneLink(PFDLink l, List clonedList) {
        if (l.isCollapsed) {
            List linkList = PFDSubdiagram.getExpandedLinks(l);
            for (int i = 0; i < linkList.size(); ++i) {
                PFDLink link = (PFDLink)linkList.get(i);
                this.clonePrimitive(link, clonedList);
            }
        } else {
            this.clonePrimitive(l, clonedList);
        }
    }

    private void redirectClonedLink(PFDLink l) {
        PFDLink copiedLink = (PFDLink)this.cloneTable.get(l);
        PFDPort copiedFromPort = (PFDPort)this.cloneTable.get(l.getFromPort());
        PFDPort copiedToPort = (PFDPort)this.cloneTable.get(l.getToPort());
        if (copiedFromPort == null) {
            copiedFromPort = new PFDPort();
            copiedFromPort.setType(0);
            copiedFromPort.setFromLinkSpot(9);
            copiedFromPort.setBBox(l.getFromPort().getBBox());
        }
        if (copiedToPort == null) {
            copiedToPort = new PFDPort();
            copiedToPort.setType(0);
            copiedToPort.setToLinkSpot(9);
            copiedToPort.setBBox(l.getToPort().getBBox());
        }
        copiedLink.setFromPort(copiedFromPort);
        copiedLink.setToPort(copiedToPort);
    }

    private void clonePrimitive(PFDPrimitive p, List clonedList) {
        if (this.cloneTable.containsKey(p)) {
            return;
        }
        Object o = p.cloneObject(this.cloneTable);
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            clonedList.addAll((List)o);
        } else {
            clonedList.add(o);
        }
    }

    public boolean drop(int x, int y, Transferable transfer) {
        this.setHoldDisplay(false);
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        try {
            PFDSelectionList data = (PFDSelectionList)transfer.getTransferData(PFDSelectionList.PFD_FLAVOR);
            if (data.hasNoPrimitives()) {
                return false;
            }
            Rectangle b = data.getBBox();
            int dx = pt.x - b.x;
            int dy = pt.y - b.y;
            Enumeration en = data.getAllPrimitives();
            while (en.hasMoreElements()) {
                PFDPrimitive p = (PFDPrimitive)en.nextElement();
                if (p instanceof PFDLink) {
                    PFDLink ln = (PFDLink)p;
                    if (ln.getFromNode() == null || !data.containsPrimitive((PFDPrimitive)((Object)ln.getFromNode())) || ln.getToNode() == null || !data.containsPrimitive((PFDPrimitive)((Object)ln.getToNode()))) continue;
                    ln.updateCustomBreakPoints(dx, dy);
                }
                p.move(dx, dy);
                PFDPrimitive tlp = this.getTopLevelPrimitive(p);
                this.model.addPrimitive(tlp);
                this.dropExpanded(tlp);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (UnsupportedFlavorException e) {
            System.out.println(e.getMessage());
            return false;
        }
        this.setHoldDisplay(false);
        return true;
    }

    public boolean dropPrimitive(int x, int y, PFDPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (!bounds.contains(x, y)) {
            return false;
        }
        this.setHoldDisplay(true);
        Point pt = new Point(x, y);
        this.ViewToModel(pt);
        primitive.setLocation(pt);
        boolean rv = this.model.addPrimitive(primitive);
        this.setHoldDisplay(false);
        return rv;
    }

    private PFDPrimitive getTopLevelPrimitive(PFDPrimitive p) {
        PFDPrimitive collapsed = p.getCollapsed();
        if (!p.isCollapsable() || collapsed == null) {
            return p;
        }
        return this.getTopLevelPrimitive(collapsed);
    }

    private PFDPrimitive getBottomLevelPrimitive(PFDPrimitive p) {
        PFDPrimitive expanded = p.getExpanded();
        if (!p.isExpandable() || expanded == null) {
            return p;
        }
        return this.getBottomLevelPrimitive(expanded);
    }

    private void dropExpanded(PFDPrimitive p) {
        PFDPrimitive expanded = p.getExpanded();
        if (!p.isExpandable() || expanded == null) {
            return;
        }
        this.model.addPrimitive(expanded);
        this.dropExpanded(expanded);
    }

    private void dropCollapsed(PFDPrimitive p) {
        PFDPrimitive collapsed = p.getCollapsed();
        if (!p.isCollapsable() || collapsed == null) {
            return;
        }
        this.model.addPrimitive(collapsed);
        this.dropCollapsed(collapsed);
    }

    public void startDrag() {
        this.dragSource = true;
    }

    public void endDrag() {
        this.dragSource = false;
        this.lmbDown = false;
        this.rmbDown = false;
    }

    public boolean isDragSource() {
        return this.dragSource;
    }

    public void clear() {
        this.setHoldDisplay(true);
        Enumeration en = this.selected.getAllPrimitives();
        while (en.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)en.nextElement();
            p.detachView(this);
            this.model.removePrimitive(p);
        }
        this.clearSelections();
        this.setHoldDisplay(false);
        this.fireViewChange(8);
    }

    public void duplicate() {
        PFDPrimitive p;
        this.setHoldDisplay(true);
        this.cloneTable.clear();
        Vector<PFDPrimitive> duplicated = new Vector<PFDPrimitive>();
        if (this.selected.hasNoPrimitives()) {
            return;
        }
        Enumeration en = this.selected.getAllPrimitives();
        while (en.hasMoreElements()) {
            PFDLink ln;
            p = (PFDPrimitive)en.nextElement();
            PFDPrimitive copied = (PFDPrimitive)p.cloneObject(this.cloneTable);
            if (copied == null || p instanceof PFDLink && ((ln = (PFDLink)p).getFromNode() == null || !this.selected.containsPrimitive((PFDPrimitive)((Object)ln.getFromNode())) || ln.getToNode() == null || !this.selected.containsPrimitive((PFDPrimitive)((Object)ln.getToNode())))) continue;
            this.model.addPrimitive(copied);
            duplicated.addElement(copied);
        }
        en = this.selected.getAllPrimitives();
        while (en.hasMoreElements()) {
            PFDLink ln;
            p = (PFDPrimitive)en.nextElement();
            if (!(p instanceof PFDLink) || (ln = (PFDLink)p).getFromNode() == null || !this.selected.containsPrimitive((PFDPrimitive)((Object)ln.getFromNode())) || ln.getToNode() == null || !this.selected.containsPrimitive((PFDPrimitive)((Object)ln.getToNode()))) continue;
            PFDLink copiedLink = (PFDLink)this.cloneTable.get(ln);
            PFDPort copiedFromPort = (PFDPort)this.cloneTable.get(ln.getFromPort());
            PFDPort copiedToPort = (PFDPort)this.cloneTable.get(ln.getToPort());
            copiedLink.setFromPort(copiedFromPort);
            copiedLink.setToPort(copiedToPort);
        }
        this.setHoldDisplay(false);
        this.fireViewChange(7, duplicated.elements());
    }

    @Override
    public JToolTip createToolTip() {
        PFDMultiLineToolTip toolTip = new PFDMultiLineToolTip();
        toolTip.setComponent(this);
        return toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.toolTipEnabled && this.mouseOverPrimitive != null) {
            Point loc = event.getPoint();
            this.ViewToModel(loc);
            MouseEvent me = new MouseEvent(this, event.getID(), event.getWhen(), event.getModifiers(), loc.x, loc.y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
            return this.mouseOverPrimitive.getToolTipText(me);
        }
        return null;
    }

    public String getDragTipText(MouseEvent event) {
        return this.dragTipText;
    }

    public void buildRenderables() {
        this.xfmChanged();
        for (int i = 0; i < this.model.getNumLayers(); ++i) {
            PFDLayer layer = this.model.getLayer(i);
            for (int j = 0; j < layer.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getOrderedPrimitive(j);
                p.build(this);
            }
        }
        this.fireViewChange(0, "all");
    }

    @Override
    public void paint(Graphics g) {
        if (this.cleanBufferDirty && this.renderMode == 2) {
            this.renderMode = 0;
        }
        this.prevXORbox = null;
        if (this.renderMode != 2) {
            super.paint(g);
        } else {
            this.blitBackBuffer(g);
        }
        if (this.dragMode == 5) {
            Point clickedViewPoint = new Point(this.clickedModelPoint);
            this.ModelToView(clickedViewPoint);
            this.drawRubberBand((Graphics2D)g, Math.min(clickedViewPoint.x, this.prevx), Math.min(clickedViewPoint.y, this.prevy), Math.abs(this.prevx - clickedViewPoint.x), Math.abs(this.prevy - clickedViewPoint.y), false);
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (this.holdDisplay) {
            return;
        }
        super.paintComponent(g);
        this.renderDrawablePrimitives(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
    }

    public Rectangle convertChildCoords(JComponent comp, int x, int y, int w, int h) {
        JComponent topChild = this.getTopChild(comp);
        if (this.childComponentTable == null || topChild == null) {
            return new Rectangle(x, y, w, h);
        }
        PFDComponentPrimitive p = (PFDComponentPrimitive)this.childComponentTable.get(topChild);
        if (p == null) {
            return new Rectangle(x, y, w, h);
        }
        Point loc = SwingUtilities.convertPoint(comp, x, y, topChild);
        loc.translate(p.getX(), p.getY());
        Rectangle bounds = new Rectangle(loc.x, loc.y, w, h);
        this.ModelToView(bounds);
        return bounds;
    }

    private JComponent getTopChild(JComponent child) {
        if (child == this) {
            return child;
        }
        Container topChild = child;
        for (Container p = child.getParent(); p != null && p != this; p = p.getParent()) {
            topChild = p;
        }
        if (topChild instanceof JComponent) {
            return topChild;
        }
        return null;
    }

    public Component add(Component comp, PFDComponentPrimitive primitive) {
        if (this.childComponentTable == null) {
            this.childComponentTable = new Hashtable();
        }
        this.childComponentTable.put(comp, primitive);
        return this.add(comp);
    }

    @Override
    public void remove(Component comp) {
        if (this.childComponentTable != null) {
            this.childComponentTable.remove(comp);
        }
        super.remove(comp);
    }

    protected synchronized void renderPageDivider(Graphics2D g2d, Rectangle clipRect) {
        if (this.pageFormat == null) {
            return;
        }
        if (this.pageFormat.getImageableWidth() == 0.0 || this.pageFormat.getImageableHeight() == 0.0) {
            return;
        }
        Dimension ms = this.model.getSize();
        g2d.setColor(this.pageDividerColor);
        float[] dash = new float[]{20.0f, 5.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        g2d.setStroke(dashed);
        int ls = clipRect.y;
        int le = clipRect.y + clipRect.height;
        int x = 0;
        while (x < ms.width) {
            if (x >= clipRect.x && x <= clipRect.x + clipRect.width) {
                g2d.drawLine(x, ls, x, le);
            }
            x = (int)((double)x + this.pageFormat.getImageableWidth());
        }
        ls = clipRect.x;
        le = clipRect.x + clipRect.width;
        int y = 0;
        while (y < ms.height) {
            if (y >= clipRect.y && y <= clipRect.y + clipRect.height) {
                g2d.drawLine(ls, y, le, y);
            }
            y = (int)((double)y + this.pageFormat.getImageableHeight());
        }
    }

    protected synchronized void renderGrid(Graphics2D g2d, Rectangle clipRect) {
        Dimension ms = this.model.getSize();
        g2d.setColor(this.gridColor);
        switch (this.gridType) {
            case 0: {
                int ls = clipRect.y;
                int le = clipRect.y + clipRect.height;
                for (int x = 0; x < Math.max(ms.width, clipRect.x + clipRect.width); x += this.gridSpaceX) {
                    if (x < clipRect.x || x > clipRect.x + clipRect.width) continue;
                    g2d.drawLine(x, ls, x, le);
                }
                ls = clipRect.x;
                le = clipRect.x + clipRect.width;
                for (int y = 0; y < Math.max(ms.height, clipRect.y + clipRect.height); y += this.gridSpaceY) {
                    if (y < clipRect.y || y > clipRect.y + clipRect.height) continue;
                    g2d.drawLine(ls, y, le, y);
                }
                break;
            }
            case 1: {
                float[] dashX = new float[]{2.0f, (float)this.gridSpaceX - 2.0f};
                BasicStroke dashedX = new BasicStroke(2.0f, 0, 0, 1.0f, dashX, 1.0f);
                g2d.setStroke(dashedX);
                int ls = clipRect.x;
                int le = clipRect.x + clipRect.width;
                for (int y = 0; y < Math.max(ms.height, clipRect.y + clipRect.height); y += this.gridSpaceY) {
                    if (y < clipRect.y || y > clipRect.y + clipRect.height) continue;
                    g2d.drawLine(0, y, ms.width, y);
                }
                break;
            }
        }
    }

    protected void setShowAnnotation(boolean b) {
        this.showAnnotation = b;
    }

    protected synchronized void renderDrawablePrimitives(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.transform(this.currentXfm);
        if (this.renderQuality == 0) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        Rectangle clipBounds = g2d.getClipBounds();
        if (clipBounds == null) {
            clipBounds = this.getViewRect();
            g2d.setClip(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        if (this.gridVisible && this.renderMode != 2) {
            this.renderGrid(g2d, clipBounds);
        }
        if (this.pageDividerVisible && this.renderMode != 2) {
            this.renderPageDivider(g2d, clipBounds);
        }
        if (this.backLayerAnnotate != null && this.renderMode != 2) {
            Graphics2D annoGraphics = (Graphics2D)g.create();
            this.backLayerAnnotate.draw(annoGraphics);
            annoGraphics.dispose();
        }
        for (int i = 0; i < this.model.getNumLayers(); ++i) {
            PFDLayer layer = this.model.getLayer(i);
            for (int j = 0; j < layer.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getPrimitive(j);
                p.paint(g2d, this);
            }
        }
        if (this.showAnnotation) {
            Enumeration en = this.selected.getAllPrimitives();
            while (en.hasMoreElements()) {
                PFDHandle h;
                PFDPrimitive p = (PFDPrimitive)en.nextElement();
                if (!p.isVisible() || p.isCustomSelection() || (h = this.selected.getHandleFor(p)) == null) continue;
                h.setDrawFilledHandles(!en.hasMoreElements());
                h.paint(g2d, this, false, false);
            }
        }
        g2d.dispose();
    }

    protected boolean isFastRenderEnabled() {
        return this.fastRenderEnabled;
    }

    protected void setFastRenderEnabled(boolean b) {
        this.fastRenderEnabled = b;
    }

    protected void resetRenderMode() {
        this.renderMode = 0;
    }

    protected void copyToCleanBuffer() {
        if (this.renderMode != 0) {
            return;
        }
        this.renderMode = 1;
        Graphics2D g = this.cleanBuffer.createGraphics();
        this.paint(g);
        g.dispose();
        this.cleanBufferDirty = false;
    }

    protected void blitCleanBuffer() {
        if (this.cleanBufferDirty) {
            this.cleanBufferDirty = false;
            boolean tempHold = this.holdDisplay;
            this.holdDisplay = false;
            int tempMode = this.renderMode;
            this.renderMode = 0;
            this.copyToCleanBuffer();
            this.holdDisplay = tempHold;
            this.renderMode = tempMode;
        }
        Graphics2D g = this.backBuffer.createGraphics();
        g.drawImage(this.cleanBuffer, 0, 0, this.getWidth(), this.getHeight(), this);
        g.dispose();
    }

    protected void renderDraggedPrimitives() {
        this.renderMode = 2;
        Graphics2D g = this.backBuffer.createGraphics();
        this.renderDrawablePrimitives(g);
        g.dispose();
    }

    protected void blitBackBuffer(Graphics g) {
        g.drawImage(this.backBuffer, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (this.printMode == 0) {
            return this.printAllInOne(g, pf, pi);
        }
        if (this.printMode == 1) {
            return this.printPages(g, pf, pi);
        }
        return 1;
    }

    private int printAllInOne(Graphics g, PageFormat pf, int pi) {
        if (pi >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        double px = pf.getImageableWidth() / (double)this.model.getSize().width;
        double py = pf.getImageableHeight() / (double)this.model.getSize().height;
        double s = Math.min(px, py);
        AffineTransform defaultXfm = g2d.getTransform();
        AffineTransform xfm = new AffineTransform(defaultXfm);
        xfm.scale(s, s);
        g2d.setTransform(xfm);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.model.getSize().width, this.model.getSize().height);
        }
        if (this.gridVisible) {
            this.renderGrid(g2d, new Rectangle(0, 0, this.model.getSize().width, this.model.getSize().height));
        }
        for (int i = 0; i < this.model.getNumLayers(); ++i) {
            PFDLayer layer = this.model.getLayer(i);
            for (int j = 0; j < this.model.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getPrimitive(j);
                p.paint(g2d);
            }
        }
        g2d.setTransform(defaultXfm);
        g2d.scale(s, s);
        this.paintChildren(g2d);
        return 0;
    }

    private int printPages(Graphics g, PageFormat pf, int pi) {
        int nrows;
        Dimension ms = this.model.getSize();
        int ncols = (int)Math.round((double)ms.width / pf.getImageableWidth() + 0.5);
        int totalPages = ncols * (nrows = (int)Math.round((double)ms.height / pf.getImageableHeight() + 0.5));
        if (pi >= totalPages) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        int row = pi / ncols;
        int col = pi - row * ncols;
        double tx = (double)(-col) * pf.getImageableWidth();
        double ty = (double)(-row) * pf.getImageableHeight();
        AffineTransform defaultXfm = g2d.getTransform();
        AffineTransform xfm = new AffineTransform(defaultXfm);
        xfm.translate(tx, ty);
        g2d.setTransform(xfm);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Rectangle clipBounds = new Rectangle(-((int)tx), -((int)ty), (int)pf.getImageableWidth(), (int)pf.getImageableHeight());
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(-((int)tx), -((int)ty), (int)pf.getImageableWidth(), (int)pf.getImageableHeight());
        }
        if (this.gridVisible) {
            this.renderGrid(g2d, clipBounds);
        }
        for (int i = 0; i < this.model.getNumLayers(); ++i) {
            PFDLayer layer = this.model.getLayer(i);
            for (int j = 0; j < this.model.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getPrimitive(j);
                if (!clipBounds.intersects(p.getRBBox())) continue;
                p.paint(g2d);
            }
        }
        if (this.printGridNumber) {
            FontMetrics fm = g2d.getFontMetrics();
            String footer = "(" + row + ", " + col + ")";
            int td = fm.getDescent();
            int tw = fm.stringWidth(footer);
            int x = (int)(pf.getImageableWidth() - tx) - tw;
            int y = (int)(pf.getImageableHeight() - ty) - td;
            g2d.setColor(this.getForeground());
            g2d.drawString(footer, x, y);
        }
        g2d.setTransform(defaultXfm);
        g2d.translate(tx, ty);
        this.paintChildren(g2d);
        g2d.translate(-tx, -ty);
        return 0;
    }

    protected int getDocumentWidth() {
        return this.getDocumentSize().width;
    }

    protected int getDocumentHeight() {
        return this.getDocumentSize().height;
    }

    protected Dimension getDocumentSize() {
        Rectangle annoBounds;
        Rectangle viewRect = this.getViewRect();
        Dimension size = new Dimension(viewRect.x + viewRect.width, viewRect.y + viewRect.height);
        if (this.model != null) {
            Dimension modelSize = this.model.getSize();
            size.width = Math.max(modelSize.width, size.width);
            size.height = Math.max(modelSize.height, size.height);
        }
        if (this.pfdAnnoComponent != null) {
            annoBounds = this.pfdAnnoComponent.getAnnotateBounds();
            size.width = Math.max(annoBounds.x + annoBounds.width, size.width);
            size.height = Math.max(annoBounds.y + annoBounds.height, size.height);
        }
        if (this.backLayerAnnotate != null) {
            annoBounds = this.backLayerAnnotate.getAnnotateBounds();
            size.width = Math.max(annoBounds.x + annoBounds.width, size.width);
            size.height = Math.max(annoBounds.y + annoBounds.height, size.height);
        }
        return size;
    }

    protected void xfmChanged() {
        this.currentXfm = new AffineTransform();
        int vw = this.getWidth();
        int vh = this.getHeight();
        if (this.userSetAlwaysCropAndScaleToFit) {
            Dimension ms = this.model.getSize();
            int w = ms.width + 1;
            int h = ms.height + 1;
            double sx = (double)vw / (double)w;
            double sy = (double)vh / (double)h;
            double s = Math.min(sx, sy);
            this.currentXfm.scale(s, s);
            this.currentXfm.translate(((double)vw - s * (double)w) / 2.0 / s, ((double)vh - s * (double)h) / 2.0 / s);
        } else if (this.scaleToFit) {
            Dimension ms = this.model.getSize();
            int w = ms.width + 1;
            int h = ms.height + 1;
            double sx = (double)vw / (double)w;
            double sy = (double)vh / (double)h;
            double s = Math.min(sx, sy);
            this.currentXfm.scale(s, s);
        } else if (this.zoomAtCenter) {
            this.currentXfm.translate(vw / 2, vh / 2);
            this.currentXfm.scale(this.scale, this.scale);
            this.currentXfm.translate(this.translateX - (double)(vw / 2), this.translateY - (double)(vh / 2));
        } else {
            this.currentXfm.scale(this.scale, this.scale);
            this.currentXfm.translate(this.translateX, this.translateY);
        }
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.getPFDAnnotate().setDirty();
        }
        if (this.backLayerAnnotate != null) {
            this.backLayerAnnotate.setDirty();
        }
    }

    @Override
    public void modelChanged(PFDModelEvent e) {
        int type = e.getType();
        Rectangle repaintBounds = null;
        if (type == 7) {
            PFDPrimitive p = e.getPrimitive();
            p.update(e.getProperty(), this);
            repaintBounds = p.getRepaintBBox();
            this.tabOrderDirty = true;
        } else if (type == 4) {
            PFDPrimitive p = e.getPrimitive();
            p.build(this);
            if (this.snapToGrid) {
                this.snapPrimitiveToGrid(p);
            } else if (!this.userSetAlwaysCropAndScaleToFit) {
                Point loc = p.getLocation();
                loc.x = Math.max(0, loc.x);
                loc.y = Math.max(0, loc.y);
                p.setLocation(loc);
            }
            repaintBounds = p.getRepaintBBox();
            this.tabOrderDirty = true;
        } else if (type == 10) {
            this.xfmChanged();
            this.fireViewChange(0, "all");
        } else if (type == 5) {
            PFDPrimitive p = e.getPrimitive();
            if (p instanceof PFDLink) {
                PFDSubdiagram.deleteLink((PFDLink)p, this.getModel());
            }
            this.deselectPrimitive(p);
            repaintBounds = p.getRepaintBBox();
            this.tabOrderDirty = true;
        } else if (type == 13) {
            PFDPrimitive p = e.getPrimitive();
            p.build(this);
            repaintBounds = p.getRepaintBBox();
        }
        if (repaintBounds != null) {
            this.ModelToView(repaintBounds);
            --repaintBounds.x;
            --repaintBounds.y;
            repaintBounds.width += 2;
            repaintBounds.height += 2;
            this.repaint(repaintBounds);
        } else {
            this.repaint();
        }
    }

    public void repaint(PFDPrimitive p) {
        if (p == null) {
            return;
        }
        Rectangle repaintBounds = p.getRepaintBBox();
        this.ModelToView(repaintBounds);
        --repaintBounds.x;
        --repaintBounds.y;
        repaintBounds.width += 2;
        repaintBounds.height += 2;
        this.repaint(repaintBounds);
    }

    public void addPFDViewListener(PFDViewListener l) {
        this.listenerList.add(PFDViewListener.class, l);
    }

    public void removePFDViewListener(PFDViewListener l) {
        this.listenerList.remove(PFDViewListener.class, l);
    }

    protected void firePFDViewChanged(PFDViewEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PFDViewListener.class) continue;
            ((PFDViewListener)listeners[i + 1]).viewChanged(e);
        }
    }

    protected void fireViewChange(int type, String property) {
        if (!this.enableUpdate) {
            return;
        }
        PFDViewEvent e = new PFDViewEvent(this, type, property);
        this.firePFDViewChanged(e);
    }

    protected void fireViewChange(int type) {
        if (!this.enableUpdate) {
            return;
        }
        PFDViewEvent e = new PFDViewEvent(this, type, null);
        this.firePFDViewChanged(e);
    }

    protected void fireViewChange(int type, Object value) {
        if (!this.enableUpdate) {
            return;
        }
        PFDViewEvent e = new PFDViewEvent(this, type, null, value);
        this.firePFDViewChanged(e);
    }

    protected void fireViewChange(int type, String property, PFDAbstractNode of, PFDAbstractNode nf, PFDAbstractNode ot, PFDAbstractNode nt, PFDLink link) {
        if (!this.enableUpdate) {
            return;
        }
        if (of == nf && ot == nt) {
            return;
        }
        PFDViewEvent e = new PFDViewEvent(this, type, property, of, nf, ot, nt, link);
        this.firePFDViewChanged(e);
    }

    protected void fireViewChange(int type, String property, PFDAbstractNode of, PFDPort ofp, PFDAbstractNode nf, PFDPort nfp, PFDAbstractNode ot, PFDPort otp, PFDAbstractNode nt, PFDPort ntp, PFDLink link) {
        if (!this.enableUpdate) {
            return;
        }
        if (ofp == nfp && otp == ntp) {
            return;
        }
        PFDViewEvent e = new PFDViewEvent(this, type, property, of, ofp, nf, nfp, ot, otp, nt, ntp, link);
        this.firePFDViewChanged(e);
    }

    @Override
    public void lostOwnership(Clipboard c, Transferable t) {
    }

    public void setDragMode(int mode) {
        this.dragMode = mode;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    private MouseEvent createPrimitiveMouseEvent(MouseEvent e) {
        Point loc = e.getPoint();
        this.ViewToModel(loc);
        MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return me;
    }

    private void firePrimitiveMouseEvent(MouseEvent e) {
        if (e == null) {
            return;
        }
        for (int i = this.model.getNumLayers() - 1; i >= 0 && !e.isConsumed(); --i) {
            PFDLayer layer = this.model.getLayer(i);
            for (int j = layer.getNumPrimitives() - 1; j >= 0 && !e.isConsumed(); --j) {
                PFDPrimitive p = layer.getPrimitive(j);
                if (!p.visible || !p.contains(e.getX(), e.getY())) continue;
                p.dispatchEvent(e);
            }
        }
        if (!e.isConsumed()) {
            this.setMouseOverPrimitive(null, e);
        }
    }

    private int getMouseExtendedMode(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return 4;
        }
        if ((e.getModifiersEx() & 0x400) != 0) {
            if (e.isShiftDown() && e.isControlDown()) {
                return 3;
            }
            if (e.isShiftDown()) {
                return 1;
            }
            if (e.isControlDown()) {
                return 2;
            }
            if (e.isAltDown()) {
                return 6;
            }
            return 0;
        }
        return 4;
    }

    protected boolean isDragged(PFDPrimitive p) {
        PFDLinkLabel ll;
        PFDLink l;
        if (this.newLinks != null && this.newLinks.contains(p)) {
            return true;
        }
        if (p == this.redirectingLink) {
            return true;
        }
        if (p == this.resizePrimitive) {
            return true;
        }
        if (this.isMovePrimitive(p)) {
            return true;
        }
        if (p instanceof PFDLink) {
            PFDLink l2 = (PFDLink)p;
            PFDPort from = l2.getFromPort();
            if (from != null && this.isMovePrimitive(from)) {
                return true;
            }
            PFDPort to = l2.getToPort();
            if (to != null && this.isMovePrimitive(to)) {
                return true;
            }
        }
        if (p instanceof PFDLinkLabel && (l = (ll = (PFDLinkLabel)p).getLink()) != null) {
            PFDPort from = l.getFromPort();
            if (from != null && (this.isMovePrimitive(from) || from == this.floatingPort || from == this.lastSnappedPort)) {
                return true;
            }
            PFDPort to = l.getToPort();
            if (to != null && (this.isMovePrimitive(to) || to == this.floatingPort || to == this.lastSnappedPort)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.dragMode == 9) {
            this.setMouseOverPrimitive(null, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        if (this.dragMode != 9) {
            return;
        }
        this.clickedX = e.getX();
        this.clickedY = e.getY();
        this.prevx = this.clickedX;
        this.prevy = this.clickedY;
        this.initialOffsetX = 0;
        this.initialOffsetY = 0;
        this.draggingAction = false;
        this.clickedModelPoint.setLocation(this.clickedX, this.clickedY);
        this.ViewToModel(this.clickedModelPoint);
        this.mouseExtendedMode = this.getMouseExtendedMode(e);
        if (this.mouseMode == 1) {
            if (this.mouseExtendedMode == 0) {
                this.dragMode = 7;
            }
        } else if (this.mouseMode == 2) {
            if (this.mouseExtendedMode == 0 && this.scale < this.maxZoomScale) {
                this.dragMode = 6;
            }
        } else if (this.mouseMode == 0) {
            if (this.model == null) {
                return;
            }
            if (this.keyboardEnabled) {
                this.endTextEditing(e.getX(), e.getY());
            }
            if (this.mouseExtendedMode != 2) {
                if (this.pfdAnnoComponent != null) {
                    this.pfdAnnoComponent.getPFDAnnotate().clearSelections();
                }
                if (this.backLayerAnnotate != null && this.mouseExtendedMode != 4) {
                    this.backLayerAnnotate.clearSelections();
                }
            }
            this.dragMode = 9;
            switch (this.mouseExtendedMode) {
                case 0: 
                case 2: {
                    this.resizeHandle = this.pickHandle(e.getX(), e.getY());
                    if (this.resizeHandle >= 0) {
                        this.resizePrimitive = this.selected.getLastPrimitive();
                        this.dragMode = 4;
                        break;
                    }
                    Point loc = e.getPoint();
                    this.ViewToModel(loc);
                    MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    this.firePrimitiveMouseEvent(me);
                    if (me.isConsumed()) {
                        this.backgroundClicked = false;
                        if (this.mouseOverPrimitive == null) break;
                        this.bringPrimitiveToFront(this.mouseOverPrimitive);
                        loc = this.mouseOverPrimitive.getTopMovePrimitive().getSpotLocation(10, null);
                        this.ModelToView(loc);
                        this.initialOffsetX = loc.x - e.getX();
                        this.initialOffsetY = loc.y - e.getY();
                        break;
                    }
                    if (this.backAnnotateContains(e.getX(), e.getY())) {
                        this.backgroundClicked = false;
                        this.backLayerAnnotate.mousePressed(e);
                        this.dragMode = 10;
                        break;
                    }
                    this.backgroundClicked = true;
                    if (this.mouseExtendedMode == 0) {
                        this.clearSelections();
                    }
                    this.dragMode = 5;
                    break;
                }
                case 4: {
                    Point loc = e.getPoint();
                    this.ViewToModel(loc);
                    MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    this.firePrimitiveMouseEvent(me);
                    if (me.isConsumed()) {
                        if (this.backLayerAnnotate != null) {
                            this.backLayerAnnotate.clearSelections();
                        }
                        this.backgroundClicked = false;
                        if (this.mouseOverPrimitive != null) {
                            this.bringPrimitiveToFront(this.mouseOverPrimitive);
                            loc = this.mouseOverPrimitive.getLocation();
                            this.ModelToView(loc);
                            this.initialOffsetX = loc.x - e.getX();
                            this.initialOffsetY = loc.y - e.getY();
                        }
                    } else if (this.backAnnotateContains(e.getX(), e.getY())) {
                        this.backgroundClicked = false;
                        this.backLayerAnnotate.mousePressed(e);
                        this.dragMode = 10;
                    } else {
                        if (this.backLayerAnnotate != null) {
                            this.backLayerAnnotate.clearSelections();
                        }
                        this.backgroundClicked = true;
                        this.clearSelections();
                    }
                    this.showPopupMenu(e);
                    break;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseMode == 1) {
            this.dragMode = 9;
        } else if (this.mouseMode == 2) {
            if (this.dragMode == 6) {
                this.roiZoom(Math.min(this.clickedX, e.getX()), Math.min(this.clickedY, e.getY()), Math.abs(e.getX() - this.clickedX), Math.abs(e.getY() - this.clickedY));
                this.prevXORbox = null;
            }
            this.dragMode = 9;
        } else if (this.mouseMode == 0) {
            if (this.selectedNode != null) {
                this.selected.removePrimitive(this.selectedNode);
                this.repaint(this.selectedNode);
                this.selectedNode = null;
            }
            this.lastSelectedNode = null;
            this.resetRenderMode();
            switch (this.dragMode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.endDragLinkTo();
                    break;
                }
                case 2: {
                    this.endDragLinkFrom();
                    break;
                }
                case 3: {
                    this.endDragNewLink();
                    break;
                }
                case 4: {
                    this.resizePrimitive.endResize();
                    this.resizePrimitive = null;
                    break;
                }
                case 5: {
                    Point clickedViewPoint = new Point(this.clickedModelPoint);
                    this.ModelToView(clickedViewPoint);
                    this.selectArea(Math.min(clickedViewPoint.x, e.getX()), Math.min(clickedViewPoint.y, e.getY()), Math.abs(e.getX() - clickedViewPoint.x), Math.abs(e.getY() - clickedViewPoint.y));
                    this.prevXORbox = null;
                    break;
                }
                case 9: {
                    Point loc = e.getPoint();
                    this.ViewToModel(loc);
                    MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    this.firePrimitiveMouseEvent(me);
                    this.showPopupMenu(e);
                    break;
                }
                case 8: {
                    if (this.mouseOverPrimitive instanceof PFDComponentPrimitive) {
                        Point loc = e.getPoint();
                        this.ViewToModel(loc);
                        MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                        ((PFDComponentPrimitive)this.mouseOverPrimitive).fireDraggedComponentMouseEvent(me);
                        break;
                    }
                    System.out.println("ERROR: mouseOverPrimitive is not instanceof PFDComponentPrimitive");
                    break;
                }
                case 10: {
                    this.backLayerAnnotate.mouseReleased(e);
                }
            }
            this.dragPort = null;
            this.dragMode = 9;
            if (this.draggingAction) {
                this.draggingAction = false;
                this.fireViewChange(2);
            }
            this.initialOffsetX = 0;
            this.initialOffsetY = 0;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseMode == 0) {
            PFDText text;
            Point loc = e.getPoint();
            this.ViewToModel(loc);
            MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            this.firePrimitiveMouseEvent(me);
            if (!me.isConsumed() && this.keyboardEnabled && e.getClickCount() == 2 && (text = this.pickText(e.getX(), e.getY())) != null && text.isSelectable()) {
                this.startTextEditing(text);
            }
            if (!me.isConsumed() && this.backAnnotateContains(e.getX(), e.getY())) {
                this.backLayerAnnotate.mouseClicked(e);
            }
        } else if (this.mouseMode == 2) {
            if (this.mouseExtendedMode == 6) {
                this.decreaseScale(e.getPoint());
            } else if (this.mouseExtendedMode == 0) {
                this.increaseScale(e.getPoint());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragTipText = null;
        if (this.mouseMode == 1) {
            if (this.dragMode == 7) {
                this.setCursor(6);
                this.panView(e.getX() - this.prevx, e.getY() - this.prevy);
            }
        } else if (this.mouseMode == 2) {
            if (this.dragMode == 6) {
                this.drawRubberBand(Math.min(this.clickedX, e.getX()), Math.min(this.clickedY, e.getY()), Math.abs(e.getX() - this.clickedX), Math.abs(e.getY() - this.clickedY), false);
            }
        } else if (this.mouseMode == 0) {
            this.setFastRenderEnabled(true);
            switch (this.dragMode) {
                case 0: {
                    if (!this.draggingAction) {
                        this.draggingAction = true;
                        this.fireViewChange(1);
                    }
                    Dimension movement = this.calculateDragMovement(new Point(this.prevx, this.prevy), e.getPoint(), false);
                    if (this.snapToGrid) {
                        Point pt = this.mouseOverPrimitive.getTopMovePrimitive().getSpotLocation(10, null);
                        this.ModelToView(pt);
                        int xo = pt.x;
                        int yo = pt.y;
                        pt.x = e.getX() + this.initialOffsetX;
                        pt.y = e.getY() + this.initialOffsetY;
                        this.snapViewGrid(pt);
                        movement.width = pt.x - xo;
                        movement.height = pt.y - yo;
                    }
                    this.moveSelected(movement.width, movement.height);
                    break;
                }
                case 1: 
                case 2: {
                    if (!this.draggingAction) {
                        this.draggingAction = true;
                        this.fireViewChange(1);
                    }
                    if (this.isFastRenderEnabled()) {
                        this.copyToCleanBuffer();
                    }
                    this.setHoldDisplay(true);
                    this.calculateDragMovement(new Point(this.prevx, this.prevy), e.getPoint(), true);
                    this.movePrimitive(this.floatingPort, e.getX(), e.getY());
                    this.lastSelectedNode = this.selectedNode;
                    this.selectedNode = null;
                    this.cursorSet = false;
                    this.linkSnapped = false;
                    Point loc = e.getPoint();
                    this.ViewToModel(loc);
                    MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    this.firePrimitiveMouseEvent(me);
                    if (!this.cursorSet) {
                        this.setCursor(1);
                    }
                    if (!this.linkSnapped) {
                        if (this.redirectingLink.getFromPort() == this.lastSnappedPort) {
                            this.redirectingLink.setFromPort(this.floatingPort);
                        }
                        if (this.redirectingLink.getToPort() == this.lastSnappedPort) {
                            this.redirectingLink.setToPort(this.floatingPort);
                        }
                        this.redirectingLink.resetBreakPoints();
                    }
                    if (this.lastSelectedNode != this.selectedNode) {
                        if (this.lastSelectedNode != null) {
                            this.selected.removePrimitive(this.lastSelectedNode);
                        }
                        if (this.selectedNode != null) {
                            this.selected.addPrimitive(this.selectedNode);
                        }
                        this.setCleanBufferDirty();
                    }
                    if (this.isFastRenderEnabled()) {
                        this.blitCleanBuffer();
                        this.renderDraggedPrimitives();
                    }
                    this.setHoldDisplay(false);
                    break;
                }
                case 3: {
                    if (!this.draggingAction) {
                        this.draggingAction = true;
                        this.startDragNewLink();
                        this.fireViewChange(1);
                    }
                    if (this.isFastRenderEnabled()) {
                        this.copyToCleanBuffer();
                    }
                    this.setHoldDisplay(true);
                    this.calculateDragMovement(new Point(this.prevx, this.prevy), e.getPoint(), true);
                    this.movePrimitive(this.floatingPort, e.getX(), e.getY());
                    this.lastSelectedNode = this.selectedNode;
                    this.selectedNode = null;
                    this.cursorSet = false;
                    this.linkSnapped = false;
                    Point loc = e.getPoint();
                    this.ViewToModel(loc);
                    MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    this.firePrimitiveMouseEvent(me);
                    if (!this.cursorSet) {
                        this.setCursor(2);
                    }
                    if (!this.linkSnapped) {
                        for (int i = 0; i < this.newLinks.size(); ++i) {
                            PFDLink l = (PFDLink)this.newLinks.elementAt(i);
                            if (l == null) continue;
                            l.setToPort(this.floatingPort);
                            l.resetBreakPoints();
                        }
                    }
                    if (this.lastSelectedNode != this.selectedNode) {
                        if (this.lastSelectedNode != null) {
                            this.selected.removePrimitive(this.lastSelectedNode);
                        }
                        if (this.selectedNode != null) {
                            this.selected.addPrimitive(this.selectedNode);
                        }
                        this.setCleanBufferDirty();
                    }
                    if (this.isFastRenderEnabled()) {
                        this.blitCleanBuffer();
                        this.renderDraggedPrimitives();
                    }
                    this.setHoldDisplay(false);
                    break;
                }
                case 4: {
                    this.resizePrimitive(this.resizePrimitive, this.resizeHandle, e.getX(), e.getY());
                    break;
                }
                case 5: {
                    this.calculateDragMovement(new Point(this.prevx, this.prevy), e.getPoint(), true);
                    Point clickedViewPoint = new Point(this.clickedModelPoint);
                    this.ModelToView(clickedViewPoint);
                    this.drawRubberBand(Math.min(clickedViewPoint.x, e.getX()), Math.min(clickedViewPoint.y, e.getY()), Math.abs(e.getX() - clickedViewPoint.x), Math.abs(e.getY() - clickedViewPoint.y), false);
                    this.firePFDViewChanged(new PFDViewEvent(this, 11, "autoscroll"));
                    break;
                }
                case 9: {
                    this.setCursor(0);
                    Point loc = e.getPoint();
                    this.ViewToModel(loc);
                    MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    this.firePrimitiveMouseEvent(me);
                    break;
                }
                case 8: {
                    if (this.mouseOverPrimitive instanceof PFDComponentPrimitive) {
                        Point loc = e.getPoint();
                        this.ViewToModel(loc);
                        MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                        ((PFDComponentPrimitive)this.mouseOverPrimitive).fireDraggedComponentMouseEvent(me);
                        break;
                    }
                    System.out.println("ERROR: mouseOverPrimitive is not instanceof PFDComponentPrimitive");
                    break;
                }
                case 10: {
                    this.backLayerAnnotate.mouseDragged(e);
                }
            }
        }
        this.prevx = e.getX();
        this.prevy = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseMode == 1) {
            this.setCursor(6);
        } else if (this.mouseMode == 2) {
            int modifier = this.getMouseExtendedMode(e);
            if (modifier == 6) {
                if (this.scale > this.minZoomScale) {
                    this.setCursor(9);
                } else {
                    this.setCursor(7);
                }
            } else if (this.scale < this.maxZoomScale) {
                this.setCursor(8);
            } else {
                this.setCursor(7);
            }
        } else if (this.mouseMode == 0) {
            int handleIndex = this.pickHandle(e.getX(), e.getY());
            if (handleIndex >= 0) {
                this.dragCursor = Cursor.getPredefinedCursor(PFDHandle.getCursor(handleIndex));
                this.setCursor(this.dragCursor);
                return;
            }
            this.setCursor(0);
            Point loc = e.getPoint();
            this.ViewToModel(loc);
            MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), loc.x, loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            this.fireHotspotMouseEvent(me);
            this.firePrimitiveMouseEvent(me);
            if (!me.isConsumed() && this.backAnnotateContains(e.getX(), e.getY())) {
                this.backLayerAnnotate.mouseMoved(e);
            }
        }
    }

    protected Dimension calculateDragMovement(Point oldPt, Point newPt, boolean boundToModel) {
        int dy;
        int dx;
        this.scrollPosition.x = 0;
        this.scrollPosition.y = 0;
        if (newPt.x < 0) {
            if (oldPt.x < 0) {
                this.scrollPosition.x = dx = newPt.x;
            } else {
                dx = -oldPt.x - 1;
            }
        } else if (newPt.x > this.getWidth() - 1) {
            if (oldPt.x > this.getWidth() - 1) {
                this.scrollPosition.x = dx = newPt.x - this.getWidth() + 1;
            } else {
                dx = this.getWidth() - oldPt.x;
            }
        } else {
            dx = oldPt.x < 0 ? newPt.x + 1 : (oldPt.x > this.getWidth() - 1 ? newPt.x - this.getWidth() : newPt.x - oldPt.x);
        }
        if (newPt.y < 0) {
            if (oldPt.y < 0) {
                this.scrollPosition.y = dy = newPt.y;
            } else {
                dy = -oldPt.y - 1;
            }
        } else if (newPt.y > this.getHeight() - 1) {
            if (oldPt.y > this.getHeight() - 1) {
                this.scrollPosition.y = dy = newPt.y - this.getHeight() + 1;
            } else {
                dy = this.getHeight() - oldPt.y;
            }
        } else {
            dy = oldPt.y < 0 ? newPt.y + 1 : (oldPt.y > this.getHeight() - 1 ? newPt.y - this.getHeight() : newPt.y - oldPt.y);
        }
        this.ViewToModel(this.scrollPosition);
        Dimension vs = this.getViewSize();
        Dimension docSize = this.getDocumentSize();
        if (boundToModel) {
            if (this.scrollPosition.x > docSize.width - vs.width) {
                this.scrollPosition.x = docSize.width - vs.width;
            }
            if (this.scrollPosition.y > docSize.height - vs.height) {
                this.scrollPosition.y = docSize.height - vs.height;
            }
        }
        if (this.scrollPosition.x < 0) {
            this.scrollPosition.x = 0;
        }
        if (this.scrollPosition.y < 0) {
            this.scrollPosition.y = 0;
        }
        Point p = new Point(0, 0);
        this.ModelToView(p);
        p.x -= this.initialOffsetX;
        p.y -= this.initialOffsetY;
        if (oldPt.x < p.x && p.x > 0) {
            dx = newPt.x <= p.x ? 0 : newPt.x - p.x;
        }
        if (oldPt.y < p.y && p.y > 0) {
            dy = newPt.y <= p.y ? 0 : newPt.y - p.y;
        }
        return new Dimension(dx, dy);
    }

    protected void snapModelGrid(Point pt) {
        int n = (int)((double)pt.x / (double)this.gridSpaceX + 0.5);
        pt.x = n * this.gridSpaceX;
        n = (int)((double)pt.y / (double)this.gridSpaceY + 0.5);
        pt.y = n * this.gridSpaceY;
    }

    public void snapViewGrid(Point pt) {
        this.ViewToModel(pt);
        int n = (int)((double)pt.x / (double)this.gridSpaceX + 0.5);
        pt.x = n * this.gridSpaceX;
        n = (int)((double)pt.y / (double)this.gridSpaceY + 0.5);
        pt.y = n * this.gridSpaceY;
        this.ModelToView(pt);
    }

    public void snapPrimitiveToGrid(PFDPrimitive p) {
        Point pt = p.getSpotLocation(10, null);
        Point loc = p.getLocation();
        int dx = pt.x - loc.x;
        int dy = pt.y - loc.y;
        this.snapModelGrid(pt);
        while (pt.x - dx < 0) {
            pt.x += this.gridSpaceX;
        }
        while (pt.y - dy < 0) {
            pt.y += this.gridSpaceY;
        }
        p.setSpotLocation(10, pt);
    }

    private void resizePrimitive(PFDPrimitive p, int handle, int toX, int toY) {
        if (this.isFastRenderEnabled()) {
            this.setShowAnnotation(false);
            this.copyToCleanBuffer();
            this.setShowAnnotation(true);
        }
        Point toPoint = new Point(toX, toY);
        if (this.snapToGrid) {
            this.snapViewGrid(toPoint);
        }
        this.ViewToModel(toPoint);
        this.setHoldDisplay(true);
        Rectangle r = p.getBBox();
        switch (handle) {
            case 0: {
                r.width = r.x + r.width - toPoint.x;
                r.height = r.y + r.height - toPoint.y;
                r.x = toPoint.x;
                r.y = toPoint.y;
                p.setForcedBBox(r.x, r.y, r.width, r.height);
                break;
            }
            case 1: {
                r.height = r.y + r.height - toPoint.y;
                r.y = toPoint.y;
                p.setForcedBBox(r.x, r.y, r.width, r.height);
                break;
            }
            case 2: {
                r.width = toPoint.x - r.x;
                r.height = r.y + r.height - toPoint.y;
                r.y = toPoint.y;
                p.setForcedBBox(r.x, r.y, r.width, r.height);
                break;
            }
            case 3: {
                r.width = toPoint.x - r.x;
                p.setForcedSize(r.width, r.height);
                break;
            }
            case 4: {
                r.width = toPoint.x - r.x;
                r.height = toPoint.y - r.y;
                p.setForcedSize(r.width, r.height);
                break;
            }
            case 5: {
                r.height = toPoint.y - r.y;
                p.setForcedSize(r.width, r.height);
                break;
            }
            case 6: {
                r.width = r.x + r.width - toPoint.x;
                r.height = toPoint.y - r.y;
                r.x = toPoint.x;
                p.setForcedBBox(r.x, r.y, r.width, r.height);
                break;
            }
            case 7: {
                r.width = r.x + r.width - toPoint.x;
                r.x = toPoint.x;
                p.setForcedBBox(r.x, r.y, r.width, r.height);
                break;
            }
        }
        if (this.isFastRenderEnabled()) {
            this.blitCleanBuffer();
            this.renderDraggedPrimitives();
        }
        this.setHoldDisplay(false);
    }

    private void drawRubberBand(int x, int y, int w, int h, boolean forceAspectRatio) {
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        this.drawRubberBand(g2d, x, y, w, h, forceAspectRatio);
        g2d.dispose();
    }

    private void drawRubberBand(Graphics2D g2d, int x, int y, int w, int h, boolean forceAspectRatio) {
        g2d.setXORMode(Color.white);
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
        if (this.prevXORbox != null) {
            g2d.drawRect(this.prevXORbox.x, this.prevXORbox.y, this.prevXORbox.width, this.prevXORbox.height);
        } else {
            this.prevXORbox = new Rectangle();
        }
        if (forceAspectRatio) {
            double aspect = (double)this.getWidth() / (double)this.getHeight();
            if ((double)h * aspect < (double)w) {
                h = (int)((double)w / aspect);
            } else {
                w = (int)((double)h * aspect);
            }
        }
        g2d.drawRect(x, y, w, h);
        this.prevXORbox.x = x;
        this.prevXORbox.y = y;
        this.prevXORbox.width = w;
        this.prevXORbox.height = h;
    }

    private void redirectLinkToPoint(int x, int y) {
        if (this.isFastRenderEnabled()) {
            this.copyToCleanBuffer();
        }
        this.setHoldDisplay(true);
        this.movePrimitive(this.floatingPort, x, y);
        PFDPort port = this.getNearestPort(x, y);
        if (port.snap(x, y, this)) {
            if (this.redirectingLink.getFromPort() == this.floatingPort && port.isValidFromPort() && port.isValidInteractiveFromPort() && this.redirectingLink.isLinkSupported(port, this.redirectingLink.getToPort()) && port != this.redirectingLink.getToPort()) {
                this.redirectingLink.setFromPort(port);
                this.lastSnappedPort = port;
                this.newFromPort = port;
            }
            if (this.redirectingLink.getToPort() == this.floatingPort && port.isValidToPort() && port.isValidInteractiveToPort() && this.redirectingLink.isLinkSupported(this.redirectingLink.getFromPort(), port) && port != this.redirectingLink.getFromPort()) {
                this.redirectingLink.setToPort(port);
                this.lastSnappedPort = port;
                this.newToPort = port;
            }
        } else {
            if (this.redirectingLink.getFromPort() == this.lastSnappedPort) {
                this.redirectingLink.setFromPort(this.floatingPort);
            }
            if (this.redirectingLink.getToPort() == this.lastSnappedPort) {
                this.redirectingLink.setToPort(this.floatingPort);
            }
        }
        if (this.isFastRenderEnabled()) {
            this.blitCleanBuffer();
            this.renderDraggedPrimitives();
        }
        this.setHoldDisplay(false);
    }

    private void moveSelected(int dx, int dy) {
        if (this.isFastRenderEnabled()) {
            this.copyToCleanBuffer();
        }
        this.setHoldDisplay(true);
        Dimension d = new Dimension(dx, dy);
        this.ViewToModel(d);
        Vector movePrimitives = this.getMovePrimitives();
        Enumeration en = movePrimitives.elements();
        while (en.hasMoreElements()) {
            Point pt = ((PFDPrimitive)en.nextElement()).getLocation();
            if (this.snapToGrid) {
                while (d.width < -pt.x) {
                    d.width += this.gridSpaceX;
                }
                while (d.height < -pt.y) {
                    d.height += this.gridSpaceY;
                }
                continue;
            }
            if (d.width < -pt.x) {
                d.width = -pt.x;
            }
            if (d.height >= -pt.y) continue;
            d.height = -pt.y;
        }
        Vector links = this.model.getAllLinks();
        for (int i = 0; i < links.size(); ++i) {
            boolean toSelected;
            PFDLink link = (PFDLink)links.get(i);
            boolean linkSelected = this.selected.containsPrimitive(link);
            PFDPort from = link.getFromPort();
            PFDPort to = link.getToPort();
            boolean fromSelected = from != null && this.selected.containsPrimitive(from);
            boolean bl = toSelected = to != null && this.selected.containsPrimitive(to);
            if (linkSelected || fromSelected && toSelected) {
                if (link.getNumSelectedBreaks() > 0) {
                    link.updateSelectedBreaks(d.width, d.height);
                    continue;
                }
                link.updateCustomBreakPoints(d.width, d.height);
                continue;
            }
            if (!fromSelected && !toSelected) continue;
            link.resetBreakPoints();
        }
        Enumeration en2 = movePrimitives.elements();
        while (en2.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)en2.nextElement();
            if (!p.isDraggable()) continue;
            p.move(d.width, d.height);
        }
        if (this.isFastRenderEnabled()) {
            this.blitCleanBuffer();
            this.renderDraggedPrimitives();
        }
        this.setHoldDisplay(false);
    }

    private Vector getMovePrimitives() {
        Vector<PFDPrimitive> copy = new Vector<PFDPrimitive>();
        for (int i = 0; i < this.selected.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.selected.getPrimitive(i);
            PFDPrimitive moveP = p.getTopMovePrimitive();
            if (copy.contains(moveP)) continue;
            copy.add(moveP);
        }
        return copy;
    }

    private boolean isMovePrimitive(PFDPrimitive primitive) {
        if (this.selected.containsPrimitive(primitive)) {
            return true;
        }
        for (int i = 0; i < this.selected.getNumPrimitives(); ++i) {
            PFDGroup g;
            PFDPrimitive p = this.selected.getPrimitive(i);
            PFDPrimitive moveP = p.getTopMovePrimitive();
            if (moveP == primitive) {
                return true;
            }
            if (!(moveP instanceof PFDGroup) || !(g = (PFDGroup)moveP).isChild(primitive)) continue;
            return true;
        }
        return false;
    }

    private void dragNewLinkToPoint(int x, int y) {
        if (this.isFastRenderEnabled()) {
            this.copyToCleanBuffer();
        }
        PFDPort port = this.getNearestPort(x, y);
        this.movePrimitive(this.floatingPort, x, y);
        if (port.snap(x, y, this) && port.isValidToPort() && port.isValidInteractiveToPort()) {
            for (int i = 0; i < this.newLinks.size(); ++i) {
                PFDLink l = (PFDLink)this.newLinks.elementAt(i);
                if (l != null && l.getFromPort() != port && l.isLinkSupported(l.getFromPort(), port)) {
                    l.setToPort(port);
                    continue;
                }
                if (l == null || l.getToPort() == this.floatingPort) continue;
                l.setToPort(this.floatingPort);
            }
        } else {
            for (int i = 0; i < this.newLinks.size(); ++i) {
                PFDLink l = (PFDLink)this.newLinks.elementAt(i);
                if (l == null || l.getToPort() == this.floatingPort) continue;
                l.setToPort(this.floatingPort);
            }
        }
        if (this.isFastRenderEnabled()) {
            this.blitCleanBuffer();
            this.renderDraggedPrimitives();
        }
        this.setHoldDisplay(false);
    }

    private void startTextEditing(PFDText text) {
        this.clearSelections();
        this.editingText = text;
        this.editingText.setVisible(false);
        if (this.textEditor != null && this.textEditor.getParent() == this) {
            this.remove(this.textEditor);
        }
        this.textEditor = new JTextField(text.getText());
        this.textEditor.setMargin(new Insets(5, 1, 5, 1));
        this.textEditor.setHorizontalAlignment(0);
        this.textEditor.setBorder(new BevelBorder(1));
        Rectangle rect = this.editingText.getBBox();
        this.ModelToView(rect);
        this.textEditor.setFont(this.editingText.getFont());
        Dimension ps = this.textEditor.getPreferredSize();
        int cx = rect.x + rect.width / 2;
        int cy = rect.y + ps.height / 2;
        this.textEditor.setBounds(cx - ps.width / 2, cy - ps.height / 2, ps.width, ps.height);
        this.add(this.textEditor);
        this.textEditor.requestFocus();
        this.textEditor.selectAll();
        this.textEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                Rectangle b = PFDView.this.textEditor.getBounds();
                Dimension s = PFDView.this.textEditor.getPreferredSize();
                if (s.width > b.width) {
                    PFDView.this.textEditor.setBounds(b.x + (b.width - s.width) / 2, b.y, s.width, s.height);
                }
            }
        });
        this.textEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ((JComponent)e.getSource()).requestFocus();
            }
        });
    }

    private void endTextEditing(int x, int y) {
        PFDText pt = this.pickText(x, y);
        if ((pt == null || pt != this.editingText) && this.editingText != null) {
            PFDShapeNode sn;
            this.editingText.setText(this.textEditor.getText());
            if (this.editingText.getGroup() instanceof PFDShapeNode && (sn = (PFDShapeNode)this.editingText.getGroup()).getLabelPosition() == 0 && !this.editingText.isMultiline()) {
                Rectangle r = sn.getRBBox();
                Dimension d = this.textEditor.getPreferredSize();
                this.ViewToModel(d);
                int dw = d.width - r.width;
                if (dw > 0) {
                    sn.setForcedBBox(r.x - dw / 2, r.y, r.width + dw, r.height);
                }
            }
            this.editingText.setVisible(true);
            this.remove(this.textEditor);
            this.requestFocus();
        }
    }

    private void roiZoom(int x, int y, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        this.scaleToFit = false;
        double aspect = (double)this.getWidth() / (double)this.getHeight();
        if ((double)h * aspect < (double)w) {
            h = (int)((double)w / aspect);
        } else {
            w = (int)((double)h * aspect);
        }
        Rectangle r = new Rectangle(x, y, w, h);
        this.ViewToModel(r);
        double newScale = (double)this.getWidth() / (double)r.width;
        if (newScale > this.maxZoomScale) {
            int cx = r.x + r.width / 2;
            int cy = r.y + r.height / 2;
            int newWidth = (int)((double)this.getWidth() / this.maxZoomScale);
            int newHeight = (int)((double)this.getHeight() / this.maxZoomScale);
            int newX = Math.max(0, cx - newWidth / 2);
            int newY = Math.max(0, cy - newHeight / 2);
            r = new Rectangle(newX, newY, newWidth, newHeight);
        }
        this.setViewRect(r);
    }

    private void showPopupMenu(MouseEvent e) {
        if (this.popupMenuEnabled && e.isPopupTrigger() && (this.selected.getNumPrimitives() != 0 || this.backgroundClicked)) {
            this.showPopupMenu(this.getSelectedPrimitives(), e.getX(), e.getY());
        }
    }

    public void showPopupMenu(PFDPrimitive[] selectedItems, int x, int y) {
        if (this.popupMenu == null) {
            this.popupMenu = new PFDPopupMenu(this);
        }
        this.popupMenu.updateMenu(selectedItems);
        if (this.popupMenu.getComponentCount() == 0) {
            return;
        }
        Dimension d = this.popupMenu.getPreferredSize();
        if (x + d.width > this.getWidth()) {
            x = this.getWidth() - d.width;
        }
        if (y + d.height > this.getHeight()) {
            y = this.getHeight() - d.height;
        }
        this.popupMenu.show(this, x, y);
    }

    private boolean pickLinkEndPoints(PFDLink link, int x, int y) {
        if (!link.isDraggable()) {
            return false;
        }
        this.floatingPort.setType(0);
        if (this.isLinkStartAt(link, x, y)) {
            this.lastSnappedPort = link.getFromPort();
            this.floatingPort.setFromLinkDirection(this.lastSnappedPort.getFromLinkDirection());
            this.floatingPort.setFromLinkSpot(this.lastSnappedPort.getFromLinkSpot());
            this.movePrimitive(this.floatingPort, x, y);
            link.setFromPort(this.floatingPort);
            this.redirectingLink = link;
            this.oldFromPort = this.lastSnappedPort;
            this.newToPort = this.oldToPort = link.getToPort();
            return true;
        }
        if (this.isLinkEndAt(link, x, y)) {
            this.lastSnappedPort = link.getToPort();
            this.floatingPort.setToLinkDirection(this.lastSnappedPort.getToLinkDirection());
            this.floatingPort.setToLinkSpot(this.lastSnappedPort.getToLinkSpot());
            this.movePrimitive(this.floatingPort, x, y);
            link.setToPort(this.floatingPort);
            this.redirectingLink = link;
            this.newFromPort = this.oldFromPort = link.getFromPort();
            this.oldToPort = this.lastSnappedPort;
            return true;
        }
        return false;
    }

    private void portPicked(PFDPort port, int x, int y) {
        this.setHoldDisplay(true);
        this.floatingPort.setType(0);
        this.floatingPort.setToLinkSpot(9);
        this.floatingPort.removeAllLinks();
        PFDLink newLink = new PFDLink(port, null);
        this.getModel().addPrimitive(newLink);
        this.newLinks.add(newLink);
        this.oldFromPort = null;
        this.oldToPort = null;
        this.newFromPort = port;
        newLink.setToPort(this.floatingPort);
        Enumeration e = this.selected.getAllPrimitives();
        while (e.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)e.nextElement();
            if (p instanceof PFDAbstractNode && p != this.newFromPort.getParentNode()) {
                PFDPort outPort = ((PFDAbstractNode)p).getOutputPort();
                if (outPort == null || !outPort.isValidFromPort() || !outPort.isValidInteractiveFromPort()) continue;
                newLink = new PFDLink(outPort, this.floatingPort);
                this.getModel().addPrimitive(newLink);
                this.newLinks.add(newLink);
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            Vector groupNodes = new Vector();
            ((PFDGroup)p).accumulatePrimitive(groupNodes, PFDAbstractNode.class);
            Enumeration nodes = groupNodes.elements();
            while (nodes.hasMoreElements()) {
                PFDPort outPort;
                PFDAbstractNode node = (PFDAbstractNode)nodes.nextElement();
                if (node == this.newFromPort.getParentNode() || (outPort = node.getOutputPort()) == null || !outPort.isValidFromPort() || !outPort.isValidInteractiveFromPort()) continue;
                newLink = new PFDLink(outPort, this.floatingPort);
                this.getModel().addPrimitive(newLink);
                this.newLinks.add(newLink);
            }
        }
        this.movePrimitive(this.floatingPort, x, y);
        this.setHoldDisplay(false);
    }

    private int getResizeHandleAt(int x, int y) {
        Point mp = new Point(x, y);
        this.ViewToModel(mp);
        PFDHandle handle = this.selected.getHandleFor(this.selected.getLastPrimitive());
        return handle.getSelectedResizeHandle(mp);
    }

    private int pickHandle(int x, int y) {
        int handle = -1;
        PFDPrimitive lastSelected = this.selected.getLastPrimitive();
        if (lastSelected != null && !(lastSelected instanceof PFDLink)) {
            handle = this.getResizeHandleAt(x, y);
        }
        return handle;
    }

    private PFDPrimitive pickedUpItem(int x, int y) {
        PFDPort port;
        this.resizeHandle = -1;
        PFDPrimitive lastSelected = this.selected.getLastPrimitive();
        if (lastSelected != null && !(lastSelected instanceof PFDLink)) {
            this.resizeHandle = this.getResizeHandleAt(x, y);
            if (this.resizeHandle >= 0) {
                this.itemPicked = 1;
                return null;
            }
        }
        if (this.mouseExtendedMode == 0 && (port = this.pickPort(x, y)) != null && port.isValidInteractiveFromPort()) {
            this.portPicked(port, x, y);
            this.itemPicked = 2;
            return null;
        }
        PFDPrimitive item = this.pickPrimitive(x, y);
        if (item == null || item != null && !item.isSelectable()) {
            this.itemPicked = 0;
            return null;
        }
        if (item instanceof PFDLink) {
            this.itemPicked = this.isLinkBreakAt((PFDLink)item, x, y) && ((PFDLink)item).isCustomBreakPointsDragable() ? 5 : (this.mouseExtendedMode != 0 ? 3 : (this.pickLinkEndPoints((PFDLink)item, x, y) ? 4 : 3));
            return item;
        }
        PFDGroup group = item.getTopLevelGroup();
        if (group != null) {
            this.model.bringToFront(group);
            Vector links = new Vector();
            group.accumulateLinks(links);
            if (links.size() > 0) {
                this.model.bringToFront(links.elements());
            }
        } else {
            this.model.bringToFront(item);
        }
        this.itemPicked = 7;
        return item;
    }

    public static JToolBar createPrimitivePalette() {
        JToolBar palette = new JToolBar(RB.getStringResource(RB_KEY, "primitivePaletteTitle.txt"));
        Class<PFDView> thisClass = PFDView.class;
        URL url = thisClass.getResource("res/sasNode.gif");
        Image sasNode = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/rectangle.gif");
        Image rectangle = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/rounded_rectangle.gif");
        Image round_rectangle = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/oval.gif");
        Image oval = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/diamond.gif");
        Image diamond = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/parallelogram.gif");
        Image parallelogram = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/hexagon.gif");
        Image hexagon = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/pentagon.gif");
        Image pentagon = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/simpleNode.gif");
        Image simple = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/imageNode.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/tableNode.gif");
        Image table = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/text.gif");
        Image label = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/link.gif");
        Image link = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/textField.gif");
        Image text = Toolkit.getDefaultToolkit().getImage(url);
        url = thisClass.getResource("res/button.gif");
        Image jbutton = Toolkit.getDefaultToolkit().getImage(url);
        MediaTracker imageTracker = new MediaTracker(palette);
        imageTracker.addImage(sasNode, 0);
        imageTracker.addImage(rectangle, 0);
        imageTracker.addImage(round_rectangle, 0);
        imageTracker.addImage(oval, 0);
        imageTracker.addImage(diamond, 0);
        imageTracker.addImage(parallelogram, 0);
        imageTracker.addImage(hexagon, 0);
        imageTracker.addImage(pentagon, 0);
        imageTracker.addImage(simple, 0);
        imageTracker.addImage(image, 0);
        imageTracker.addImage(table, 0);
        imageTracker.addImage(text, 0);
        imageTracker.addImage(link, 0);
        imageTracker.addImage(label, 0);
        imageTracker.addImage(jbutton, 0);
        try {
            imageTracker.waitForAll();
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
        }
        PFDPrimitiveButton button = null;
        button = new PFDPrimitiveButton("PFDSASNode", new ImageIcon(sasNode));
        button.setToolTipText(RB.getStringResource(RB_KEY, "sasNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Rectangle Node", new ImageIcon(rectangle));
        button.setToolTipText(RB.getStringResource(RB_KEY, "rectangleNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Round Rectangle Node", new ImageIcon(round_rectangle));
        button.setToolTipText(RB.getStringResource(RB_KEY, "roundRectNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Oval Node", new ImageIcon(oval));
        button.setToolTipText(RB.getStringResource(RB_KEY, "ovalNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Diamond Node", new ImageIcon(diamond));
        button.setToolTipText(RB.getStringResource(RB_KEY, "diamondNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Parallelogram Node", new ImageIcon(parallelogram));
        button.setToolTipText(RB.getStringResource(RB_KEY, "parallelogramNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Hexagon Node", new ImageIcon(hexagon));
        button.setToolTipText(RB.getStringResource(RB_KEY, "hexagonNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Pentagon Node", new ImageIcon(pentagon));
        button.setToolTipText(RB.getStringResource(RB_KEY, "pentagonNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Simple Node", new ImageIcon(simple));
        button.setToolTipText(RB.getStringResource(RB_KEY, "simpleNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Image Node", new ImageIcon(image));
        button.setToolTipText(RB.getStringResource(RB_KEY, "imageNode.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Table Node", new ImageIcon(table));
        button.setToolTipText(RB.getStringResource(RB_KEY, "tableNode.txt"));
        palette.add(button);
        palette.addSeparator();
        button = new PFDPrimitiveButton("PFDText", new ImageIcon(label));
        button.setToolTipText(RB.getStringResource(RB_KEY, "text.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("Link", new ImageIcon(link));
        button.setToolTipText(RB.getStringResource(RB_KEY, "link.txt"));
        palette.add(button);
        palette.addSeparator();
        button = new PFDPrimitiveButton("JTextField", new ImageIcon(text));
        button.setToolTipText(RB.getStringResource(RB_KEY, "jtextFiled.txt"));
        palette.add(button);
        button = new PFDPrimitiveButton("JButton", new ImageIcon(jbutton));
        button.setToolTipText(RB.getStringResource(RB_KEY, "jbutton.txt"));
        palette.add(button);
        return palette;
    }

    public LayoutStrategyInterface getPFDLayout() {
        return this.layoutStrategy;
    }

    public void setPFDLayout(LayoutStrategyInterface layout) {
        if (this.layoutStrategy == layout) {
            return;
        }
        this.layoutStrategy = layout;
        Action layoutAction = this.getAction("ACTION_RUN_LAYOUT");
        if (this.layoutStrategy == null) {
            layoutAction.setEnabled(false);
        } else {
            layoutAction.setEnabled(true);
        }
        if (this.layoutStrategy != null) {
            this.layoutStrategy.setModel(this.model);
        }
        if (this.controlToolBar != null) {
            this.controlToolBar.setFlowDirection(((LayeredLayoutStrategyInterface)layout).getFlowDirection());
        }
    }

    public void doPFDLayout(boolean layoutChanged) {
        if (this.layoutStrategy == null) {
            return;
        }
        this.fireViewChange(12);
        this.setHoldDisplay(true);
        this.disableChangeUpdate();
        if (this.layoutStrategy instanceof LayeredLayoutStrategyInterface) {
            ((LayeredLayoutStrategyInterface)this.layoutStrategy).arrange(layoutChanged);
            Action action = null;
            LayeredLayoutStrategy l = (LayeredLayoutStrategy)this.layoutStrategy;
            String flowDirection = l.getFlowDirection();
            if (flowDirection.equalsIgnoreCase("up")) {
                action = this.getAction("ACTION_LAYOUT_UP");
            } else if (flowDirection.equalsIgnoreCase("down")) {
                action = this.getAction("ACTION_LAYOUT_DOWN");
            } else if (flowDirection.equalsIgnoreCase("left")) {
                action = this.getAction("ACTION_LAYOUT_LEFT");
            } else if (flowDirection.equalsIgnoreCase("right")) {
                action = this.getAction("ACTION_LAYOUT_RIGHT");
            }
            if (action != null) {
                action.putValue("pfdAbstractAction.selected", Boolean.TRUE);
            }
        } else {
            this.layoutStrategy.arrange();
        }
        for (int i = 0; i < this.model.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.model.getPrimitive(i);
            if (!(p instanceof PFDGroup) || p instanceof PFDAbstractNode) continue;
            p.update("bbox", this);
        }
        this.model.crop();
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.getPFDAnnotate().cropAnnotateBounds();
        }
        if (this.backLayerAnnotate != null) {
            this.backLayerAnnotate.cropAnnotateBounds();
        }
        this.setViewPosition(new Point(0, 0));
        this.enableChangeUpdate();
        this.setHoldDisplay(false);
        this.fireViewChange(3);
        if (this.controlToolBar != null) {
            LayeredLayoutStrategy l = (LayeredLayoutStrategy)this.layoutStrategy;
            this.controlToolBar.setFlowDirection(l.getFlowDirection());
        }
    }

    public PFDKeyAdapter getDefaultKeyAdapter() {
        return this.keyAdapter;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.cursorSet = true;
        if (!this.holdCursor) {
            super.setCursor(cursor);
        }
    }

    public void setCursor(int type) {
        Cursor cursor = this.getCursor(type);
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    public Cursor getCursor(int type) {
        switch (type) {
            case 0: {
                return Cursor.getDefaultCursor();
            }
            case 1: {
                return Cursor.getPredefinedCursor(13);
            }
            case 2: {
                return this.pencilCursor;
            }
            case 3: {
                return Cursor.getPredefinedCursor(1);
            }
            case 4: {
                return this.invalidCursor;
            }
            case 5: {
                return Cursor.getPredefinedCursor(12);
            }
            case 6: {
                return this.panCursor;
            }
            case 7: {
                return this.zoomCursor;
            }
            case 8: {
                return this.zoomInCursor;
            }
            case 9: {
                return this.zoomOutCursor;
            }
        }
        return null;
    }

    public void setHoldCursor(boolean hold) {
        this.holdCursor = hold;
    }

    public void setToolTipMaxWidth(int width) {
        if (width < 0) {
            return;
        }
        this.toolTipMaxWidth = width;
    }

    public void setToolTipLineWrap(boolean lineWrap) {
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public boolean saveModel(OutputStream out) throws IOException {
        if (this.model == null) {
            return false;
        }
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(this.model);
        os.close();
        return true;
    }

    public boolean restoreModel(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream is = new ObjectInputStream(in);
        Object newModel = is.readObject();
        if (!(newModel instanceof PFDModel)) {
            return false;
        }
        this.setModel((PFDModel)newModel);
        is.close();
        this.selected.removeAllPrimitives();
        this.setScale(1.0);
        return true;
    }

    public PFDPrimitive getNextSelection(PFDPrimitive currentSelection, boolean forward) {
        if (currentSelection == null) {
            return null;
        }
        if (this.tabOrder == null) {
            return null;
        }
        this.calculateTabOrder();
        int inc = 0;
        inc = forward ? 1 : -1;
        if (this.tabOrderIndex < 0 || this.tabOrderIndex >= this.tabOrder.size() || this.tabOrder.elementAt(this.tabOrderIndex) != currentSelection) {
            this.tabOrderIndex = this.tabOrder.indexOf(currentSelection);
        }
        if (this.tabOrderIndex != -1) {
            this.tabOrderIndex = this.tabOrderIndex + inc < 0 ? this.tabOrder.size() - 1 : (this.tabOrderIndex + inc >= this.tabOrder.size() ? 0 : (this.tabOrderIndex += inc));
            return (PFDPrimitive)this.tabOrder.elementAt(this.tabOrderIndex);
        }
        return (PFDPrimitive)this.tabOrder.elementAt(0);
    }

    private void calculateTabOrder() {
        if (this.model == null || this.model.hasNoPrimitives() || this.tabOrder == null) {
            return;
        }
        if (!this.tabOrderDirty) {
            return;
        }
        this.tabOrder.removeAllElements();
        for (int i = 0; i < this.model.getNumPrimitives(); ++i) {
            PFDPrimitive p = this.model.getPrimitive(i);
            if (!p.isVisible() || !p.isSelectable()) continue;
            boolean inserted = false;
            for (int j = 0; !inserted && j < this.tabOrder.size(); ++j) {
                PFDPrimitive sortedPrim = (PFDPrimitive)this.tabOrder.elementAt(j);
                if (!this.isPrimitiveLessThan(p, sortedPrim, this.model.getFlowDirection())) continue;
                this.tabOrder.insertElementAt(p, j);
                inserted = true;
            }
            if (inserted) continue;
            this.tabOrder.addElement(p);
        }
        this.tabOrderDirty = false;
    }

    private boolean isPrimitiveLessThan(PFDPrimitive p1, PFDPrimitive p2, String flowDirection) {
        if (p1 == null || p2 == null || flowDirection == null) {
            return false;
        }
        Point pt1 = p1.getLocation();
        Point pt2 = p2.getLocation();
        if (pt1 == null || pt2 == null) {
            return false;
        }
        if (flowDirection.equalsIgnoreCase("right")) {
            if (pt1.y < pt2.y) {
                return true;
            }
            return pt1.y == pt2.y && pt1.x < pt2.x;
        }
        if (flowDirection.equalsIgnoreCase("left")) {
            if (pt1.y < pt2.y) {
                return true;
            }
            return pt1.y == pt2.y && pt1.x > pt2.x;
        }
        if (flowDirection.equalsIgnoreCase("down")) {
            if (pt1.x < pt2.x) {
                return true;
            }
            return pt1.x == pt2.x && pt1.y < pt2.y;
        }
        if (flowDirection.equalsIgnoreCase("up")) {
            if (pt1.x < pt2.x) {
                return true;
            }
            return pt1.x == pt2.x && pt1.y > pt2.y;
        }
        return false;
    }

    protected Point getViewScrollPosition() {
        return this.scrollPosition;
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        this.scrollPosition.x = cursorLocn.x < this.autoscrollInsets.left ? cursorLocn.x - this.autoscrollInsets.left : (cursorLocn.x >= this.getWidth() - this.autoscrollInsets.right ? cursorLocn.x - this.getWidth() + this.autoscrollInsets.right + 1 : 0);
        this.scrollPosition.y = cursorLocn.y < this.autoscrollInsets.top ? cursorLocn.y - this.autoscrollInsets.top : (cursorLocn.y >= this.getHeight() - this.autoscrollInsets.bottom ? cursorLocn.y - this.getHeight() + this.autoscrollInsets.bottom + 1 : 0);
        this.ViewToModel(this.scrollPosition);
        Dimension ms = this.model.getSize();
        Dimension vs = this.getViewSize();
        if (this.scrollPosition.x < 0) {
            this.scrollPosition.x = 0;
        }
        if (this.scrollPosition.y < 0) {
            this.scrollPosition.y = 0;
        }
        Point newModelBounds = new Point(this.scrollPosition.x + vs.width, this.scrollPosition.y + vs.height);
        this.model.updateSize(newModelBounds);
        this.firePFDViewChanged(new PFDViewEvent(this, 11, "autoscroll"));
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public JToolBar getAnnotationToolBar() {
        if (this.isAnnotationSupported()) {
            return this.getAnnotateComponent().getPFDAnnotate().getAnnotationToolBar();
        }
        return null;
    }

    public boolean isAnnotationSupported() {
        return this.getAnnotateComponent() != null;
    }

    public Element getAnnotationXML() {
        return this.getFrontAnnotationXML();
    }

    public void readAnnotationFromXML(Element e) {
        this.readFrontAnnotationFromXML(e);
    }

    public PFDAnnotateComponent getAnnotateComponent() {
        return this.pfdAnnoComponent;
    }

    public Object getAnnotateObject() {
        return this.getFrontAnnotateObject();
    }

    public Object getFrontAnnotateObject() {
        if (this.isAnnotationSupported()) {
            return this.getAnnotateComponent().getPFDAnnotate().getAnnotateObject();
        }
        return null;
    }

    public Object getBackAnnotateObject() {
        if (this.backLayerAnnotate != null) {
            return this.backLayerAnnotate.getAnnotateObject();
        }
        return null;
    }

    public Element getFrontAnnotationXML() {
        if (this.isAnnotationSupported()) {
            return this.getAnnotateComponent().getPFDAnnotate().getAnnotationElement();
        }
        return null;
    }

    public void readFrontAnnotationFromXML(Element e) {
        if (this.isAnnotationSupported()) {
            this.getAnnotateComponent().getPFDAnnotate().readFromXML(e);
        }
    }

    public Element getBackAnnotationXML() {
        if (this.backLayerAnnotate != null) {
            return this.backLayerAnnotate.getAnnotationElement();
        }
        return null;
    }

    public void readBackAnnotationFromXML(Element e) {
        if (this.backLayerAnnotate != null) {
            this.backLayerAnnotate.readFromXML(e);
        }
    }

    private boolean backAnnotateContains(int x, int y) {
        if (this.backLayerAnnotate == null) {
            return false;
        }
        if (this.backLayerAnnotate.isInSelectMode()) {
            return this.backLayerAnnotate.contains(x, y);
        }
        return true;
    }

    public void annotateClear(PFDAnnotateInterface anno) {
        this.clearSelections();
        if (anno == this.backLayerAnnotate) {
            this.pfdAnnoComponent.getPFDAnnotate().clearSelections();
        } else {
            this.backLayerAnnotate.clearSelections();
        }
    }

    public boolean expandSelectedPrimitive() {
        PFDPrimitive p = this.getSelectionList().getLastPrimitive();
        if (p == null || !p.isExpandable()) {
            return false;
        }
        Point anchor = p.getSpotLocation(1, null);
        p.expand();
        this.deselectPrimitive(p);
        this.selectPrimitive(p.getExpanded());
        if (p.getExpanded() instanceof PFDSubdiagram && this.layoutStrategy != null && this.layoutStrategy instanceof LayeredLayoutStrategyInterface) {
            ((LayeredLayoutStrategyInterface)this.layoutStrategy).arrangeExpandedSubdiagram((PFDSubdiagram)p.getExpanded());
        }
        p.getExpanded().setLocation(anchor.x, anchor.y);
        this.makeSpace(p.getExpanded(), 5);
        return true;
    }

    public boolean collapseSelectedPrimitive() {
        PFDPrimitive p = this.getSelectionList().getLastPrimitive();
        if (p == null || !p.isCollapsable()) {
            return false;
        }
        Rectangle oldBBox = p.getBBox();
        p.collapse();
        this.deselectPrimitive(p);
        this.selectPrimitive(p.getCollapsed());
        p.getCollapsed().setLocation(oldBBox.x, oldBBox.y);
        return true;
    }

    private void makeSpace(PFDPrimitive p, int padding) {
        if (p == null) {
            return;
        }
        Rectangle bbox = p.getBBox();
        int top = bbox.y;
        int right = bbox.x + bbox.width;
        int bottom = bbox.y + bbox.height;
        int left = bbox.x;
        double diagSlope = (double)bbox.height / (double)bbox.width;
        Point center = new Point();
        Point topLeft = new Point();
        Vector nodes = this.model.getAllNodes();
        p.disableChangeUpdate();
        p.setVisible(false);
        for (int i = 0; i < nodes.size(); ++i) {
            PFDPrimitive pi = (PFDPrimitive)nodes.elementAt(i);
            pi.getSpotLocation(0, center);
            pi.getSpotLocation(1, topLeft);
            if (!pi.isVisible() || !bbox.intersects(pi.getRBBox())) continue;
            int dx = center.x - bbox.x;
            int dy = center.y - bbox.y;
            if (dx <= 0 && (dy >= 0 || (double)dy / (double)dx < diagSlope)) {
                pi.setLocation(left - padding - pi.getWidth(), pi.getY());
                continue;
            }
            if (dy <= 0) {
                pi.setLocation(pi.getX(), top - padding - pi.getHeight());
                continue;
            }
            if ((double)dy / (double)dx < diagSlope) {
                pi.setLocation(right + padding, pi.getY());
                continue;
            }
            pi.setLocation(pi.getX(), bottom + padding);
        }
        p.setVisible(true);
        p.enableChangeUpdate();
    }

    public void startDragLinkFrom(PFDLink link, int x, int y) {
        this.dragMode = 2;
        this.floatingPort.setType(0);
        this.lastSnappedPort = link.getFromPort();
        this.floatingPort.setFromLinkDirection(this.lastSnappedPort.getFromLinkDirection());
        this.floatingPort.setFromLinkSpot(9);
        this.floatingPort.setLocation(x, y);
        link.setFromPort(this.floatingPort);
        this.redirectingLink = link;
        this.oldFromPort = this.lastSnappedPort;
        this.newToPort = this.oldToPort = link.getToPort();
        this.newFromPort = null;
        link.resetBreakPoints();
    }

    public void startDragLinkTo(PFDLink link, int x, int y) {
        this.dragMode = 1;
        this.floatingPort.setType(0);
        this.lastSnappedPort = link.getToPort();
        this.floatingPort.setToLinkDirection(this.lastSnappedPort.getToLinkDirection());
        this.floatingPort.setToLinkSpot(9);
        this.floatingPort.setLocation(x, y);
        link.setToPort(this.floatingPort);
        this.redirectingLink = link;
        this.newFromPort = this.oldFromPort = link.getFromPort();
        this.oldToPort = this.lastSnappedPort;
        this.newToPort = null;
        link.resetBreakPoints();
    }

    public PFDLink getDraggedLink() {
        switch (this.dragMode) {
            case 1: 
            case 2: {
                return this.redirectingLink;
            }
            case 3: {
                if (this.newLinks.size() > 0) {
                    return (PFDLink)this.newLinks.elementAt(0);
                }
                return null;
            }
        }
        return null;
    }

    public void snapLinkToPort(PFDPort port) {
        this.linkSnapped = true;
        switch (this.dragMode) {
            case 2: {
                if (port == this.redirectingLink.getToPort() || port == this.redirectingLink.getFromPort()) break;
                this.redirectingLink.setFromPort(port);
                this.layoutSelfLink(this.redirectingLink);
                this.lastSnappedPort = port;
                this.newFromPort = port;
                break;
            }
            case 1: {
                if (port == this.redirectingLink.getFromPort() || port == this.redirectingLink.getToPort()) break;
                this.redirectingLink.setToPort(port);
                this.layoutSelfLink(this.redirectingLink);
                this.lastSnappedPort = port;
                this.newToPort = port;
                break;
            }
            case 3: {
                PFDLink link;
                PFDLink pFDLink = link = this.newLinks == null || this.newLinks.isEmpty() ? null : (PFDLink)this.newLinks.get(0);
                if (link == null || port == link.getFromPort() || port == link.getToPort()) break;
                link.setToPort(port);
                this.layoutSelfLink(link);
            }
        }
        this.selectedNode = port.getParentNode();
    }

    private void layoutSelfLink(PFDLink link) {
        if (link == null) {
            return;
        }
        NodeLayoutInterface from = link.getTopFromNode();
        NodeLayoutInterface to = link.getTopToNode();
        if (from != null && from == to) {
            from.layoutSelfLinks();
        }
    }

    private void endDragLinkFrom() {
        if (this.redirectingLink.getFromPort() == this.floatingPort) {
            this.redirectingLink.setFromPort(this.lastSnappedPort);
            this.layoutSelfLink(this.redirectingLink);
        }
        if (this.oldFromPort != null && this.newFromPort != null && this.oldToPort != null && this.newToPort != null && this.oldFromPort != this.newFromPort) {
            PFDSubdiagram.redirectLink(this.oldFromPort, this.newFromPort, this.oldToPort, this.newToPort, this.redirectingLink, this);
            this.newFromPort = this.redirectingLink.getFromPort();
            this.fireViewChange(10, "fromNode", this.oldFromPort.getParentNode(), this.oldFromPort, this.newFromPort.getParentNode(), this.newFromPort, this.oldToPort.getParentNode(), this.oldToPort, this.newToPort.getParentNode(), this.newToPort, this.redirectingLink);
        }
        this.redirectingLink.endRedirect();
        this.redirectingLink = null;
        this.oldFromPort = null;
        this.newFromPort = null;
        this.oldToPort = null;
        this.newToPort = null;
    }

    private void endDragLinkTo() {
        if (this.redirectingLink.getToPort() == this.floatingPort) {
            this.redirectingLink.setToPort(this.lastSnappedPort);
            this.layoutSelfLink(this.redirectingLink);
        }
        if (this.oldFromPort != null && this.newFromPort != null && this.oldToPort != null && this.newToPort != null && this.oldToPort != this.newToPort) {
            PFDSubdiagram.redirectLink(this.oldFromPort, this.newFromPort, this.oldToPort, this.newToPort, this.redirectingLink, this);
            this.newToPort = this.redirectingLink.getToPort();
            this.fireViewChange(10, "toNode", this.oldFromPort.getParentNode(), this.oldFromPort, this.newFromPort.getParentNode(), this.newFromPort, this.oldToPort.getParentNode(), this.oldToPort, this.newToPort.getParentNode(), this.newToPort, this.redirectingLink);
        }
        this.redirectingLink.endRedirect();
        this.redirectingLink = null;
        this.oldFromPort = null;
        this.newFromPort = null;
        this.oldToPort = null;
        this.newToPort = null;
    }

    private void endDragNewLink() {
        Enumeration links = this.newLinks.elements();
        while (links.hasMoreElements()) {
            PFDLink newLink = (PFDLink)links.nextElement();
            if (newLink == null) continue;
            this.newToPort = newLink.getToPort();
            this.newFromPort = newLink.getFromPort();
            if (this.newToPort == null || this.newFromPort == null || this.newToPort == this.floatingPort) {
                this.getModel().removePrimitive(newLink);
            } else {
                this.fireViewChange(9, null, null, null, this.newFromPort.getParentNode(), this.newFromPort, null, null, this.newToPort.getParentNode(), this.newToPort, newLink);
                PFDSubdiagram.linkAdded(this.newFromPort, this.newToPort, newLink, this);
            }
            this.oldFromPort = null;
            this.newFromPort = null;
            this.oldToPort = null;
            this.newToPort = null;
            Object var2_2 = null;
        }
        this.newLinks.clear();
    }

    public void dragNewLink(PFDPort port, boolean multipleLinks) {
        if (port == null) {
            return;
        }
        this.dragMode = 3;
        this.dragPort = port;
    }

    private void startDragNewCollapsedLink(PFDPort port) {
        this.floatingPort.setType(0);
        this.floatingPort.setToLinkSpot(9);
        this.floatingPort.removeAllLinks();
        PFDPort expandedPort = ((PFDCollapsedPort)((Object)port)).getExpandedPort();
        PFDLink expandedLink = expandedPort.createDragLink();
        expandedLink.setFromPort(expandedPort);
        this.getModel().addPrimitive(expandedLink);
        Vector<PFDLink> outLinks = new Vector<PFDLink>();
        outLinks.add(expandedLink);
        PFDSubdiagram.collapseOutputLinksToPort(outLinks, port);
        PFDLink collapsedLink = PFDSubdiagram.getCollapsedLink(expandedLink);
        this.newLinks.add(collapsedLink);
        this.oldFromPort = null;
        this.oldToPort = null;
        this.newToPort = null;
        this.newFromPort = port;
        collapsedLink.setToPort(this.floatingPort);
        this.movePrimitive(this.floatingPort, this.clickedX, this.clickedY);
    }

    private void startDragNewLink() {
        if (this.dragPort == null) {
            return;
        }
        if (this.dragPort instanceof PFDCollapsedPort) {
            this.startDragNewCollapsedLink(this.dragPort);
            return;
        }
        PFDLink newLink = this.dragPort.createDragLink();
        this.floatingPort.setType(0);
        this.floatingPort.setToLinkSpot(9);
        this.floatingPort.removeAllLinks();
        newLink.setFromPort(this.dragPort);
        this.getModel().addPrimitive(newLink);
        this.newLinks.add(newLink);
        this.oldFromPort = null;
        this.oldToPort = null;
        this.newToPort = null;
        this.newFromPort = this.dragPort;
        newLink.setToPort(this.floatingPort);
        this.movePrimitive(this.floatingPort, this.clickedX, this.clickedY);
    }

    protected void bringPrimitiveToFront(PFDPrimitive p) {
        if (p == null || this.model == null) {
            return;
        }
        p.bringToFront();
    }

    public int getMouseExtendedMode() {
        return this.mouseExtendedMode;
    }

    public void setMouseOverPrimitive(PFDPrimitive p, MouseEvent e) {
        MouseEvent me;
        if (this.mouseOverPrimitive == p) {
            return;
        }
        if (this.mouseOverPrimitive != null) {
            me = new MouseEvent(this, 505, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            this.mouseOverPrimitive.dispatchEventToSelf(me);
        }
        this.mouseOverPrimitive = p;
        if (this.mouseOverPrimitive != null) {
            me = new MouseEvent(this, 504, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            this.mouseOverPrimitive.dispatchEventToSelf(me);
        }
    }

    public void setResizePrimitive(PFDPrimitive p, int handleIndex) {
        this.resizePrimitive = p;
        this.resizeHandle = handleIndex;
    }

    public void setCleanBufferDirty() {
        this.cleanBufferDirty = true;
    }

    @Override
    public Action getAction(String actionKey) {
        ActionMap map = this.getActionMap();
        if (map != null) {
            return map.get(actionKey);
        }
        return null;
    }

    @Override
    public void setAction(String actionKey, Action a) {
        ActionMap map = this.getActionMap();
        if (map != null) {
            map.put(actionKey, a);
        }
    }

    public void setMouseMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                this.mouseMode = mode;
            }
        }
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    private void panView(int dx, int dy) {
        if (this.model == null) {
            return;
        }
        Dimension d = new Dimension(-dx, -dy);
        this.ViewToModel(d);
        Dimension viewSize = this.getViewSize();
        Dimension modelSize = this.model.getSize();
        Point p = this.getViewPosition();
        p.x = Math.max(0, Math.min(modelSize.width - viewSize.width, p.x + d.width));
        p.y = Math.max(0, Math.min(modelSize.height - viewSize.height, p.y + d.height));
        this.setViewPosition(p);
    }

    public void setOverviewVisible(boolean visible) {
        Action action;
        if (this.overviewPanel == null) {
            this.overviewPanel = new PFDOverviewPanel(this);
        }
        if ((action = this.getAction("ACTION_TOGGLE_OVERVIEW")) != null) {
            action.putValue("pfdAbstractAction.selected", visible);
        }
        this.overviewPanel.setVisible(visible);
    }

    public boolean isOverviewVisible() {
        return this.overviewPanel != null && this.overviewPanel.isVisible();
    }

    public PFDOverviewPanel getOverviewPanel() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new PFDOverviewPanel(this);
        }
        return this.overviewPanel;
    }

    public boolean isControlVisible() {
        return this.controlVisible;
    }

    public void setControlVisible(boolean visible) {
        if (this.controlVisible == visible) {
            return;
        }
        this.controlVisible = visible;
        Vector controlPrimitives = this.getControlPrimitives();
        Enumeration e = controlPrimitives.elements();
        while (e.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)e.nextElement();
            p.setVisible(visible);
        }
        this.repaint();
    }

    private Vector getControlPrimitives() {
        Vector<PFDPrimitive> controlPrimitives = new Vector<PFDPrimitive>();
        Vector ports = new Vector();
        Vector links = new Vector();
        if (this.model == null) {
            return controlPrimitives;
        }
        for (int i = 0; i < this.model.getNumPrimitives(); ++i) {
            int j;
            PFDPrimitive p = this.model.getPrimitive(i);
            if (p instanceof PFDLink && ((PFDLink)p).isControl()) {
                controlPrimitives.add(p);
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            ports.clear();
            g.accumulatePrimitive(ports, PFDPort.class);
            for (j = 0; j < ports.size(); ++j) {
                PFDPort port = (PFDPort)ports.get(j);
                if (!port.isControl()) continue;
                controlPrimitives.add(port);
            }
            links.clear();
            g.accumulatePrimitive(links, PFDLink.class);
            for (j = 0; j < links.size(); ++j) {
                PFDLink link = (PFDLink)links.get(j);
                if (!link.isControl()) continue;
                controlPrimitives.add(link);
            }
        }
        return controlPrimitives;
    }

    public Point getClickedPoint() {
        return new Point(this.clickedX, this.clickedY);
    }

    public PFDControlToolBar getToolBar() {
        if (this.controlToolBar == null) {
            this.controlToolBar = new PFDControlToolBar(this);
            Action toolbarAction = this.getAction("ACTION_TOGGLE_TOOLBAR");
            toolbarAction.putValue("pfdAbstractAction.selected", Boolean.TRUE);
            toolbarAction.setEnabled(true);
        }
        return this.controlToolBar;
    }

    public PFDCollapsableNodeGroup createGroup() {
        if (this.model == null || this.selected.getNumPrimitives() <= 1) {
            return null;
        }
        PFDCollapsableNodeGroup group = this.model.createGroup(this.selected.getPrimitives());
        if (group == null) {
            return null;
        }
        this.clearSelections();
        this.selectPrimitive(group);
        return group;
    }

    @Override
    public List getMenuItems() {
        Vector<JComponent> items = new Vector<JComponent>();
        Action action = this.getAction("ACTION_PASTE");
        Transferable data = this.getClipboard().getContents(this);
        if (data == null || !(data instanceof PFDSelectionList)) {
            action.setEnabled(false);
        } else {
            PFDSelectionList sl = (PFDSelectionList)data;
            if (sl.hasNoPrimitives()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
        }
        items.add(PFDMenuUtil.createMenuItem(action));
        items.add(new JPopupMenu.Separator());
        items.add(PFDMenuUtil.createLayoutMenu(this));
        items.add(PFDMenuUtil.createZoomMenu(this));
        items.add(PFDMenuUtil.createGridMenu(this));
        items.add(new JPopupMenu.Separator());
        action = this.getAction("ACTION_ADD_NOTE");
        items.add(PFDMenuUtil.createMenuItem(action));
        items.add(new JPopupMenu.Separator());
        action = this.getAction("ACTION_SAVE_AS_IMAGE");
        items.add(PFDMenuUtil.createMenuItem(action));
        items.add(new JPopupMenu.Separator());
        items.add(PFDMenuUtil.createPrintMenu(this));
        items.add(new JPopupMenu.Separator());
        action = this.getAction("ACTION_TOGGLE_TOOLBAR");
        items.add(PFDMenuUtil.createCheckBoxMenuItem(action));
        return items;
    }

    public void addHotspot(PFDHotspotInterface hotspot) {
        this.addHotspot(hotspot, false);
    }

    public void addHotspot(PFDHotspotInterface hotspot, boolean mouseover) {
        if (!this.hotspots.contains(hotspot)) {
            this.hotspots.add(hotspot);
        }
        if (mouseover && !this.mouseoverHotspots.contains(hotspot)) {
            this.mouseoverHotspots.add(hotspot);
        }
    }

    public void removeHotspot(PFDHotspotInterface hotspot) {
        this.hotspots.remove(hotspot);
        this.mouseoverHotspots.remove(hotspot);
    }

    private void fireHotspotMouseEvent(MouseEvent me) {
        for (int i = 0; i < this.hotspots.size(); ++i) {
            PFDHotspotInterface hs = (PFDHotspotInterface)this.hotspots.get(i);
            boolean containsPt = hs.contains(me.getX(), me.getY());
            boolean isMouseover = this.mouseoverHotspots.contains(hs);
            if (containsPt) {
                if (!isMouseover) {
                    this.mouseoverHotspots.add(hs);
                    hs.mouseEntered(me);
                }
                hs.mouseMoved(me);
                continue;
            }
            if (containsPt || !isMouseover) continue;
            this.mouseoverHotspots.remove(hs);
            hs.mouseExited(me);
        }
    }

    public void setEditMode(boolean edit) {
        if (edit == this.isEditMode) {
            return;
        }
        this.isEditMode = edit;
        this.firePropertyChange("editMode", !this.isEditMode, this.isEditMode);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public boolean showConnectionsDialog() {
        PFDPrimitive selectedPrimitive = this.selected.getLastPrimitive();
        if (!(selectedPrimitive instanceof PFDAbstractNode)) {
            return false;
        }
        PFDAbstractNode selectedNode = (PFDAbstractNode)selectedPrimitive;
        PFDConnectionsDialog dialog = this.getConnectionsDialog();
        dialog.setConnectionNode(selectedNode);
        dialog.setVisible(true);
        return true;
    }

    public boolean showConnectionsDialog(PFDAbstractNode connectionNode) {
        if (connectionNode == null) {
            return false;
        }
        PFDConnectionsDialog dialog = this.getConnectionsDialog();
        dialog.setConnectionNode(connectionNode);
        dialog.setVisible(true);
        return true;
    }

    public PFDConnectionsDialog getConnectionsDialog() {
        if (this.connectionsDialog == null) {
            this.connectionsDialog = new PFDConnectionsDialog(this);
        }
        return this.connectionsDialog;
    }

    public void setConnectionsDialog(PFDConnectionsDialog connectionsDialog) {
        this.connectionsDialog = connectionsDialog;
    }

    public void createLink(PFDPort fromPort, PFDPort toPort, PFDLink link) {
        if (fromPort == null || toPort == null || this.model == null) {
            return;
        }
        if (link == null) {
            link = fromPort.createDragLink();
        } else {
            link.resetPorts();
            link.setVisible(true);
        }
        link.setFromPort(fromPort);
        link.setToPort(toPort);
        this.model.addPrimitive(link);
        this.fireViewChange(9, null, null, null, fromPort.getParentNode(), fromPort, null, null, toPort.getParentNode(), toPort, link);
    }

    public void redirectLinkTo(PFDLink link, PFDPort toPort) {
        if (link == null || toPort == null || this.model == null) {
            return;
        }
        PFDPort fromPort = link.getFromPort();
        PFDPort oldToPort = link.getToPort();
        if (toPort == oldToPort) {
            return;
        }
        link.setToPort(toPort);
        PFDSubdiagram.redirectLink(fromPort, fromPort, oldToPort, toPort, link, this);
        this.fireViewChange(10, "toNode", fromPort.getParentNode(), fromPort, fromPort.getParentNode(), fromPort, oldToPort.getParentNode(), oldToPort, toPort.getParentNode(), toPort, link);
    }

    public void redirectLinkFrom(PFDLink link, PFDPort fromPort) {
        if (link == null || fromPort == null || this.model == null) {
            return;
        }
        PFDPort toPort = link.getToPort();
        PFDPort oldFromPort = link.getFromPort();
        if (fromPort == oldFromPort) {
            return;
        }
        link.setFromPort(fromPort);
        PFDSubdiagram.redirectLink(oldFromPort, fromPort, toPort, toPort, link, this);
        this.fireViewChange(10, "fromNode", oldFromPort.getParentNode(), oldFromPort, fromPort.getParentNode(), fromPort, toPort.getParentNode(), toPort, toPort.getParentNode(), toPort, link);
    }

    public void rejectLinkDrag(PFDAbstractNode node, PFDPort port) {
        PFDAbstractNode fromNode = null;
        PFDAbstractNode toNode = null;
        PFDPort fromPort = null;
        PFDPort toPort = null;
        PFDLink l = this.getDraggedLink();
        switch (this.dragMode) {
            case 1: 
            case 3: {
                fromPort = l.getFromPort();
                fromNode = fromPort.getParentNode();
                toPort = port;
                toNode = node;
                break;
            }
            case 2: {
                toPort = l.getToPort();
                toNode = toPort.getParentNode();
                fromPort = port;
                fromNode = node;
                break;
            }
            default: {
                return;
            }
        }
        this.rejectLinkDrag(l, fromNode, fromPort, toNode, toPort);
    }

    public void rejectLinkDrag(PFDLink link, PFDAbstractNode fromNode, PFDPort fromPort, PFDAbstractNode toNode, PFDPort toPort) {
        this.dragTipText = link.getValidationString(fromNode, fromPort, toNode, toPort);
        this.setCursor(4);
    }

    protected void detachModel(PFDModel m) {
        if (m == null) {
            return;
        }
        for (int i = 0; i < m.getNumLayers(); ++i) {
            PFDLayer layer = m.getLayer(i);
            for (int j = 0; j < m.getNumPrimitives(); ++j) {
                PFDPrimitive p = layer.getPrimitive(j);
                p.detachView(this);
            }
        }
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 9: {
                return this.getPFDItemId();
            }
            case 7: {
                return this.gridSpaceY;
            }
            case 6: {
                return this.gridSpaceX;
            }
            case 4: {
                if (this.gridType == 1) {
                    return "dots";
                }
                return "lines";
            }
            case 5: {
                return this.gridVisible;
            }
            case 1: {
                return this.pageDividerVisible;
            }
            case 10: {
                return this.getViewRect().x;
            }
            case 11: {
                return this.getViewRect().y;
            }
            case 12: {
                return this.getViewRect().width;
            }
            case 13: {
                return this.getViewRect().height;
            }
            case 15: {
                return this.model.getFlowDirection();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        switch (id) {
            case 7: {
                if (this.gridSpaceY == 33) break;
                return true;
            }
            case 6: {
                if (this.gridSpaceX == 33) break;
                return true;
            }
            case 4: {
                if (this.gridType == 0) break;
                return true;
            }
            case 5: {
                if (!this.gridVisible) break;
                return true;
            }
            case 3: {
                if (!this.isOverviewVisible()) break;
                return true;
            }
            case 1: {
                if (!this.pageDividerVisible) break;
                return true;
            }
            case 2: {
                if (this.controlToolBar != null && this.controlToolBar.isVisible()) break;
                return true;
            }
            case 9: {
                return true;
            }
            case 15: {
                return !this.model.getFlowDirection().equalsIgnoreCase("Right");
            }
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 7: {
                if (!(value instanceof Number)) break;
                this.setGridSpaceY(((Number)value).intValue());
                break;
            }
            case 6: {
                if (!(value instanceof Number)) break;
                this.setGridSpaceX(((Number)value).intValue());
                break;
            }
            case 4: {
                if (!(value instanceof String)) break;
                if (((String)value).equalsIgnoreCase("dots")) {
                    this.setGridType(1);
                    break;
                }
                this.setGridType(0);
                break;
            }
            case 5: {
                if (!(value instanceof Boolean)) break;
                this.setGridVisible((Boolean)value);
                break;
            }
            case 8: {
                if (!(value instanceof Boolean)) break;
                this.doPFDLayout((Boolean)value);
                break;
            }
            case 3: {
                if (!(value instanceof Boolean)) break;
                this.setOverviewVisible((Boolean)value);
                break;
            }
            case 1: {
                if (!(value instanceof Boolean)) break;
                this.setPageDividerVisible((Boolean)value);
                break;
            }
            case 2: {
                if (!(value instanceof Boolean)) break;
                boolean isVisible = (Boolean)value;
                this.getToolBar().setVisible(isVisible);
                this.getAction("ACTION_TOGGLE_TOOLBAR").putValue("pfdAbstractAction.selected", isVisible);
                break;
            }
            case 9: {
                if (!(value instanceof String)) break;
                this.setPFDItemId((String)value);
                break;
            }
            case 15: {
                if (!(value instanceof String)) break;
                this.model.setFlowDirection((String)value);
            }
        }
    }

    public Object[] getDataIds() {
        return this.model.getDataIds();
    }

    public Object getDataSource() {
        return this.model.getDataSource();
    }

    public Object getDataSource(Object id) {
        return this.model.getDataSource(id);
    }

    public boolean setDataSource(Object source) {
        return this.model.setDataSource(source);
    }

    public boolean setDataSource(Object source, Object id) {
        this.model.setDataSource(source, id);
        return true;
    }

    public Object getObsoleteDataSource() {
        return this.model.getObsoleteDataSource();
    }

    public boolean dataSourceIsObsolete() {
        return this.model.dataSourceIsObsolete();
    }

    public void destroyObsoleteDataSource() {
        this.model.destroyObsoleteDataSource();
    }

    @Override
    public String getPFDItemId() {
        if (this.id == null || this.id.trim().length() == 0) {
            return null;
        }
        return this.id;
    }

    @Override
    public void setPFDItemId(String id) {
        this.id = id;
    }

    public class ImageIterator {
        private Dimension imageSize = null;
        private double imageScale = 1.0;
        private boolean drawCoords = false;
        private int numRows = 0;
        private int numCols = 0;
        private int index = 0;
        private Rectangle[][] imageRect = null;

        public ImageIterator(Dimension size) {
            this(size, 1.0, false);
        }

        public ImageIterator(Dimension size, double scale, boolean drawImageCoordinates) {
            this.imageSize = size;
            this.imageScale = scale;
            this.drawCoords = drawImageCoordinates;
            this.calculateImageRects();
        }

        public boolean hasNext() {
            return this.index < this.numRows * this.numCols;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int row = this.index / this.numCols;
            int col = this.index % this.numCols;
            Rectangle oldBounds = PFDView.this.getBounds();
            double oldScale = PFDView.this.scale;
            Point oldViewPos = PFDView.this.getViewPosition();
            if (PFDView.this.pfdAnnoComponent != null) {
                PFDView.this.pfdAnnoComponent.addNotify();
                PFDView.this.pfdAnnoComponent.setBounds(oldBounds.x, oldBounds.y, this.imageSize.width, this.imageSize.height);
                PFDView.this.pfdAnnoComponent.validate();
            }
            PFDView.this.addNotify();
            PFDView.this.setBounds(oldBounds.x, oldBounds.y, this.imageSize.width, this.imageSize.height);
            PFDView.this.validate();
            Rectangle bufferRect = new Rectangle(this.imageRect[row][col]);
            PFDView.this.setViewRect(bufferRect, this.imageSize.width, this.imageSize.height);
            BufferedImage img = new BufferedImage(this.imageSize.width, this.imageSize.height, 1);
            Graphics bg = img.getGraphics();
            boolean oldHold = PFDView.this.holdDisplay;
            PFDView.this.holdDisplay = false;
            PFDView.this.paint(bg);
            if (PFDView.this.pfdAnnoComponent != null) {
                PFDView.this.pfdAnnoComponent.paint(bg);
            }
            PFDView.this.holdDisplay = oldHold;
            if (this.drawCoords) {
                FontMetrics fm = bg.getFontMetrics();
                String footer = "(" + row + ", " + col + ")";
                int td = fm.getDescent();
                int tw = fm.stringWidth(footer);
                int x = this.imageSize.width - tw;
                int y = this.imageSize.height - td;
                bg.setColor(PFDView.this.getForeground());
                bg.drawString(footer, x, y);
            }
            bg.dispose();
            PFDView.this.setBounds(oldBounds);
            PFDView.this.validate();
            PFDView.this.setViewPosition(oldViewPos);
            PFDView.this.setScale(oldScale);
            if (PFDView.this.pfdAnnoComponent != null) {
                PFDView.this.pfdAnnoComponent.setBounds(oldBounds);
                PFDView.this.pfdAnnoComponent.validate();
            }
            ++this.index;
            return img;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getNumCols() {
            return this.numCols;
        }

        protected void calculateImageRects() {
            Dimension ps;
            Rectangle annoBounds;
            Dimension ms = PFDView.this.model.getSize();
            if (PFDView.this.pfdAnnoComponent != null) {
                annoBounds = PFDView.this.pfdAnnoComponent.getAnnotateBounds();
                ms.width = Math.max(annoBounds.x + annoBounds.width, ms.width);
                ms.height = Math.max(annoBounds.y + annoBounds.height, ms.height);
            }
            if (PFDView.this.backLayerAnnotate != null) {
                annoBounds = PFDView.this.backLayerAnnotate.getAnnotateBounds();
                ms.width = Math.max(annoBounds.x + annoBounds.width, ms.width);
                ms.height = Math.max(annoBounds.y + annoBounds.height, ms.height);
            }
            ++ms.height;
            ++ms.width;
            double oldScale = PFDView.this.scale;
            Point oldViewPos = PFDView.this.getViewPosition();
            PFDView.this.setScale(this.imageScale);
            if (this.imageSize == null) {
                this.imageSize = new Dimension(ms);
                ps = new Dimension(ms);
                PFDView.this.ModelToView(this.imageSize);
            } else {
                ps = new Dimension(this.imageSize);
                PFDView.this.ViewToModel(ps);
            }
            if (ps == null || ps.width <= 0 || ps.height <= 0 || ms == null || ms.width <= 0 || ms.height <= 0) {
                this.numRows = 0;
                this.numCols = 0;
                this.imageRect = null;
                return;
            }
            this.numRows = (int)Math.ceil((double)ms.height / (double)ps.height);
            this.numCols = (int)Math.ceil((double)ms.width / (double)ps.width);
            this.imageRect = new Rectangle[this.numRows][this.numCols];
            for (int r = 0; r < this.numRows; ++r) {
                for (int c = 0; c < this.numCols; ++c) {
                    this.imageRect[r][c] = new Rectangle(c * ps.width, r * ps.height, ps.width, ps.height);
                }
            }
            PFDView.this.setViewPosition(oldViewPos);
            PFDView.this.setScale(oldScale);
        }
    }

    private class ClipImage
    implements Transferable {
        private Image image;

        public ClipImage(Image img) {
            this.image = img;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

