/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDControlNode;
import com.sas.graphics.components.pfd.PFDShape;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Hashtable;

public class PFDTriangleControlNode
extends PFDControlNode {
    private static final long serialVersionUID = -8298271718837414461L;
    public static int DIRECTION_FORWARD = 0;
    public static int DIRECTION_BACKWARD = 1;
    protected int direction = DIRECTION_FORWARD;
    protected Dimension selectionOffset;
    protected Dimension iconOffset;

    public PFDTriangleControlNode() {
        this.controlShape = new PFDShape(new Rectangle(0, 0, PFDTriangleControlNode.defaultSize.width, PFDTriangleControlNode.defaultSize.height));
        this.selectionShape = new PFDShape();
        this.selectionOffset = new Dimension();
        this.iconOffset = new Dimension();
        this.init();
    }

    @Override
    protected void layoutChildren() {
        this.disableChangeUpdate();
        int shapeDirection = this.getShapeDirection();
        Shape s = this.createControlShape(shapeDirection);
        ((PFDShape)this.controlShape).setShape(s);
        ((PFDShape)this.selectionShape).setShape(s);
        this.selectionShape.setBBox(this.getSelectionBBox(shapeDirection));
        this.layoutText();
        this.layoutStatusButton(shapeDirection);
        this.layoutPorts();
        this.layoutNodeNumber(this.controlShape.getSpotLocation(1, null));
        this.enableChangeUpdate();
        this.calculateBBox();
    }

    @Override
    protected void layoutStatusButton() {
        this.layoutStatusButton(this.getShapeDirection());
    }

    private void layoutStatusButton(int shapeDirection) {
        Rectangle bounds = this.controlShape.getRBBox();
        switch (shapeDirection) {
            case 4: {
                this.statusButton.setLocation(bounds.x - this.statusButton.getWidth() / 2, bounds.y + bounds.height - this.statusButton.getHeight() / 2);
                break;
            }
            case 2: {
                this.statusButton.setLocation(bounds.x + bounds.width - this.statusButton.getWidth() / 2, bounds.y - this.statusButton.getHeight() / 2);
                break;
            }
            default: {
                this.statusButton.setLocation(bounds.x + bounds.width - this.statusButton.getWidth() / 2, bounds.y + bounds.height - this.statusButton.getHeight() / 2);
            }
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == this.direction) {
            return;
        }
        if (direction == DIRECTION_FORWARD || direction == DIRECTION_BACKWARD) {
            this.direction = direction;
            this.firePropertyChange("direction");
        }
    }

    private int getShapeDirection() {
        String flowDir = this.getFlowDirection();
        if (this.direction == DIRECTION_FORWARD) {
            if (flowDir.equalsIgnoreCase("right")) {
                return 4;
            }
            if (flowDir.equalsIgnoreCase("left")) {
                return 3;
            }
            if (flowDir.equalsIgnoreCase("up")) {
                return 1;
            }
            return 2;
        }
        if (flowDir.equalsIgnoreCase("right")) {
            return 3;
        }
        if (flowDir.equalsIgnoreCase("left")) {
            return 4;
        }
        if (flowDir.equalsIgnoreCase("up")) {
            return 2;
        }
        return 1;
    }

    private Shape createControlShape(int shapeDirection) {
        AffineTransform transform = new AffineTransform();
        switch (shapeDirection) {
            case 4: {
                transform.rotate(1.5707963267948966);
                break;
            }
            case 3: {
                transform.rotate(-1.5707963267948966);
                break;
            }
            case 2: {
                transform.rotate(Math.PI);
            }
        }
        Area a = new Area(PFDShape.getTriangleShape());
        a.transform(transform);
        return a;
    }

    private Rectangle getSelectionBBox(int shapeDirection) {
        Rectangle bounds = this.controlShape.getRBBox();
        switch (shapeDirection) {
            case 4: {
                return new Rectangle(bounds.x - 4, bounds.y - 6, bounds.width + 12, bounds.height + 12);
            }
            case 3: {
                return new Rectangle(bounds.x - 8, bounds.y - 6, bounds.width + 12, bounds.height + 12);
            }
            case 2: {
                return new Rectangle(bounds.x - 6, bounds.y - 4, bounds.width + 12, bounds.height + 12);
            }
        }
        return new Rectangle(bounds.x - 6, bounds.y - 8, bounds.width + 12, bounds.height + 12);
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("direction")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDTriangleControlNode clone = new PFDTriangleControlNode();
        table.put(this, clone);
        this.copyObject(clone);
        this.clonePorts(table, clone);
        return clone;
    }

    public void copyObject(PFDTriangleControlNode toObject) {
        super.copyObject(toObject);
        toObject.setDirection(this.getDirection());
    }
}

