/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PFDTextCustomizerPanel
extends JPanel
implements ActionListener,
FocusListener {
    public static final String RB_KEY = "PFDTextCustomizerPanel.";
    PFDText text;
    JTextField textField;
    JCheckBox wrap;
    JComboBox fontName;
    JComboBox fontSize;
    JComboBox fontStyle;
    JLabel textColorPreview;
    JButton textColor;
    JCheckBox textBackground;
    JLabel textBackgroundPreview;
    JButton textBackgroundColor;

    public PFDTextCustomizerPanel(PFDText text) {
        this.text = text;
        this.setLayout(new BoxLayout(this, 1));
        JPanel textPanel1 = new JPanel(new BorderLayout());
        JLabel textLabel = new JLabel(RB.getStringResource(RB_KEY, "label.txt"));
        textLabel.setPreferredSize(new Dimension(100, textLabel.getPreferredSize().height));
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(100, textLabel.getPreferredSize().height + 5));
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
        textPanel1.add((Component)textLabel, "West");
        textPanel1.add((Component)this.textField, "Center");
        JPanel textPanel3 = new JPanel(new BorderLayout());
        JLabel wrapLabel = new JLabel();
        wrapLabel.setPreferredSize(new Dimension(100, wrapLabel.getPreferredSize().height));
        this.wrap = new JCheckBox(RB.getStringResource(RB_KEY, "wrap.txt"));
        this.wrap.addActionListener(this);
        textPanel3.add((Component)wrapLabel, "West");
        textPanel3.add((Component)this.wrap, "Center");
        JPanel textPanel4 = new JPanel(new BorderLayout());
        JLabel fontNameLabel = new JLabel(RB.getStringResource(RB_KEY, "fontName.txt"));
        fontNameLabel.setPreferredSize(new Dimension(100, fontNameLabel.getPreferredSize().height));
        String[] fontNames = new String[]{RB.getStringResource(RB_KEY, "dialog.txt"), RB.getStringResource(RB_KEY, "dialogInput.txt"), RB.getStringResource(RB_KEY, "monospaced.txt"), RB.getStringResource(RB_KEY, "serif.txt"), RB.getStringResource(RB_KEY, "sansSerif.txt")};
        this.fontName = new JComboBox<String>(fontNames);
        this.fontName.setSelectedIndex(4);
        this.fontName.addActionListener(this);
        textPanel4.add((Component)fontNameLabel, "West");
        textPanel4.add((Component)this.fontName, "Center");
        JPanel textPanel5 = new JPanel();
        textPanel5.setLayout(new BoxLayout(textPanel5, 0));
        JLabel fontOtherLabel = new JLabel(RB.getStringResource(RB_KEY, "fontOther.txt"));
        fontOtherLabel.setPreferredSize(new Dimension(100, fontOtherLabel.getPreferredSize().height));
        String[] fontSizes = new String[]{"8", "10", "12", "14", "16", "18", "24"};
        this.fontSize = new JComboBox<String>(fontSizes);
        this.fontSize.setEditable(true);
        this.fontSize.addActionListener(this);
        String[] fontStyles = new String[]{RB.getStringResource(RB_KEY, "regular.txt"), RB.getStringResource(RB_KEY, "bold.txt"), RB.getStringResource(RB_KEY, "italic.txt"), RB.getStringResource(RB_KEY, "boldItalic.txt")};
        this.fontStyle = new JComboBox<String>(fontStyles);
        this.fontStyle.addActionListener(this);
        textPanel5.add(fontOtherLabel);
        textPanel5.add(this.fontSize);
        textPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        textPanel5.add(this.fontStyle);
        JPanel textPanel6 = new JPanel();
        textPanel6.setLayout(new BoxLayout(textPanel6, 0));
        JLabel textColorLabel = new JLabel(RB.getStringResource(RB_KEY, "color.txt"));
        textColorLabel.setPreferredSize(new Dimension(100, textColorLabel.getPreferredSize().height));
        JPanel textColorPanel = new JPanel(new BorderLayout());
        this.textColorPreview = new JLabel();
        this.textColorPreview.setOpaque(true);
        this.textColorPreview.setBorder(new BevelBorder(1));
        this.textColor = new JButton("...");
        this.textColor.addActionListener(this);
        this.textColor.setPreferredSize(new Dimension(this.textColor.getPreferredSize().height, this.textColor.getPreferredSize().height));
        textColorPanel.add((Component)this.textColorPreview, "Center");
        textColorPanel.add((Component)this.textColor, "East");
        textPanel6.add(textColorLabel);
        textPanel6.add(textColorPanel);
        JPanel textPanel7 = new JPanel(new BorderLayout());
        this.textBackground = new JCheckBox(RB.getStringResource(RB_KEY, "background.txt"));
        this.textBackground.addActionListener(this);
        this.textBackground.setPreferredSize(new Dimension(100, this.textBackground.getPreferredSize().height));
        JPanel textBackgroundPanel = new JPanel(new BorderLayout());
        this.textBackgroundPreview = new JLabel();
        this.textBackgroundPreview.setOpaque(true);
        this.textBackgroundPreview.setBorder(new BevelBorder(1));
        this.textBackgroundColor = new JButton("...");
        this.textBackgroundColor.addActionListener(this);
        this.textBackgroundColor.setPreferredSize(new Dimension(this.textBackgroundColor.getPreferredSize().height, this.textBackgroundColor.getPreferredSize().height));
        textBackgroundPanel.add((Component)this.textBackgroundPreview, "Center");
        textBackgroundPanel.add((Component)this.textBackgroundColor, "East");
        textPanel7.add((Component)this.textBackground, "West");
        textPanel7.add((Component)textBackgroundPanel, "Center");
        this.add(textPanel1);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(textPanel3);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(textPanel4);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(textPanel5);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(textPanel6);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(textPanel7);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.setBorder(new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "text.txt")));
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.textField.setText(this.text.getText());
        this.wrap.setSelected(this.text.isMultiline());
        this.fontSize.setSelectedItem(String.valueOf(this.text.getFontSize()));
        this.textColorPreview.setBackground(this.text.getForeground());
        this.textBackground.setSelected(!this.text.isTransparent());
        this.textBackgroundPreview.setBackground(this.text.getBackground());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color newColor;
        if (e.getSource() == this.textColor) {
            newColor = JColorChooser.showDialog(this, RB.getStringResource(RB_KEY, "textColorDialog.txt"), this.text.getForeground());
            this.text.setForeground(newColor);
            this.textColorPreview.setBackground(newColor);
        }
        if (e.getSource() == this.fontName) {
            int index = this.fontName.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.text.setFontName("Dialog");
                    break;
                }
                case 1: {
                    this.text.setFontName("DialogInput");
                    break;
                }
                case 2: {
                    this.text.setFontName("Monospaced");
                    break;
                }
                case 3: {
                    this.text.setFontName("Serif");
                    break;
                }
                case 4: {
                    this.text.setFontName("SansSerif");
                    break;
                }
            }
        }
        if (e.getSource() == this.fontStyle) {
            int index = this.fontStyle.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.text.setFontStyle(0);
                    break;
                }
                case 1: {
                    this.text.setFontStyle(1);
                    break;
                }
                case 2: {
                    this.text.setFontStyle(2);
                    break;
                }
                case 3: {
                    this.text.setFontStyle(3);
                    break;
                }
            }
        }
        if (e.getSource() == this.fontSize) {
            String fsize = (String)this.fontSize.getSelectedItem();
            this.text.setFontSize(Integer.valueOf(fsize));
        }
        if (e.getSource() == this.wrap) {
            this.text.setMultiline(this.wrap.isSelected());
        }
        if (e.getSource() == this.textBackground) {
            this.text.setTransparent(!this.textBackground.isSelected());
        }
        if (e.getSource() == this.textBackgroundColor) {
            newColor = JColorChooser.showDialog(this, RB.getStringResource(RB_KEY, "textBackgroundColorDialog.txt"), this.text.getBackground());
            this.text.setBackground(newColor);
            this.textBackgroundPreview.setBackground(newColor);
        }
        if (e.getSource() == this.textField) {
            this.text.setText(this.textField.getText());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textField) {
            this.text.setText(this.textField.getText());
        }
    }
}

