/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableInterface;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableNode;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsedPort;
import com.sas.graphics.components.pfd.interfaces.PFDSubdiagramContainer;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.SubdiagramNodeLayoutInterface;
import java.awt.Color;
import java.awt.Point;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PFDSubdiagram
extends PFDGroup
implements SubdiagramNodeLayoutInterface {
    protected static Hashtable expandedLink2CollapsedLink = new Hashtable();
    protected Vector inputNodes = null;
    protected Vector outputNodes = null;
    protected String flowDirection = "Right";
    private static boolean ignoreLinkChanges = false;

    public PFDSubdiagram() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.editable = true;
        this.resizable = false;
        this.pen.setStyle(2);
        this.pen.setColor(Color.lightGray);
        this.inputNodes = new Vector();
        this.outputNodes = new Vector();
    }

    public PFDSubdiagram(PFDPrimitive[] primitives) {
        this();
        for (int i = 0; i < primitives.length; ++i) {
            PFDPrimitive p;
            if (primitives[i] instanceof PFDLink) continue;
            PFDModel m = primitives[i].getModel();
            if (m != null) {
                m.getDefaultLayer().removePrimitive(primitives[i]);
            }
            this.addPrimitive(primitives[i]);
            if (primitives[i].isExpandable() && (p = primitives[i].getExpanded()) != null) {
                m = p.getModel();
                if (m == null) continue;
                m.getDefaultLayer().removePrimitive(p);
                continue;
            }
            if (!primitives[i].isCollapsable() || (p = primitives[i].getCollapsed()) == null || (m = p.getModel()) == null) continue;
            m.getDefaultLayer().removePrimitive(p);
        }
        this.calculateBBox();
    }

    public static PFDSubdiagram makeSubdiagram(PFDPrimitive[] primitives) {
        PFDSubdiagram s = new PFDSubdiagram(primitives);
        return s;
    }

    public static boolean isCollapsedSubdiagram(PFDAbstractNode node) {
        PFDSubdiagram sub = PFDSubdiagram.getExpandedSubdiagram(node);
        return sub != null;
    }

    public static boolean isCollapsedCollapsable(PFDAbstractNode node) {
        if (node instanceof PFDCollapsableInterface) {
            return true;
        }
        return PFDSubdiagram.isCollapsedSubdiagram(node);
    }

    public static boolean isInSubdiagram(PFDAbstractNode node) {
        PFDSubdiagram sub = PFDSubdiagram.getParentSubdiagram(node);
        return sub != null;
    }

    public static PFDSubdiagram getExpandedSubdiagram(PFDAbstractNode node) {
        if (node == null) {
            return null;
        }
        PFDPrimitive expanded = node.getExpanded();
        if (expanded instanceof PFDSubdiagram) {
            return (PFDSubdiagram)expanded;
        }
        if (expanded instanceof PFDSubdiagramContainer) {
            return ((PFDSubdiagramContainer)((Object)expanded)).getSubdiagram();
        }
        return null;
    }

    public static PFDSubdiagram getParentSubdiagram(PFDAbstractNode node) {
        if (node == null) {
            return null;
        }
        PFDGroup group = node.getGroup();
        if (group instanceof PFDSubdiagram) {
            return (PFDSubdiagram)group;
        }
        if (group instanceof PFDCollapsableNodeGroup && (group = group.getGroup()) instanceof PFDSubdiagram) {
            return (PFDSubdiagram)group;
        }
        return null;
    }

    public static boolean linkAdded(PFDPort fromPort, PFDPort toPort, PFDLink newLink, PFDView view) {
        if (ignoreLinkChanges) {
            return false;
        }
        PFDAbstractNode fromNode = PFDSubdiagram.getParentNode(fromPort);
        PFDAbstractNode toNode = PFDSubdiagram.getParentNode(toPort);
        if (fromNode == null || toNode == null || newLink == null || view == null) {
            return false;
        }
        if (newLink.isCollapsed()) {
            return PFDSubdiagram.collapsedLinkAdded(fromNode, toNode, newLink, view);
        }
        PFDModel model = view.getModel();
        if (model == null) {
            return false;
        }
        boolean retVal = PFDSubdiagram.linkAddedToCollapsed(model, fromNode, toNode, newLink, view);
        PFDUtil.updateParentCollapsable(fromNode);
        PFDUtil.updateParentCollapsable(toNode);
        return retVal;
    }

    private static boolean collapsedLinkAdded(PFDAbstractNode fromNode, PFDAbstractNode toNode, PFDLink newLink, PFDView view) {
        List expandedLinks = PFDSubdiagram.getExpandedLinks(newLink);
        if (expandedLinks == null || expandedLinks.isEmpty()) {
            return false;
        }
        PFDPort newToPort = newLink.getToPort();
        for (int i = 0; i < expandedLinks.size(); ++i) {
            PFDLink expanded = (PFDLink)expandedLinks.get(i);
            if (expanded == null) continue;
            PFDPort newFromPort = expanded.getFromPort();
            expanded.setToPort(newToPort);
            if (newFromPort == null || newToPort == null) continue;
            view.fireViewChange(9, null, null, null, newFromPort.getParentNode(), newFromPort, null, null, newToPort.getParentNode(), newToPort, expanded);
        }
        return true;
    }

    private static boolean linkAddedToCollapsed(PFDModel model, PFDAbstractNode fromNode, PFDAbstractNode toNode, PFDLink newLink, PFDView view) {
        PFDSubdiagram fromSub = PFDSubdiagram.getExpandedSubdiagram(fromNode);
        PFDSubdiagram toSub = PFDSubdiagram.getExpandedSubdiagram(toNode);
        if (fromSub == null && toSub == null) {
            return false;
        }
        PFDPort fromPort = newLink.getFromPort();
        PFDPort toPort = newLink.getToPort();
        Vector<PFDPort> fromPorts = null;
        Vector<PFDPort> toPorts = null;
        if (fromSub != null) {
            fromPorts = fromSub.getOutputPorts();
            if (fromPorts == null || fromPorts.isEmpty()) {
                return false;
            }
        } else {
            fromPorts = new Vector<PFDPort>();
            fromPorts.add(fromPort);
        }
        if (toSub != null) {
            toPorts = toSub.getInputPorts();
            if (toPorts == null || toPorts.isEmpty()) {
                return false;
            }
        } else {
            toPorts = new Vector<PFDPort>();
            toPorts.add(toPort);
        }
        PFDLink collapsedLink = null;
        Vector fromLinks = fromPort.getFromLinks();
        for (int i = 0; i < fromLinks.size() && collapsedLink == null; ++i) {
            PFDLink l = (PFDLink)fromLinks.elementAt(i);
            if (l == newLink || toPort != l.getToPort()) continue;
            collapsedLink = l;
        }
        if (collapsedLink == null) {
            collapsedLink = newLink;
            collapsedLink.setIsCollapsed(true);
        } else {
            PFDSubdiagram.removeModelPrimitive(model, newLink);
        }
        return PFDSubdiagram.createExpandedLinks(fromPorts, toPorts, collapsedLink, view);
    }

    public static void deleteLink(PFDLink deletedLink, PFDModel m) {
        if (ignoreLinkChanges || deletedLink == null) {
            return;
        }
        if (expandedLink2CollapsedLink.containsKey(deletedLink)) {
            PFDSubdiagram.deleteCollapsedLink(deletedLink, m);
        } else if (expandedLink2CollapsedLink.containsValue(deletedLink)) {
            PFDSubdiagram.deleteExpandedLinks(deletedLink, m);
        }
    }

    public static boolean redirectLink(PFDPort oldFromPort, PFDPort newFromPort, PFDPort oldToPort, PFDPort newToPort, PFDLink redirectedLink, PFDView view) {
        if (ignoreLinkChanges || redirectedLink == null) {
            return false;
        }
        if (expandedLink2CollapsedLink.containsValue(redirectedLink)) {
            return PFDSubdiagram.redirectCollapsedLink(oldFromPort, newFromPort, oldToPort, newToPort, redirectedLink, view);
        }
        if (expandedLink2CollapsedLink.containsKey(redirectedLink)) {
            return PFDSubdiagram.redirectExpandedLink(oldFromPort, newFromPort, oldToPort, newToPort, redirectedLink, view);
        }
        return PFDSubdiagram.redirectNormalLink(oldFromPort, newFromPort, oldToPort, newToPort, redirectedLink, view);
    }

    private static boolean redirectNormalLink(PFDPort oldFromPort, PFDPort newFromPort, PFDPort oldToPort, PFDPort newToPort, PFDLink redirectedLink, PFDView view) {
        if (oldFromPort == newFromPort && newToPort instanceof PFDCollapsedPort) {
            PFDPort expandedPort = ((PFDCollapsedPort)((Object)newToPort)).getExpandedPort();
            if (expandedPort == null) {
                return false;
            }
            redirectedLink.setToPort(expandedPort);
            PFDUtil.updateParentCollapsable(expandedPort.getParentNode());
            return true;
        }
        if (oldToPort == newToPort && newFromPort instanceof PFDCollapsedPort) {
            PFDPort expandedPort = ((PFDCollapsedPort)((Object)newFromPort)).getExpandedPort();
            if (expandedPort == null) {
                return false;
            }
            redirectedLink.setFromPort(expandedPort);
            PFDUtil.updateParentCollapsable(expandedPort.getParentNode());
            return true;
        }
        return PFDSubdiagram.linkAdded(newFromPort, newToPort, redirectedLink, view);
    }

    private static boolean redirectExpandedLink(PFDPort oldFromPort, PFDPort newFromPort, PFDPort oldToPort, PFDPort newToPort, PFDLink redirectedLink, PFDView view) {
        PFDAbstractNode oldFrom = PFDSubdiagram.getParentNode(oldFromPort);
        PFDAbstractNode newFrom = PFDSubdiagram.getParentNode(newFromPort);
        PFDAbstractNode oldTo = PFDSubdiagram.getParentNode(oldToPort);
        PFDAbstractNode newTo = PFDSubdiagram.getParentNode(newToPort);
        PFDModel model = view.getModel();
        if (model == null) {
            return false;
        }
        PFDSubdiagram.deleteCollapsedLink(redirectedLink, model);
        redirectedLink.setVisible(true);
        if (oldFromPort == newFromPort) {
            PFDUtil.updateParentCollapsable(oldTo);
            PFDUtil.updateParentCollapsable(newTo);
        } else {
            PFDUtil.updateParentCollapsable(oldFrom);
            PFDUtil.updateParentCollapsable(newFrom);
        }
        return true;
    }

    private static boolean redirectCollapsedLink(PFDPort oldFromPort, PFDPort newFromPort, PFDPort oldToPort, PFDPort newToPort, PFDLink redirectedLink, PFDView view) {
        PFDAbstractNode newFrom = PFDSubdiagram.getParentNode(newFromPort);
        PFDAbstractNode newTo = PFDSubdiagram.getParentNode(newToPort);
        PFDSubdiagram sub = null;
        PFDPort mainToPort = null;
        PFDPort mainFromPort = null;
        List<PFDPort> toPorts = null;
        List<PFDPort> fromPorts = null;
        boolean removeCollapsed = false;
        Vector expandedLinks = PFDSubdiagram.getKeys(expandedLink2CollapsedLink, redirectedLink);
        if (oldFromPort == newFromPort) {
            sub = PFDSubdiagram.getExpandedSubdiagram(newTo);
            fromPorts = new Vector(expandedLinks.size());
            if (sub == null) {
                PFDLink l;
                mainToPort = redirectedLink.getToPort();
                if (mainToPort instanceof PFDCollapsedPort) {
                    PFDCollapsedPort cp = (PFDCollapsedPort)((Object)mainToPort);
                    mainToPort = cp.getExpandedPort();
                } else if (!expandedLinks.isEmpty() && (l = (PFDLink)expandedLinks.firstElement()).getFromPort() == redirectedLink.getFromPort()) {
                    removeCollapsed = true;
                }
            } else {
                toPorts = sub.getInputPorts();
                if (toPorts != null && toPorts.size() > 0) {
                    mainToPort = (PFDPort)toPorts.get(0);
                }
            }
            if (mainToPort != null) {
                PFDModel m;
                Enumeration e = expandedLinks.elements();
                while (e.hasMoreElements()) {
                    PFDLink link = (PFDLink)e.nextElement();
                    PFDPort ofp = link.getFromPort();
                    PFDPort otp = link.getToPort();
                    PFDAbstractNode of = (PFDAbstractNode)link.getFromNode();
                    PFDAbstractNode ot = (PFDAbstractNode)link.getToNode();
                    fromPorts.add(link.getFromPort());
                    link.setToPort(mainToPort);
                    PFDAbstractNode nt = (PFDAbstractNode)link.getToNode();
                    view.fireViewChange(10, "toNode", of, ofp, of, ofp, ot, otp, nt, mainToPort, link);
                    if (!removeCollapsed) continue;
                    link.setVisible(true);
                    expandedLink2CollapsedLink.remove(link);
                }
                if (removeCollapsed && (m = view.getModel()) != null) {
                    PFDSubdiagram.removeModelPrimitive(m, redirectedLink);
                }
            } else {
                return false;
            }
            if (toPorts != null && toPorts.size() > 1) {
                toPorts.remove(0);
                PFDSubdiagram.createExpandedLinks(fromPorts, toPorts, redirectedLink, view);
                toPorts.add(0, mainToPort);
            }
        } else if (oldToPort == newToPort) {
            sub = PFDSubdiagram.getExpandedSubdiagram(newFrom);
            toPorts = new Vector(expandedLinks.size());
            if (sub == null) {
                PFDLink l;
                mainFromPort = redirectedLink.getFromPort();
                if (mainFromPort instanceof PFDCollapsedPort) {
                    PFDCollapsedPort cp = (PFDCollapsedPort)((Object)mainFromPort);
                    mainFromPort = cp.getExpandedPort();
                } else if (!expandedLinks.isEmpty() && (l = (PFDLink)expandedLinks.firstElement()).getToPort() == redirectedLink.getToPort()) {
                    removeCollapsed = true;
                }
            } else {
                fromPorts = sub.getOutputPorts();
                if (fromPorts != null && fromPorts.size() > 0) {
                    mainFromPort = (PFDPort)fromPorts.get(0);
                }
            }
            if (mainFromPort != null) {
                PFDModel m;
                Enumeration e = expandedLinks.elements();
                while (e.hasMoreElements()) {
                    PFDLink link = (PFDLink)e.nextElement();
                    PFDPort ofp = link.getFromPort();
                    PFDPort otp = link.getToPort();
                    PFDAbstractNode of = (PFDAbstractNode)link.getFromNode();
                    PFDAbstractNode ot = (PFDAbstractNode)link.getToNode();
                    toPorts.add(link.getToPort());
                    link.setFromPort(mainFromPort);
                    PFDAbstractNode nf = (PFDAbstractNode)link.getFromNode();
                    view.fireViewChange(10, "fromNode", of, ofp, nf, mainFromPort, ot, otp, ot, otp, link);
                    if (!removeCollapsed) continue;
                    link.setVisible(true);
                    expandedLink2CollapsedLink.remove(link);
                }
                if (removeCollapsed && (m = view.getModel()) != null) {
                    PFDSubdiagram.removeModelPrimitive(m, redirectedLink);
                }
            } else {
                return false;
            }
            if (fromPorts != null && fromPorts.size() > 1) {
                fromPorts.remove(0);
                PFDSubdiagram.createExpandedLinks(fromPorts, toPorts, redirectedLink, view);
                fromPorts.add(0, mainFromPort);
            }
        }
        return true;
    }

    private static boolean createExpandedLinks(List fromPorts, List toPorts, PFDLink collapsedLink, PFDView view) {
        if (fromPorts == null || fromPorts.isEmpty() || toPorts == null || toPorts.isEmpty() || collapsedLink == null || view == null) {
            return true;
        }
        PFDModel model = view.getModel();
        if (model == null) {
            return false;
        }
        boolean linkFailed = false;
        for (int i = 0; i < fromPorts.size(); ++i) {
            for (int j = 0; j < toPorts.size(); ++j) {
                PFDPort from = (PFDPort)fromPorts.get(i);
                PFDPort to = (PFDPort)toPorts.get(j);
                if (from.canDragNewLink() && to.canAcceptNewLink()) {
                    PFDLink expanded = from.createDragLink();
                    expanded.setModel(model);
                    if (expanded.isLinkSupported(from, to)) {
                        expanded.setFromPort(from);
                        expanded.setToPort(to);
                        PFDAbstractNode toNode = (PFDAbstractNode)expanded.getToNode();
                        PFDAbstractNode fromNode = (PFDAbstractNode)expanded.getFromNode();
                        expanded.setVisible(false);
                        PFDSubdiagram.addModelPrimitive(model, expanded);
                        view.fireViewChange(9, null, null, null, fromNode, from, null, null, toNode, to, expanded);
                        expandedLink2CollapsedLink.put(expanded, collapsedLink);
                        continue;
                    }
                    linkFailed = true;
                    continue;
                }
                linkFailed = true;
            }
        }
        if (linkFailed) {
            view.fireViewChange(13);
        }
        return true;
    }

    private static void deleteExpandedLinks(PFDLink deletedLink, PFDModel m) {
        if (deletedLink == null) {
            return;
        }
        Vector<PFDLink> deleteList = new Vector<PFDLink>();
        Enumeration en = expandedLink2CollapsedLink.keys();
        while (en.hasMoreElements()) {
            PFDLink expandedLink = (PFDLink)en.nextElement();
            PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.get(expandedLink);
            if (collapsedLink != deletedLink) continue;
            deleteList.add(expandedLink);
        }
        for (int i = 0; i < deleteList.size(); ++i) {
            expandedLink2CollapsedLink.remove(deleteList.elementAt(i));
            PFDSubdiagram.removeModelPrimitive(m, (PFDPrimitive)deleteList.elementAt(i));
        }
    }

    private static void deleteCollapsedLink(PFDLink deletedLink, PFDModel m) {
        if (deletedLink == null) {
            return;
        }
        PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.get(deletedLink);
        if (collapsedLink == null) {
            return;
        }
        expandedLink2CollapsedLink.remove(deletedLink);
        if (!expandedLink2CollapsedLink.containsValue(collapsedLink)) {
            PFDSubdiagram.removeModelPrimitive(m, collapsedLink);
        }
    }

    public static void collapseOutputLinksToPort(List outputLinks, PFDPort fromPort) {
        if (outputLinks == null || fromPort == null) {
            return;
        }
        PFDModel m = null;
        Vector<PFDLink> modelRemoveList = new Vector<PFDLink>();
        for (int i = 0; i < outputLinks.size(); ++i) {
            boolean removeOldLink;
            PFDLink l = (PFDLink)outputLinks.get(i);
            if (l == null) continue;
            m = l.getModel();
            PFDPort to = l.getToPort();
            PFDLink collapsedLink = null;
            collapsedLink = PFDSubdiagram.getExistingLink(fromPort, to, l.isControl());
            if (collapsedLink == null) {
                collapsedLink = l.createCollapsedLink();
                collapsedLink.setToPort(to);
                collapsedLink.setFromPort(fromPort);
                PFDSubdiagram.addModelPrimitive(m, collapsedLink);
            }
            if (collapsedLink != null && (removeOldLink = PFDSubdiagram.putWithRecursion(expandedLink2CollapsedLink, l, collapsedLink))) {
                modelRemoveList.addElement(l);
            }
            l.setVisible(false);
            collapsedLink.setVisible(true);
        }
        for (int k = 0; k < modelRemoveList.size(); ++k) {
            PFDSubdiagram.removeModelPrimitive(m, (PFDLink)modelRemoveList.elementAt(k));
        }
    }

    public static void collapseInputLinksToPort(List inputLinks, PFDPort toPort) {
        if (inputLinks == null || toPort == null) {
            return;
        }
        PFDModel m = null;
        Vector<PFDLink> modelRemoveList = new Vector<PFDLink>();
        for (int i = 0; i < inputLinks.size(); ++i) {
            boolean removeOldLink;
            PFDLink l = (PFDLink)inputLinks.get(i);
            if (l == null) continue;
            m = l.getModel();
            PFDPort from = l.getFromPort();
            PFDLink collapsedLink = null;
            collapsedLink = PFDSubdiagram.getExistingLink(from, toPort, l.isControl());
            if (collapsedLink == null) {
                collapsedLink = l.createCollapsedLink();
                collapsedLink.setToPort(toPort);
                collapsedLink.setFromPort(from);
                PFDSubdiagram.addModelPrimitive(m, collapsedLink);
            }
            if (collapsedLink != null && (removeOldLink = PFDSubdiagram.putWithRecursion(expandedLink2CollapsedLink, l, collapsedLink))) {
                modelRemoveList.addElement(l);
            }
            l.setVisible(false);
            collapsedLink.setVisible(true);
        }
        for (int k = 0; k < modelRemoveList.size(); ++k) {
            PFDSubdiagram.removeModelPrimitive(m, (PFDLink)modelRemoveList.elementAt(k));
        }
    }

    public static void expandLinks(List links) {
        for (int i = 0; i < links.size(); ++i) {
            PFDLink outLink = (PFDLink)links.get(i);
            if (outLink == null) continue;
            outLink.setVisible(true);
            PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.remove(outLink);
            if (collapsedLink == null || collapsedLink.getModel() == null) continue;
            outLink.setCollapsedBreakPoints(collapsedLink);
            PFDSubdiagram.removeModelPrimitive(collapsedLink.getModel(), collapsedLink);
        }
    }

    public static void expandOutLinks(List links) {
        int i;
        PFDModel m = null;
        Vector<PFDLink> modelRemoveList = new Vector<PFDLink>();
        Vector<PFDLink> modelAddList = new Vector<PFDLink>();
        Vector<PFDLink> tableRemoveList = new Vector<PFDLink>();
        Vector<Object[]> tableAddList = new Vector<Object[]>();
        for (i = 0; i < links.size(); ++i) {
            PFDLink outLink = (PFDLink)links.get(i);
            if (outLink == null) continue;
            m = outLink.getModel();
            PFDLink expandedLink = outLink;
            PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.get(expandedLink);
            if (collapsedLink == null) continue;
            PFDPort fromPort = null;
            PFDPort toPort = null;
            PFDAbstractNode fromNode = null;
            PFDAbstractNode toNode = null;
            NodeLayoutInterface node = collapsedLink.getToNode();
            if (node instanceof PFDAbstractNode) {
                toNode = (PFDAbstractNode)node;
            }
            if ((node = expandedLink.getFromNode()) instanceof PFDAbstractNode) {
                fromNode = (PFDAbstractNode)node;
            }
            fromPort = expandedLink.getFromPort();
            toPort = collapsedLink.getToPort();
            PFDLink newLink = null;
            if (PFDSubdiagram.isCollapsedCollapsable(fromNode) || PFDSubdiagram.isCollapsedCollapsable(toNode)) {
                newLink = PFDSubdiagram.getExistingLink(fromPort, toPort, collapsedLink.isControl());
                if (newLink == null) {
                    newLink = collapsedLink.createCollapsedLink();
                    newLink.setFromPort(fromPort);
                    newLink.setToPort(toPort);
                    modelAddList.add(newLink);
                }
                newLink.setVisible(true);
                if (newLink == expandedLink) {
                    tableRemoveList.add(expandedLink);
                } else {
                    tableAddList.add(new Object[]{expandedLink, newLink});
                }
            } else {
                expandedLink.setVisible(true);
                tableRemoveList.add(expandedLink);
            }
            if (newLink == collapsedLink || modelRemoveList.contains(collapsedLink)) continue;
            modelRemoveList.add(collapsedLink);
        }
        for (i = 0; i < tableRemoveList.size(); ++i) {
            expandedLink2CollapsedLink.remove(tableRemoveList.elementAt(i));
        }
        for (i = 0; i < tableAddList.size(); ++i) {
            Object[] keyValue = (Object[])tableAddList.elementAt(i);
            expandedLink2CollapsedLink.put(keyValue[0], keyValue[1]);
        }
        if (m != null) {
            for (i = 0; i < modelAddList.size(); ++i) {
                PFDSubdiagram.addModelPrimitive(m, (PFDPrimitive)modelAddList.elementAt(i));
            }
            for (i = 0; i < modelRemoveList.size(); ++i) {
                PFDSubdiagram.removeModelPrimitive(m, (PFDPrimitive)modelRemoveList.elementAt(i));
            }
        }
    }

    public static void expandInLinks(List links) {
        int i;
        PFDModel m = null;
        Vector<PFDLink> modelRemoveList = new Vector<PFDLink>();
        Vector<PFDLink> modelAddList = new Vector<PFDLink>();
        Vector<PFDLink> tableRemoveList = new Vector<PFDLink>();
        Vector<Object[]> tableAddList = new Vector<Object[]>();
        for (i = 0; i < links.size(); ++i) {
            PFDLink inLink = (PFDLink)links.get(i);
            if (inLink == null) continue;
            m = inLink.getModel();
            PFDLink expandedLink = inLink;
            PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.get(expandedLink);
            if (collapsedLink == null) continue;
            PFDPort fromPort = null;
            PFDPort toPort = null;
            PFDAbstractNode fromNode = null;
            PFDAbstractNode toNode = null;
            NodeLayoutInterface node = expandedLink.getToNode();
            if (node instanceof PFDAbstractNode) {
                toNode = (PFDAbstractNode)node;
            }
            if ((node = collapsedLink.getFromNode()) instanceof PFDAbstractNode) {
                fromNode = (PFDAbstractNode)node;
            }
            fromPort = collapsedLink.getFromPort();
            toPort = expandedLink.getToPort();
            PFDLink newLink = null;
            if (PFDSubdiagram.isCollapsedCollapsable(fromNode) || PFDSubdiagram.isCollapsedCollapsable(toNode)) {
                newLink = PFDSubdiagram.getExistingLink(fromPort, toPort, collapsedLink.isControl());
                if (newLink == null) {
                    newLink = collapsedLink.createCollapsedLink();
                    newLink.setFromPort(fromPort);
                    newLink.setToPort(toPort);
                    modelAddList.add(newLink);
                }
                newLink.setVisible(true);
                if (newLink == expandedLink) {
                    tableRemoveList.add(expandedLink);
                } else {
                    tableAddList.add(new Object[]{expandedLink, newLink});
                }
            } else {
                expandedLink.setVisible(true);
                tableRemoveList.add(expandedLink);
            }
            if (newLink == collapsedLink || modelRemoveList.contains(collapsedLink)) continue;
            modelRemoveList.add(collapsedLink);
        }
        for (i = 0; i < tableRemoveList.size(); ++i) {
            expandedLink2CollapsedLink.remove(tableRemoveList.elementAt(i));
        }
        for (i = 0; i < tableAddList.size(); ++i) {
            Object[] keyValue = (Object[])tableAddList.elementAt(i);
            expandedLink2CollapsedLink.put(keyValue[0], keyValue[1]);
        }
        if (m != null) {
            for (i = 0; i < modelAddList.size(); ++i) {
                PFDSubdiagram.addModelPrimitive(m, (PFDPrimitive)modelAddList.elementAt(i));
            }
            for (i = 0; i < modelRemoveList.size(); ++i) {
                PFDSubdiagram.removeModelPrimitive(m, (PFDPrimitive)modelRemoveList.elementAt(i));
            }
        }
    }

    public static List getExpandedLinks(PFDLink collapsedLink) {
        return PFDSubdiagram.getKeys(expandedLink2CollapsedLink, collapsedLink);
    }

    public static PFDLink getCollapsedLink(PFDLink expandedLink) {
        return (PFDLink)expandedLink2CollapsedLink.get(expandedLink);
    }

    public static void detachLink(PFDLink link) {
        expandedLink2CollapsedLink.remove(link);
    }

    public boolean addInputNode(PFDAbstractNode node) {
        boolean rv = !this.inputNodes.contains(node) && this.isExpandedChild(node) ? this.inputNodes.add(node) : false;
        if (rv) {
            this.updateCollapsedInputPortState();
        }
        return rv;
    }

    public boolean removeInputNode(PFDAbstractNode node) {
        boolean rv = this.inputNodes.remove(node);
        if (rv) {
            this.updateCollapsedInputPortState();
        }
        return rv;
    }

    public List getInputNodes() {
        return Collections.unmodifiableList(this.inputNodes);
    }

    public boolean addOutputNode(PFDAbstractNode node) {
        boolean rv = !this.outputNodes.contains(node) && this.isExpandedChild(node) ? this.outputNodes.add(node) : false;
        if (rv) {
            this.updateCollapsedOutputPortState();
        }
        return rv;
    }

    public boolean removeOutputNode(PFDAbstractNode node) {
        boolean rv = this.outputNodes.remove(node);
        if (rv) {
            this.updateCollapsedOutputPortState();
        }
        return rv;
    }

    public List getOutputNodes() {
        return Collections.unmodifiableList(this.outputNodes);
    }

    public List getOutputPorts() {
        Vector<PFDPort> outputPorts = new Vector<PFDPort>();
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.get(i);
            if (p instanceof PFDAbstractNode) {
                outputPorts.add(((PFDAbstractNode)p).getOutputPort());
                continue;
            }
            if (!(p instanceof PFDCollapsableNodeGroup)) continue;
            outputPorts.addAll(((PFDCollapsableNodeGroup)p).getGroupWindow().getSubdiagram().getOutputPorts());
        }
        return outputPorts;
    }

    public List getInputPorts() {
        Vector<PFDPort> inputPorts = new Vector<PFDPort>();
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.get(i);
            if (p instanceof PFDAbstractNode) {
                inputPorts.add(((PFDAbstractNode)p).getInputPort());
                continue;
            }
            if (!(p instanceof PFDCollapsableNodeGroup)) continue;
            inputPorts.addAll(((PFDCollapsableNodeGroup)p).getGroupWindow().getSubdiagram().getInputPorts());
        }
        return inputPorts;
    }

    public PFDGroup duplicate() {
        Hashtable ht = new Hashtable();
        PFDGroup copied = (PFDGroup)this.cloneObject(ht);
        this.redirectLinks(ht);
        return copied;
    }

    @Override
    public void collapse() {
        super.collapse();
        this.collapseLinks();
    }

    @Override
    protected void expandToPoint(int x, int y, PFDGroup g) {
        super.expandToPoint(x, y, g);
        this.expandLinks();
    }

    @Override
    protected void setCollapsed(PFDPrimitive p) {
        super.setCollapsed(p);
        this.collapse();
        this.updateCollapsedInputPortState();
        this.updateCollapsedOutputPortState();
    }

    protected void collapseLinks() {
        if (this.collapsed instanceof PFDAbstractNode) {
            this.collapseLinks(((PFDAbstractNode)this.collapsed).getInputPort(), ((PFDAbstractNode)this.collapsed).getOutputPort());
        }
    }

    public void collapseLinks(PFDPort in, PFDPort out) {
        this.buildInterdiagramLinkMaps(this, expandedLink2CollapsedLink, in, out);
        Enumeration en = expandedLink2CollapsedLink.keys();
        while (en.hasMoreElements()) {
            PFDLink expandedLink = (PFDLink)en.nextElement();
            if (!this.isConnectedLink(expandedLink) || this.isInternalLink(expandedLink)) continue;
            PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.get(expandedLink);
            expandedLink.setVisible(false);
            collapsedLink.setVisible(true);
        }
    }

    public void expandLinks() {
        int i;
        Vector<PFDLink> modelRemoveList = new Vector<PFDLink>();
        Vector<PFDLink> modelAddList = new Vector<PFDLink>();
        Vector<PFDLink> tableRemoveList = new Vector<PFDLink>();
        Vector<Object[]> tableAddList = new Vector<Object[]>();
        Enumeration en = expandedLink2CollapsedLink.keys();
        while (en.hasMoreElements()) {
            PFDCollapsableInterface collapsable;
            PFDSubdiagram sub;
            NodeLayoutInterface node;
            PFDLink expandedLink = (PFDLink)en.nextElement();
            PFDLink collapsedLink = (PFDLink)expandedLink2CollapsedLink.get(expandedLink);
            PFDPort fromPort = null;
            PFDPort toPort = null;
            PFDAbstractNode fromNode = null;
            PFDAbstractNode toNode = null;
            if (this.isInternalLink(expandedLink)) continue;
            if (this.isChild(expandedLink.getToPort())) {
                node = collapsedLink.getFromNode();
                if (node instanceof PFDAbstractNode) {
                    fromNode = (PFDAbstractNode)node;
                }
                if ((node = expandedLink.getToNode()) instanceof PFDAbstractNode) {
                    toNode = (PFDAbstractNode)node;
                }
                fromPort = collapsedLink.getFromPort();
                toPort = expandedLink.getToPort();
            } else if (this.isChild(expandedLink.getFromPort())) {
                node = collapsedLink.getToNode();
                if (node instanceof PFDAbstractNode) {
                    toNode = (PFDAbstractNode)node;
                }
                if ((node = expandedLink.getFromNode()) instanceof PFDAbstractNode) {
                    fromNode = (PFDAbstractNode)node;
                }
                fromPort = expandedLink.getFromPort();
                toPort = collapsedLink.getToPort();
            } else if (this.isExpandedChild(expandedLink.getToPort())) {
                node = collapsedLink.getFromNode();
                if (node instanceof PFDAbstractNode) {
                    fromNode = (PFDAbstractNode)node;
                }
                if ((node = expandedLink.getToNode()) instanceof PFDAbstractNode) {
                    sub = PFDSubdiagram.getParentSubdiagram((PFDAbstractNode)node);
                    if (sub != null) {
                        toNode = sub.getDirectChildNode(this, (PFDAbstractNode)node);
                        toPort = toNode.getInputPort();
                    } else {
                        collapsable = PFDUtil.getParentCollapsable((PFDAbstractNode)node);
                        if (collapsable instanceof PFDCollapsableNode) {
                            toPort = ((PFDCollapsableNode)collapsable).getCollapsedInputPort(expandedLink.getToPort());
                            toNode = toPort.getParentNode();
                        }
                    }
                }
                fromPort = collapsedLink.getFromPort();
            } else {
                if (!this.isExpandedChild(expandedLink.getFromPort())) continue;
                node = collapsedLink.getToNode();
                if (node instanceof PFDAbstractNode) {
                    toNode = (PFDAbstractNode)node;
                }
                if ((node = expandedLink.getFromNode()) instanceof PFDAbstractNode) {
                    sub = PFDSubdiagram.getParentSubdiagram((PFDAbstractNode)node);
                    if (sub != null) {
                        fromNode = sub.getDirectChildNode(this, (PFDAbstractNode)node);
                        fromPort = fromNode.getOutputPort();
                    } else {
                        collapsable = PFDUtil.getParentCollapsable((PFDAbstractNode)node);
                        if (collapsable instanceof PFDCollapsableNode) {
                            fromPort = ((PFDCollapsableNode)collapsable).getCollapsedOutputPort(expandedLink.getFromPort());
                            fromNode = fromPort.getParentNode();
                        }
                    }
                }
                toPort = collapsedLink.getToPort();
            }
            PFDLink newLink = null;
            if (PFDSubdiagram.isCollapsedCollapsable(fromNode) || PFDSubdiagram.isCollapsedCollapsable(toNode)) {
                newLink = PFDSubdiagram.getExistingLink(fromPort, toPort, collapsedLink.isControl());
                if (newLink == null) {
                    newLink = collapsedLink.createCollapsedLink();
                    newLink.setFromPort(fromPort);
                    newLink.setToPort(toPort);
                    modelAddList.add(newLink);
                }
                newLink.setVisible(true);
                tableAddList.add(new Object[]{expandedLink, newLink});
            } else {
                expandedLink.setVisible(true);
                tableRemoveList.add(expandedLink);
            }
            if (newLink == collapsedLink || modelRemoveList.contains(collapsedLink)) continue;
            modelRemoveList.add(collapsedLink);
        }
        for (i = 0; i < tableRemoveList.size(); ++i) {
            expandedLink2CollapsedLink.remove(tableRemoveList.elementAt(i));
        }
        for (i = 0; i < tableAddList.size(); ++i) {
            Object[] keyValue = (Object[])tableAddList.elementAt(i);
            expandedLink2CollapsedLink.put(keyValue[0], keyValue[1]);
        }
        PFDModel m = this.getModel();
        if (m != null) {
            int i2;
            for (i2 = 0; i2 < modelAddList.size(); ++i2) {
                PFDSubdiagram.addModelPrimitive(m, (PFDPrimitive)modelAddList.elementAt(i2));
            }
            for (i2 = 0; i2 < modelRemoveList.size(); ++i2) {
                PFDSubdiagram.removeModelPrimitive(m, (PFDPrimitive)modelRemoveList.elementAt(i2));
            }
        }
    }

    private boolean isConnectedLink(PFDLink link) {
        if (link == null) {
            return false;
        }
        boolean rc = this.isChild(link.getToPort()) || this.isChild(link.getFromPort());
        return rc;
    }

    private boolean isInternalLink(PFDLink link) {
        if (link == null) {
            return false;
        }
        boolean rc = this.isExpandedChild(link.getToPort()) && this.isExpandedChild(link.getFromPort());
        return rc;
    }

    protected PFDAbstractNode getDirectChildNode(PFDSubdiagram parent, PFDAbstractNode child) {
        if (this == parent) {
            return child;
        }
        if (this.collapsable && this.collapsed instanceof PFDAbstractNode) {
            PFDSubdiagram sub = PFDSubdiagram.getParentSubdiagram((PFDAbstractNode)this.collapsed);
            if (sub == null) {
                return null;
            }
            return sub.getDirectChildNode(parent, (PFDAbstractNode)this.collapsed);
        }
        if (this.getGroup() instanceof PFDSubdiagramContainer) {
            PFDAbstractNode node = ((PFDSubdiagramContainer)((Object)this.getGroup())).getCollapsedNode();
            if (node == null) {
                return null;
            }
            PFDSubdiagram sub = PFDSubdiagram.getParentSubdiagram(node);
            if (sub == null) {
                return null;
            }
            return sub.getDirectChildNode(parent, node);
        }
        return null;
    }

    private void updateCollapsedInputPortState() {
        PFDPort p;
        boolean enable = !this.inputNodes.isEmpty();
        if (this.collapsed instanceof PFDAbstractNode && (p = ((PFDAbstractNode)this.collapsed).getInputPort()) != null) {
            p.setValidInteractiveToPort(enable);
        }
    }

    private void updateCollapsedOutputPortState() {
        PFDPort p;
        boolean enable = !this.outputNodes.isEmpty();
        if (this.collapsed instanceof PFDAbstractNode && (p = ((PFDAbstractNode)this.collapsed).getOutputPort()) != null) {
            p.setValidInteractiveFromPort(enable);
        }
    }

    @Override
    public boolean addPrimitive(PFDPrimitive p) {
        if (p instanceof PFDLink) {
            return false;
        }
        return super.addPrimitive(p);
    }

    public void addPrimitives(PFDPrimitive[] primitives) {
        this.addSubdiagramPrimitives(primitives);
    }

    public void addSubdiagramPrimitive(PFDPrimitive p) {
        PFDPrimitive p2;
        if (p instanceof PFDLink) {
            return;
        }
        if (!p.canGroup()) {
            return;
        }
        PFDModel m = p.getModel();
        if (m != null) {
            m.getDefaultLayer().removePrimitive(p);
        }
        this.addPrimitive(p);
        if (p.isExpandable() && (p2 = p.getExpanded()) != null) {
            m = p2.getModel();
            if (m != null) {
                m.getDefaultLayer().removePrimitive(p2);
            }
        } else if (p.isCollapsable() && (p2 = p.getCollapsed()) != null && (m = p2.getModel()) != null) {
            m.getDefaultLayer().removePrimitive(p2);
        }
    }

    public void addSubdiagramPrimitives(List primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        this.disableChangeUpdate();
        Iterator i = primitives.iterator();
        while (i.hasNext()) {
            this.addSubdiagramPrimitive((PFDPrimitive)i.next());
        }
        this.enableChangeUpdate();
        this.firePropertyChange("children");
    }

    public void addSubdiagramPrimitives(PFDPrimitive[] primitives) {
        if (primitives == null || primitives.length == 0) {
            return;
        }
        this.disableChangeUpdate();
        for (int i = 0; i < primitives.length; ++i) {
            this.addSubdiagramPrimitive(primitives[i]);
        }
        this.enableChangeUpdate();
        this.firePropertyChange("children");
    }

    public List getSubdiagramPrimitives() {
        return new Vector(this.children);
    }

    public boolean removeSubdiagramPrimitive(PFDPrimitive p) {
        return this.removePrimitive(p);
    }

    public void removeSubdiagramPrimitives(PFDPrimitive[] primitives) {
        if (primitives == null || primitives.length == 0) {
            return;
        }
        this.disableChangeUpdate();
        for (int i = 0; i < primitives.length; ++i) {
            this.removeSubdiagramPrimitive(primitives[i]);
        }
        this.enableChangeUpdate();
        this.firePropertyChange("children");
    }

    public void removeSubdiagramPrimitives(List primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        this.disableChangeUpdate();
        Iterator i = primitives.iterator();
        while (i.hasNext()) {
            this.removeSubdiagramPrimitive((PFDPrimitive)i.next());
        }
        this.enableChangeUpdate();
        this.firePropertyChange("children");
    }

    @Override
    public Point getCenterLocation() {
        if (this.bboxDirty) {
            this.calculateBBox();
        }
        return new Point(this.bbox.x + this.bbox.width / 2, this.bbox.y + this.bbox.height / 2);
    }

    @Override
    public void setCenterLocation(Point p) {
        if (this.bboxDirty) {
            this.calculateBBox();
        }
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public int getLayoutHeight() {
        return this.getHeight();
    }

    @Override
    public int getLayoutWidth() {
        return this.getWidth();
    }

    @Override
    public int getInputEndSegmentLength() {
        return 0;
    }

    @Override
    public int getOutputEndSegmentLength() {
        return 0;
    }

    @Override
    public double getInputLinkDirection() {
        return Double.NaN;
    }

    @Override
    public double getOutputLinkDirection() {
        return Double.NaN;
    }

    @Override
    public void setNodePlaced(boolean place) {
    }

    @Override
    public boolean isNodePlaced() {
        return false;
    }

    @Override
    public Vector getExternalLinks() {
        Vector links = new Vector();
        this.accumulateLinks(links);
        for (int i = 0; i < links.size(); ++i) {
            if (!this.isInternalLink((PFDLink)links.elementAt(i))) continue;
            links.remove(i);
            --i;
        }
        return links;
    }

    @Override
    public Vector getInternalLinks() {
        Vector links = new Vector();
        this.accumulateLinks(links);
        for (int i = 0; i < links.size(); ++i) {
            if (this.isInternalLink((PFDLink)links.elementAt(i))) continue;
            links.remove(i);
            --i;
        }
        return links;
    }

    @Override
    public Vector getChildNodes() {
        Vector<NodeLayoutInterface> nodes = new Vector<NodeLayoutInterface>(this.children);
        for (int i = 0; i < nodes.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)nodes.get(i);
            if (p instanceof PFDCollapsableNodeGroup) {
                NodeLayoutInterface layoutNode = ((PFDCollapsableNodeGroup)p).getLayoutNode();
                if (layoutNode != null) {
                    nodes.set(i, layoutNode);
                    continue;
                }
                nodes.remove(i);
                --i;
                continue;
            }
            if (p instanceof NodeLayoutInterface) continue;
            nodes.remove(i);
            --i;
        }
        return nodes;
    }

    @Override
    public boolean isChildNode(NodeLayoutInterface node) {
        if (node instanceof PFDPrimitive) {
            return this.isChild((PFDPrimitive)((Object)node));
        }
        return false;
    }

    @Override
    public void layoutSelfLinks() {
    }

    public String getFlowDirection() {
        return this.flowDirection;
    }

    public void setFlowDirection(String direction) {
        PFDModel.checkFlowDirection(direction);
        if (this.flowDirection == direction) {
            return;
        }
        this.flowDirection = direction;
        for (int i = 0; i < this.children.size(); ++i) {
            Object o = this.children.get(i);
            if (!(o instanceof PFDDirectionalNodeInterface)) continue;
            ((PFDDirectionalNodeInterface)o).setFlowDirection(direction);
        }
    }

    @Override
    public void bringToFront(PFDPrimitive p) {
        if (this.model == null || !this.children.contains(p)) {
            return;
        }
        this.children.remove(p);
        this.children.add(p);
        this.bringToFront();
    }

    @Override
    protected void primitiveRemoved(PFDPrimitive p) {
        this.removePrimitive(p);
        PFDCollapsableNodeGroup nodeGroup = PFDCollapsableNodeGroup.getParentNodeGroup(this);
        if (nodeGroup != null) {
            nodeGroup.update();
        }
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        if (spot == 10 && this.children.size() > 0) {
            PFDPrimitive child = (PFDPrimitive)this.children.get(0);
            return child.getSpotLocation(spot, p);
        }
        return super.getSpotLocation(spot, p);
    }

    private static PFDAbstractNode getParentNode(PFDPort port) {
        if (port == null) {
            return null;
        }
        return port.getParentNode();
    }

    private static void addModelPrimitive(PFDModel m, PFDPrimitive p) {
        if (m == null || p == null) {
            return;
        }
        ignoreLinkChanges = true;
        m.addPrimitive(p);
        ignoreLinkChanges = false;
    }

    private static void removeModelPrimitive(PFDModel m, PFDPrimitive p) {
        if (m == null || p == null) {
            return;
        }
        ignoreLinkChanges = true;
        m.removePrimitive(p);
        ignoreLinkChanges = false;
    }
}

