/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDMessageWindow;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDStatusInterface;
import com.sas.graphics.components.pfd.interfaces.PFDWindowContainerInterface;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;

public class PFDStatusUtil
implements PFDStatusInterface,
Serializable {
    private transient PFDStatus statusObject = null;
    private PFDAbstractAction statusAction;
    private PFDMessageWindow statusWindow;
    private PFDWindowContainerInterface container;
    private static final Dimension smallIconSize = new Dimension(12, 12);

    public PFDStatusUtil(PFDWindowContainerInterface container) {
        this.setStatus(0);
        this.container = container;
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(status, null, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip) {
        this.setStatus(status, tooltip, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip, String title, String content, HyperlinkListener listener) {
        PFDStatus newStatus = PFDStatus.getInstance(status);
        newStatus.putValue("Tooltip", tooltip);
        newStatus.putValue("MessageTitle", title);
        newStatus.putValue("MessgeContent", content);
        newStatus.putValue("MessageHyperlinkListener", listener);
        this.setStatus(newStatus);
    }

    @Override
    public void setStatus(PFDStatus status) {
        this.statusObject = status;
        String content = (String)status.getValue("MessgeContent");
        boolean hasDetails = content != null && content.length() > 0;
        Icon icon = (Icon)status.getValue("LargeIcon");
        String tooltip = (String)status.getValue("Tooltip");
        if (icon == null) {
            this.statusAction = null;
        } else {
            this.statusAction = new StatusAction();
            this.statusAction.putValue("SmallIcon", icon);
            this.statusAction.putValue("ShortDescription", tooltip);
            this.statusAction.setEnabled(hasDetails);
        }
        if (hasDetails) {
            String title = (String)status.getValue("MessageTitle");
            Icon smallIcon = (Icon)status.getValue("SmallIcon");
            HyperlinkListener listener = (HyperlinkListener)status.getValue("MessageHyperlinkListener");
            this.statusWindow = new PFDMessageWindow(this.container);
            this.statusWindow.setTitleText(title);
            this.statusWindow.setText(content);
            this.statusWindow.setIcon(smallIcon);
            if (listener != null) {
                this.statusWindow.getTextPane().addHyperlinkListener(listener);
            }
        } else {
            this.statusWindow = null;
        }
    }

    @Override
    public int getStatus() {
        if (this.statusObject == null) {
            return 0;
        }
        Integer statusID = (Integer)this.statusObject.getValue("ID");
        if (statusID == null) {
            return -1;
        }
        return statusID;
    }

    public PFDAbstractAction getAction() {
        return this.statusAction;
    }

    public PFDMessageWindow getMessageWindow() {
        return this.statusWindow;
    }

    public static String getLargeIconName(int status) {
        switch (status) {
            case 1: {
                return "MessageWarning_16.gif";
            }
            case 2: {
                return "MessageError_16.gif";
            }
            case 3: {
                return "Progress.gif";
            }
            case 4: {
                return "MessageIncomplete_16.gif";
            }
            case 5: {
                return "MessageComplete_16.gif";
            }
            case 6: {
                return "MessageInvalid_16.gif";
            }
        }
        return null;
    }

    public static Icon getLargeIcon(int status) {
        return PFDIconManager.getIcon(PFDStatusUtil.getLargeIconName(status));
    }

    public static Icon getSmallIcon(int status) {
        return PFDIconManager.getSizedIcon(PFDStatusUtil.getLargeIconName(status), smallIconSize);
    }

    public static String getContextName(int status) {
        switch (status) {
            case 0: {
                return "StatusNormal";
            }
            case 1: {
                return "StatusWarning";
            }
            case 2: {
                return "StatusError";
            }
            case 3: {
                return "StatusProcessing";
            }
            case 4: {
                return "StatusIncomplete";
            }
            case 5: {
                return "StatusComplete";
            }
            case 6: {
                return "StatusInvalid";
            }
        }
        return null;
    }

    public static boolean isPredefinedStatus(int statusID) {
        switch (statusID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void updateStatusObject(Style style) {
        if (this.statusObject == null) {
            return;
        }
        Integer statusID = (Integer)this.statusObject.getValue("ID");
        if (statusID == null) {
            return;
        }
        if (!PFDStatusUtil.isPredefinedStatus(statusID)) {
            return;
        }
        String context = PFDStatusUtil.getContextName(statusID);
        LineStyleElement lse = null;
        if (style != null && context != null) {
            lse = style.getLineStyleElement(context);
        }
        if (lse == null) {
            this.statusObject.putValue("LineThickness", null);
            this.statusObject.putValue("LineColor", null);
        } else {
            this.statusObject.putValue("LineThickness", new Integer(lse.getLineThickness().toPixels(0, 0)));
            this.statusObject.putValue("LineColor", lse.getLineColor());
        }
    }

    @Override
    public PFDStatus getStatusObject() {
        return this.statusObject;
    }

    private class StatusAction
    extends PFDAbstractAction {
        public StatusAction() {
            super((PFDView)null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PFDStatusUtil.this.container != null && PFDStatusUtil.this.statusWindow != null) {
                PFDStatusUtil.this.container.setWindowVisible(PFDStatusUtil.this.statusWindow, true);
            }
        }
    }
}

