/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDStatusUtil;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.util.Hashtable;
import java.util.Vector;

public class PFDStatus
implements PropertyInterface {
    public static final String NAME = "Name";
    public static final String ID = "ID";
    public static final String LINE_COLOR = "LineColor";
    public static final String LINE_THICKNESS = "LineThickness";
    public static final String SMALL_ICON = "SmallIcon";
    public static final String LARGE_ICON = "LargeIcon";
    public static final String TOOLTIP = "Tooltip";
    public static final String MESSAGE_TITLE = "MessageTitle";
    public static final String MESSAGE_CONTENT = "MessgeContent";
    public static final String MESSAGE_HYPERLINK_LISTENER = "MessageHyperlinkListener";
    public static final String MESSAGE_VISIBLE = "MessageVisible";
    private Hashtable table;
    protected PropertyList pending = new PropertyList();

    public Object getValue(String key) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(key);
    }

    public void putValue(String key, Object value) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        if (value == null) {
            this.table.remove(key);
        } else {
            this.table.put(key, value);
        }
    }

    public static PFDStatus getInstance(int statusID) {
        if (!PFDStatusUtil.isPredefinedStatus(statusID)) {
            throw new IllegalArgumentException("The specified status is not supported");
        }
        PFDStatus status = new PFDStatus();
        status.putValue(ID, new Integer(statusID));
        String context = PFDStatusUtil.getContextName(statusID);
        status.putValue(NAME, context);
        status.putValue(LARGE_ICON, PFDStatusUtil.getLargeIcon(statusID));
        status.putValue(SMALL_ICON, PFDStatusUtil.getSmallIcon(statusID));
        return status;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object value = null;
        switch (id) {
            case 700: {
                return this.getValue(NAME);
            }
            case 701: {
                return this.getValue(LINE_COLOR);
            }
            case 702: {
                return this.getValue(LINE_THICKNESS);
            }
            case 703: {
                return this.getValue(SMALL_ICON);
            }
            case 704: {
                return this.getValue(LARGE_ICON);
            }
            case 705: {
                return this.getValue(TOOLTIP);
            }
            case 706: {
                return this.getValue(MESSAGE_TITLE);
            }
            case 707: {
                return this.getValue(MESSAGE_CONTENT);
            }
            case 708: {
                return this.getValue(MESSAGE_HYPERLINK_LISTENER);
            }
            case 709: {
                return this.getValue(MESSAGE_VISIBLE);
            }
        }
        return value;
    }

    public boolean hasUserSetValue(int id) {
        boolean userSet = false;
        switch (id) {
            case 700: {
                if (this.getValue(NAME) == null) break;
                userSet = true;
                break;
            }
            case 701: {
                if (this.getValue(LINE_COLOR) == null) break;
                userSet = true;
                break;
            }
            case 702: {
                if (this.getValue(LINE_THICKNESS) == null) break;
                userSet = true;
                break;
            }
            case 703: {
                if (this.getValue(SMALL_ICON) == null) break;
                userSet = true;
                break;
            }
            case 704: {
                if (this.getValue(LARGE_ICON) == null) break;
                userSet = true;
                break;
            }
            case 705: {
                if (this.getValue(TOOLTIP) == null) break;
                userSet = true;
                break;
            }
            case 706: {
                if (this.getValue(MESSAGE_TITLE) == null) break;
                userSet = true;
                break;
            }
            case 707: {
                if (this.getValue(MESSAGE_CONTENT) == null) break;
                userSet = true;
                break;
            }
            case 708: {
                if (this.getValue(MESSAGE_HYPERLINK_LISTENER) == null) break;
                userSet = true;
                break;
            }
            case 709: {
                if (this.getValue(MESSAGE_VISIBLE) == null) break;
                userSet = true;
            }
        }
        return userSet;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 704: 
            case 705: 
            case 706: 
            case 707: 
            case 708: 
            case 709: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 700: {
                if (!(value instanceof String)) break;
                this.putValue(NAME, value);
                break;
            }
            case 701: {
                if (!(value instanceof String)) break;
                this.putValue(LINE_COLOR, value);
                break;
            }
            case 702: {
                if (!(value instanceof String)) break;
                this.putValue(LINE_THICKNESS, value);
                break;
            }
            case 703: {
                if (!(value instanceof String)) break;
                this.putValue(SMALL_ICON, value);
                break;
            }
            case 704: {
                if (!(value instanceof String)) break;
                this.putValue(LARGE_ICON, value);
                break;
            }
            case 705: {
                if (!(value instanceof String)) break;
                this.putValue(TOOLTIP, value);
                break;
            }
            case 706: {
                if (!(value instanceof String)) break;
                this.putValue(MESSAGE_TITLE, value);
                break;
            }
            case 707: {
                if (!(value instanceof String)) break;
                this.putValue(MESSAGE_CONTENT, value);
                break;
            }
            case 708: {
                if (!(value instanceof String)) break;
                this.putValue(MESSAGE_HYPERLINK_LISTENER, value);
                break;
            }
            case 709: {
                if (!(value instanceof Boolean)) break;
                this.putValue(MESSAGE_VISIBLE, value);
            }
        }
    }
}

