/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDLabeledNodeInterface;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;

public class PFDSimpleNode
extends PFDAbstractNode
implements PFDLabeledNodeInterface {
    public static final String RB_KEY = "PFDSimpleNode.";
    private PFDEllipse ellipse = null;
    private PFDText label = null;
    private PFDPort port = null;
    private int labelPosition = 2;
    private Point location;
    private Dimension size;
    private String text;

    public PFDSimpleNode() {
        this(new Point(0, 0), new Dimension(0, 0), null);
    }

    public PFDSimpleNode(Point loc, Dimension size, String label) {
        this.setBreakable(false);
        this.location = loc;
        this.size = size;
        this.text = label;
        this.initialize();
    }

    public PFDEllipse getEllipse() {
        return this.ellipse;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.port.isVisible();
    }

    @Override
    public void setForceShowPorts(boolean b) {
        if (this.isForceShowPorts() == b) {
            return;
        }
        this.port.setVisible(b);
    }

    public PFDPort getPort() {
        return this.port;
    }

    public PFDText getLabel() {
        return this.label;
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(int position) {
        if (this.labelPosition == position) {
            return;
        }
        this.checkLabelPosition(position);
        this.labelPosition = position;
        this.layoutChildren();
    }

    private void checkLabelPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "label.ex.txt"));
            }
        }
    }

    protected void initialize() {
        this.ellipse = new PFDEllipse();
        this.ellipse.setBBox(this.location, this.size);
        this.ellipse.setShadowOn(false);
        if (this.text != null) {
            this.label = new PFDText(this.text);
        }
        this.port = new PFDPort();
        this.port.setName("port");
        this.port.setFromLinkSpot(9);
        this.port.setToLinkSpot(9);
        this.port.setValidFromPort(true);
        this.port.setValidToPort(true);
        this.port.setType(5);
        this.port.getBrush().setColor(Color.black);
        this.addPrimitive(this.ellipse);
        this.addPrimitive(this.label);
        this.addPrimitive(this.port);
        this.layoutChildren();
    }

    protected void layoutChildren() {
        Rectangle r = this.ellipse.getRBBox();
        Point p = new Point();
        this.ellipse.getSpotLocation(0, p);
        this.port.setBBox(p.x - r.width / 6, p.y - r.height / 6, r.width / 3, r.height / 3);
        this.port.setFreeSpotOffsetX(r.width / 2 + 1);
        this.port.setFreeSpotOffsetY(r.height / 2 + 1);
        if (this.label == null) {
            this.calculateBBox();
            return;
        }
        switch (this.labelPosition) {
            default: {
                this.ellipse.getSpotLocation(0, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 1: {
                this.ellipse.getSpotLocation(2, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(2);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 2: {
                this.ellipse.getSpotLocation(6, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(1);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 3: {
                this.ellipse.getSpotLocation(8, p);
                this.label.setHorizontalAlignment(2);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 4: {
                this.ellipse.getSpotLocation(4, p);
                this.label.setHorizontalAlignment(1);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
            }
        }
        this.calculateBBox();
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDSimpleNode clone = this.getLabel() != null ? new PFDSimpleNode(this.ellipse.getLocation(), this.ellipse.getSize(), this.getLabel().getText()) : new PFDSimpleNode(this.ellipse.getLocation(), this.ellipse.getSize(), null);
        super.copyObject(clone);
        clone.setForceShowPorts(this.isForceShowPorts());
        clone.setLabelPosition(this.getLabelPosition());
        this.ellipse.copyObject(clone.getEllipse());
        if (this.label != null) {
            this.label.copyObject(clone.getLabel());
        }
        table.put(this, clone);
        table.put(this.ellipse, clone.ellipse);
        if (this.label != null) {
            table.put(this.label, clone.label);
        }
        table.put(this.port, clone.port);
        return clone;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        Rectangle r = this.getRBBox();
        if (r.x == x && r.y == y && r.width == w && r.height == h) {
            return;
        }
        this.location = this.ellipse.getLocation();
        this.size = this.ellipse.getSize();
        x = Math.max(0, x);
        y = Math.max(0, y);
        Dimension labelSize = this.label != null ? this.label.getSize() : new Dimension(0, 0);
        if (w < labelSize.width && !this.label.isMultiline()) {
            return;
        }
        if (h < labelSize.height) {
            return;
        }
        this.location.x += x - r.x;
        this.location.y += y - r.y;
        this.size.width += w - r.width;
        this.size.height += h - r.height;
        this.ellipse.setBBox(this.location, this.size);
        this.layoutChildren();
        this.firePropertyChange("bbox");
    }

    @Override
    public PFDPort getPort(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
        }
        if (name.equals(this.port.getName())) {
            return this.port;
        }
        return null;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public PFDPort getInputPort() {
        return this.port;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.port;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        Vector inLinks = this.port.getToLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        Vector outLinks = this.port.getFromLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }
}

