/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDBrushCustomizerPanel;
import com.sas.graphics.components.pfd.PFDPenCustomizerPanel;
import com.sas.graphics.components.pfd.PFDShapeNode;
import com.sas.graphics.components.pfd.PFDTextCustomizerPanel;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class PFDShapeNodePropertyDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String RB_KEY = "PFDShapeNodePropertyDialog.";
    PFDShapeNode node;
    PFDView view;
    JComboBox shape;
    JCheckBox shadow;
    JCheckBox portSpot;
    JButton closeButton;

    public PFDShapeNodePropertyDialog(Frame aFrame, String title, PFDShapeNode node, PFDView viewer) {
        super(aFrame, true);
        this.setResizable(false);
        this.node = node;
        this.view = viewer;
        this.setTitle(title);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel shapePanel = new JPanel();
        shapePanel.setLayout(new BoxLayout(shapePanel, 0));
        JLabel shapeLabel = new JLabel(RB.getStringResource(RB_KEY, "shape.txt"));
        shapeLabel.setPreferredSize(new Dimension(100, shapeLabel.getPreferredSize().height));
        String[] shapes = new String[]{RB.getStringResource(RB_KEY, "rectangle.txt"), RB.getStringResource(RB_KEY, "roundrect.txt"), RB.getStringResource(RB_KEY, "ellipse.txt"), RB.getStringResource(RB_KEY, "diamond.txt"), RB.getStringResource(RB_KEY, "hexagon.txt"), RB.getStringResource(RB_KEY, "parallelogram.txt"), RB.getStringResource(RB_KEY, "pentagon.txt"), RB.getStringResource(RB_KEY, "octagon.txt")};
        this.shape = new JComboBox<String>(shapes);
        this.shape.addActionListener(this);
        shapePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        shapePanel.add((Component)shapeLabel, "West");
        shapePanel.add((Component)this.shape, "Center");
        contentPane.add(shapePanel);
        JPanel shadowPanel = new JPanel();
        shadowPanel.setLayout(new BoxLayout(shadowPanel, 0));
        this.shadow = new JCheckBox(RB.getStringResource(RB_KEY, "shadow.txt"));
        this.shadow.addActionListener(this);
        shadowPanel.add(Box.createRigidArea(new Dimension(105, 0)));
        shadowPanel.add(this.shadow);
        shadowPanel.add(Box.createHorizontalGlue());
        contentPane.add(shadowPanel);
        contentPane.add(new PFDTextCustomizerPanel(node.getLabel()));
        contentPane.add(new PFDPenCustomizerPanel(node.getDrawable().getPen()));
        contentPane.add(new PFDBrushCustomizerPanel(node.getDrawable().getBrush()));
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 0));
        this.portSpot = new JCheckBox(RB.getStringResource(RB_KEY, "portSpot.txt"));
        this.portSpot.addActionListener(this);
        portPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        portPanel.add(this.portSpot);
        portPanel.add(Box.createHorizontalGlue());
        contentPane.add(portPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new BoxLayout(closePanel, 0));
        this.closeButton = new JButton(RB.getStringResource(RB_KEY, "close.txt"));
        closePanel.add(Box.createHorizontalGlue());
        closePanel.add(this.closeButton);
        contentPane.add(closePanel);
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(contentPane);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        switch (this.node.getShape()) {
            default: {
                this.shape.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.shape.setSelectedIndex(1);
                break;
            }
            case 5: {
                this.shape.setSelectedIndex(2);
                break;
            }
            case 6: {
                this.shape.setSelectedIndex(3);
                break;
            }
            case 7: {
                this.shape.setSelectedIndex(4);
                break;
            }
            case 8: {
                this.shape.setSelectedIndex(5);
                break;
            }
            case 9: {
                this.shape.setSelectedIndex(6);
                break;
            }
            case 10: {
                this.shape.setSelectedIndex(7);
            }
        }
        this.shadow.setSelected(this.node.getDrawable().isShadowOn());
        this.node.getDrawable().getPen().addPropertyChangeListener(this);
        this.node.getDrawable().getBrush().addPropertyChangeListener(this);
        this.portSpot.setSelected(this.node.isForceFixedAngleConnectionPorts());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.shape) {
            int index = this.shape.getSelectedIndex();
            if (index == 0) {
                this.node.setShape(2);
            } else if (index == 1) {
                this.node.setShape(3);
            } else if (index == 2) {
                this.node.setShape(5);
            } else if (index == 3) {
                this.node.setShape(6);
            } else if (index == 4) {
                this.node.setShape(7);
            } else if (index == 5) {
                this.node.setShape(8);
            } else if (index == 6) {
                this.node.setShape(9);
            } else if (index == 7) {
                this.node.setShape(10);
            }
        } else if (source == this.shadow) {
            this.node.getDrawable().setShadowOn(this.shadow.isSelected());
        } else if (source == this.closeButton) {
            this.node.getDrawable().getPen().removePropertyChangeListener(this);
            this.node.getDrawable().getBrush().removePropertyChangeListener(this);
            this.dispose();
        } else if (source == this.portSpot) {
            this.node.setForceFixedAngleConnectionPorts(this.portSpot.isSelected());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.node.getDrawable().getBrush() || e.getSource() == this.node.getDrawable().getPen()) {
            this.view.repaint();
        }
    }
}

