/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDFlowChartShapes;
import com.sas.graphics.components.pfd.PFDLabeledNodeInterface;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPolygon;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;

public class PFDShapeNode
extends PFDAbstractNode
implements PFDLabeledNodeInterface,
PFDDirectionalNodeInterface {
    public static final String RB_KEY = "PFDShapeNode.";
    public static final String EAST = "east";
    public static final String WEST = "west";
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    private PFDDrawablePrimitive drawable = null;
    private PFDText label = null;
    private Vector ports = new Vector();
    private int shape = 2;
    private int labelPosition = 0;
    private String text;
    private Point location;
    private Dimension size;
    private boolean gradientColor = false;
    private boolean showPorts = true;
    private boolean fixedAnglePorts = true;
    private PFDPort eastPort;
    private PFDPort westPort;
    private PFDPort northPort;
    private PFDPort southPort;
    private PFDPort inputPort;
    private PFDPort outputPort;
    private String flowDirection = "Right";

    public PFDShapeNode() {
        this(new Point(0, 0), new Dimension(0, 0), null);
    }

    public PFDShapeNode(Point loc, Dimension size, String s) {
        this(loc, size, 2, s);
    }

    public PFDShapeNode(Point loc, Dimension size, int shape, String s) {
        this.checkShape(shape);
        this.setBreakable(false);
        this.location = loc;
        this.size = size;
        this.shape = shape;
        this.text = s;
        this.initialize();
    }

    public PFDDrawablePrimitive getDrawable() {
        return this.drawable;
    }

    public boolean isGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(boolean b) {
        String hctString = System.getProperty("HIGH_CONTRAST_TESTING");
        this.gradientColor = hctString != null ? false : b;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        if (this.shape == shape) {
            return;
        }
        this.checkShape(shape);
        this.shape = shape;
        this.removePrimitive(this.drawable);
        this.createDrawable();
        this.addPrimitive(0, this.drawable);
        this.layoutChildren();
    }

    private void checkShape(int shape) {
        switch (shape) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "shape.ex.txt"));
            }
        }
    }

    public PFDText getLabel() {
        return this.label;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.showPorts;
    }

    @Override
    public void setForceShowPorts(boolean b) {
        if (this.showPorts == b) {
            return;
        }
        this.showPorts = b;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            p.setVisible(this.showPorts);
        }
    }

    public boolean isForceFixedAngleConnectionPorts() {
        return this.fixedAnglePorts;
    }

    public void setForceFixedAngleConnectionPorts(boolean b) {
        if (this.fixedAnglePorts == b) {
            return;
        }
        this.fixedAnglePorts = b;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (this.fixedAnglePorts) {
                p.setFromLinkSpot(0);
                p.setToLinkSpot(0);
                continue;
            }
            p.setFromLinkSpot(9);
            p.setToLinkSpot(9);
            p.setFreeSpotOffsetX(3);
            p.setFreeSpotOffsetY(3);
        }
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(int position) {
        if (this.labelPosition == position) {
            return;
        }
        this.checkLabelPosition(position);
        this.labelPosition = position;
        this.layoutChildren();
    }

    private void checkLabelPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "label.ex.txt"));
            }
        }
    }

    protected void initialize() {
        this.createDrawable();
        this.label = new PFDText(this.text);
        this.eastPort = new PFDPort();
        this.eastPort.setName(EAST);
        this.eastPort.setType(0);
        this.eastPort.setFromLinkDirection(0.0);
        this.eastPort.setToLinkDirection(Math.PI);
        this.ports.addElement(this.eastPort);
        this.westPort = new PFDPort();
        this.westPort.setName(WEST);
        this.westPort.setType(0);
        this.westPort.setFromLinkDirection(Math.PI);
        this.westPort.setToLinkDirection(0.0);
        this.ports.addElement(this.westPort);
        this.northPort = new PFDPort();
        this.northPort.setName(NORTH);
        this.northPort.setType(0);
        this.northPort.setFromLinkDirection(1.5707963267948966);
        this.northPort.setToLinkDirection(4.71238898038469);
        this.ports.addElement(this.northPort);
        this.southPort = new PFDPort();
        this.southPort.setName(SOUTH);
        this.southPort.setType(0);
        this.southPort.setFromLinkDirection(4.71238898038469);
        this.southPort.setToLinkDirection(1.5707963267948966);
        this.ports.addElement(this.southPort);
        this.addPrimitive(this.drawable);
        this.addPrimitive(this.label);
        this.addPrimitive(this.eastPort);
        this.addPrimitive(this.westPort);
        this.addPrimitive(this.northPort);
        this.addPrimitive(this.southPort);
        this.layoutChildren();
        this.inputPort = this.westPort;
        this.outputPort = this.eastPort;
    }

    protected void createDrawable() {
        PFDBrush brush = null;
        PFDPen pen = null;
        if (this.drawable != null) {
            brush = this.drawable.getBrush();
            pen = this.drawable.getPen();
            this.location = this.drawable.getLocation();
            this.size = this.drawable.getSize();
        }
        switch (this.shape) {
            default: {
                this.drawable = new PFDRectangle();
                break;
            }
            case 3: {
                this.drawable = new PFDRoundRectangle();
                break;
            }
            case 5: {
                this.drawable = new PFDEllipse();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.drawable = new PFDPolygon();
            }
        }
        this.drawable.setBBox(this.location, this.size);
        if (brush != null) {
            this.drawable.setBrush(brush);
        }
        if (pen != null) {
            this.drawable.setPen(pen);
        }
    }

    protected void layoutChildren() {
        switch (this.shape) {
            default: {
                break;
            }
            case 6: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createDiamond(new Rectangle(this.location, this.size)));
                break;
            }
            case 7: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createHexagon(new Rectangle(this.location, this.size)));
                break;
            }
            case 8: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createParallelogram(new Rectangle(this.location, this.size)));
                break;
            }
            case 9: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createRightPentagon(new Rectangle(this.location, this.size)));
                break;
            }
            case 10: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createOctagon(new Rectangle(this.location, this.size)));
            }
        }
        Point p = new Point();
        Rectangle r = this.drawable.getRBBox();
        switch (this.labelPosition) {
            default: {
                this.drawable.getSpotLocation(0, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                this.label.setClipHeight(r.height);
                break;
            }
            case 1: {
                this.drawable.getSpotLocation(2, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(2);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 2: {
                this.drawable.getSpotLocation(6, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(1);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 3: {
                this.drawable.getSpotLocation(8, p);
                this.label.setHorizontalAlignment(2);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 4: {
                this.drawable.getSpotLocation(4, p);
                this.label.setHorizontalAlignment(1);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
            }
        }
        PFDPort eastPort = this.getPort(EAST);
        PFDPort westPort = this.getPort(WEST);
        PFDPort northPort = this.getPort(NORTH);
        PFDPort southPort = this.getPort(SOUTH);
        switch (this.shape) {
            default: {
                this.drawable.getSpotLocation(8, p);
                westPort.setBBox(p.x, p.y, 0, 0);
                this.drawable.getSpotLocation(4, p);
                eastPort.setBBox(p.x, p.y, 0, 0);
                break;
            }
            case 8: {
                westPort.setBBox(r.x + r.width / 8, r.y + r.height / 2, 0, 0);
                eastPort.setBBox(r.x + 7 * r.width / 8, r.y + r.height / 2, 0, 0);
            }
        }
        this.drawable.getSpotLocation(2, p);
        northPort.setBBox(p.x, p.y, 0, 0);
        this.drawable.getSpotLocation(6, p);
        southPort.setBBox(p.x, p.y, 0, 0);
        eastPort.setToLinkSpot(0);
        eastPort.setFromLinkSpot(0);
        westPort.setToLinkSpot(0);
        westPort.setFromLinkSpot(0);
        northPort.setToLinkSpot(0);
        northPort.setFromLinkSpot(0);
        southPort.setToLinkSpot(0);
        southPort.setFromLinkSpot(0);
        this.calculateBBox();
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        Rectangle r = this.drawable.getRBBox();
        PFDBrush brush = this.drawable.getBrush();
        if (this.gradientColor) {
            GradientPaint gp = new GradientPaint(new Point(r.x, r.y + r.height / 2), new Color(102, 153, 204), new Point(r.x + r.width, r.y + r.height / 2), Color.white, true);
            brush.setStyle(1);
            brush.paint = gp;
        }
        super.render(g2d, v);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDShapeNode clone = new PFDShapeNode(this.drawable.getLocation(), this.drawable.getSize(), this.text);
        super.copyObject(clone);
        clone.setShape(this.getShape());
        clone.setLabelPosition(this.getLabelPosition());
        clone.setFlowDirection(this.getFlowDirection());
        clone.setForceShowPorts(this.isForceShowPorts());
        clone.setForceFixedAngleConnectionPorts(this.isForceFixedAngleConnectionPorts());
        clone.setGradientColor(this.isGradientColor());
        this.drawable.copyObject(clone.getDrawable());
        this.label.copyObject(clone.getLabel());
        table.put(this, clone);
        table.put(this.drawable, clone.drawable);
        table.put(this.label, clone.label);
        for (int i = 0; i < this.ports.size(); ++i) {
            table.put(this.ports.elementAt(i), clone.ports.elementAt(i));
        }
        return clone;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        Rectangle r = this.getRBBox();
        if (r.x == x && r.y == y && r.width == w && r.height == h) {
            return;
        }
        this.location = this.drawable.getLocation();
        this.size = this.drawable.getSize();
        x = Math.max(0, x);
        y = Math.max(0, y);
        Dimension labelSize = this.label != null ? this.label.getSize() : new Dimension(0, 0);
        if (w < labelSize.width && !this.label.isMultiline()) {
            return;
        }
        if (h < labelSize.height) {
            return;
        }
        this.location.x += x - r.x;
        this.location.y += y - r.y;
        this.size.width += w - r.width;
        this.size.height += h - r.height;
        this.drawable.setBBox(this.location, this.size);
        this.layoutChildren();
        this.firePropertyChange("bbox");
    }

    public PFDPort getPort(int i) {
        return (PFDPort)this.ports.elementAt(i);
    }

    @Override
    public PFDPort getPort(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort port = this.getPort(i);
            if (!name.equals(port.getName())) continue;
            return port;
        }
        return null;
    }

    private void checkPortName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
        }
        if (name.equals(EAST) || name.equals(WEST) || name.equals(NORTH) || name.equals(SOUTH)) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public PFDPort getInputPort() {
        return this.inputPort;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.outputPort;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        this.checkFlowDirection(direction);
        if (this.flowDirection.equals(direction)) {
            return;
        }
        this.flowDirection = direction;
        int numIns = 0;
        if (this.inputPort != null) {
            numIns = this.inputPort.getNumLinks();
        }
        int numOuts = 0;
        if (this.outputPort != null) {
            numOuts = this.outputPort.getNumLinks();
        }
        Object[] inLinks = new PFDLink[numIns];
        this.inputPort.links.copyInto(inLinks);
        Object[] outLinks = new PFDLink[numOuts];
        this.outputPort.links.copyInto(outLinks);
        if (this.flowDirection.equals("Right")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.westPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.eastPort);
            }
            this.inputPort = this.westPort;
            this.outputPort = this.eastPort;
        } else if (direction.equals("Left")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.eastPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.westPort);
            }
            this.inputPort = this.eastPort;
            this.outputPort = this.westPort;
        } else if (direction.equals("Up")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.southPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.northPort);
            }
            this.inputPort = this.southPort;
            this.outputPort = this.northPort;
        } else {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.northPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.southPort);
            }
            this.inputPort = this.northPort;
            this.outputPort = this.southPort;
        }
    }

    private void checkFlowDirection(String direction) {
        if (direction == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
        }
        if (direction.equals("Left") || direction.equals("Right") || direction.equals("Up") || direction.equals("Down")) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (!p.isValidToPort()) continue;
            Vector inLinks = p.getToLinks();
            for (int j = 0; j < inLinks.size(); ++j) {
                PFDLink l = (PFDLink)inLinks.elementAt(j);
                if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
                pv.addElement(l.getFromNode());
            }
        }
        return pv;
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (!p.isValidFromPort()) continue;
            Vector outLinks = p.getFromLinks();
            for (int j = 0; j < outLinks.size(); ++j) {
                PFDLink l = (PFDLink)outLinks.elementAt(j);
                if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
                cv.addElement(l.getToNode());
            }
        }
        return cv;
    }
}

