/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class PFDShape
extends PFDDrawablePrimitive {
    private static final long serialVersionUID = 7833560184774640592L;
    protected transient Shape shape;

    public PFDShape() {
    }

    public PFDShape(Point p, Dimension size) {
        super(p, size);
    }

    public PFDShape(Rectangle r) {
        super(r);
    }

    public void setShape(Shape s) {
        this.shape = s;
    }

    public Shape getShape() {
        return this.shape;
    }

    @Override
    protected void render(Graphics2D g, PFDView v) {
        if (this.shape == null) {
            return;
        }
        if (this.shadowOn) {
            this.drawShadow(g, v);
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(this.bbox.getCenterX(), this.bbox.getCenterY());
        transform.scale(this.bbox.width - 1, this.bbox.height - 1);
        Area area = new Area(this.shape);
        area.transform(transform);
        if (this.brush.getStyle() != 0) {
            this.brush.apply(g);
            g.fill(area);
        }
        if (this.pen.getStyle() != 0) {
            this.pen.apply(g);
            g.draw(area);
        }
    }

    public static Shape getTriangleShape() {
        GeneralPath triangle = new GeneralPath(0, 3);
        triangle.moveTo(0.0f, -0.5f);
        triangle.lineTo(0.5f, 0.5f);
        triangle.lineTo(-0.5f, 0.5f);
        triangle.closePath();
        return triangle;
    }

    public static Shape getDiamondShape() {
        GeneralPath diamond = new GeneralPath(0, 4);
        diamond.moveTo(0.0f, -0.5f);
        diamond.lineTo(0.5f, 0.0f);
        diamond.lineTo(0.0f, 0.5f);
        diamond.lineTo(-0.5f, 0.0f);
        diamond.closePath();
        return diamond;
    }

    public static Shape getLoop() {
        Ellipse2D.Float outerCircle = new Ellipse2D.Float(-0.4f, -0.4f, 0.8f, 0.8f);
        Ellipse2D.Float innerCircle = new Ellipse2D.Float(-0.2f, -0.2f, 0.4f, 0.4f);
        GeneralPath arrowHead = new GeneralPath(0, 3);
        arrowHead.moveTo(0.1f, 0.0f);
        arrowHead.lineTo(0.5f, 0.0f);
        arrowHead.lineTo(0.3f, 0.2f);
        arrowHead.closePath();
        GeneralPath subtractArea = new GeneralPath(0, 3);
        subtractArea.moveTo(0.0f, 0.0f);
        subtractArea.lineTo(0.5f, 0.0f);
        subtractArea.lineTo(0.5f, 0.5f);
        subtractArea.lineTo(-0.5f, 0.5f);
        subtractArea.closePath();
        Area constructArea = new Area(outerCircle);
        constructArea.subtract(new Area(innerCircle));
        constructArea.subtract(new Area(subtractArea));
        constructArea.add(new Area(arrowHead));
        return constructArea;
    }

    public static Shape getAnd() {
        Rectangle2D.Float rect = new Rectangle2D.Float(-0.5f, -0.5f, 0.5f, 1.0f);
        Ellipse2D.Float circle = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);
        Area constructArea = new Area(rect);
        constructArea.add(new Area(circle));
        return constructArea;
    }

    public static Shape getOr() {
        GeneralPath path = new GeneralPath();
        path.moveTo(-0.5f, -0.5f);
        path.quadTo(0.25f, -0.5f, 0.5f, 0.0f);
        path.quadTo(0.25f, 0.5f, -0.5f, 0.5f);
        path.quadTo(0.0f, 0.0f, -0.5f, -0.5f);
        return path;
    }
}

