/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDHandle;
import com.sas.graphics.components.pfd.PFDListInterface;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.RB;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class PFDSelectionList
implements PFDListInterface,
Transferable,
Serializable {
    public static final String RB_KEY = "PFDSelectionList.";
    public static final DataFlavor PFD_FLAVOR = new DataFlavor(PFDSelectionList.class, "pfd selection(s)");
    private Vector primitives = new Vector();
    private Vector handles = new Vector();
    private DataFlavor[] supportedFlavors = new DataFlavor[]{PFD_FLAVOR};
    public static final int SELECTION_FILL_NONE = 0;
    public static final int SELECTION_FILL_GLASS = 1;
    int selectionFillStyle = 0;
    static final Color defaultGlassColor = new Color(100, 100, 255, 64);
    Color selectionGlassColor = defaultGlassColor;
    static final Color defaultHandleColor = new Color(255, 204, 102);
    Color selectionHandleColor = defaultHandleColor;
    int selectionHandleSize = 7;

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.supportedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.supportedFlavors[0]);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public int getSelectionFillStyle() {
        return this.selectionFillStyle;
    }

    public void setSelectionFillStyle(int style) {
        this.checkFillStyle(style);
        this.selectionFillStyle = style;
    }

    private void checkFillStyle(int style) {
        switch (style) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "fill.ex.txt"));
            }
        }
    }

    public Color getSelectionHandleColor() {
        return this.selectionHandleColor;
    }

    public void setSelectionHandleColor(Color c) {
        this.selectionHandleColor = c;
    }

    public Color getSelectionGlassColor() {
        return this.selectionGlassColor;
    }

    public void setSelectionGlassColor(Color c) {
        this.selectionGlassColor = c;
    }

    public int getSelectionHandleSize() {
        return this.selectionHandleSize;
    }

    public void setSelectionHandleSize(int size) {
        this.selectionHandleSize = size;
    }

    @Override
    public int getNumPrimitives() {
        return this.primitives.size();
    }

    @Override
    public boolean hasNoPrimitives() {
        return this.primitives.isEmpty();
    }

    @Override
    public boolean containsPrimitive(PFDPrimitive p) {
        if (this.primitives.contains(p)) {
            return true;
        }
        for (int i = 0; i < this.primitives.size(); ++i) {
            PFDGroup g;
            PFDPrimitive pr = this.getPrimitive(i);
            if (!(pr instanceof PFDGroup) || !(g = (PFDGroup)pr).isChild(p)) continue;
            return true;
        }
        return false;
    }

    public boolean hasComponentPrimitives() {
        for (int i = 0; i < this.primitives.size(); ++i) {
            PFDGroup g;
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDComponentPrimitive) {
                return true;
            }
            if (!(p instanceof PFDGroup) || !(g = (PFDGroup)p).hasComponentPrimitives()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addPrimitive(PFDPrimitive p) {
        this.primitives.addElement(p);
        PFDHandle h = new PFDHandle(p);
        h.setFillStyle(this.selectionFillStyle);
        h.setHandleColor(this.selectionHandleColor);
        h.setGlassColor(this.selectionGlassColor);
        h.setHandleSize(this.selectionHandleSize);
        this.handles.addElement(h);
        return true;
    }

    @Override
    public void addPrimitive(int index, PFDPrimitive p) {
        this.primitives.insertElementAt(p, index);
        PFDHandle h = new PFDHandle(p);
        h.setFillStyle(this.selectionFillStyle);
        h.setHandleColor(this.selectionHandleColor);
        h.setGlassColor(this.selectionGlassColor);
        h.setHandleSize(this.selectionHandleSize);
        this.handles.insertElementAt(h, index);
    }

    @Override
    public boolean removePrimitive(PFDPrimitive p) {
        int index = this.primitives.indexOf(p);
        if (index < 0) {
            return false;
        }
        this.primitives.removeElementAt(index);
        this.handles.removeElementAt(index);
        return true;
    }

    @Override
    public PFDPrimitive removePrimitive(int index) {
        PFDPrimitive p = (PFDPrimitive)this.primitives.elementAt(index);
        this.primitives.removeElementAt(index);
        this.handles.removeElementAt(index);
        return p;
    }

    @Override
    public void removeAllPrimitives() {
        this.primitives.removeAllElements();
        this.handles.removeAllElements();
    }

    @Override
    public PFDPrimitive getPrimitive(int index) {
        PFDPrimitive p = (PFDPrimitive)this.primitives.elementAt(index);
        return p;
    }

    public PFDPrimitive getLastPrimitive() {
        if (this.hasNoPrimitives()) {
            return null;
        }
        return (PFDPrimitive)this.primitives.lastElement();
    }

    @Override
    public PFDPrimitive setPrimitive(int index, PFDPrimitive p) {
        PFDPrimitive oldP = (PFDPrimitive)this.primitives.elementAt(index);
        this.primitives.setElementAt(p, index);
        PFDHandle h = new PFDHandle(p);
        h.setFillStyle(this.selectionFillStyle);
        h.setHandleColor(this.selectionHandleColor);
        h.setGlassColor(this.selectionGlassColor);
        h.setHandleSize(this.selectionHandleSize);
        this.handles.setElementAt(h, index);
        return oldP;
    }

    @Override
    public int indexOfPrimitive(PFDPrimitive p) {
        return this.primitives.indexOf(p);
    }

    public PFDHandle getHandleFor(PFDPrimitive p) {
        int index = this.primitives.indexOf(p);
        return (PFDHandle)this.handles.elementAt(index);
    }

    public void setPrimitiveHandle(PFDPrimitive p, PFDHandle h) {
        int index = this.indexOfPrimitive(p);
        this.handles.setElementAt(h, index);
    }

    public Enumeration getAllPrimitives() {
        Vector temp = new Vector();
        temp.addAll(this.primitives);
        return temp.elements();
    }

    public List getPrimitives() {
        Vector temp = new Vector();
        temp.addAll(this.primitives);
        return temp;
    }

    public Rectangle getBBox() {
        if (this.hasNoPrimitives()) {
            return null;
        }
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymin = Integer.MAX_VALUE;
        int ymax = Integer.MIN_VALUE;
        for (int i = 0; i < this.primitives.size(); ++i) {
            PFDPrimitive p = this.getPrimitive(i);
            Rectangle r = p.getRBBox();
            xmin = Math.min(xmin, r.x);
            ymin = Math.min(ymin, r.y);
            xmax = Math.max(xmax, r.x + r.width);
            ymax = Math.max(ymax, r.y + r.height);
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public PFDSelectionList duplicate() {
        PFDSelectionList newList = new PFDSelectionList();
        for (int i = 0; i < this.primitives.size(); ++i) {
            PFDPrimitive p = this.getPrimitive(i);
            newList.addPrimitive(p);
        }
        return newList;
    }
}

