/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompoundRectangle;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PFDSASNode
extends PFDAbstractNode {
    protected PFDCompoundRectangle drawable = null;
    public static final int NODE_SIZE_LARGE = 0;
    public static final int NODE_SIZE_SMALL = 1;
    private static final int nodeIconSizeLarge = 24;
    private static final int nodeIconSizeSmall = 16;
    private static final int messageIconSizeLarge = 16;
    private static final int messageIconSizeSmall = 12;
    private static final int arcRadius = 4;
    public static final int largeWidth = 150;
    public static final int largeMinHeight = 59;
    public static final int largeMaxHeight = 85;
    private static final int largeTitlebarHeight = 23;
    private static final int largeTitleWidth = 119;
    private static final int largeTitleWidthNoIcon = 138;
    private static final int largeTitleHeight = 14;
    private static final int largeTitlePosX = 6;
    private static final int largeTitlePosY = 4;
    private static final int largeMessageImagePosX = 130;
    private static final int largeMessageImagePosY = 4;
    private static final int largeNodeImagePosLeftX = 6;
    private static final int largeNodeImagePosRightX = 120;
    private static final int largeNodeImagePosY = 29;
    private static final int largeContentWidth = 109;
    private static final int largeContentHeight = 52;
    private static final int largeContentPosLeftX = 6;
    private static final int largeContentPosRightX = 35;
    private static final int largeContentPosY = 27;
    public static final int smallWidth = 120;
    public static final int smallMinHeight = 45;
    public static final int smallMaxHeight = 75;
    private static final int smallTitleWidth = 95;
    private static final int smallTitleWidthNoIcon = 110;
    private static final int smallTitleHeight = 12;
    private static final int smallTitlebarHeight = 19;
    private static final int smallTitlePosX = 5;
    private static final int smallTitlePosY = 3;
    private static final int smallMessageImagePosX = 105;
    private static final int smallMessageImagePosY = 4;
    private static final int smallNodeImagePosLeftX = 5;
    private static final int smallNodeImagePosRightX = 99;
    private static final int smallNodeImagePosY = 24;
    private static final int smallContentWidth = 90;
    private static final int smallContentHeight = 48;
    private static final int smallContentPosLeftX = 5;
    private static final int smallContentPosRightX = 25;
    private static final int smallContentPosYTop = 22;
    private static final int smallContentPosYCenter = 25;
    protected int nodeSize;
    protected Point location;
    protected Dimension size;
    protected int titlebarHeight;
    private String fontName = "SansSerif";
    private Color fontColor = Color.BLACK;
    private int largeFontSize = 11;
    private int smallFontSize = 10;
    protected Color titleAreaColor = Color.WHITE;
    protected Color contentAreaColor = Color.WHITE;
    protected Color borderColor = Color.BLACK;
    protected Color seperatorColor = Color.BLACK;
    protected PFDPen selectionPen = null;
    protected Color selectionColor = new Color(255, 204, 0);
    protected int selectionLineWidth = 2;
    protected PFDPen focusPen = null;
    protected Color focusColor = Color.BLACK;
    protected PFDPort port = null;
    protected PFDText titleText = null;
    protected PFDText contentText = null;
    protected ImageIcon largeNodeIcon = null;
    protected ImageIcon smallNodeIcon = null;
    protected PFDImage nodeImage = null;
    protected boolean nodeIconVisible = true;
    protected int nodeIconPosition = 3;
    protected ImageIcon largeMessageIcon = null;
    protected ImageIcon smallMessageIcon = null;
    protected PFDImage messageImage = null;
    protected boolean messageIconVisible = true;

    public PFDSASNode(Point loc, int size, String title, String content) {
        this.location = loc;
        this.nodeSize = size;
        this.titleText = new PFDText(title);
        this.contentText = new PFDText(content);
        this.initialize();
    }

    public PFDSASNode() {
        this(new Point(0, 0), 0, null, null);
    }

    protected void initialize() {
        this.setBreakable(false);
        this.titleText.setSelectable(false);
        this.contentText.setSelectable(false);
        this.selectionPen = new PFDPen();
        this.selectionPen.setColor(this.selectionColor);
        this.selectionPen.setLineWidth(this.selectionLineWidth);
        this.setCustomSelection(true);
        this.focusPen = new PFDPen();
        this.focusPen.setColor(this.focusColor);
        this.focusPen.setStyle(2);
        this.initNodeSize();
        this.createDrawable();
        this.titleText.setFontName(this.fontName);
        this.contentText.setFontName(this.fontName);
        this.titleText.getPen().setColor(this.fontColor);
        this.contentText.getPen().setColor(this.fontColor);
        this.port = new PFDPort();
        this.port.setName("port");
        this.port.setFromLinkSpot(9);
        this.port.setToLinkSpot(9);
        this.port.setValidFromPort(true);
        this.port.setValidToPort(true);
        this.port.setType(0);
        this.addPrimitive(this.drawable);
        this.addPrimitive(this.port);
        this.addPrimitive(this.titleText);
        this.addPrimitive(this.contentText);
        this.layoutChildren();
    }

    protected void createDrawable() {
        this.drawable = new PFDCompoundRectangle(this.location, new Dimension(this.size.width - 1, this.size.height - 1));
        this.drawable.setArcWidth(4);
        this.drawable.setArcHeight(4);
        this.drawable.setTopHeight(this.titlebarHeight);
        this.drawable.getBrush().setColor(this.contentAreaColor);
        this.drawable.getPen().setColor(this.borderColor);
        this.drawable.getTopBrush().setColor(this.titleAreaColor);
        this.drawable.getTopPen().setColor(this.seperatorColor);
    }

    protected void layoutChildren() {
        int wrapWidth;
        Point p = this.drawable.getSpotLocation(1, null);
        this.titleText.setHorizontalAlignment(1);
        this.titleText.setVerticalAlignment(1);
        this.titleText.setMultiline(false);
        this.titleText.setClipping(true);
        this.contentText.setHorizontalAlignment(1);
        this.contentText.setVerticalAlignment(1);
        this.contentText.setMultiline(true);
        this.contentText.setClipping(true);
        if (this.nodeSize == 0) {
            if (this.nodeImage != null) {
                if (this.nodeIconPosition == 3) {
                    this.nodeImage.setBBox(p.x + 6, p.y + 29, 24, 24);
                } else {
                    this.nodeImage.setBBox(p.x + 120, p.y + 29, 24, 24);
                }
            }
            if (this.messageImage != null) {
                this.messageImage.setBBox(p.x + 130, p.y + 4, 16, 16);
            }
            this.titleText.setFontSize(this.largeFontSize);
            this.titleText.setLocation(p.x + 6, p.y + 4);
            wrapWidth = 119;
            if (this.largeMessageIcon == null || !this.messageIconVisible) {
                wrapWidth = 138;
            }
            this.titleText.setWrapWidth(wrapWidth);
            this.titleText.setClipHeight(14);
            this.titleText.forceUpdate();
            if (this.nodeIconPosition == 3) {
                this.contentText.setLocation(p.x + 35, p.y + 27);
            } else {
                this.contentText.setLocation(p.x + 6, p.y + 27);
            }
            this.contentText.setFontSize(this.largeFontSize);
            this.contentText.setWrapWidth(109);
            this.contentText.setClipHeight(52);
            this.contentText.forceUpdate();
        } else {
            if (this.nodeImage != null) {
                if (this.nodeIconPosition == 3) {
                    this.nodeImage.setBBox(p.x + 5, p.y + 24, 16, 16);
                } else {
                    this.nodeImage.setBBox(p.x + 99, p.y + 24, 16, 16);
                }
            }
            if (this.messageImage != null) {
                this.messageImage.setBBox(p.x + 105, p.y + 4, 12, 12);
            }
            this.titleText.setFontSize(this.smallFontSize);
            this.titleText.setLocation(p.x + 5, p.y + 3);
            wrapWidth = 95;
            if (this.smallMessageIcon == null || !this.messageIconVisible) {
                wrapWidth = 110;
            }
            this.titleText.setWrapWidth(wrapWidth);
            this.titleText.setClipHeight(12);
            this.titleText.forceUpdate();
            this.contentText.setFontSize(this.smallFontSize);
            this.contentText.setWrapWidth(90);
            this.contentText.setClipHeight(48);
            this.contentText.forceUpdate();
            int textXPos = 0;
            int textYPos = 0;
            textXPos = this.nodeIconPosition == 3 ? p.x + 25 : p.x + 5;
            textYPos = this.contentText.getNumLines() <= 1 ? p.y + 25 : p.y + 22;
            this.contentText.setLocation(textXPos, textYPos);
        }
        this.computeNodeSize();
        Rectangle r = this.drawable.getRBBox();
        this.drawable.getSpotLocation(0, p);
        this.port.setBBox(p.x, p.y, 0, 0);
        this.port.setFreeSpotBox(true);
        this.port.setFreeSpotOffsetX(r.width / 2 + 1);
        this.port.setFreeSpotOffsetY(r.height / 2 + 1);
        this.port.setSnapBox(true);
        this.port.setSnapXDistance(r.width / 2);
        this.port.setSnapYDistance(r.height / 2);
        this.port.setCustomPortArea(new Rectangle(-r.width / 2, -r.height / 2 + this.titlebarHeight, r.width, r.height - this.titlebarHeight));
        this.calculateBBox();
    }

    protected void initNodeSize() {
        if (this.nodeSize == 0) {
            this.size = new Dimension(150, 59);
            this.titlebarHeight = 23;
        } else if (this.nodeSize == 1) {
            this.size = new Dimension(120, 45);
            this.titlebarHeight = 19;
        }
    }

    protected void computeNodeSize() {
        Rectangle rect = null;
        if (this.drawable != null && this.contentText != null && (rect = this.contentText.getRBBox()) != null) {
            int newHeight;
            if (this.nodeSize == 0) {
                newHeight = Math.min(Math.max(59, rect.height + 33), 85);
            } else if (this.nodeSize == 1) {
                newHeight = Math.min(Math.max(45, rect.height + 27), 75);
            } else {
                return;
            }
            Rectangle bounds = this.drawable.getRBBox();
            this.drawable.setBBox(bounds.x, bounds.y, bounds.width, newHeight - 1);
        }
    }

    public boolean setNodeSize(int s) {
        if (s != 0 && s != 1) {
            return false;
        }
        this.nodeSize = s;
        this.initNodeSize();
        this.drawable.setSize(this.size);
        this.drawable.setTopHeight(this.titlebarHeight);
        this.setImages(s);
        this.layoutChildren();
        this.firePropertyChange("nodeSize");
        return true;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public void setTitleAreaColor(Color c) {
        if (c == null) {
            return;
        }
        this.titleAreaColor = c;
        this.drawable.getTopBrush().setColor(c);
    }

    public Color getTitleAreaColor() {
        return this.titleAreaColor;
    }

    public void setContentAreaColor(Color c) {
        if (c == null) {
            return;
        }
        this.contentAreaColor = c;
        this.drawable.getBrush().setColor(c);
    }

    public Color getContentAreaColor() {
        return this.contentAreaColor;
    }

    public void setBorderColor(Color c) {
        if (c == null) {
            return;
        }
        this.borderColor = c;
        this.drawable.getPen().setColor(c);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setSeperatorColor(Color c) {
        if (c == null) {
            return;
        }
        this.seperatorColor = c;
        this.drawable.getTopPen().setColor(c);
    }

    public Color getSeperatorColor() {
        return this.seperatorColor;
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public PFDPort getInputPort() {
        return this.port;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.port;
    }

    @Override
    public boolean isForceShowPorts() {
        return false;
    }

    @Override
    public void setForceShowPorts(boolean visible) {
    }

    @Override
    public PFDPort getPort(String name) {
        return null;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        Vector outLinks = this.port.getFromLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        Vector inLinks = this.port.getToLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        this.render(g2d, v);
        Rectangle bounds = this.drawable.getRBBox();
        this.selectionPen.apply(g2d);
        g2d.drawRoundRect(bounds.x - 3, bounds.y - 3, bounds.width + 5, bounds.height + 5, 7, 7);
    }

    @Override
    protected Rectangle getCustomSelectionBBox() {
        Rectangle bounds = this.drawable.getBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        bounds.x -= 3 + halfStrokeWidth;
        bounds.y -= 3 + halfStrokeWidth;
        bounds.width += 6 + halfStrokeWidth * 2;
        bounds.height += 6 + halfStrokeWidth * 2;
        return bounds;
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.render(g2d, v);
        Rectangle bounds = this.drawable.getRBBox();
        this.selectionPen.apply(g2d);
        g2d.drawRoundRect(bounds.x - 3, bounds.y - 3, bounds.width + 5, bounds.height + 5, 7, 7);
        this.focusPen.apply(g2d);
        g2d.drawRect(bounds.x + 3, bounds.y + this.titlebarHeight + 3, bounds.width - 7, bounds.height - this.titlebarHeight - 7);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.drawable.renderOverview(g2d, v);
    }

    protected void setImages(int size) {
        if (size == 0) {
            if (this.largeNodeIcon == null) {
                if (this.nodeImage != null) {
                    this.removePrimitive(this.nodeImage);
                    this.nodeImage = null;
                }
            } else if (this.nodeImage == null) {
                this.nodeImage = new PFDImage(this.largeNodeIcon.getImage());
                this.nodeImage.setVisible(this.nodeIconVisible);
                this.addPrimitive(this.nodeImage);
            } else {
                this.nodeImage.setImage(this.largeNodeIcon.getImage());
            }
            if (this.largeMessageIcon == null) {
                if (this.messageImage != null) {
                    this.removePrimitive(this.messageImage);
                    this.messageImage = null;
                }
            } else if (this.messageImage == null) {
                this.messageImage = new PFDImage(this.largeMessageIcon.getImage());
                this.messageImage.setVisible(this.messageIconVisible);
                this.addPrimitive(this.messageImage);
            } else {
                this.messageImage.setImage(this.largeMessageIcon.getImage());
            }
        } else if (size == 1) {
            if (this.smallNodeIcon == null) {
                if (this.nodeImage != null) {
                    this.removePrimitive(this.nodeImage);
                    this.nodeImage = null;
                }
            } else if (this.nodeImage == null) {
                this.nodeImage = new PFDImage(this.smallNodeIcon.getImage());
                this.nodeImage.setVisible(this.nodeIconVisible);
                this.addPrimitive(this.nodeImage);
            } else {
                this.nodeImage.setImage(this.smallNodeIcon.getImage());
            }
            if (this.smallMessageIcon == null) {
                if (this.messageImage != null) {
                    this.removePrimitive(this.messageImage);
                    this.messageImage = null;
                }
            } else if (this.messageImage == null) {
                this.messageImage = new PFDImage(this.smallMessageIcon.getImage());
                this.messageImage.setVisible(this.messageIconVisible);
                this.addPrimitive(this.messageImage);
            } else {
                this.messageImage.setImage(this.smallMessageIcon.getImage());
            }
        }
    }

    public boolean setNodeIcon(ImageIcon icon, int size) {
        if (icon == null) {
            return false;
        }
        if (size == 0) {
            if (!this.validateIconSize(icon, 24)) {
                return false;
            }
            this.largeNodeIcon = icon;
        } else if (size == 1) {
            if (!this.validateIconSize(icon, 16)) {
                return false;
            }
            this.smallNodeIcon = icon;
        } else {
            return false;
        }
        if (size == this.nodeSize) {
            if (this.nodeImage == null) {
                this.nodeImage = new PFDImage(icon.getImage());
                this.nodeImage.setVisible(this.nodeIconVisible);
                this.addPrimitive(this.nodeImage);
            } else {
                this.nodeImage.setImage(icon.getImage());
            }
        }
        this.layoutChildren();
        this.firePropertyChange("nodeIcon");
        return true;
    }

    public void setNodeIconVisible(boolean visible) {
        if (this.nodeIconVisible == visible) {
            return;
        }
        this.nodeIconVisible = visible;
        if (this.nodeImage != null) {
            this.nodeImage.setVisible(visible);
        }
        this.layoutChildren();
    }

    public boolean isNodeIconVisible() {
        return this.nodeIconVisible;
    }

    public void setNodeIconPosition(int position) {
        if (position == 3 || position == 4) {
            this.nodeIconPosition = position;
            this.layoutChildren();
        }
    }

    public int getNodeIconPosition() {
        return this.nodeIconPosition;
    }

    public boolean setMessageIcon(ImageIcon icon, int size) {
        if (icon == null) {
            return false;
        }
        if (size == 0) {
            if (!this.validateIconSize(icon, 16)) {
                return false;
            }
            this.largeMessageIcon = icon;
        } else if (size == 1) {
            if (!this.validateIconSize(icon, 12)) {
                return false;
            }
            this.smallMessageIcon = icon;
        } else {
            return false;
        }
        if (size == this.nodeSize) {
            if (this.messageImage == null) {
                this.messageImage = new PFDImage(icon.getImage());
                this.messageImage.setVisible(this.messageIconVisible);
                this.addPrimitive(this.messageImage);
            } else {
                this.messageImage.setImage(icon.getImage());
            }
        }
        this.layoutChildren();
        this.firePropertyChange("messageIcon");
        return true;
    }

    public void setMessageIconVisible(boolean visible) {
        if (this.messageIconVisible == visible) {
            return;
        }
        this.messageIconVisible = visible;
        if (this.messageImage != null) {
            this.messageImage.setVisible(visible);
        }
        this.layoutChildren();
    }

    public boolean isMessageIconVisible() {
        return this.messageIconVisible;
    }

    private boolean validateIconSize(ImageIcon icon, int iconSize) {
        if (icon == null) {
            return false;
        }
        return icon.getIconHeight() == iconSize && icon.getIconWidth() == iconSize;
    }

    public PFDText getTitleText() {
        return this.titleText;
    }

    public PFDText getContentText() {
        return this.contentText;
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDSASNode clone = new PFDSASNode();
        table.put(this, clone);
        this.copyObject(clone);
        table.put(this.getTitleText(), clone.getTitleText());
        table.put(this.getContentText(), clone.getContentText());
        return clone;
    }

    public void copyObject(PFDSASNode toObject) {
        super.copyObject(toObject);
        toObject.setNodeSize(this.nodeSize);
        toObject.setTitleAreaColor(this.titleAreaColor);
        toObject.setContentAreaColor(this.contentAreaColor);
        toObject.setBorderColor(this.borderColor);
        toObject.setSeperatorColor(this.seperatorColor);
        toObject.setNodeIcon(this.largeNodeIcon, 0);
        toObject.setNodeIcon(this.smallNodeIcon, 1);
        toObject.setMessageIcon(this.largeMessageIcon, 0);
        toObject.setMessageIcon(this.smallMessageIcon, 1);
        toObject.setNodeIconVisible(this.nodeIconVisible);
        toObject.setMessageIconVisible(this.messageIconVisible);
        toObject.setNodeIconPosition(this.nodeIconPosition);
        this.titleText.copyObject(toObject.getTitleText());
        this.contentText.copyObject(toObject.getContentText());
        toObject.setCenterLocation(this.getCenterLocation());
        toObject.layoutChildren();
    }
}

