/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDClonable;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDHoldChangeUpdateInterface;
import com.sas.graphics.components.pfd.PFDLayer;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPropertyChangeCache;
import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDActionInterface;
import com.sas.graphics.components.pfd.interfaces.PFDGroupElementInterface;
import com.sas.graphics.components.pfd.interfaces.PFDPopupMenuInterface;
import com.sas.graphics.components.pfd.interfaces.PFDUniqueItemInterface;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;

public abstract class PFDPrimitive
implements PFDHoldChangeUpdateInterface,
Serializable,
PFDClonable,
MouseInputListener,
PFDPopupMenuInterface,
PFDActionInterface,
PFDGroupElementInterface,
PFDUniqueItemInterface {
    public static final String RB_KEY = "PFDPrimitive.";
    public static final int CENTER = 0;
    public static final int TOP_LEFT = 1;
    public static final int TOP_CENTER = 2;
    public static final int TOP_RIGHT = 3;
    public static final int RIGHT_CENTER = 4;
    public static final int BOTTOM_RIGHT = 5;
    public static final int BOTTOM_CENTER = 6;
    public static final int BOTTOM_LEFT = 7;
    public static final int LEFT_CENTER = 8;
    public static final int FREE_SPOT = 9;
    public static final int SNAP_SPOT = 10;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    protected String id = null;
    protected String name = null;
    protected String toolTipText = null;
    protected transient PFDModel model = null;
    protected transient PFDLayer layer = null;
    protected PFDGroup group = null;
    protected Rectangle bbox = null;
    protected Rectangle visualBBox = null;
    protected Rectangle oldVisualBBox = null;
    PFDPen pen = new PFDPen();
    PFDBrush brush = new PFDBrush();
    protected PFDPen selectionPen = new PFDPen();
    protected boolean visible = true;
    protected boolean selectable = true;
    protected boolean resizable = true;
    protected boolean draggable = true;
    protected boolean enableUpdate = true;
    protected boolean customSelection = false;
    protected PFDPrimitive expanded = null;
    protected PFDPrimitive collapsed = null;
    protected boolean expandable = false;
    protected boolean collapsable = false;
    private EventListenerList eventListeners = new EventListenerList();
    protected transient PFDView theView;
    protected boolean forceRender = false;
    private transient ActionMap actionMap;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PFDPropertyChangeCache propertyChangeCache = new PFDPropertyChangeCache();
    protected PFDGroup parent = null;

    public PFDPrimitive() {
        this(new Rectangle());
    }

    public PFDPrimitive(Point p, Dimension size) {
        this(new Rectangle(p, size));
    }

    public PFDPrimitive(Rectangle r) {
        this.checkBBox(r);
        this.bbox = new Rectangle(r);
        this.visualBBox = new Rectangle(this.bbox);
        this.oldVisualBBox = new Rectangle(this.bbox);
    }

    protected void checkBBox(Rectangle r) {
        if (r == null || r.x < 0 || r.y < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "bbox.ex.txt"));
        }
    }

    public PFDPen getPen() {
        return this.pen;
    }

    public void setPen(PFDPen pen) {
        this.pen = pen;
        this.firePropertyChange("pen");
    }

    public PFDBrush getBrush() {
        return this.brush;
    }

    public void setBrush(PFDBrush brush) {
        this.brush = brush;
        this.firePropertyChange("brush");
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public PFDPrimitive getExpanded() {
        return this.expanded;
    }

    public void setExpanded(PFDPrimitive p) {
        if (p == null) {
            return;
        }
        p.setVisible(false);
        this.expanded = p;
        this.expandable = true;
        this.initExpanded();
        this.firePropertyChange("all");
    }

    protected void initExpanded() {
        PFDModel m = this.getModel();
        if (m != null && this.expandable && this.expanded != null && this.expanded.getCollapsed() != this) {
            this.expanded.setCollapsed(this);
        }
    }

    protected void setCollapsed(PFDPrimitive p) {
        if (p == null) {
            return;
        }
        this.collapsable = true;
        this.collapsed = p;
        PFDModel m = this.collapsed.getModel();
        PFDGroup g = this.collapsed.getGroup();
        if (g == null) {
            if (m != null && !m.containsPrimitive(this)) {
                m.addPrimitive(this);
            }
        } else if (m != null) {
            this.setModel(m);
        }
    }

    public void expand() {
        if (this.expandable && this.expanded != null) {
            this.setVisible(false);
            this.expanded.expandToPoint(this.bbox.x, this.bbox.y, this.getGroup());
        }
    }

    protected void expandToPoint(int x, int y, PFDGroup g) {
        this.disableChangeUpdate();
        this.setLocation(x, y);
        this.enableChangeUpdate();
        this.setVisible(true);
        if (g != null) {
            g.removePrimitive(this.collapsed);
            if (!g.containsPrimitive(this)) {
                g.addPrimitive(this);
            }
        }
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    public PFDPrimitive getCollapsed() {
        return this.collapsed;
    }

    public void collapse() {
        if (this.collapsable && this.collapsed != null) {
            this.setVisible(false);
            this.collapsed.collapseToPoint(this.bbox.x, this.bbox.y, this.getGroup());
        }
    }

    protected void collapseToPoint(int x, int y, PFDGroup g) {
        this.disableChangeUpdate();
        this.setLocation(x, y);
        this.enableChangeUpdate();
        this.setVisible(true);
        if (g != null) {
            g.removePrimitive(this.expanded);
            if (!g.containsPrimitive(this)) {
                g.addPrimitive(this);
            }
        }
    }

    protected void removeCollapsed() {
        if (this.model != null && this.collapsable && this.collapsed != null) {
            this.collapsed.expandable = false;
            this.collapsed.expanded = null;
            this.model.removePrimitive(this.collapsed);
            this.collapsable = false;
            this.collapsed = null;
        }
    }

    protected void removeExpanded() {
        if (this.model != null && this.expandable && this.expanded != null) {
            this.expanded.collapsable = false;
            this.expanded.collapsed = null;
            this.model.removePrimitive(this.expanded);
            this.expandable = false;
            this.expanded = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPFDItemId() {
        if (this.id == null || this.id.trim().length() == 0) {
            return null;
        }
        return this.id;
    }

    @Override
    public void setPFDItemId(String id) {
        this.id = id;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    public PFDGroup getGroup() {
        return this.group;
    }

    protected void setGroup(PFDGroup g) {
        this.group = g;
    }

    public PFDGroup getTopLevelGroup() {
        if (this.group != null) {
            return this.group.getTopLevelGroup();
        }
        return null;
    }

    public PFDPrimitive getTopMovePrimitive() {
        if (this.group != null && this.group.getMovesWithChildren()) {
            return this.group.getTopMovePrimitive();
        }
        return this;
    }

    public PFDLayer getLayer() {
        if (this.layer != null) {
            return this.layer;
        }
        if (this.group != null) {
            this.layer = this.group.getLayer();
            return this.layer;
        }
        return null;
    }

    protected void setLayer(PFDLayer l) {
        this.layer = l;
    }

    public PFDModel getModel() {
        if (this.model != null) {
            return this.model;
        }
        if (this.layer != null) {
            this.model = this.layer.getModel();
            return this.model;
        }
        if (this.group != null) {
            this.model = this.group.getModel();
            return this.model;
        }
        return null;
    }

    protected void setModel(PFDModel m) {
        this.model = m;
    }

    protected Rectangle getVisualBBox() {
        return new Rectangle(this.getVisualRBBox());
    }

    protected Rectangle getVisualRBBox() {
        return this.visualBBox;
    }

    protected void updateVisualBBox() {
        this.oldVisualBBox.setBounds(this.visualBBox);
        this.visualBBox.setBounds(this.bbox);
    }

    protected Rectangle getCustomSelectionBBox() {
        return this.bbox;
    }

    public Rectangle getRepaintBBox() {
        Rectangle repaintBBox = this.visualBBox.union(this.oldVisualBBox);
        this.oldVisualBBox.setBounds(this.visualBBox);
        return repaintBBox;
    }

    public Rectangle getBBox() {
        return new Rectangle(this.getRBBox());
    }

    protected Rectangle getRBBox() {
        return this.bbox;
    }

    public void setBBox(Rectangle r) {
        this.setBBox(r.x, r.y, r.width, r.height);
    }

    public void setBBox(Point p, Dimension s) {
        this.setBBox(p.x, p.y, s.width, s.height);
    }

    public void setBBox(int x, int y, int width, int height) {
        if (this.bbox.x == x && this.bbox.y == y && this.bbox.width == width && this.bbox.height == height) {
            return;
        }
        this.bbox.x = x;
        this.bbox.y = y;
        this.bbox.width = width;
        this.bbox.height = height;
        this.updateVisualBBox();
        if (this.expandable && !this.expanded.isVisible()) {
            this.expanded.disableChangeUpdate();
            this.expanded.setLocation(x, y);
            this.expanded.enableChangeUpdate();
        }
        if (this.collapsable && !this.collapsed.isVisible()) {
            this.collapsed.disableChangeUpdate();
            this.collapsed.setLocation(x, y);
            this.collapsed.enableChangeUpdate();
        }
        if (this.getModel() != null) {
            this.getModel().updateSize(this);
        }
        this.firePropertyChange("bbox");
    }

    public int getX() {
        return this.getRBBox().x;
    }

    public int getY() {
        return this.getRBBox().y;
    }

    public int getWidth() {
        return this.getRBBox().width;
    }

    public int getHeight() {
        return this.getRBBox().height;
    }

    public Point getLocation() {
        Rectangle rbbox = this.getRBBox();
        return new Point(rbbox.x, rbbox.y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.setBBox(x, y, this.bbox.width, this.bbox.height);
    }

    public Dimension getSize() {
        Rectangle rbbox = this.getRBBox();
        return new Dimension(rbbox.width, rbbox.height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        this.setBBox(this.bbox.x, this.bbox.y, width, height);
    }

    public void setPreferredSize(Dimension d) {
        this.setSize(d);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void move(int dx, int dy) {
        this.setLocation(this.bbox.x + dx, this.bbox.y + dy);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean aBoolean) {
        if (this.visible == aBoolean) {
            return;
        }
        this.visible = aBoolean;
        this.firePropertyChange("visible");
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean aBoolean) {
        if (this.selectable == aBoolean) {
            return;
        }
        this.selectable = aBoolean;
        this.firePropertyChange("selectable");
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean aBoolean) {
        if (this.resizable == aBoolean) {
            return;
        }
        this.resizable = aBoolean;
        this.firePropertyChange("resizable");
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean aBoolean) {
        if (this.draggable == aBoolean) {
            return;
        }
        this.draggable = aBoolean;
        this.firePropertyChange("draggable");
    }

    public boolean isCustomSelection() {
        return this.customSelection;
    }

    public void setCustomSelection(boolean aBoolean) {
        if (this.customSelection == aBoolean) {
            return;
        }
        this.customSelection = aBoolean;
        this.firePropertyChange("customSelection");
    }

    public void paint(Graphics2D g) {
        this.paint(g, null);
    }

    public void paint(Graphics2D g, PFDView v) {
        if (this.visible && this.isRenderNeeded(v)) {
            Rectangle pBounds = this.getVisualRBBox();
            boolean hitClip = g.hitClip(pBounds.x, pBounds.y, pBounds.width, pBounds.height);
            if (hitClip) {
                if (v == null) {
                    this._paint(g, null, false, false);
                } else {
                    this._paint(g, v, v.isSelected(this), v.isFocused(this));
                }
            }
        }
    }

    public void paint(Graphics2D g, PFDView v, boolean selected, boolean focused) {
        if (this.visible && this.isRenderNeeded(v)) {
            Rectangle pBounds = this.getVisualRBBox();
            boolean hitClip = g.hitClip(pBounds.x, pBounds.y, pBounds.width, pBounds.height);
            if (hitClip) {
                this._paint(g, v, selected, focused);
            }
        }
    }

    private void _paint(Graphics2D g, PFDView v, boolean selected, boolean focused) {
        if (this.customSelection && selected) {
            if (focused) {
                this.renderFocused(g, v);
            } else {
                this.renderSelected(g, v);
            }
        } else {
            this.render(g, v);
        }
    }

    protected abstract void render(Graphics2D var1, PFDView var2);

    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        if (this.brush.getStyle() != 0) {
            g2d.setColor(this.brush.getColor());
            g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        }
        if (this.pen.getStyle() != 0) {
            g2d.setColor(this.pen.getColor());
            g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
        }
    }

    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
    }

    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
    }

    protected synchronized void renderGhosted(Graphics2D g2d, PFDView v, boolean selected, boolean focused) {
    }

    protected synchronized void renderGhostedElements(Graphics2D g2d, PFDView v, boolean selected, boolean focused) {
    }

    protected synchronized void renderNonGhostedElements(Graphics2D g2d, PFDView v, boolean selected, boolean focused) {
    }

    public Point getSpotLocation(int spot, Point p) {
        return PFDPrimitive.getSpotLocation(this.getRBBox(), spot, p);
    }

    protected static Point getSpotLocation(Rectangle bounds, int spot, Point p) {
        PFDPrimitive.checkSpot(spot);
        if (p == null) {
            p = new Point();
        }
        switch (spot) {
            default: {
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y + bounds.height / 2;
                break;
            }
            case 1: 
            case 10: {
                p.x = bounds.x;
                p.y = bounds.y;
                break;
            }
            case 2: {
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y;
                break;
            }
            case 3: {
                p.x = bounds.x + bounds.width - 1;
                p.y = bounds.y;
                break;
            }
            case 4: {
                p.x = bounds.x + bounds.width - 1;
                p.y = bounds.y + bounds.height / 2;
                break;
            }
            case 5: {
                p.x = bounds.x + bounds.width - 1;
                p.y = bounds.y + bounds.height - 1;
                break;
            }
            case 6: {
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y + bounds.height - 1;
                break;
            }
            case 7: {
                p.x = bounds.x;
                p.y = bounds.y + bounds.height - 1;
                break;
            }
            case 8: {
                p.x = bounds.x;
                p.y = bounds.y + bounds.height / 2;
            }
        }
        if (bounds.width <= 0) {
            p.x = bounds.x;
        }
        if (bounds.height <= 0) {
            p.y = bounds.y;
        }
        return p;
    }

    public void setSpotLocation(int spot, Point p) {
        PFDPrimitive.checkSpot(spot);
        if (p == null) {
            return;
        }
        Point loc = this.getSpotLocation(spot, null);
        this.move(p.x - loc.x, p.y - loc.y);
    }

    protected static void checkSpot(int spot) {
        switch (spot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "spot.ex.txt"));
            }
        }
    }

    public Point getLayoutLocation(int spot, Point p) {
        return this.getSpotLocation(spot, p);
    }

    public void setLayoutLocation(int spot, Point p) {
        this.setSpotLocation(spot, p);
    }

    public boolean contains(int x, int y) {
        return this.bbox.contains(x, y);
    }

    public boolean intersects(int x, int y, int width, int height) {
        return this.bbox.intersects(new Rectangle(x, y, width, height));
    }

    @Override
    public void disableChangeUpdate() {
        this.enableUpdate = false;
    }

    @Override
    public void enableChangeUpdate() {
        if (this.enableUpdate) {
            return;
        }
        this.enableUpdate = true;
        if (!this.propertyChangeCache.isEmpty()) {
            this.firePropertyChange("enableUpdate");
            this.propertyChangeCache.clearProperties();
        }
    }

    protected void build(PFDView v) {
        this.update("all", v);
    }

    protected void update(String property, PFDView v) {
        if (property.equals("enableUpdate")) {
            this.update(this.propertyChangeCache, v);
        } else if (property.equals("all")) {
            this.initExpanded();
            this.updateStyle();
            this.attachView(v);
        } else if (property.equals("style")) {
            this.updateStyle();
        } else if (property.equals("bbox")) {
            if (this.getGroup() == null) {
                if (this.getModel() != null) {
                    this.getModel().updateSize(this);
                }
            } else {
                this.getGroup().firePropertyChange("bbox");
            }
        }
    }

    protected void update(PFDPropertyChangeCache cache, PFDView v) {
        if (cache.containsProperty("style")) {
            this.updateStyle();
        }
        if (cache.containsProperty("bbox")) {
            if (this.getGroup() == null) {
                if (this.getModel() != null) {
                    this.getModel().updateSize(this);
                }
            } else {
                this.getGroup().firePropertyChange("bbox");
            }
        }
    }

    protected void firePropertyChange(String property) {
        this.firePropertyChange(property, null, null);
    }

    protected void firePropertyChange(String property, Object oldVal, Object newVal) {
        if (!this.enableUpdate) {
            this.propertyChangeCache.addProperty(property);
            return;
        }
        PFDModel m = this.getModel();
        if (m != null) {
            m.fireModelChange(7, property, this, oldVal);
        }
        this.propertyChangeSupport.firePropertyChange(property, oldVal, newVal);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        return null;
    }

    public void copyObject(PFDPrimitive toObject) {
        toObject.setVisible(this.isVisible());
        toObject.setSelectable(this.isSelectable());
        toObject.setResizable(this.isResizable());
        toObject.setDraggable(this.isDraggable());
        toObject.setExpanded(this.getExpanded());
        toObject.setCustomSelection(this.isCustomSelection());
        toObject.setToolTipText(this.getToolTipText());
        toObject.setPFDItemId(null);
        this.pen.copyObject(toObject.getPen());
        this.brush.copyObject(toObject.getBrush());
    }

    public void setForcedLocation(int x, int y) {
        this.setForcedBBox(x, y, this.bbox.width, this.bbox.height);
    }

    public void setForcedSize(int w, int h) {
        this.setForcedBBox(this.bbox.x, this.bbox.y, w, h);
    }

    public void setForcedBBox(int x, int y, int w, int h) {
        this.setBBox(x, y, w, h);
    }

    protected void attachView(PFDView v) {
        if (v != null) {
            this.theView = v;
            if (this.actionMap != null) {
                this.actionMap.setParent(this.theView.getActionMap());
            }
        }
    }

    protected void detachView(PFDView v) {
        this.theView = null;
        if (this.actionMap != null) {
            this.actionMap.setParent(null);
        }
    }

    protected void removeAssociation() {
        this.detachView(this.theView);
    }

    protected void removeModelAssociation() {
        this.removeAssociation();
        this.removeCollapsed();
        this.removeExpanded();
        if (this.getParent() != null) {
            this.getParent().primitiveRemoved(this);
        }
    }

    public void customize(PFDView view) {
    }

    protected boolean isRenderNeeded(PFDView v) {
        if (v == null || this.forceRender) {
            return true;
        }
        boolean needed = true;
        switch (v.renderMode) {
            case 0: {
                needed = true;
                break;
            }
            case 1: {
                if (!v.isDragged(this)) break;
                needed = false;
                break;
            }
            case 2: {
                needed = v.isDragged(this) || this.getGroup() != null && this.getGroup().isRenderNeeded(v);
            }
        }
        return needed;
    }

    public PFDPrimitive pickPrimitive(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public void dispatchEvent(MouseEvent e) {
        this.dispatchEventToSelf(e);
    }

    public final void dispatchEventToSelf(MouseEvent e) {
        this.theView = (PFDView)e.getSource();
        e.setSource(this);
        switch (e.getID()) {
            case 500: {
                this.fireMouseClickedEvent(e);
                break;
            }
            case 506: {
                this.fireMouseDraggedEvent(e);
                break;
            }
            case 504: {
                this.fireMouseEnteredEvent(e);
                break;
            }
            case 505: {
                this.fireMouseExitedEvent(e);
                break;
            }
            case 503: {
                this.fireMouseMovedEvent(e);
                break;
            }
            case 501: {
                this.fireMousePressedEvent(e);
                break;
            }
            case 502: {
                this.fireMouseReleasedEvent(e);
            }
        }
        e.setSource(this.theView);
    }

    public void addMouseListener(MouseListener l) {
        this.eventListeners.add(MouseListener.class, l);
    }

    public void removeMouseListener(MouseListener l) {
        this.eventListeners.remove(MouseListener.class, l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.eventListeners.add(MouseMotionListener.class, l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.eventListeners.remove(MouseMotionListener.class, l);
    }

    private void fireMouseClickedEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mouseClicked(e);
        }
    }

    private void fireMouseEnteredEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mouseEntered(e);
        }
    }

    private void fireMouseExitedEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mouseExited(e);
        }
    }

    private void fireMousePressedEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mousePressed(e);
        }
    }

    private void fireMouseReleasedEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mouseReleased(e);
        }
    }

    private void fireMouseDraggedEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseMotionListener.class) continue;
            ((MouseMotionListener)listeners[i + 1]).mouseDragged(e);
        }
    }

    private void fireMouseMovedEvent(MouseEvent e) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseMotionListener.class) continue;
            ((MouseMotionListener)listeners[i + 1]).mouseMoved(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            int mouseMode = this.theView.getMouseExtendedMode();
            if (this.isSelectable()) {
                if (mouseMode == 4) {
                    if (!this.theView.isSelected(this)) {
                        this.theView.clearSelections();
                        this.theView.selectPrimitive(this);
                    }
                } else if (mouseMode == 2) {
                    if (this.theView.isSelected(this)) {
                        this.theView.deselectPrimitive(this);
                    } else {
                        this.theView.selectPrimitive(this);
                        if (this.theView.isEditMode() && this.isDraggable()) {
                            this.theView.setDragMode(0);
                        }
                    }
                } else {
                    if (!this.theView.isSelected(this)) {
                        this.theView.clearSelections();
                        this.theView.selectPrimitive(this);
                    }
                    if (this.theView.isEditMode() && this.isDraggable()) {
                        this.theView.setDragMode(0);
                    }
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            e.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            if (this.theView.isEditMode() && this.selectable && this.draggable) {
                this.theView.setCursor(1);
            }
            e.consume();
        }
    }

    protected void updateStyle() {
        if (this.model == null) {
            return;
        }
        Style style = this.model.getStyle();
        if (style == null) {
            return;
        }
        this.updateStyle(style);
    }

    protected void updateStyle(Style style) {
        LineStyleElement lse = style.getLineStyleElement("Selection");
        if (lse != null) {
            this.setSelectionColor(lse.getLineColor());
            this.setSelectionWidth(lse.getLineThickness().toPixels(0, 0));
        }
    }

    protected void setSelectionWidth(float width) {
        if (width == this.selectionPen.getLineWidth()) {
            return;
        }
        this.selectionPen.setLineWidth(width);
    }

    protected void setSelectionColor(Color clr) {
        if (clr == null || clr.equals(this.selectionPen.getColor())) {
            return;
        }
        this.selectionPen.setColor(clr);
    }

    public void setForceRender(boolean b) {
        this.forceRender = b;
    }

    public boolean getForceRender() {
        return this.forceRender;
    }

    public boolean canGroup() {
        return this.group == null || this.group.isBreakable();
    }

    public void bringToFront() {
        if (this.model == null) {
            return;
        }
        if (this.group != null) {
            this.group.bringToFront(this);
        } else {
            this.model.bringToFront(this);
        }
    }

    public void selectArea(PFDView v, Rectangle area) {
        if (this.isVisible() && this.isSelectable() && area.contains(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height)) {
            v.selectPrimitive(this);
        }
    }

    public void selectAll(PFDView v) {
        if (v != null && this.isSelectable()) {
            PFDSelectionList selections = v.getSelectionList();
            selections.addPrimitive(this);
            v.fireItemStateChanged(new ItemEvent(v, 701, this, 1));
        }
    }

    @Override
    public List getMenuItems() {
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        Action action = this.getAction("ACTION_CUT");
        items.add(new JMenuItem(action));
        action = this.getAction("ACTION_COPY");
        items.add(new JMenuItem(action));
        action = this.getAction("ACTION_DELETE");
        items.add(new JMenuItem(action));
        return items;
    }

    @Override
    public Action getAction(String actionKey) {
        Action value;
        if (actionKey == null) {
            return null;
        }
        if (this.actionMap == null) {
            this.actionMap = this.createActionMap();
        }
        if ((value = this.actionMap.get(actionKey)) == null && (value = this.createAction(actionKey)) != null) {
            this.actionMap.put(actionKey, value);
        }
        return value;
    }

    @Override
    public void setAction(String actionKey, Action a) {
        if (actionKey == null || a == null) {
            return;
        }
        if (this.actionMap == null) {
            this.actionMap = this.createActionMap();
        }
        this.actionMap.put(actionKey, a);
    }

    private ActionMap createActionMap() {
        ActionMap map = new ActionMap();
        if (this.theView != null) {
            map.setParent(this.theView.getActionMap());
        }
        return map;
    }

    protected Action createAction(String actionKey) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public PFDGroup getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return this.group;
    }

    @Override
    public void setParent(PFDGroup parent) {
        this.parent = parent;
    }

    public void endResize() {
        this.fireResizeEvent();
    }

    protected void fireResizeEvent() {
        if (!this.enableUpdate) {
            return;
        }
        PFDModel m = this.getModel();
        if (m != null) {
            m.fireModelChange(15, null, this);
        }
    }
}

