/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;

public class PFDPolygon
extends PFDDrawablePrimitive {
    Polygon polygon = new Polygon();
    Vector vertices = new Vector();

    public PFDPolygon() {
    }

    public PFDPolygon(Vector v) {
        this.vertices = v;
    }

    public Vector getVertices() {
        return this.vertices;
    }

    public void setVertices(Vector v) {
        this.vertices = v;
        this.firePropertyChange("bbox");
    }

    public void addVertex(int x, int y) {
        this.vertices.addElement(new Point(x, y));
        this.firePropertyChange("bbox");
    }

    public void addVertex(Point p) {
        this.vertices.addElement(p);
        this.firePropertyChange("bbox");
    }

    public void removeVertex(int index) {
        this.vertices.removeElementAt(index);
        this.firePropertyChange("bbox");
    }

    public void removeAllVerices() {
        this.vertices.removeAllElements();
        this.firePropertyChange("bbox");
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.shadowOn) {
            this.drawShadow(g2d, v);
        }
        if (this.brush.getStyle() != 0) {
            this.brush.apply(g2d);
            g2d.fill(this.polygon);
        }
        if (this.pen.getStyle() != 0) {
            this.pen.apply(g2d);
            g2d.draw(this.polygon);
        }
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        if (this.brush.getStyle() != 0) {
            g2d.setColor(this.brush.getColor());
            g2d.fill(this.polygon);
        }
        if (this.pen.getStyle() != 0) {
            g2d.setColor(this.pen.getColor());
            g2d.draw(this.polygon);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        return this.polygon.contains(x, y);
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("bbox") || property.equals("all")) {
            this.polygonChanged();
        }
        super.update(property, v);
    }

    protected void calculateBBox() {
        this.bbox.setBounds(this.polygon.getBounds());
        ++this.bbox.width;
        ++this.bbox.height;
    }

    protected void polygonChanged() {
        this.polygon = new Polygon();
        for (int i = 0; i < this.vertices.size(); ++i) {
            Point p = (Point)this.vertices.elementAt(i);
            this.polygon.addPoint(p.x, p.y);
        }
        Rectangle r = this.polygon.getBounds();
        this.polygon.translate(this.bbox.x - r.x, this.bbox.y - r.y);
        this.calculateBBox();
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDPolygon clone = new PFDPolygon();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDPolygon toObject) {
        super.copyObject(toObject);
        toObject.setVertices(this.getVertices());
    }
}

