/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDPropertyChangeSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PFDPen
extends PFDPropertyChangeSupport
implements Serializable {
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int DASHED = 2;
    public static final int DOTTED = 3;
    public static final int DASHDOT = 4;
    public static final int DASHDOTDOT = 5;
    protected int style = 1;
    protected float lineWidth = 1.0f;
    protected Color color = Color.black;
    protected transient Stroke stroke = new BasicStroke();
    static final float[] dash1 = new float[]{5.0f};

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        if (style == 2) {
            this.stroke = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash1, 0.0f);
        } else if (style == 1) {
            this.stroke = new BasicStroke(this.lineWidth);
        }
        this.firePropertyChange("style", null, null);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.firePropertyChange("color", null, null);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float width) {
        if (this.lineWidth == width) {
            return;
        }
        this.lineWidth = width;
        if (this.style == 2) {
            this.stroke = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash1, 0.0f);
        } else if (this.style == 1) {
            this.stroke = new BasicStroke(this.lineWidth);
        }
        this.firePropertyChange("lineWidth", null, null);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.firePropertyChange("stroke", null, null);
    }

    public void apply(Graphics2D g2d) {
        g2d.setColor(this.color);
        g2d.setStroke(this.stroke);
    }

    public void copyObject(PFDPen toObject) {
        toObject.setColor(this.getColor());
        toObject.setLineWidth(this.getLineWidth());
        toObject.setStyle(this.getStyle());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.style == 2) {
            this.stroke = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash1, 0.0f);
        } else if (this.style == 1) {
            this.stroke = new BasicStroke(this.lineWidth);
        }
    }
}

