/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;

public class PFDPathDiagramLink
extends PFDLink
implements PathDiagramLinkLayoutInterface {
    private static final long serialVersionUID = 4343700553944733956L;
    public static final int LINK_DIRECTION_TO = 1;
    public static final int LINK_DIRECTION_FROM = 2;
    public static final int LINK_DIRECTION_BOTH = 3;
    public static final int LINK_DIRECTION_NONE = 4;
    private int linkDirection;
    public static final int LINK_PRIORITY_1 = 1;
    public static final int LINK_PRIORITY_2 = 2;
    public static final int LINK_PRIORITY_3 = 3;
    public static final int LINK_PRIORITY_0 = -1;
    private int linkPriority = 1;

    public PFDPathDiagramLink(PFDPort from, PFDPort to) {
        super(from, to, false);
    }

    @Override
    public int getLinkDirection() {
        return this.linkDirection;
    }

    @Override
    public void setLinkDirection(int linkDirection) {
        this.linkDirection = linkDirection;
    }

    public void update() {
        this.linkChanged();
        this.arrowChanged();
        this.labelChanged();
        this.buttonsChanged();
        this.calculateBBox();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName() == "breakPointChanged") {
            PFDPathDiagramLink pdl = (PFDPathDiagramLink)e.getSource();
            this.setCustomBreakPointsUsed(pdl.isCustomBreakPointsUsed());
            this.addBreakPoint(pdl.getBreakPoint(pdl.getNumBreakPoints() - 1));
        }
    }

    @Override
    public int getLinkPriority() {
        return this.linkPriority;
    }

    @Override
    public void setLinkPriority(int priority) {
        this.linkPriority = priority;
    }

    @Override
    public void move(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        if (this.isCustomBreakPointsUsed()) {
            for (int i = 0; i < this.breakPoints.size(); ++i) {
                Point p = (Point)this.breakPoints.get(i);
                p.move(p.x + dx, p.y + dy);
            }
        }
        this.calculateBBox();
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        Shape s;
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        if (this.getFromElbowLineWidth() == 1.0f && this.getToElbowLineWidth() == 1.0f) {
            super.render(g2d, v);
            return;
        }
        Shape clipSave = g2d.getClip();
        Rectangle clipBounds = g2d.getClipBounds();
        if (clipBounds == null) {
            clipBounds = v.getViewRect();
        }
        Area area = new Area(new Rectangle2D.Double(clipBounds.getX(), clipBounds.getY(), clipBounds.getWidth(), clipBounds.getHeight()));
        PFDAbstractNode node = this.fromPort.getParentNode();
        if (node instanceof PFDPathDiagramNode && (s = ((PFDPathDiagramNode)node).getDrawableShape()) != null) {
            area.subtract(new Area(s));
        }
        if ((node = this.toPort.getParentNode()) instanceof PFDPathDiagramNode && (s = ((PFDPathDiagramNode)node).getDrawableShape()) != null) {
            area.subtract(new Area(s));
        }
        g2d.setClip(area);
        super.render(g2d, v);
        g2d.setClip(clipSave);
    }
}

