/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.util.layout.CustomLinkedList;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramNodeLayoutInterface;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;

public class PFDPathDiagramGroupNode
extends PFDAbstractNode
implements NodeLayoutInterface {
    private static final int hPad = 20;
    private static final int vPad = 20;
    public static final int baseNodeHeight = 50;
    public static final int baseNodeWidth = 100;
    private static final int vGap = 100;
    private static final int p3Gap = 33;
    public static final int arcHeight = 50;
    private PathDiagramNodeLayoutInterface mainNode;
    private Vector<PathDiagramNodeLayoutInterface> priority2Nodes = new Vector();
    private Vector<PathDiagramNodeLayoutInterface> priority3Nodes = new Vector();
    private CustomLinkedList<PathDiagramNodeLayoutInterface> p2NodesOrderedList = new CustomLinkedList();
    private Hashtable<PathDiagramNodeLayoutInterface, Integer> linksUnderRightCountMap = new Hashtable();
    private Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface> p2p3NodesMap = null;
    public static final String RB_KEY = "PFDPrimitive.";
    private int maxLinkDepth = 0;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private PFDPort port = new PFDPort();
    private PFDPathDiagramNode pfd_pdn = null;
    private Vector<PathDiagramNodeLayoutInterface> directErrorNodes = null;
    private double gridScaleFactor = 1.0;

    public void setGridScaleFactor(double fac) {
        this.gridScaleFactor = fac;
    }

    public PFDPathDiagramGroupNode() {
        this.port.setName("port");
        this.port.setFromLinkSpot(3);
        this.port.setToLinkSpot(1);
        this.port.setValidFromPort(true);
        this.port.setValidToPort(true);
        this.port.setType(0);
        this.port.setParent(this);
        this.port.setGroup(this);
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setSpotLocation(0, p);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getLayoutHeight() {
        return this.height;
    }

    @Override
    public int getLayoutWidth() {
        return this.width;
    }

    @Override
    public Rectangle getBBox() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public Point getLayoutLocation(int spot, Point p) {
        return this.getSpotLocation(spot, p);
    }

    @Override
    public void setLayoutLocation(int spot, Point p) {
        this.setSpotLocation(spot, p);
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        PFDPathDiagramGroupNode.checkSpot(spot);
        if (p == null) {
            p = new Point();
        }
        switch (spot) {
            default: {
                p.x = this.x + this.width / 2;
                p.y = this.y + this.height / 2;
                break;
            }
            case 1: 
            case 10: {
                p.x = this.x;
                p.y = this.y;
                break;
            }
            case 2: {
                p.x = this.x + this.width / 2;
                p.y = this.y;
                break;
            }
            case 3: {
                p.x = this.x + this.width - 1;
                p.y = this.y;
                break;
            }
            case 4: {
                p.x = this.x + this.width - 1;
                p.y = this.y + this.height / 2;
                break;
            }
            case 5: {
                p.x = this.x + this.width - 1;
                p.y = this.y + this.height - 1;
                break;
            }
            case 6: {
                p.x = this.x + this.width / 2;
                p.y = this.y + this.height - 1;
                break;
            }
            case 7: {
                p.x = this.x;
                p.y = this.y + this.height - 1;
                break;
            }
            case 8: {
                p.x = this.x;
                p.y = this.y + this.height / 2;
            }
        }
        if (this.width <= 0) {
            p.x = this.x;
        }
        if (this.height <= 0) {
            p.y = this.y;
        }
        return p;
    }

    @Override
    public void setSpotLocation(int spot, Point p) {
        PFDPathDiagramGroupNode.checkSpot(spot);
        if (p == null) {
            return;
        }
        Point loc = this.getSpotLocation(spot, null);
        this.moveTo(p.x - loc.x, p.y - loc.y);
    }

    @Override
    public int getInputEndSegmentLength() {
        return 0;
    }

    @Override
    public int getOutputEndSegmentLength() {
        return 0;
    }

    @Override
    public void setNodePlaced(boolean place) {
    }

    @Override
    public boolean isNodePlaced() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public double getInputLinkDirection() {
        return 0.0;
    }

    @Override
    public double getOutputLinkDirection() {
        return 0.0;
    }

    @Override
    public void layoutSelfLinks() {
    }

    public Vector<PathDiagramNodeLayoutInterface> getPriority2Nodes() {
        return this.priority2Nodes;
    }

    public void addPriority2Node(PathDiagramNodeLayoutInterface node) {
        if (!this.priority2Nodes.contains(node) && node.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2) {
            this.priority2Nodes.add(node);
        }
    }

    public Vector<PathDiagramNodeLayoutInterface> getPriority3Nodes() {
        return this.priority3Nodes;
    }

    public void addPriority3Node(PathDiagramNodeLayoutInterface node) {
        if (!this.priority3Nodes.contains(node) && node.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3) {
            this.priority3Nodes.add(node);
        }
    }

    public CustomLinkedList<PathDiagramNodeLayoutInterface> getPriority2NodesOrderedList() {
        return this.p2NodesOrderedList;
    }

    public Hashtable<PathDiagramNodeLayoutInterface, Integer> getLinksUnderCountMap() {
        return this.linksUnderRightCountMap;
    }

    public int getMaxLinkDepth() {
        return this.maxLinkDepth;
    }

    public void setMaxLinkDepth(int maxLinkDepth) {
        this.maxLinkDepth = maxLinkDepth;
    }

    public PathDiagramNodeLayoutInterface getMainNode() {
        return this.mainNode;
    }

    public void setMainNode(PathDiagramNodeLayoutInterface mainNode) {
        this.mainNode = mainNode;
    }

    protected static void checkSpot(int spot) {
        switch (spot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "spot.ex.txt"));
            }
        }
    }

    private void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
        if (this.pfd_pdn != null) {
            this.pfd_pdn.setLocation(x, y);
            this.pfd_pdn.setBBox(x, y, this.width, this.height);
        }
        this.port.setBBox(x, y, this.width, this.height);
        this.setBBox(x, y, this.width, this.height);
        this.moveContainedNodes();
    }

    private void moveContainedNodes() {
        int hPad = (int)(20.0 * this.gridScaleFactor);
        int vPad = (int)(20.0 * this.gridScaleFactor);
        int baseNodeHeight = (int)(50.0 * this.gridScaleFactor);
        int baseNodeWidth = (int)(100.0 * this.gridScaleFactor);
        int vGap = (int)(100.0 * this.gridScaleFactor);
        int p3Gap = vGap / 3;
        int arcHeight = (int)(50.0 * this.gridScaleFactor);
        PFDPathDiagramNode mNode = (PFDPathDiagramNode)this.mainNode;
        Point p = new Point(this.x + this.width / 2, this.y + vPad + this.mainNode.getWidth() / 2);
        this.mainNode.setCenterLocation(p);
        if (this.p2NodesOrderedList.getSize() > 0) {
            int posY = this.y + vPad + this.mainNode.getHeight() + vGap + this.mainNode.getHeight() / 2;
            boolean directErrorNodesPlaced = false;
            for (int i = 0; i < this.p2NodesOrderedList.getSize(); ++i) {
                PathDiagramNodeLayoutInterface pdn = this.p2NodesOrderedList.get(i);
                int posX = this.x + (hPad + pdn.getWidth()) * i + hPad + pdn.getWidth() / 2;
                if (this.directErrorNodes != null && this.directErrorNodes.size() > 0) {
                    if (directErrorNodesPlaced) {
                        posX += this.directErrorNodes.elementAt(0).getWidth() * this.directErrorNodes.size() + hPad;
                    } else if (i + 1 > this.p2NodesOrderedList.getSize() / 2) {
                        for (int d = 0; d < this.directErrorNodes.size(); ++d) {
                            PathDiagramNodeLayoutInterface den = this.directErrorNodes.elementAt(d);
                            int px = this.mainNode.getX() + ((PFDPathDiagramNode)this.mainNode).getDrawable().getWidth() / 2;
                            int py = this.y;
                            den.setCenterLocation(new Point(px, py));
                        }
                    }
                }
                p = new Point(posX, posY);
                pdn.setCenterLocation(p);
            }
        } else if (this.directErrorNodes != null && this.directErrorNodes.size() > 0) {
            for (int d = 0; d < this.directErrorNodes.size(); ++d) {
                PathDiagramNodeLayoutInterface den = this.directErrorNodes.elementAt(d);
                int px = this.x + den.getWidth() / 2;
                int py = (int)((double)(this.y + vPad) + (double)this.mainNode.getHeight() * 1.5 + (double)p3Gap + (double)(den.getHeight() / 2) + (double)(d * den.getHeight()));
                den.setCenterLocation(new Point(px, py));
            }
        }
        for (int i = 0; i < this.priority3Nodes.size(); ++i) {
            int ny;
            PathDiagramNodeLayoutInterface pdn = this.priority3Nodes.elementAt(i);
            if (this.directErrorNodes != null && this.directErrorNodes.contains(pdn)) continue;
            PathDiagramNodeLayoutInterface ln = this.p2p3NodesMap.get(pdn);
            Point lc = new Point(this.x + this.width / 2, this.y + this.height / 2);
            if (ln != null) {
                lc = ln.getCenterLocation();
                ny = lc.y + ln.getHeight() / 2 + p3Gap + ln.getHeight() / 2;
            } else {
                ny = lc.y;
            }
            PFDPathDiagramNode pdn_ln = (PFDPathDiagramNode)ln;
            lc = pdn_ln.getDrawable().getSpotLocation(0, null);
            p = new Point(lc.x, ny);
            pdn.setCenterLocation(p);
        }
    }

    public void computeSize() {
        int hPad = (int)(20.0 * this.gridScaleFactor);
        int vPad = (int)(20.0 * this.gridScaleFactor);
        int baseNodeHeight = (int)(50.0 * this.gridScaleFactor);
        int baseNodeWidth = (int)(100.0 * this.gridScaleFactor);
        int vGap = (int)(100.0 * this.gridScaleFactor);
        int p3Gap = vGap / 3;
        int arcHeight = (int)(50.0 * this.gridScaleFactor);
        this.width = hPad * 2 + this.mainNode.getWidth();
        this.height = vPad * 2 + this.mainNode.getHeight();
        int p2NodesWidth = 0;
        int maxP2NodeHeight = 0;
        for (int i = 0; i < this.priority2Nodes.size(); ++i) {
            PathDiagramNodeLayoutInterface node = this.priority2Nodes.elementAt(i);
            p2NodesWidth += node.getWidth();
            maxP2NodeHeight = Math.max(maxP2NodeHeight, node.getHeight());
        }
        p2NodesWidth += (this.priority2Nodes.size() + 1) * hPad;
        if (maxP2NodeHeight > 0) {
            this.height += maxP2NodeHeight + vGap;
        }
        int p3NodesWidth = 0;
        int maxP3NodeHeight = 0;
        for (int i = 0; i < this.priority3Nodes.size(); ++i) {
            PathDiagramNodeLayoutInterface node = this.priority3Nodes.elementAt(i);
            PathDiagramNodeLayoutInterface ln = this.p2p3NodesMap.get(node);
            if (ln == null) {
                if (this.directErrorNodes == null) {
                    this.directErrorNodes = new Vector();
                }
                this.directErrorNodes.add(node);
                node.setDirectErrorNode(true);
                continue;
            }
            p3NodesWidth += node.getWidth();
            maxP3NodeHeight = Math.max(maxP3NodeHeight, node.getHeight());
        }
        int numDirectErrorNodes = this.directErrorNodes != null ? this.directErrorNodes.size() : 0;
        p3NodesWidth += (this.priority3Nodes.size() - numDirectErrorNodes + 1) * hPad;
        if (maxP3NodeHeight > 0) {
            this.height += maxP3NodeHeight + p3Gap;
        }
        double multiplier = 1 + ((this.maxLinkDepth + 2) * (this.maxLinkDepth + 1) / 2 - 3) / 2;
        this.height = (int)((double)this.height + multiplier * (double)arcHeight);
        this.width = Math.max(this.width, p2NodesWidth);
        this.width = Math.max(this.width, p3NodesWidth);
        this.port.setBBox(this.x, this.y, this.width, this.height);
        this.setBBox(this.x, this.y, this.width, this.height);
    }

    @Override
    public PFDPort getInputPort() {
        return this.port;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.port;
    }

    @Override
    public boolean isForceShowPorts() {
        return false;
    }

    @Override
    public void setForceShowPorts(boolean visible) {
    }

    @Override
    public PFDPort getPort(String name) {
        return this.port;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    protected Vector getChildren() {
        return null;
    }

    @Override
    protected Vector getParents() {
        return null;
    }

    public Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface> getP2P3NodesMap() {
        return this.p2p3NodesMap;
    }

    public void setP2P3NodesMap(Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface> nodesMap) {
        this.p2p3NodesMap = nodesMap;
    }
}

