/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDOverview;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class PFDOverviewDialog
extends JDialog
implements WindowListener {
    PFDView view;
    PFDOverview overview;

    public PFDOverviewDialog(Frame aFrame, String title, PFDView viewer) {
        super(aFrame, false);
        this.view = viewer;
        this.setTitle(title);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout());
        JPanel overviewPanel = new JPanel(new BorderLayout());
        overviewPanel.setBorder(new EtchedBorder(1));
        this.overview = new PFDOverview(this.view);
        overviewPanel.add((Component)this.overview, "Center");
        contentPane.add((Component)overviewPanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        int w = Math.max(this.view.getModel().getSize().width, this.view.getWidth());
        int h = Math.max(this.view.getModel().getSize().height, this.view.getHeight());
        double aspectRatio = (double)h / (double)w;
        int iw = this.view.preferredOverviewWidth;
        int ih = Math.max(iw / 4, (int)((double)this.view.preferredOverviewWidth * aspectRatio));
        ih = Math.min(ih, 640);
        contentPane.setPreferredSize(new Dimension(iw, ih));
        this.getContentPane().add(contentPane);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.overview.detachView();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }
}

