/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDNote;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDTextPaneWindow;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public class PFDNoteWindow
extends PFDTextPaneWindow {
    private PFDButton menuButton;
    private PFDNote note;
    private String noteStyleContext = "NoteStyleYellow";

    public PFDNoteWindow(PFDNote note) {
        this.note = note;
        this.selectPrimitive = note;
        this.initialize();
    }

    private void initialize() {
        this.minWindowSize = new Dimension(150, 81);
        this.defaultWindowSize = new Dimension(180, 141);
        this.maxWindowSize = new Dimension(300, 246);
        this.preferredSize.setSize(this.defaultWindowSize);
        this.menuButton = new PFDButton();
        this.menuButton.setAction(new MenuAction());
        this.addPrimitive(this.menuButton);
    }

    @Override
    protected void closeWindow() {
        this.note.setCollapsed(true);
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        int y = this.closeButton.getY() + this.closeButton.getHeight() / 2 - this.menuButton.getHeight() / 2;
        this.menuButton.setLocation(this.backgroundRect.getX() + 7, y);
    }

    @Override
    protected Dimension getContentSize(Dimension windowSize) {
        return new Dimension(windowSize.width - 14, windowSize.height - this.getTitleBarHeight() - 7);
    }

    @Override
    protected Point getContentLocation(Point windowLocation) {
        return new Point(windowLocation.x + 7, windowLocation.y + this.getTitleBarHeight());
    }

    @Override
    protected Dimension getWindowSize(Dimension contentSize) {
        return new Dimension(contentSize.width + 14, contentSize.height + this.getTitleBarHeight() + 7);
    }

    @Override
    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        this.backgroundRect.paint(g);
        this.closeButton.paint(g);
        this.menuButton.paint(g);
        this.drawTitleBar(g);
        this.drawSeperator(g);
        this.componentPrimitive.paint(g);
        if (this.resizable) {
            this.drawResizeHandle(g);
        }
        if (selected) {
            this.drawSelection(g);
        }
    }

    protected void drawTitleBar(Graphics2D g) {
        int numLines = 4;
        int x = this.titleBar.getX() + 7 + this.menuButton.getWidth() + 4;
        int y = this.titleBar.getY() + 7;
        int width = this.titleBar.getWidth() - 14 - 8 - this.menuButton.getWidth() - this.closeButton.getWidth();
        int height = this.titleBar.getHeight() - 7 - 4;
        int dy = height / (numLines - 1);
        int halfStrokeWidth = (int)Math.floor((double)seperatorStroke.getLineWidth() / 2.0);
        if (g.hitClip(x - halfStrokeWidth, y - halfStrokeWidth, width - 1 + halfStrokeWidth * 2, height + 1 + halfStrokeWidth * 2)) {
            g.setColor(this.lineColor);
            g.setStroke(seperatorStroke);
            for (int i = 0; i < numLines; ++i) {
                g.drawLine(x, y + i * dy, x + width - 1, y + i * dy);
            }
        }
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        StyleElement se = style.getStyleElement(this.noteStyleContext);
        if (se != null) {
            this.setFillColor(se.getColorAttribute("fillColor", defaultFillColor));
            Color lineColor = se.getColorAttribute("lineColor", defaultOutlineColor);
            Color contrastColor = se.getColorAttribute("altColor", defaultOutlineColor);
            this.setOutlineColor(lineColor);
            this.setLineColor(contrastColor);
        }
    }

    public void setNoteStyleContext(String styleContext) {
        if (styleContext == null || styleContext.equals(this.noteStyleContext)) {
            return;
        }
        this.noteStyleContext = styleContext;
        this.updateStyle();
    }

    @Override
    public void endResize() {
        this.note.endResize();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        block12: {
            int mouseMode;
            block11: {
                e.consume();
                mouseMode = this.theView.getMouseExtendedMode();
                this.theView.setMouseOverPrimitive(this, e);
                if (e.getSource() != this && e.getSource() != this.titleBar) break block11;
                if (!this.selectable) {
                    return;
                }
                switch (mouseMode) {
                    case 4: {
                        if (!this.theView.isSelected(this.note)) {
                            this.theView.clearSelections();
                            this.theView.selectPrimitive(this.note);
                            break;
                        }
                        break block12;
                    }
                    case 2: {
                        if (this.theView.isSelected(this.note)) {
                            this.theView.deselectPrimitive(this.note);
                            break;
                        }
                        this.theView.selectPrimitive(this.note);
                        if (this.theView.isEditMode() && this.isDraggable() && e.getSource() == this.titleBar) {
                            this.theView.setDragMode(0);
                            break;
                        }
                        break block12;
                    }
                    default: {
                        if (!this.theView.isSelected(this.note)) {
                            this.theView.clearSelections();
                            this.theView.selectPrimitive(this.note);
                        }
                        if (this.theView.isEditMode() && this.isDraggable() && e.getSource() == this.titleBar) {
                            this.theView.setDragMode(0);
                            break;
                        }
                        break block12;
                    }
                }
                break block12;
            }
            if (e.getSource() == this.resizeHotSpot && this.isResizable() && this.theView.isEditMode() && mouseMode == 0) {
                this.theView.setResizePrimitive(this, 4);
                this.theView.setDragMode(4);
            }
        }
    }

    @Override
    protected void attachView(PFDView v) {
        super.attachView(v);
        ((PFDAbstractAction)this.menuButton.getAction()).setView(v);
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        ((PFDAbstractAction)this.menuButton.getAction()).setView(null);
    }

    private class MenuAction
    extends PFDAbstractAction {
        public MenuAction() {
            super((PFDView)null);
            this.putValue("SmallIcon", new MenuIcon());
            this.putValue("ShortDescription", RB.getStringResource("PFDNoteWindow.MenuAction.action.tip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.view != null) {
                this.view.clearSelections();
                this.view.selectPrimitive(PFDNoteWindow.this.note);
                Point p = PFDNoteWindow.this.titleBar.getSpotLocation(7, null);
                this.view.ModelToView(p);
                this.view.showPopupMenu(new PFDPrimitive[]{PFDNoteWindow.this.note}, p.x, p.y);
            }
        }
    }

    private class MenuIcon
    implements Icon {
        private Polygon triangle = new Polygon();
        private int width = 8;
        private int height = (int)Math.sqrt(Math.pow(this.width, 2.0) - Math.pow((double)this.width / 2.0, 2.0));

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            this.triangle.reset();
            this.triangle.addPoint(x, y);
            this.triangle.addPoint(x + this.width / 2, y + this.height);
            this.triangle.addPoint(x + this.width, y);
            g2d.setColor(PFDNoteWindow.this.lineColor);
            g2d.fill(this.triangle);
        }
    }
}

