/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDIcon;
import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDNote;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public class PFDNoteIcon
extends PFDGroup {
    private PFDIcon icon;
    private PFDText text;
    private String noteStyleContext = "NoteStyleYellow";
    private PFDNote note;
    private static final int textExtent = 20;

    public PFDNoteIcon(PFDNote note) {
        this.note = note;
        this.initialize();
    }

    private void initialize() {
        this.setBreakable(false);
        this.setEditable(false);
        this.setCustomSelection(true);
        this.icon = new PFDIcon();
        this.icon.setIcon(this.getIconForStyle(this.noteStyleContext));
        this.text = new PFDText();
        this.text.setFontSize(11);
        this.text.setSelectable(false);
        this.text.setVerticalAlignment(1);
        this.text.setHorizontalAlignment(0);
        this.text.setMultiline(true);
        this.text.setWrapWidth(0);
        this.text.setClipping(true);
        this.text.setMaxLines(2);
        this.addPrimitive(this.icon);
        this.addPrimitive(this.text);
    }

    protected void layoutChildren() {
        Rectangle bounds = this.icon.getRBBox();
        this.text.setWrapWidth(bounds.width + 40);
        this.text.setBBox(bounds.x + bounds.width / 2, bounds.y + bounds.height, 0, 0);
        this.text.forceUpdate();
        this.calculateBBox();
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        this.draw(g2d, v, false);
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        this.draw(g2d, v, true);
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.renderSelected(g2d, v);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
    }

    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        this.icon.paint(g);
        this.text.paint(g);
        if (selected) {
            this.drawSelection(g);
        }
    }

    protected void drawSelection(Graphics2D g) {
        Rectangle bounds = this.icon.getRBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        if (g.hitClip(bounds.x - 2 - halfStrokeWidth, bounds.y - halfStrokeWidth, bounds.width + 4 + halfStrokeWidth * 2, bounds.height - 1 + halfStrokeWidth * 2)) {
            this.selectionPen.apply(g);
            g.drawRect(bounds.x - 2, bounds.y, bounds.width + 3, bounds.height - 2);
        }
    }

    @Override
    protected Rectangle getCustomSelectionBBox() {
        Rectangle bounds = this.icon.getBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        bounds.x -= 2 + halfStrokeWidth;
        bounds.y -= halfStrokeWidth;
        bounds.width += 4 + halfStrokeWidth * 2;
        bounds.height += -1 + halfStrokeWidth * 2;
        return bounds;
    }

    private Icon getIconForStyle(String styleContext) {
        if (styleContext.equals("NoteStyleYellow")) {
            return PFDIconManager.getIcon("StickyNote_yellow.gif");
        }
        if (styleContext.equals("NoteStyleBlue")) {
            return PFDIconManager.getIcon("StickyNote_blue.gif");
        }
        if (styleContext.equals("NoteStylePink")) {
            return PFDIconManager.getIcon("StickyNote_pink.gif");
        }
        return null;
    }

    public void setNoteStyleContext(String styleContext) {
        if (styleContext == null || styleContext.equals(this.noteStyleContext)) {
            return;
        }
        this.noteStyleContext = styleContext;
        this.updateNoteStyle();
    }

    public void setText(String s) {
        if (s == null ? this.text.getText() == null : s.equals(this.text.getText())) {
            return;
        }
        this.text.setText(s);
        this.firePropertyChange("text");
    }

    public String getText() {
        return this.text.getText();
    }

    private void updateNoteStyle() {
        this.icon.setIcon(this.getIconForStyle(this.noteStyleContext));
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children") || property.equals("text") || property.equals("all")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        int mouseMode = v.getMouseExtendedMode();
        v.setMouseOverPrimitive(this, e);
        if (this.selectable) {
            if (mouseMode == 4) {
                if (!v.isSelected(this.note)) {
                    v.clearSelections();
                    v.selectPrimitive(this.note);
                }
            } else if (mouseMode == 2) {
                if (v.isSelected(this.note)) {
                    v.deselectPrimitive(this.note);
                } else {
                    v.selectPrimitive(this.note);
                    if (this.theView.isEditMode() && this.draggable && this.icon.contains(e.getX(), e.getY())) {
                        v.setDragMode(0);
                    }
                }
            } else {
                if (!v.isSelected(this.note)) {
                    v.clearSelections();
                    v.selectPrimitive(this.note);
                }
                if (this.theView.isEditMode() && this.draggable && this.icon.contains(e.getX(), e.getY())) {
                    v.setDragMode(0);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (this.theView.isEditMode() && this.selectable && this.draggable && this.icon.contains(e.getX(), e.getY())) {
            v.setCursor(1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (e.getClickCount() == 2) {
            this.note.setCollapsed(false);
        }
    }
}

