/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;

public class PFDNodeNumber
extends PFDGroup {
    private int number;
    private PFDText numberText;
    private PFDEllipse background;

    public PFDNodeNumber() {
        this.init();
    }

    private void init() {
        this.setSelectable(false);
        this.setDraggable(false);
        this.setBreakable(false);
        this.numberText = new PFDText();
        this.background = new PFDEllipse(new Rectangle(0, 0, 50, 50));
        this.numberText.setVerticalAlignment(0);
        this.numberText.setHorizontalAlignment(0);
        this.numberText.setFontSize(9);
        this.initNumberText();
        this.background.getBrush().setColor(new Color(255, 255, 225));
        this.background.getPen().setColor(new Color(150, 150, 150));
        this.addPrimitive(this.background);
        this.addPrimitive(this.numberText);
    }

    protected void layoutChildren() {
        Point center = this.background.getSpotLocation(0, null);
        this.numberText.setBBox(center.x, center.y, 0, 0);
        Rectangle textBBox = this.numberText.getRBBox();
        double halfWidth = (double)textBBox.width / 2.0;
        double halfHeight = (double)textBBox.height / 2.0;
        double h = (double)textBBox.height * 0.75;
        double w = halfWidth * halfWidth / (1.0 - halfHeight * halfHeight / (h * h));
        w = Math.sqrt(w);
        if (w < h) {
            w = h;
        }
        this.background.setSize((int)w * 2, (int)h * 2);
        this.background.setSpotLocation(0, center);
    }

    public void setNumber(int number) {
        if (this.number == number) {
            return;
        }
        this.number = number;
        this.initNumberText();
        this.firePropertyChange("number");
    }

    private void initNumberText() {
        this.numberText.setText(NumberFormat.getInstance().format(this.number));
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children") || property.equals("number") || property.equals("all")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        return this.background.getSpotLocation(spot, p);
    }
}

