/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDControlNode;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDShape;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Hashtable;

public class PFDLoopControlNode
extends PFDControlNode {
    private static final long serialVersionUID = 8888826236603016173L;
    public static int DIRECTION_FORWARD = 0;
    public static int DIRECTION_BACKWARD = 1;
    protected int direction = DIRECTION_FORWARD;

    public PFDLoopControlNode() {
        this.init();
    }

    @Override
    protected void init() {
        this.controlShape = new PFDShape(new Rectangle(0, 0, PFDLoopControlNode.defaultSize.width, PFDLoopControlNode.defaultSize.height));
        this.selectionShape = new PFDEllipse();
        super.init();
    }

    @Override
    protected void layoutChildren() {
        this.disableChangeUpdate();
        ((PFDShape)this.controlShape).setShape(this.createControlShape());
        this.selectionShape.setBBox(this.controlShape.getRBBox());
        this.layoutText();
        this.layoutStatusButton();
        this.layoutPorts();
        this.layoutNodeNumber(this.controlShape.getSpotLocation(1, null));
        this.enableChangeUpdate();
        this.calculateBBox();
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        Rectangle bounds = this.controlShape.getRBBox();
        this.selectionPen.apply(g2d);
        g2d.drawOval(bounds.x, bounds.y, bounds.width, bounds.height);
        this.render(g2d, v);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == this.direction) {
            return;
        }
        if (direction == DIRECTION_FORWARD || direction == DIRECTION_BACKWARD) {
            this.direction = direction;
            this.firePropertyChange("direction");
        }
    }

    private Shape createControlShape() {
        AffineTransform transform = new AffineTransform();
        String flowDir = this.getFlowDirection();
        if (flowDir.equalsIgnoreCase("right")) {
            if (this.direction == DIRECTION_BACKWARD) {
                transform.rotate(Math.PI);
            }
        } else if (flowDir.equalsIgnoreCase("left")) {
            if (this.direction == DIRECTION_FORWARD) {
                transform.rotate(Math.PI);
            }
            transform.scale(1.0, -1.0);
        } else if (flowDir.equalsIgnoreCase("up")) {
            if (this.direction == DIRECTION_FORWARD) {
                transform.rotate(-1.5707963267948966);
            } else {
                transform.rotate(1.5707963267948966);
            }
        } else if (flowDir.equalsIgnoreCase("down")) {
            if (this.direction == DIRECTION_FORWARD) {
                transform.rotate(1.5707963267948966);
            } else {
                transform.rotate(-1.5707963267948966);
            }
            transform.scale(1.0, -1.0);
        }
        Area a = (Area)PFDShape.getLoop();
        a.transform(transform);
        return a;
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("direction")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDLoopControlNode clone = new PFDLoopControlNode();
        table.put(this, clone);
        this.copyObject(clone);
        this.clonePorts(table, clone);
        return clone;
    }

    public void copyObject(PFDLoopControlNode toObject) {
        super.copyObject(toObject);
        toObject.setDirection(this.getDirection());
    }
}

