/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDShape;
import com.sas.graphics.components.pfd.PFDShapeControlNode;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Hashtable;

public class PFDLogicalOperatorNode
extends PFDShapeControlNode {
    public static final int AND_OPERATOR_TYPE = 0;
    public static final int OR_OPERATOR_TYPE = 1;
    private int operatorType = 0;

    public PFDLogicalOperatorNode() {
        this.init();
    }

    public PFDLogicalOperatorNode(int operatorType) {
        this();
        this.setOperatorType(operatorType);
    }

    @Override
    protected void init() {
        super.init();
        this.getInputPort().setMaxNumLinks(Integer.MAX_VALUE);
    }

    public void setOperatorType(int operatorType) {
        switch (operatorType) {
            case 0: 
            case 1: {
                this.operatorType = operatorType;
                this.firePropertyChange("operatorType");
            }
        }
    }

    public int getOperatorType() {
        return this.operatorType;
    }

    @Override
    protected Shape createSelectionShape() {
        return this.createControlShape();
    }

    @Override
    protected Shape createControlShape() {
        Shape s;
        AffineTransform transform = new AffineTransform();
        String flowDir = this.getFlowDirection();
        if (flowDir.equalsIgnoreCase("left")) {
            transform.scale(-1.0, 1.0);
        } else if (flowDir.equalsIgnoreCase("up")) {
            transform.rotate(-1.5707963267948966);
        } else if (flowDir.equalsIgnoreCase("down")) {
            transform.rotate(1.5707963267948966);
        }
        switch (this.operatorType) {
            case 1: {
                s = PFDShape.getOr();
                break;
            }
            default: {
                s = PFDShape.getAnd();
            }
        }
        Area a = s instanceof Area ? (Area)s : new Area(s);
        a.transform(transform);
        return a;
    }

    @Override
    protected void setSelectionBBox(Rectangle controlBBox) {
        if (this.operatorType == 0) {
            super.setSelectionBBox(controlBBox);
        } else {
            this.setOrSelectionBBox(controlBBox);
        }
    }

    private void setOrSelectionBBox(Rectangle controlBBox) {
        if (this.flowDirection.equalsIgnoreCase("right")) {
            this.selectionShape.setBBox(controlBBox.x - 8, controlBBox.y - 4, controlBBox.width + 12, controlBBox.height + 8);
        } else if (this.flowDirection.equalsIgnoreCase("left")) {
            this.selectionShape.setBBox(controlBBox.x - 4, controlBBox.y - 4, controlBBox.width + 12, controlBBox.height + 8);
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            this.selectionShape.setBBox(controlBBox.x - 4, controlBBox.y - 4, controlBBox.width + 8, controlBBox.height + 12);
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            this.selectionShape.setBBox(controlBBox.x - 4, controlBBox.y - 8, controlBBox.width + 8, controlBBox.height + 12);
        }
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDLogicalOperatorNode clone = new PFDLogicalOperatorNode();
        table.put(this, clone);
        this.copyObject(clone);
        this.clonePorts(table, clone);
        return clone;
    }

    public void copyObject(PFDLogicalOperatorNode toObject) {
        super.copyObject(toObject);
        toObject.setOperatorType(this.getOperatorType());
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("operatorType")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }
}

