/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPenCustomizerPanel;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class PFDLinkPropertyDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String RB_KEY = "PFDLinkPropertyDialog.";
    PFDLink link;
    PFDView view;
    JComboBox arrowPosition;
    JComboBox arrowSize;
    JCheckBox elbow;
    JButton closeButton;

    public PFDLinkPropertyDialog(Frame aFrame, String title, PFDLink link, PFDView viewer) {
        super(aFrame, true);
        this.setResizable(false);
        this.link = link;
        this.view = viewer;
        this.setTitle(title);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel arrowPanel = new JPanel();
        arrowPanel.setLayout(new BoxLayout(arrowPanel, 1));
        JPanel arrowPanel1 = new JPanel(new BorderLayout());
        JLabel arrowPositionLabel = new JLabel(RB.getStringResource(RB_KEY, "position.txt"));
        arrowPositionLabel.setPreferredSize(new Dimension(100, arrowPositionLabel.getPreferredSize().height));
        String[] arrowPositions = new String[]{RB.getStringResource(RB_KEY, "none.txt"), RB.getStringResource(RB_KEY, "end.txt"), RB.getStringResource(RB_KEY, "start.txt"), RB.getStringResource(RB_KEY, "middle.txt"), RB.getStringResource(RB_KEY, "startEnd.txt")};
        this.arrowPosition = new JComboBox<String>(arrowPositions);
        this.arrowPosition.addActionListener(this);
        arrowPanel1.add((Component)arrowPositionLabel, "West");
        arrowPanel1.add((Component)this.arrowPosition, "Center");
        JPanel arrowPanel2 = new JPanel(new BorderLayout());
        JLabel arrowSizeLabel = new JLabel(RB.getStringResource(RB_KEY, "size.txt"));
        arrowSizeLabel.setPreferredSize(new Dimension(100, arrowSizeLabel.getPreferredSize().height));
        String[] arrowSizes = new String[]{RB.getStringResource(RB_KEY, "small.txt"), RB.getStringResource(RB_KEY, "medium.txt"), RB.getStringResource(RB_KEY, "large.txt")};
        this.arrowSize = new JComboBox<String>(arrowSizes);
        this.arrowSize.addActionListener(this);
        arrowPanel2.add((Component)arrowSizeLabel, "West");
        arrowPanel2.add((Component)this.arrowSize, "Center");
        arrowPanel.add(arrowPanel1);
        arrowPanel.add(arrowPanel2);
        arrowPanel.setBorder(new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "arrowHeads.txt")));
        contentPane.add(arrowPanel);
        contentPane.add(new PFDPenCustomizerPanel(link.getPen()));
        JPanel elbowPanel = new JPanel();
        elbowPanel.setLayout(new BoxLayout(elbowPanel, 0));
        this.elbow = new JCheckBox(RB.getStringResource(RB_KEY, "elbow.txt"));
        this.elbow.addActionListener(this);
        elbowPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        elbowPanel.add(this.elbow);
        elbowPanel.add(Box.createHorizontalGlue());
        contentPane.add(elbowPanel);
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new BoxLayout(closePanel, 0));
        this.closeButton = new JButton(RB.getStringResource(RB_KEY, "close.txt"));
        closePanel.add(Box.createHorizontalGlue());
        closePanel.add(this.closeButton);
        contentPane.add(closePanel);
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(contentPane);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        if (this.link.isFromArrowVisible() && this.link.isToArrowVisible()) {
            this.arrowPosition.setSelectedIndex(4);
        } else if (this.link.isFromArrowVisible()) {
            this.arrowPosition.setSelectedIndex(2);
        } else if (this.link.isMiddleArrowVisible()) {
            this.arrowPosition.setSelectedIndex(3);
        } else if (this.link.isToArrowVisible()) {
            this.arrowPosition.setSelectedIndex(1);
        } else {
            this.arrowPosition.setSelectedIndex(0);
        }
        this.elbow.setSelected(this.link.isOrthogonal());
        this.link.getPen().addPropertyChangeListener(this);
        float arrowBase = this.link.getArrowBase();
        float arrowLength = this.link.getArrowLength();
        if (arrowBase == 5.0f && arrowLength == 7.0f) {
            this.arrowSize.setSelectedIndex(0);
        } else if (arrowBase == 7.0f && arrowLength == 9.0f) {
            this.arrowSize.setSelectedIndex(1);
        } else {
            this.arrowSize.setSelectedIndex(2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.elbow) {
            this.link.setOrthogonal(this.elbow.isSelected());
        } else if (source == this.arrowPosition) {
            int index = this.arrowPosition.getSelectedIndex();
            if (index == 0) {
                this.link.setFromArrowVisible(false);
                this.link.setToArrowVisible(false);
                this.link.setMiddleArrowVisible(false);
            } else if (index == 2) {
                this.link.setFromArrowVisible(true);
                this.link.setToArrowVisible(false);
                this.link.setMiddleArrowVisible(false);
            } else if (index == 3) {
                this.link.setFromArrowVisible(false);
                this.link.setToArrowVisible(false);
                this.link.setMiddleArrowVisible(true);
            } else if (index == 1) {
                this.link.setFromArrowVisible(false);
                this.link.setToArrowVisible(true);
                this.link.setMiddleArrowVisible(false);
            } else if (index == 4) {
                this.link.setFromArrowVisible(true);
                this.link.setToArrowVisible(true);
                this.link.setMiddleArrowVisible(false);
            }
        } else if (source == this.arrowSize) {
            int index = this.arrowSize.getSelectedIndex();
            if (index == 0) {
                this.link.setArrowBase(5.0f);
                this.link.setArrowLength(7.0f);
            } else if (index == 1) {
                this.link.setArrowBase(7.0f);
                this.link.setArrowLength(9.0f);
            } else {
                this.link.setArrowBase(9.0f);
                this.link.setArrowLength(11.0f);
            }
        } else if (source == this.closeButton) {
            this.link.getPen().removePropertyChangeListener(this);
            this.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.link.getPen()) {
            this.view.repaint();
        }
    }
}

