/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDButtonGroup;
import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDGroupNode;
import com.sas.graphics.components.pfd.PFDLinkLabel;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollectionParentInterface;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsedPort;
import com.sas.graphics.components.pfd.interfaces.PFDGhostablePrimitiveInterface;
import com.sas.graphics.components.pfd.interfaces.PFDLinkValidator;
import com.sas.graphics.components.pfd.interfaces.PFDUniqueItemInterface;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class PFDLink
extends PFDDrawablePrimitive
implements PropertyChangeListener,
LinkLayoutInterface,
PFDButtonCollection,
PFDButtonCollectionParentInterface,
PFDGhostablePrimitiveInterface,
PropertyInterface,
PFDUniqueItemInterface {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "PFDLink.";
    public static final int DEFAULT_ARROW_SHAPE = 0;
    public static final int TRIANGLE_ARROW_SHAPE = 1;
    public static final Color defaultColor = new Color(150, 150, 150);
    protected PFDPort fromPort = null;
    protected PFDPort toPort = null;
    protected boolean fromArrowVisible = false;
    protected boolean middleArrowVisible = false;
    protected boolean toArrowVisible = true;
    protected boolean orthogonal = false;
    protected int arrowShape = 0;
    protected float arrowBase = 4.0f;
    protected float arrowLength = 6.0f;
    protected transient Vector segments = new Vector();
    protected Vector points = new Vector();
    protected Vector elbowPoints = new Vector();
    protected Vector breakPoints = new Vector();
    protected Vector selectedBreaks = new Vector();
    protected Vector collapsedBreaks = new Vector();
    protected transient GeneralPath fromArrow;
    protected transient GeneralPath middleArrow;
    protected transient GeneralPath toArrow;
    protected PFDLinkLabel fromLabel = null;
    protected PFDLinkLabel toLabel = null;
    protected PFDLinkLabel middleLabel = null;
    private boolean fromLabelVisible = true;
    private boolean toLabelVisible = true;
    private boolean middleLabelVisible = true;
    protected int middleLabelPosition = 0;
    protected Point fromPoint = new Point();
    protected Point toPoint = new Point();
    private float fromElbowLineWidth = 1.0f;
    private float toElbowLineWidth = 1.0f;
    private boolean freeStyleBreaks = false;
    private boolean dragableBreaks = false;
    protected PFDButtonGroup buttonGroup;
    protected AffineTransform buttonTransform;
    protected boolean isControl = false;
    protected boolean isCollapsed = false;
    protected PFDPort originalFromPort = null;
    protected PFDPort originalToPort = null;
    protected List customValidators = null;
    protected boolean ghosted = false;
    protected boolean layoutAffected = true;
    protected int validationStatus = -1;
    protected transient PropertyList pending = null;

    public PFDLink() {
        this(null, null, false);
    }

    public PFDLink(boolean isControl) {
        this(null, null, isControl);
    }

    public PFDLink(PFDPort from, PFDPort to) {
        this(from, to, false);
    }

    public PFDLink(PFDPort from, PFDPort to, boolean isControl) {
        this.setIsControl(isControl);
        this.toolTipText = null;
        this.setFromPort(from);
        this.setToPort(to);
        this.brush.setColor(Color.black);
        this.pen.setColor(defaultColor);
        this.pen.addPropertyChangeListener(this);
        this.buttonGroup = new PFDButtonGroup();
        this.buttonGroup.setForceRender(true);
        this.buttonTransform = new AffineTransform();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pending = new PropertyList();
    }

    public void setLayoutAffected(boolean layoutAffected) {
        if (this.layoutAffected == layoutAffected) {
            return;
        }
        this.layoutAffected = layoutAffected;
        this.firePropertyChange("layoutAffected");
    }

    @Override
    public boolean isLayoutAffected() {
        return this.layoutAffected;
    }

    public boolean setIsControl(boolean isControl) {
        if (this.isControl == isControl) {
            return true;
        }
        boolean rv = true;
        this.isControl = isControl;
        if (this.fromPort != null && !this.fromPort.isLinkSupported(this)) {
            rv = false;
        }
        if (this.toPort != null && !this.toPort.isLinkSupported(this)) {
            rv = false;
        }
        if (!rv) {
            this.isControl = !isControl;
        } else if (isControl) {
            this.pen.setStyle(2);
        } else {
            this.pen.setStyle(1);
        }
        return rv;
    }

    public boolean isControl() {
        return this.isControl;
    }

    public void setIsCollapsed(boolean isCollapsed) {
        if (this.isCollapsed == isCollapsed) {
            return;
        }
        this.isCollapsed = isCollapsed;
        if (this.fromPort != null) {
            this.fromPort.updateCollapsedLinkCount(isCollapsed);
        }
        if (this.toPort != null) {
            this.toPort.updateCollapsedLinkCount(isCollapsed);
        }
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    private boolean isInteractiveLinkSupported(PFDPort from, PFDPort to) {
        this.validationStatus = 0;
        if (!from.validFromPort) {
            this.validationStatus = 6;
        } else if (!to.validToPort) {
            this.validationStatus = 5;
        } else if (!from.validInteractiveFromPort) {
            this.validationStatus = 8;
        } else if (!to.validInteractiveToPort) {
            this.validationStatus = 7;
        } else if (this.fromPort != from && from.isFull() || this.toPort != to && to.isFull()) {
            this.validationStatus = 9;
        }
        if (this.validationStatus != 0) {
            return false;
        }
        return this.isLinkSupported(from, to);
    }

    public boolean isLinkSupported(PFDPort from, PFDPort to) {
        this.validationStatus = -1;
        if (from == null || to == null || this.isOriginalLink(from, to)) {
            this.validationStatus = 0;
            return true;
        }
        if (this.isCollapsed()) {
            return this.isExpandedLinksSupported(from, to);
        }
        if (from instanceof PFDCollapsedPort || to instanceof PFDCollapsedPort || from instanceof PFDGroupNode.PFDGroupPort || to instanceof PFDGroupNode.PFDGroupPort) {
            return this.isExpandedPortLinkSupported(from, to);
        }
        if (!from.isLinkSupported(this) || !to.isLinkSupported(this)) {
            this.validationStatus = 1;
            return false;
        }
        if (!PFDPort.isLinkSupported(from, to)) {
            this.validationStatus = 2;
            return false;
        }
        PFDAbstractNode fn = from.getParentNode();
        PFDAbstractNode tn = to.getParentNode();
        if (fn == null || tn == null) {
            this.validationStatus = 0;
            return true;
        }
        if (fn == tn) {
            this.validationStatus = 4;
            return false;
        }
        if (!tn.isFromNodeTypeSupported(fn.getNodeType())) {
            this.validationStatus = 3;
            return false;
        }
        if (this.doLinkValidation(from, to)) {
            this.validationStatus = 0;
            return true;
        }
        if (this.validationStatus == -1) {
            this.validationStatus = 100;
        }
        return false;
    }

    private List getExpandedPorts(PFDPort port) {
        List<PFDPort> ports = null;
        if (port instanceof PFDCollapsedPort) {
            ports = new Vector<PFDPort>();
            ports.add(((PFDCollapsedPort)((Object)port)).getExpandedPort());
        } else if (port instanceof PFDGroupNode.PFDGroupPort) {
            ports = ((PFDGroupNode.PFDGroupPort)port).getExpandedPorts();
        } else {
            ports = new Vector();
            ports.add(port);
        }
        return ports;
    }

    public boolean isExpandedPortLinkSupported(PFDPort from, PFDPort to) {
        if (from instanceof PFDGroupNode.PFDGroupPort && to instanceof PFDGroupNode.PFDGroupPort && from.getParentNode() == to.getParentNode()) {
            this.validationStatus = 4;
            return false;
        }
        List fromPorts = this.getExpandedPorts(from);
        List toPorts = this.getExpandedPorts(to);
        if (fromPorts.size() <= 0 || toPorts.size() <= 0) {
            return false;
        }
        if (fromPorts.size() == 1 && toPorts.size() == 1) {
            return this.isInteractiveLinkSupported((PFDPort)fromPorts.get(0), (PFDPort)toPorts.get(0));
        }
        boolean notSupported = false;
        boolean supported = false;
        for (int i = 0; i < fromPorts.size(); ++i) {
            for (int j = 0; j < toPorts.size(); ++j) {
                if (this.isInteractiveLinkSupported((PFDPort)fromPorts.get(i), (PFDPort)toPorts.get(j))) {
                    supported = true;
                    continue;
                }
                notSupported = true;
            }
        }
        if (notSupported) {
            this.validationStatus = supported ? 10 : 11;
        }
        return supported;
    }

    public boolean isExpandedLinksSupported(PFDPort from, PFDPort to) {
        List links = PFDSubdiagram.getExpandedLinks(this);
        if (links != null) {
            for (int i = 0; i < links.size(); ++i) {
                PFDLink l = (PFDLink)links.get(i);
                if (from == this.fromPort) {
                    if (l.isLinkSupported(l.getFromPort(), to)) continue;
                    this.validationStatus = l.getValidationStatus();
                    return false;
                }
                if (to == this.toPort) {
                    if (l.isLinkSupported(from, l.getToPort())) continue;
                    this.validationStatus = l.getValidationStatus();
                    return false;
                }
                if (l.isLinkSupported(from, to)) continue;
                this.validationStatus = l.getValidationStatus();
                return false;
            }
        }
        this.validationStatus = 0;
        return true;
    }

    public PFDPort getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(PFDPort port) {
        if (this.fromPort == port) {
            return;
        }
        if (port != null && !port.isValidFromPort()) {
            return;
        }
        if (!this.isLinkSupported(port, this.toPort)) {
            return;
        }
        if (this.fromPort != null) {
            PFDModel m;
            this.fromPort.removeLink(this);
            if (this.fromPort.getGroup() == null && (m = this.fromPort.getModel()) != null) {
                m.removePrimitive(this.fromPort);
            }
        }
        this.fromPort = port;
        if (this.fromPort != null) {
            this.fromPort.addLink(this);
        }
        this.firePropertyChange("fromPort");
    }

    public PFDPort getToPort() {
        return this.toPort;
    }

    public void setToPort(PFDPort port) {
        if (this.toPort == port) {
            return;
        }
        if (port != null && !port.isValidToPort()) {
            return;
        }
        if (!this.isLinkSupported(this.fromPort, port)) {
            return;
        }
        if (this.toPort != null) {
            PFDModel m;
            this.toPort.removeLink(this);
            if (this.toPort.getGroup() == null && this.toPort.getNumLinks() == 0 && (m = this.toPort.getModel()) != null) {
                m.removePrimitive(this.toPort);
            }
        }
        this.toPort = port;
        if (this.toPort != null) {
            this.toPort.addLink(this);
        }
        this.firePropertyChange("toPort");
    }

    public void resetPorts() {
        this.fromPort = null;
        this.toPort = null;
    }

    public boolean isToArrowVisible() {
        return this.toArrowVisible;
    }

    public void setToArrowVisible(boolean visible) {
        if (this.toArrowVisible == visible) {
            return;
        }
        this.toArrowVisible = visible;
        this.firePropertyChange("toArrowVisible");
    }

    public boolean isMiddleArrowVisible() {
        return this.middleArrowVisible;
    }

    public void setMiddleArrowVisible(boolean visible) {
        if (this.middleArrowVisible == visible) {
            return;
        }
        this.setCustomBreakPointsUsed(false);
        this.middleArrowVisible = visible;
        this.firePropertyChange("middleArrowVisible");
    }

    public boolean isFromArrowVisible() {
        return this.fromArrowVisible;
    }

    public void setFromArrowVisible(boolean visible) {
        if (this.fromArrowVisible == visible) {
            return;
        }
        this.fromArrowVisible = visible;
        this.firePropertyChange("fromArrowVisible");
    }

    public void setLabelsVisible(boolean visible) {
        this.setFromLabelVisible(visible);
        this.setToLabelVisible(visible);
        this.setMiddleLabelVisible(visible);
    }

    public boolean isFromLabelVisible() {
        return this.fromLabelVisible;
    }

    public void setFromLabelVisible(boolean visible) {
        if (this.fromLabelVisible == visible) {
            return;
        }
        this.fromLabelVisible = visible;
        if (this.fromLabel != null) {
            this.fromLabel.setVisible(this.fromLabelVisible);
        }
        this.firePropertyChange("fromLabelVisible");
    }

    public boolean isToLabelVisible() {
        return this.toLabelVisible;
    }

    public void setToLabelVisible(boolean visible) {
        if (this.toLabelVisible == visible) {
            return;
        }
        this.toLabelVisible = visible;
        if (this.toLabel != null) {
            this.toLabel.setVisible(this.toLabelVisible);
        }
        this.firePropertyChange("toLabelVisible");
    }

    public boolean isMiddleLabelVisible() {
        return this.middleLabelVisible;
    }

    public void setMiddleLabelVisible(boolean visible) {
        if (this.middleLabelVisible == visible) {
            return;
        }
        this.middleLabelVisible = visible;
        if (this.middleLabel != null) {
            this.middleLabel.setVisible(this.middleLabelVisible);
        }
        this.firePropertyChange("middleLabelVisible");
    }

    public void setMiddleLabelPosition(int position) {
        this.middleLabelPosition = position;
    }

    public String getFromLabel() {
        if (this.fromLabel != null) {
            return this.fromLabel.getText();
        }
        return null;
    }

    public void setFromLabel(String label) {
        if (this.getFromLabel() == label) {
            return;
        }
        if (label == null) {
            this.fromLabel = null;
        } else {
            this.fromLabel = new PFDLinkLabel(label);
            this.fromLabel.setLink(this);
            this.fromLabel.setVisible(this.fromLabelVisible);
        }
        this.firePropertyChange("fromLabel");
    }

    public String getToLabel() {
        if (this.toLabel != null) {
            return this.toLabel.getText();
        }
        return null;
    }

    public void setToLabel(String label) {
        if (this.getToLabel() == label) {
            return;
        }
        if (label == null) {
            this.toLabel = null;
        } else {
            this.toLabel = new PFDLinkLabel(label);
            this.toLabel.setLink(this);
            this.toLabel.setVisible(this.toLabelVisible);
        }
        this.firePropertyChange("toLabel");
    }

    public String getMiddleLabel() {
        if (this.middleLabel != null) {
            return this.middleLabel.getText();
        }
        return null;
    }

    public PFDLinkLabel getMiddleLabelObject() {
        return this.middleLabel;
    }

    public void setMiddleLabel(String label) {
        if (this.getMiddleLabel() == label) {
            return;
        }
        if (label == null) {
            this.middleLabel = null;
        } else {
            this.middleLabel = new PFDLinkLabel(label);
            this.middleLabel.setLink(this);
            this.middleLabel.setVisible(this.middleLabelVisible);
        }
        this.firePropertyChange("middleLabel");
    }

    @Override
    public boolean isOrthogonal() {
        return this.orthogonal;
    }

    @Override
    public void setOrthogonal(boolean b) {
        if (this.orthogonal == b) {
            return;
        }
        this.orthogonal = b;
        this.firePropertyChange("orthogonal");
    }

    public int getArrowShape() {
        return this.arrowShape;
    }

    public void setArrowShape(int shape) {
        if (this.arrowShape == shape) {
            return;
        }
        this.arrowShape = shape;
        this.firePropertyChange("arrowShape");
    }

    public float getArrowBase() {
        return this.arrowBase;
    }

    public void setArrowBase(float base) {
        if (this.arrowBase == base) {
            return;
        }
        this.arrowBase = base;
        this.firePropertyChange("arrowBase");
    }

    public float getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(float length) {
        if (this.arrowLength == length) {
            return;
        }
        this.arrowLength = length;
        this.firePropertyChange("arrowLength");
    }

    @Override
    public boolean contains(int x, int y) {
        for (int i = 0; i < this.segments.size(); ++i) {
            Shape segment = this.getSegment(i);
            if (segment == null || !segment.intersects(x - 3, y - 3, 7.0, 7.0)) continue;
            return true;
        }
        if (this.fromArrowVisible && this.fromArrow != null && this.fromArrow.contains(x, y)) {
            return true;
        }
        if (this.middleArrowVisible && this.middleArrow != null && this.middleArrow.contains(x, y)) {
            return true;
        }
        if (this.toArrowVisible && this.toArrow != null && this.toArrow.contains(x, y)) {
            return true;
        }
        if (this.buttonGroup.hasNoPrimitives()) {
            return false;
        }
        Point translate = this.getButtonsMouseTranslation(new Point(x, y));
        return this.buttonGroup.contains(x + translate.x, y + translate.y);
    }

    @Override
    public void update(String property, PFDView v) {
        if (property.equals("bbox") || property.equals("fromPort") || property.equals("toPort") || property.equals("orthogonal") || property.equals("freeStyleBreaks") || property.equals("breakPointChanged") || property.equals("all")) {
            this.linkChanged();
            this.arrowChanged();
            this.labelChanged();
            this.buttonsChanged();
            this.calculateBBox();
        } else if (property.equals("fromArrowVisible") || property.equals("middleArrowVisible") || property.equals("toArrowVisible") || property.equals("arrowShape") || property.equals("arrowLength") || property.equals("arrowBase")) {
            this.arrowChanged();
            this.calculateBBox();
        } else if (property.equals("fromLabel") || property.equals("toLabel") || property.equals("middleLabel")) {
            this.labelChanged();
        } else if (property.equals("buttons")) {
            this.buttonsChanged();
            this.calculateBBox();
        }
        super.update(property, v);
    }

    protected void updateCustomBreakPoints(int dx, int dy) {
        if (!this.freeStyleBreaks) {
            return;
        }
        for (int i = 0; i < this.breakPoints.size(); ++i) {
            Point p = (Point)this.breakPoints.elementAt(i);
            p.translate(dx, dy);
        }
    }

    protected void updateSelectedBreaks(int dx, int dy) {
        if (!this.freeStyleBreaks || !this.dragableBreaks) {
            return;
        }
        for (int i = 0; i < this.selectedBreaks.size(); ++i) {
            Point p = (Point)this.selectedBreaks.elementAt(i);
            p.translate(dx, dy);
        }
    }

    protected void linkChanged() {
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        this.points.removeAllElements();
        this.elbowPoints.removeAllElements();
        this.segments.removeAllElements();
        this.calculateEndPoints();
        this.points.addElement(this.fromPoint);
        if (this.useBreakPoints()) {
            this.addStartElbowPoint();
            this.addCustomElbowPoints();
            this.addEndElbowPoint();
        } else {
            this.addFixedElbowPoints();
        }
        this.points.addElement(this.toPoint);
        for (int i = 0; i < this.points.size() - 1; ++i) {
            this.segments.addElement(new Line2D.Double(this.getPoint((int)i).x, this.getPoint((int)i).y, this.getPoint((int)(i + 1)).x, this.getPoint((int)(i + 1)).y));
        }
    }

    protected double calculateDir(Point from, Point to) {
        int dx = to.x - from.x;
        int dy = to.y - from.y;
        double ang = 0.0;
        if (dx == 0) {
            if (dy > 0) {
                ang = 1.5707963267948966;
            } else if (dy < 0) {
                ang = -1.5707963267948966;
            }
        } else if (dy == 0) {
            if (dx > 0) {
                ang = 0.0;
            } else if (dx < 0) {
                ang = Math.PI;
            }
        } else {
            ang = dx > 0 && dy > 0 || dx > 0 && dy < 0 ? Math.atan((double)dy / (double)dx) : (dx < 0 && dy > 0 ? Math.PI - Math.atan(-((double)dy) / (double)dx) : Math.PI + Math.atan((double)dy / (double)dx));
        }
        return ang;
    }

    protected void arrowChanged() {
        AffineTransform r;
        double rot;
        float al;
        float aw;
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        float penWidth = ((BasicStroke)this.pen.getStroke()).getLineWidth();
        switch (this.arrowShape) {
            default: {
                aw = 2.0f * penWidth + this.arrowBase;
                al = aw / 4.0f + this.arrowLength;
                break;
            }
            case 1: {
                aw = this.arrowBase;
                al = this.arrowLength;
            }
        }
        if (this.fromArrowVisible) {
            this.fromArrow = new GeneralPath(0, 3);
            switch (this.arrowShape) {
                default: {
                    this.fromArrow.moveTo(this.fromPoint.x, this.fromPoint.y);
                    this.fromArrow.lineTo((float)this.fromPoint.x + al, (float)this.fromPoint.y - aw / 2.0f);
                    this.fromArrow.lineTo((float)this.fromPoint.x + 0.75f * al, this.fromPoint.y);
                    this.fromArrow.lineTo((float)this.fromPoint.x + al, (float)this.fromPoint.y + aw / 2.0f);
                    this.fromArrow.closePath();
                    break;
                }
                case 1: {
                    this.fromArrow.moveTo(this.fromPoint.x, this.fromPoint.y);
                    this.fromArrow.lineTo((float)this.fromPoint.x + al, (float)this.fromPoint.y - aw / 2.0f);
                    this.fromArrow.lineTo((float)this.fromPoint.x + al, (float)this.fromPoint.y + aw / 2.0f);
                    this.fromArrow.closePath();
                }
            }
            rot = Math.PI + this.calculateDir(this.firstElbowPoint(), this.fromPoint);
            r = AffineTransform.getRotateInstance(rot, this.fromPoint.x, this.fromPoint.y);
            this.fromArrow.transform(r);
        }
        if (this.toArrowVisible) {
            this.toArrow = new GeneralPath(0, 3);
            switch (this.arrowShape) {
                default: {
                    this.toArrow.moveTo(this.toPoint.x, this.toPoint.y);
                    this.toArrow.lineTo((float)this.toPoint.x - al, (float)this.toPoint.y - aw / 2.0f);
                    this.toArrow.lineTo((float)this.toPoint.x - 0.75f * al, this.toPoint.y);
                    this.toArrow.lineTo((float)this.toPoint.x - al, (float)this.toPoint.y + aw / 2.0f);
                    this.toArrow.closePath();
                    break;
                }
                case 1: {
                    this.toArrow.moveTo(this.toPoint.x, this.toPoint.y);
                    this.toArrow.lineTo((float)this.toPoint.x - al, (float)this.toPoint.y - aw / 2.0f);
                    this.toArrow.lineTo((float)this.toPoint.x - al, (float)this.toPoint.y + aw / 2.0f);
                    this.toArrow.closePath();
                }
            }
            rot = this.calculateDir(this.lastElbowPoint(), this.toPoint);
            r = AffineTransform.getRotateInstance(rot, this.toPoint.x, this.toPoint.y);
            this.toArrow.transform(r);
        }
        if (this.middleArrowVisible) {
            if (this.useBreakPoints()) {
                return;
            }
            this.middleArrow = new GeneralPath(0, 3);
            float xc = (this.firstElbowPoint().x + this.lastElbowPoint().x) / 2;
            float yc = (this.firstElbowPoint().y + this.lastElbowPoint().y) / 2;
            switch (this.arrowShape) {
                default: {
                    this.middleArrow.moveTo(xc, yc);
                    this.middleArrow.lineTo(xc - al, yc - aw / 2.0f);
                    this.middleArrow.lineTo(xc - 0.75f * al, yc);
                    this.middleArrow.lineTo(xc - al, yc + aw / 2.0f);
                    this.middleArrow.closePath();
                    break;
                }
                case 1: {
                    this.middleArrow.moveTo(xc, yc);
                    this.middleArrow.lineTo(xc - al, yc - aw / 2.0f);
                    this.middleArrow.lineTo(xc - al, yc + aw / 2.0f);
                    this.middleArrow.closePath();
                }
            }
            double rot2 = Math.PI + this.calculateDir(this.lastElbowPoint(), this.firstElbowPoint());
            AffineTransform r2 = AffineTransform.getRotateInstance(rot2, xc, yc);
            this.middleArrow.transform(r2);
        }
    }

    protected void labelChanged() {
        if (this.fromLabel == null && this.toLabel == null && this.middleLabel == null) {
            return;
        }
        PFDModel m = this.getModel();
        if (m == null) {
            return;
        }
        if (this.fromLabel != null) {
            this.fromLabel.disableChangeUpdate();
            this.fromLabel.setHorizontalAlignment(1);
            this.fromLabel.setVerticalAlignment(2);
            this.fromLabel.enableChangeUpdate();
            this.fromLabel.setBBox(this.fromPoint.x + 3, this.fromPoint.y - 3, 0, 0);
            if (!m.containsPrimitive(this.fromLabel)) {
                m.addPrimitive(this.fromLabel);
            }
        }
        if (this.toLabel != null) {
            this.toLabel.disableChangeUpdate();
            this.toLabel.setHorizontalAlignment(2);
            this.toLabel.setVerticalAlignment(1);
            this.toLabel.enableChangeUpdate();
            this.toLabel.setBBox(this.toPoint.x - 3, this.toPoint.y + 3, 0, 0);
            if (!m.containsPrimitive(this.toLabel)) {
                m.addPrimitive(this.toLabel);
            }
        }
        if (this.middleLabel != null) {
            if (!m.containsPrimitive(this.middleLabel)) {
                m.addPrimitive(this.middleLabel);
            }
            if (this.elbowPoints != null && !this.elbowPoints.isEmpty()) {
                Point labelPos = new Point();
                if (this.elbowPoints.size() < 2) {
                    labelPos = (Point)this.elbowPoints.get(0);
                } else {
                    int numPoints = this.elbowPoints.size();
                    Point p1 = (Point)this.elbowPoints.get(numPoints / 2 - 1);
                    Point p2 = (Point)this.elbowPoints.get(numPoints / 2);
                    labelPos.x = (p1.x + p2.x) / 2;
                    labelPos.y = (p1.y + p2.y) / 2;
                    if (this.middleLabelPosition != 0) {
                        Rectangle label_bbox = this.middleLabel.getBBox();
                        if (p1.y < p2.y) {
                            labelPos.x = p1.x < p2.x ? (labelPos.x += label_bbox.width / 2) : (labelPos.x -= label_bbox.width / 2);
                        } else if (p1.y > p2.y) {
                            labelPos.x = p1.x < p2.x ? (labelPos.x -= label_bbox.width / 2) : (labelPos.x += label_bbox.width / 2);
                        }
                        labelPos.y = this.middleLabelPosition == 3 ? (labelPos.y += label_bbox.height / 2) : (labelPos.y -= label_bbox.height / 2);
                    }
                }
                this.middleLabel.disableChangeUpdate();
                this.middleLabel.setHorizontalAlignment(0);
                this.middleLabel.setVerticalAlignment(0);
                this.middleLabel.enableChangeUpdate();
                this.middleLabel.setBBox(labelPos.x, labelPos.y, 0, 0);
            }
        }
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
            this.draw(g2d);
            g2d.setComposite(oldComposite);
        } else {
            this.draw(g2d);
        }
    }

    private void draw(Graphics2D g2d) {
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        if (this.segments.size() > 2) {
            BasicStroke stroke = new BasicStroke(this.fromElbowLineWidth);
            g2d.setColor(this.pen.getColor());
            g2d.setStroke(stroke);
            g2d.draw(this.getSegment(0));
            stroke = new BasicStroke(this.toElbowLineWidth);
            g2d.setStroke(stroke);
            g2d.draw(this.getSegment(this.segments.size() - 1));
            this.pen.apply(g2d);
            for (int i = 1; i < this.segments.size() - 1; ++i) {
                g2d.draw(this.getSegment(i));
            }
        } else {
            this.pen.apply(g2d);
            for (int i = 0; i < this.segments.size(); ++i) {
                g2d.draw(this.getSegment(i));
            }
        }
        Object oldHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.fromArrowVisible && this.fromArrow != null) {
            g2d.fill(this.fromArrow);
        }
        if (this.middleArrowVisible && this.middleArrow != null) {
            g2d.fill(this.middleArrow);
        }
        if (this.toArrowVisible && this.toArrow != null) {
            g2d.fill(this.toArrow);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        g2d.setStroke(new BasicStroke(1.0f));
        if (this.fromArrowVisible && this.fromArrow != null) {
            g2d.draw(this.fromArrow);
        }
        if (this.middleArrowVisible && this.middleArrow != null) {
            g2d.draw(this.middleArrow);
        }
        if (this.toArrowVisible && this.toArrow != null) {
            g2d.draw(this.toArrow);
        }
        this.drawButtons(g2d);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible || this.fromPort == null || this.toPort == null) {
            return;
        }
        g2d.setColor(this.pen.getColor());
        for (int i = 0; i < this.segments.size(); ++i) {
            g2d.draw(this.getSegment(i));
        }
    }

    private void drawButtons(Graphics2D g2d) {
        if (this.buttonGroup.hasNoPrimitives()) {
            return;
        }
        AffineTransform oldTransform = new AffineTransform(g2d.getTransform());
        g2d.transform(this.buttonTransform);
        this.buttonGroup.paint(g2d);
        g2d.setTransform(oldTransform);
    }

    protected boolean isStartPoint(int x, int y) {
        Point pt = this.firstElbowPoint();
        double dist = (x - pt.x) * (x - pt.x) + (y - pt.y) * (y - pt.y);
        return (dist = Math.sqrt(dist)) < 5.0;
    }

    protected boolean isEndPoint(int x, int y) {
        Point pt = this.lastElbowPoint();
        double dist = (x - pt.x) * (x - pt.x) + (y - pt.y) * (y - pt.y);
        return (dist = Math.sqrt(dist)) < 5.0;
    }

    protected boolean isBreakPoint(int x, int y) {
        if (!this.useBreakPoints()) {
            return false;
        }
        for (int i = 0; i < this.breakPoints.size(); ++i) {
            Point pt = (Point)this.breakPoints.elementAt(i);
            double dist = (x - pt.x) * (x - pt.x) + (y - pt.y) * (y - pt.y);
            if (!((dist = Math.sqrt(dist)) < 5.0)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectedBreak(int x, int y) {
        if (!this.freeStyleBreaks || !this.dragableBreaks || this.selectedBreaks == null || this.selectedBreaks.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.selectedBreaks.size(); ++i) {
            Point pt = (Point)this.selectedBreaks.elementAt(i);
            double dist = (x - pt.x) * (x - pt.x) + (y - pt.y) * (y - pt.y);
            if (!((dist = Math.sqrt(dist)) < 5.0)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectedBreak(int elbowPointIndex) {
        return this.selectedBreaks.contains(this.getElbowPoint(elbowPointIndex));
    }

    public void selectBreakPoint(int x, int y, boolean toggle) {
        if (!this.useBreakPoints() || !this.dragableBreaks) {
            return;
        }
        for (int i = 0; i < this.breakPoints.size(); ++i) {
            Point pt = (Point)this.breakPoints.elementAt(i);
            double dist = (x - pt.x) * (x - pt.x) + (y - pt.y) * (y - pt.y);
            if (!((dist = Math.sqrt(dist)) < 5.0)) continue;
            if (!this.selectedBreaks.contains(pt)) {
                this.selectedBreaks.addElement(pt);
            } else if (toggle) {
                this.selectedBreaks.removeElement(pt);
            }
            return;
        }
    }

    public void clearSelectedBreaks() {
        this.selectedBreaks.clear();
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDLink clone = new PFDLink();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDLink toObject) {
        super.copyObject(toObject);
        toObject.setIsControl(this.isControl());
        toObject.setIsCollapsed(this.isCollapsed());
        toObject.setFromArrowVisible(this.isFromArrowVisible());
        toObject.setMiddleArrowVisible(this.isMiddleArrowVisible());
        toObject.setToArrowVisible(this.isToArrowVisible());
        toObject.setFromLabel(this.getFromLabel());
        toObject.setMiddleLabel(this.getMiddleLabel());
        toObject.setToLabel(this.getToLabel());
        toObject.setOrthogonal(this.isOrthogonal());
        toObject.setArrowBase(this.getArrowBase());
        toObject.setArrowLength(this.getArrowLength());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("lineWidth")) {
            this.arrowChanged();
        }
    }

    @Override
    protected void removeAssociation() {
        PFDModel m;
        if (this.fromPort != null) {
            this.fromPort.removeLink(this);
        }
        if (this.toPort != null) {
            this.toPort.removeLink(this);
        }
        if (this.fromLabel != null && (m = this.fromLabel.getModel()) != null && m.containsPrimitive(this.fromLabel)) {
            m.removePrimitive(this.fromLabel);
        }
        if (this.middleLabel != null && (m = this.middleLabel.getModel()) != null && m.containsPrimitive(this.middleLabel)) {
            m.removePrimitive(this.middleLabel);
        }
        if (this.toLabel != null && (m = this.toLabel.getModel()) != null && m.containsPrimitive(this.toLabel)) {
            m.removePrimitive(this.toLabel);
        }
        if ((m = this.getModel()) == null || m != null && !m.getForceNodePosition()) {
            NodeLayoutInterface toNode;
            NodeLayoutInterface fromNode = this.getTopFromNode();
            if (fromNode != null) {
                fromNode.setNodePlaced(false);
            }
            if ((toNode = this.getTopToNode()) != null) {
                toNode.setNodePlaced(false);
            }
        }
    }

    @Override
    public NodeLayoutInterface getFromNode() {
        if (this.fromPort == null) {
            return null;
        }
        return this.fromPort.getParentNode();
    }

    @Override
    public NodeLayoutInterface getToNode() {
        if (this.toPort == null) {
            return null;
        }
        return this.toPort.getParentNode();
    }

    @Override
    public NodeLayoutInterface getTopFromNode() {
        if (this.fromPort == null) {
            return null;
        }
        return this.fromPort.getTopParentNode();
    }

    @Override
    public NodeLayoutInterface getTopToNode() {
        if (this.toPort == null) {
            return null;
        }
        return this.toPort.getTopParentNode();
    }

    private Shape getSegment(int i) {
        return (Shape)this.segments.elementAt(i);
    }

    protected Point getPoint(int i) {
        return (Point)this.points.elementAt(i);
    }

    private Point getElbowPoint(int i) {
        return (Point)this.elbowPoints.elementAt(i);
    }

    protected Point firstElbowPoint() {
        return (Point)this.elbowPoints.firstElement();
    }

    protected Point lastElbowPoint() {
        return (Point)this.elbowPoints.lastElement();
    }

    private Point firstBreakPoint() {
        return (Point)this.breakPoints.firstElement();
    }

    private Point lastBreakPoint() {
        return (Point)this.breakPoints.lastElement();
    }

    protected void calculateEndPoints() {
        if (this.useBreakPoints()) {
            this.fromPort.getFromLinkPoint(this.firstBreakPoint(), this.fromPoint);
            this.toPort.getToLinkPoint(this.lastBreakPoint(), this.toPoint);
            return;
        }
        int fromSpot = this.fromPort.getFromLinkSpot();
        int toSpot = this.toPort.getToLinkSpot();
        if (fromSpot != 9 && toSpot != 9) {
            this.fromPort.getFromLinkPoint(this.fromPoint);
            this.toPort.getToLinkPoint(this.toPoint);
        } else if (!this.orthogonal) {
            this.fromPort.getSpotLocation(0, this.fromPoint);
            this.toPort.getLinkPointFromPoint(this.fromPoint, this.toPoint);
            this.fromPort.getLinkPointFromPoint(this.toPoint, this.fromPoint);
        } else {
            Point pf = new Point();
            Point pt = new Point();
            this.fromPort.getSpotLocation(0, pf);
            this.toPort.getSpotLocation(0, pt);
            if (fromSpot == 9) {
                if (toSpot == 9) {
                    this.fromPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.fromPoint);
                    this.toPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.toPoint);
                } else {
                    double dir = this.toPort.getToLinkDirection();
                    if (dir == 0.0 || dir == Math.PI) {
                        this.fromPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.fromPoint);
                        this.toPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.toPoint);
                    } else if (dir == 1.5707963267948966 || dir == 4.71238898038469) {
                        this.fromPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.fromPoint);
                        this.toPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.toPoint);
                    } else {
                        this.fromPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.fromPoint);
                        this.toPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.toPoint);
                    }
                }
            } else {
                double dir = this.fromPort.getFromLinkDirection();
                if (dir == 0.0 || dir == Math.PI) {
                    this.fromPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.fromPoint);
                    this.toPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.toPoint);
                } else if (dir == 1.5707963267948966 || dir == 4.71238898038469) {
                    this.fromPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.fromPoint);
                    this.toPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.toPoint);
                } else {
                    this.fromPort.getLinkPointFromPoint(new Point(pt.x, pf.y), this.fromPoint);
                    this.toPort.getLinkPointFromPoint(new Point(pf.x, pt.y), this.toPoint);
                }
            }
        }
    }

    protected void calculateBBox() {
        if (this.fromPort == null || this.toPort == null) {
            return;
        }
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = this.getPoint(i);
            if (p.x < xmin) {
                xmin = p.x;
            }
            if (p.y < ymin) {
                ymin = p.y;
            }
            if (p.x > xmax) {
                xmax = p.x;
            }
            if (p.y <= ymax) continue;
            ymax = p.y;
        }
        this.bbox.x = xmin;
        this.bbox.y = ymin;
        this.bbox.width = Math.max(xmax - xmin, 1);
        this.bbox.height = Math.max(ymax - ymin, 1);
        this.oldVisualBBox.setBounds(this.visualBBox);
        this.visualBBox.setBounds(this.bbox);
        if (this.fromArrowVisible && this.fromArrow != null) {
            this.visualBBox.add(this.padBounds(this.fromArrow.getBounds(), 1));
        }
        if (this.middleArrowVisible && this.middleArrow != null) {
            this.visualBBox.add(this.padBounds(this.middleArrow.getBounds(), 1));
        }
        if (this.toArrowVisible && this.toArrow != null) {
            this.visualBBox.add(this.padBounds(this.toArrow.getBounds(), 1));
        }
        if (this.segments.size() > 2) {
            if ((double)this.fromElbowLineWidth > 1.0) {
                Shape fromElbow = this.getSegment(0);
                Rectangle fromElbowBounds = fromElbow.getBounds();
                if (fromElbowBounds.width > 0 || fromElbowBounds.height > 0) {
                    ++fromElbowBounds.width;
                    ++fromElbowBounds.height;
                    this.visualBBox.add(this.padBounds(fromElbowBounds, (int)(this.fromElbowLineWidth / 2.0f)));
                }
            }
            if ((double)this.toElbowLineWidth > 1.0) {
                Shape toElbow = this.getSegment(this.segments.size() - 1);
                Rectangle toElbowBounds = toElbow.getBounds();
                if (toElbowBounds.width > 0 || toElbowBounds.height > 0) {
                    ++toElbowBounds.width;
                    ++toElbowBounds.height;
                    this.visualBBox.add(this.padBounds(toElbowBounds, (int)(this.toElbowLineWidth / 2.0f)));
                }
            }
        }
        if (this.buttonGroup.visible && !this.buttonGroup.hasNoPrimitives()) {
            this.visualBBox.add(this.buttonGroup.getVisualRBBox());
        }
    }

    private Rectangle padBounds(Rectangle r, int padding) {
        if (r != null) {
            r.x -= padding;
            r.y -= padding;
            r.width += padding * 2;
            r.height += padding * 2;
        }
        return r;
    }

    protected void addFixedElbowPoints() {
        if (this.orthogonal) {
            this.addOrthogonalElbowPoints();
        } else {
            this.addPortDrivenElbowPoints();
        }
    }

    private void addPortDrivenElbowPoints() {
        int fromLen = this.fromPort.getEndSegmentLength() - (int)(this.fromElbowLineWidth / 2.0f);
        int toLen = this.toPort.getEndSegmentLength() - (int)(this.toElbowLineWidth / 2.0f);
        int fromSpot = this.fromPort.getFromLinkSpot();
        int toSpot = this.toPort.getToLinkSpot();
        int dx = 0;
        int dy = 0;
        double theta = 0.0;
        if (fromSpot == 9) {
            if (toSpot == 9) {
                theta = this.calculateDir(this.fromPoint, this.toPoint);
                dx = (int)((double)fromLen * Math.cos(theta));
                dy = (int)((double)fromLen * Math.sin(theta));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y + dy));
                dx = (int)((double)toLen * Math.cos(theta += Math.PI));
                dy = (int)((double)toLen * Math.sin(theta));
                this.points.addElement(new Point(this.toPoint.x + dx, this.toPoint.y + dy));
            } else {
                dx = (int)((double)toLen * Math.cos(Math.PI + this.toPort.getToLinkDirection()));
                dy = (int)((double)toLen * Math.sin(Math.PI + this.toPort.getToLinkDirection()));
                Point pt = new Point(this.toPoint.x + dx, this.toPoint.y - dy);
                theta = this.calculateDir(this.fromPoint, pt);
                dx = (int)((double)fromLen * Math.cos(theta));
                dy = (int)((double)fromLen * Math.sin(theta));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y + dy));
                this.points.addElement(pt);
            }
        } else {
            dx = (int)((double)fromLen * Math.cos(this.fromPort.getFromLinkDirection()));
            dy = (int)((double)fromLen * Math.sin(this.fromPort.getFromLinkDirection()));
            Point pt = new Point(this.fromPoint.x + dx, this.fromPoint.y - dy);
            this.points.addElement(pt);
            if (toSpot == 9) {
                theta = this.calculateDir(this.toPoint, pt);
                dx = (int)((double)toLen * Math.cos(theta));
                dy = (int)((double)toLen * Math.sin(theta));
                this.points.addElement(new Point(this.toPoint.x + dx, this.toPoint.y + dy));
            } else {
                dx = (int)((double)toLen * Math.cos(Math.PI + this.toPort.getToLinkDirection()));
                dy = (int)((double)toLen * Math.sin(Math.PI + this.toPort.getToLinkDirection()));
                this.points.addElement(new Point(this.toPoint.x + dx, this.toPoint.y - dy));
            }
        }
        this.elbowPoints.addElement(this.getPoint(1));
        this.elbowPoints.addElement(this.getPoint(2));
    }

    private void addOrthogonalElbowPoints() {
        int fromSpot = this.fromPort.getFromLinkSpot();
        int toSpot = this.toPort.getToLinkSpot();
        double fromDir = this.fromPort.getFromLinkDirection();
        double toDir = this.toPort.getToLinkDirection();
        if (fromSpot == 9) {
            if (toSpot == 9) {
                int dx = (this.toPoint.x - this.fromPoint.x) / 2;
                int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dx) / 2);
                int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dx) / 2);
                if (dx < 0) {
                    fromLen = -fromLen;
                    toLen = -toLen;
                }
                this.points.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
                this.points.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
            } else if (toDir == 0.0 || toDir == Math.PI) {
                int dx = (this.toPoint.x - this.fromPoint.x) / 2;
                int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dx) / 2);
                int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dx) / 2);
                if (dx < 0) {
                    fromLen = -fromLen;
                    toLen = -toLen;
                }
                this.points.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
                this.points.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
            } else if (toDir == 1.5707963267948966 || toDir == 4.71238898038469) {
                int dy = (this.toPoint.y - this.fromPoint.y) / 2;
                int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dy) / 2);
                int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dy) / 2);
                if (dy < 0) {
                    fromLen = -fromLen;
                    toLen = -toLen;
                }
                this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
                this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
                this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
                this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
                this.points.addElement(new Point(this.toPoint.x, this.fromPoint.y + dy));
                this.elbowPoints.addElement(new Point(this.toPoint.x, this.fromPoint.y + dy));
                this.points.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
                this.elbowPoints.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
            } else {
                this.points.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.toPoint.y));
            }
        } else if (toSpot == 9) {
            if (fromDir == 0.0 || fromDir == Math.PI) {
                int dx = (this.toPoint.x - this.fromPoint.x) / 2;
                int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dx) / 2);
                int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dx) / 2);
                if (dx < 0) {
                    fromLen = -fromLen;
                    toLen = -toLen;
                }
                this.points.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
                this.points.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
            } else if (fromDir == 1.5707963267948966 || fromDir == 4.71238898038469) {
                int dy = (this.toPoint.y - this.fromPoint.y) / 2;
                int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dy) / 2);
                int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dy) / 2);
                if (dy < 0) {
                    fromLen = -fromLen;
                    toLen = -toLen;
                }
                this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
                this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
                this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
                this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
                this.points.addElement(new Point(this.toPoint.x, this.fromPoint.y + dy));
                this.elbowPoints.addElement(new Point(this.toPoint.x, this.fromPoint.y + dy));
                this.points.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
                this.elbowPoints.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
            } else {
                this.points.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.fromPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.fromPoint.y));
                this.points.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.toPoint.y));
                this.elbowPoints.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.toPoint.y));
            }
        } else if (!(fromDir != 0.0 && fromDir != Math.PI || toDir != 0.0 && toDir != Math.PI)) {
            int dx = (this.toPoint.x - this.fromPoint.x) / 2;
            int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dx) / 2);
            int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dx) / 2);
            if (fromDir == Math.PI) {
                fromLen = -fromLen;
            }
            if (toDir == Math.PI) {
                toLen = -toLen;
            }
            this.points.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
            this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
            this.points.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y));
            this.points.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
            this.elbowPoints.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
        } else if (!(fromDir != 1.5707963267948966 && fromDir != 4.71238898038469 || toDir != 1.5707963267948966 && toDir != 4.71238898038469)) {
            int dy = (this.toPoint.y - this.fromPoint.y) / 2;
            int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dy) / 2);
            int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dy) / 2);
            if (fromDir == 1.5707963267948966) {
                fromLen = -fromLen;
            }
            if (toDir == 1.5707963267948966) {
                toLen = -toLen;
            }
            this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
            this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
            this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
            this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
            this.points.addElement(new Point(this.toPoint.x, this.fromPoint.y + dy));
            this.elbowPoints.addElement(new Point(this.toPoint.x, this.fromPoint.y + dy));
            this.points.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
            this.elbowPoints.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
        } else if (!(fromDir != 0.0 && fromDir != Math.PI || toDir != 1.5707963267948966 && toDir != 4.71238898038469)) {
            int dx = (this.toPoint.x - this.fromPoint.x) / 2;
            int dy = (this.toPoint.y - this.fromPoint.y) / 2;
            int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dx) / 2);
            int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dy) / 2);
            if (fromDir == Math.PI) {
                fromLen = -fromLen;
            }
            if (toDir == 1.5707963267948966) {
                toLen = -toLen;
            }
            this.points.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + fromLen, this.fromPoint.y));
            this.points.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.fromPoint.y));
            this.points.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y - toLen));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + dx, this.toPoint.y - toLen));
            this.points.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
            this.elbowPoints.addElement(new Point(this.toPoint.x, this.toPoint.y - toLen));
        } else if (!(fromDir != 1.5707963267948966 && fromDir != 4.71238898038469 || toDir != 0.0 && toDir != Math.PI)) {
            int dx = (this.toPoint.x - this.fromPoint.x) / 2;
            int dy = (this.toPoint.y - this.fromPoint.y) / 2;
            int fromLen = Math.min(this.fromPort.getEndSegmentLength(), Math.abs(dy) / 2);
            int toLen = Math.min(this.toPort.getEndSegmentLength(), Math.abs(dx) / 2);
            if (fromDir == 1.5707963267948966) {
                fromLen = -fromLen;
            }
            if (toDir == Math.PI) {
                toLen = -toLen;
            }
            this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
            this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + fromLen));
            this.points.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
            this.elbowPoints.addElement(new Point(this.fromPoint.x, this.fromPoint.y + dy));
            this.points.addElement(new Point(this.toPoint.x - toLen, this.fromPoint.y + dy));
            this.elbowPoints.addElement(new Point(this.toPoint.x - toLen, this.fromPoint.y + dy));
            this.points.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
            this.elbowPoints.addElement(new Point(this.toPoint.x - toLen, this.toPoint.y));
        } else {
            this.points.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.fromPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.fromPoint.y));
            this.points.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.toPoint.y));
            this.elbowPoints.addElement(new Point(this.fromPoint.x + (this.toPoint.x - this.fromPoint.x) / 2, this.toPoint.y));
        }
    }

    protected void addCustomElbowPoints() {
        for (int i = 0; i < this.breakPoints.size(); ++i) {
            this.points.addElement(this.getBreakPoint(i));
            this.elbowPoints.addElement(this.getBreakPoint(i));
        }
    }

    protected void addStartElbowPoint() {
        Point pt;
        Point first = this.firstBreakPoint();
        int fromLen = this.fromPort.getEndSegmentLength();
        int len = (int)Math.sqrt((first.x - this.fromPoint.x) * (first.x - this.fromPoint.x) + (first.y - this.fromPoint.y) * (first.y - this.fromPoint.y));
        fromLen = Math.min(fromLen, len / 2);
        int fromSpot = this.fromPort.getFromLinkSpot();
        int dx = 0;
        int dy = 0;
        double theta = 0.0;
        if (fromSpot == 9) {
            theta = this.calculateDir(this.fromPoint, first);
            dx = (int)((double)fromLen * Math.cos(theta));
            dy = (int)((double)fromLen * Math.sin(theta));
            pt = new Point(this.fromPoint.x + dx, this.fromPoint.y + dy);
        } else {
            dx = (int)((double)fromLen * Math.cos(this.fromPort.getFromLinkDirection()));
            dy = (int)((double)fromLen * Math.sin(this.fromPort.getFromLinkDirection()));
            pt = new Point(this.fromPoint.x + dx, this.fromPoint.y - dy);
        }
        this.points.addElement(pt);
        this.elbowPoints.addElement(pt);
    }

    protected void addEndElbowPoint() {
        Point pt;
        Point last = this.lastBreakPoint();
        int toLen = this.toPort.getEndSegmentLength();
        int len = (int)Math.sqrt((last.x - this.toPoint.x) * (last.x - this.toPoint.x) + (last.y - this.toPoint.y) * (last.y - this.toPoint.y));
        toLen = Math.min(toLen, len / 2);
        int toSpot = this.toPort.getToLinkSpot();
        int dx = 0;
        int dy = 0;
        double theta = 0.0;
        if (toSpot == 9) {
            theta = this.calculateDir(this.toPoint, last);
            dx = (int)((double)toLen * Math.cos(theta));
            dy = (int)((double)toLen * Math.sin(theta));
            pt = new Point(this.toPoint.x + dx, this.toPoint.y + dy);
        } else {
            dx = (int)((double)toLen * Math.cos(Math.PI + this.toPort.getToLinkDirection()));
            dy = (int)((double)toLen * Math.sin(Math.PI + this.toPort.getToLinkDirection()));
            pt = new Point(this.toPoint.x + dx, this.toPoint.y - dy);
        }
        this.points.addElement(pt);
        this.elbowPoints.addElement(pt);
    }

    public Point[] getElbowPoints() {
        Object[] pts = new Point[this.elbowPoints.size()];
        this.elbowPoints.copyInto(pts);
        return pts;
    }

    @Override
    public Point[] getBreakPoints() {
        Object[] pts = new Point[this.breakPoints.size()];
        this.breakPoints.copyInto(pts);
        return pts;
    }

    @Override
    public int getNumBreakPoints() {
        return this.breakPoints.size();
    }

    public Point[] getSelectedBreaks() {
        Object[] pts = new Point[this.selectedBreaks.size()];
        this.selectedBreaks.copyInto(pts);
        return pts;
    }

    public int getNumSelectedBreaks() {
        return this.selectedBreaks.size();
    }

    @Override
    public boolean isCustomBreakPointsUsed() {
        return this.freeStyleBreaks;
    }

    public boolean isCustomBreakPointsDragable() {
        return this.dragableBreaks;
    }

    @Override
    public void setCustomBreakPointsUsed(boolean b) {
        if (this.freeStyleBreaks == b) {
            return;
        }
        this.freeStyleBreaks = b;
        if (!this.freeStyleBreaks) {
            this.firePropertyChange("freeStyleBreaks");
        }
    }

    public void setCustomBreakPointsDragable(boolean b) {
        if (this.dragableBreaks == b) {
            return;
        }
        this.dragableBreaks = b;
    }

    @Override
    public void addBreakPoint(Point p) {
        if (!this.freeStyleBreaks) {
            return;
        }
        this.breakPoints.addElement(p);
        this.firePropertyChange("breakPointChanged");
    }

    @Override
    public void insertBreakPointAt(Point p, int index) {
        if (!this.freeStyleBreaks) {
            return;
        }
        this.breakPoints.insertElementAt(p, index);
        this.firePropertyChange("breakPointChanged");
    }

    @Override
    public void removeBreakPoint(Point p) {
        if (!this.freeStyleBreaks) {
            return;
        }
        this.breakPoints.removeElement(p);
        this.firePropertyChange("breakPointChanged");
    }

    @Override
    public void removeBreakPointAt(int index) {
        if (!this.freeStyleBreaks) {
            return;
        }
        this.breakPoints.removeElementAt(index);
        this.firePropertyChange("breakPointChanged");
    }

    @Override
    public void removeAllBreakPoints() {
        if (!this.useBreakPoints()) {
            return;
        }
        this.breakPoints.removeAllElements();
        this.firePropertyChange("breakPointChanged");
    }

    @Override
    public void resetBreakPoints() {
        if (this.isCustomBreakPointsUsed()) {
            this.removeAllBreakPoints();
            this.setCustomBreakPointsUsed(false);
        }
        this.resetCollapsedBreakPoints();
        this.resetExpandedCollapsedBreakPoints();
    }

    public void setCollapsedBreakPoints(Point[] breaks) {
        this.collapsedBreaks.removeAllElements();
        if (breaks != null) {
            for (int i = 0; i < breaks.length; ++i) {
                this.collapsedBreaks.add(breaks[i]);
            }
        }
    }

    public void setCollapsedBreakPoints(PFDLink link) {
        this.collapsedBreaks.removeAllElements();
        if (link != null && link.isCustomBreakPointsUsed() && link.getNumBreakPoints() > 0) {
            int n = link.getNumBreakPoints();
            for (int i = 0; i < n; ++i) {
                Point bp = link.getBreakPoint(i);
                this.collapsedBreaks.add(new Point(bp));
            }
        }
    }

    public Point[] getCollapsedBreakPoints() {
        PFDLink collapsedLink;
        if (this.collapsedBreaks.isEmpty() && (collapsedLink = PFDSubdiagram.getCollapsedLink(this)) != null && collapsedLink.isCustomBreakPointsUsed() && collapsedLink.getNumBreakPoints() > 0) {
            this.setCollapsedBreakPoints(collapsedLink);
        }
        Object[] pts = new Point[this.collapsedBreaks.size()];
        this.collapsedBreaks.copyInto(pts);
        return pts;
    }

    public void resetCollapsedBreakPoints() {
        this.collapsedBreaks.removeAllElements();
    }

    private void resetExpandedCollapsedBreakPoints() {
        if (this.isCollapsed) {
            List expandedList = PFDSubdiagram.getExpandedLinks(this);
            if (expandedList != null) {
                for (PFDLink expandedLink : expandedList) {
                    if (!expandedLink.isCustomBreakPointsUsed()) continue;
                    expandedLink.removeAllBreakPoints();
                    expandedLink.setCustomBreakPointsUsed(false);
                }
            }
        } else {
            PFDLink collapsedLink = PFDSubdiagram.getCollapsedLink(this);
            if (collapsedLink != null && collapsedLink.isCustomBreakPointsUsed()) {
                collapsedLink.removeAllBreakPoints();
                collapsedLink.setCustomBreakPointsUsed(false);
            }
        }
    }

    @Override
    public Point getBreakPoint(int index) {
        return (Point)this.breakPoints.elementAt(index);
    }

    @Override
    public void moveBreakPoint(Point p, int dx, int dy) {
        if (!this.breakPoints.contains(p)) {
            return;
        }
        p.x += dx;
        p.y += dy;
        this.firePropertyChange("breakPointChanged");
    }

    protected boolean useBreakPoints() {
        return this.freeStyleBreaks && this.breakPoints != null && !this.breakPoints.isEmpty();
    }

    @Override
    public void getFromLinkPoint(Point p1, Point p2) {
        this.fromPort.getFromLinkPoint(p1, p2);
    }

    @Override
    public void getToLinkPoint(Point p1, Point p2) {
        this.toPort.getToLinkPoint(p1, p2);
    }

    public float getFromElbowLineWidth() {
        return this.fromElbowLineWidth;
    }

    public void setFromElbowLineWidth(float width) {
        this.fromElbowLineWidth = width;
    }

    public float getToElbowLineWidth() {
        return this.toElbowLineWidth;
    }

    public void setToElbowLineWidth(float width) {
        this.toElbowLineWidth = width;
    }

    @Override
    public void setToNode(NodeLayoutInterface node, String name) {
        PFDPort port;
        if (node instanceof PFDAbstractNode && (port = ((PFDAbstractNode)node).getPort(name)) != null) {
            this.setToPort(port);
        }
    }

    @Override
    public void setFromNode(NodeLayoutInterface node, String name) {
        PFDPort port;
        if (node instanceof PFDAbstractNode && (port = ((PFDAbstractNode)node).getPort(name)) != null) {
            this.setFromPort(port);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            int mouseMode = this.theView.getMouseExtendedMode();
            if (this.selectable) {
                if (mouseMode == 4) {
                    if (!this.theView.isSelected(this)) {
                        this.theView.clearSelections();
                        this.theView.selectPrimitive(this);
                    }
                } else if (this.dragableBreaks && this.isBreakPoint(e.getX(), e.getY())) {
                    this.theView.selectPrimitive(this);
                    this.selectBreakPoint(e.getX(), e.getY(), e.isControlDown());
                    if (this.theView.isEditMode() && this.draggable) {
                        this.theView.setDragMode(0);
                    }
                } else if (mouseMode == 2) {
                    if (this.theView.isSelected(this)) {
                        this.theView.deselectPrimitive(this);
                    } else {
                        this.theView.selectPrimitive(this);
                        if (this.theView.isEditMode() && this.draggable) {
                            this.theView.setDragMode(0);
                        }
                    }
                } else if (this.isStartPoint(e.getX(), e.getY())) {
                    this.theView.clearSelections();
                    this.theView.selectPrimitive(this);
                    if (this.theView.isEditMode() && this.draggable) {
                        this.beginRedirect();
                        this.theView.startDragLinkFrom(this, e.getX(), e.getY());
                    }
                } else if (this.isEndPoint(e.getX(), e.getY())) {
                    this.theView.clearSelections();
                    this.theView.selectPrimitive(this);
                    if (this.theView.isEditMode() && this.draggable) {
                        this.beginRedirect();
                        this.theView.startDragLinkTo(this, e.getX(), e.getY());
                    }
                } else if (!this.theView.isSelected(this)) {
                    this.theView.clearSelections();
                    this.theView.selectPrimitive(this);
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this) {
            this.theView.setMouseOverPrimitive(this, e);
            if (this.theView.isEditMode() && this.selectable && this.draggable && (this.dragableBreaks && this.isBreakPoint(e.getX(), e.getY()) || this.isStartPoint(e.getX(), e.getY()) || this.isEndPoint(e.getX(), e.getY()))) {
                this.theView.setCursor(1);
            }
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public PFDButtonCollection getIndicatorButtions() {
        return this.buttonGroup;
    }

    @Override
    public void addButton(PFDAbstractButton button) {
        this.buttonGroup.addButton(button);
        this.firePropertyChange("buttons");
    }

    @Override
    public void addButton(int index, PFDAbstractButton button) {
        this.buttonGroup.addButton(index, button);
        this.firePropertyChange("buttons");
    }

    @Override
    public boolean removeButton(PFDAbstractButton button) {
        boolean rv = this.buttonGroup.removeButton(button);
        if (rv) {
            this.firePropertyChange("buttons");
        }
        return rv;
    }

    @Override
    public PFDAbstractButton removeButton(int index) {
        PFDAbstractButton rv = this.buttonGroup.removeButton(index);
        if (rv != null) {
            this.firePropertyChange("buttons");
        }
        return rv;
    }

    @Override
    public void removeAllButtons() {
        this.buttonGroup.removeAllButtons();
        this.firePropertyChange("buttons");
    }

    @Override
    public PFDAbstractButton getButton(int index) {
        return this.buttonGroup.getButton(index);
    }

    @Override
    public boolean containsButton(PFDAbstractButton button) {
        return this.buttonGroup.containsButton(button);
    }

    @Override
    public int indexOfButton(PFDAbstractButton button) {
        return this.buttonGroup.indexOfButton(button);
    }

    @Override
    public int getNumButtons() {
        return this.buttonGroup.getNumButtons();
    }

    @Override
    public PFDButtonCollection getIndicatorButtons() {
        return this.buttonGroup;
    }

    protected void buttonsChanged() {
        if (this.buttonGroup.hasNoPrimitives() || this.segments == null || this.segments.isEmpty()) {
            return;
        }
        Line2D segment = (Line2D)this.segments.get(this.segments.size() / 2);
        if (segment != null) {
            Point2D p1 = segment.getP1();
            Point2D p2 = segment.getP2();
            if (p1.getX() > p2.getX()) {
                Point2D temp = p1;
                p1 = p2;
                p2 = temp;
            }
            int xc = (int)((p1.getX() + p2.getX()) / 2.0);
            int yc = (int)((p1.getY() + p2.getY()) / 2.0);
            double buttonAngle = Math.atan((p2.getY() - p1.getY()) / (p2.getX() - p1.getX()));
            this.buttonTransform = AffineTransform.getRotateInstance(buttonAngle, xc, yc);
            this.buttonGroup.disableChangeUpdate();
            this.buttonGroup.setLocation(xc - this.buttonGroup.getWidth() / 2, yc - this.buttonGroup.getHeight() / 2);
            this.buttonGroup.enableChangeUpdate();
        }
    }

    @Override
    public void dispatchEvent(MouseEvent e) {
        this.theView = (PFDView)e.getSource();
        if (this.buttonGroup.visible && !this.buttonGroup.hasNoPrimitives()) {
            Point translate = this.getButtonsMouseTranslation(e.getPoint());
            e.translatePoint(translate.x, translate.y);
            if (this.buttonGroup.contains(e.getX(), e.getY())) {
                this.buttonGroup.dispatchEvent(e);
            }
            e.translatePoint(-translate.x, -translate.y);
        }
        if (!e.isConsumed()) {
            this.dispatchEventToSelf(e);
        }
    }

    private Point getButtonsMouseTranslation(Point p) {
        Point translate = new Point();
        try {
            this.buttonTransform.inverseTransform(p, translate);
        }
        catch (NoninvertibleTransformException e) {
            return new Point(0, 0);
        }
        translate.x -= p.x;
        translate.y -= p.y;
        return translate;
    }

    @Override
    protected void build(PFDView v) {
        this.buttonGroup.setModel(this.model);
        this.buttonGroup.setLayer(this.layer);
        this.buttonGroup.setGroup(null);
        this.buttonGroup.build(v);
        super.build(v);
        PFDSubdiagram.linkAdded(this.fromPort, this.toPort, this, v);
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        PFDSubdiagram.detachLink(this);
    }

    @Override
    protected boolean isRenderNeeded(PFDView v) {
        if (v == null || this.forceRender) {
            return true;
        }
        switch (v.renderMode) {
            case 0: {
                return true;
            }
            case 1: {
                if (v.isDragged(this)) {
                    return false;
                }
            }
            case 2: {
                PFDGroup g;
                if (v.isDragged(this) || this.getGroup() != null && this.getGroup().isRenderNeeded(v)) {
                    return true;
                }
                if (this.fromPort != null && (g = this.fromPort.getTopLevelGroup()) != null && g.isRenderNeeded(v)) {
                    return true;
                }
                return this.toPort != null && (g = this.toPort.getTopLevelGroup()) != null && g.isRenderNeeded(v);
            }
        }
        return true;
    }

    public void beginRedirect() {
        this.originalFromPort = this.fromPort;
        this.originalToPort = this.toPort;
    }

    public void endRedirect() {
        this.originalFromPort = null;
        this.originalToPort = null;
    }

    protected boolean isOriginalLink(PFDPort from, PFDPort to) {
        return this.originalFromPort == from && this.originalToPort == to;
    }

    public void addValidator(PFDLinkValidator validator) {
        if (validator == null) {
            return;
        }
        if (this.customValidators == null) {
            this.customValidators = new Vector();
        }
        this.customValidators.add(validator);
    }

    public void removeVaidator(PFDLinkValidator validator) {
        if (validator != null && this.customValidators != null) {
            this.customValidators.remove(validator);
        }
    }

    public void setValidationStatus(int validationStatus) {
        this.validationStatus = validationStatus;
    }

    public int getValidationStatus() {
        return this.validationStatus;
    }

    public String getValidationString(PFDAbstractNode fromNode, PFDPort fromPort, PFDAbstractNode toNode, PFDPort toPort) {
        String validationString = null;
        if (this.model != null && this.model.getLinkValidator() != null) {
            validationString = this.model.getLinkValidator().getInvalidLinkMessage(this, fromNode, fromPort, toNode, toPort);
        }
        if (validationString != null || this.customValidators == null) {
            return validationString;
        }
        Iterator i = this.customValidators.iterator();
        while (i.hasNext() && validationString == null) {
            PFDLinkValidator validator = (PFDLinkValidator)i.next();
            validationString = validator.getInvalidLinkMessage(this, fromNode, fromPort, toNode, toPort);
        }
        return validationString;
    }

    protected final boolean doLinkValidation(PFDPort from, PFDPort to) {
        if (!this.doGlobalLinkValidation(from, to)) {
            return false;
        }
        if (this.customValidators == null) {
            return true;
        }
        for (int i = 0; i < this.customValidators.size(); ++i) {
            PFDLinkValidator validator = (PFDLinkValidator)this.customValidators.get(i);
            if (validator.validateLink(this, from, to)) continue;
            return false;
        }
        return true;
    }

    private boolean doGlobalLinkValidation(PFDPort from, PFDPort to) {
        if (this.model == null || this.model.getLinkValidator() == null) {
            return true;
        }
        return this.model.getLinkValidator().validateLink(this, from, to);
    }

    public PFDLink createCollapsedLink() {
        PFDLink collapsedLink = null;
        try {
            collapsedLink = (PFDLink)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            collapsedLink = new PFDLink();
        }
        catch (IllegalAccessException e) {
            collapsedLink = new PFDLink();
        }
        this.copyObject(collapsedLink);
        collapsedLink.setIsCollapsed(true);
        if (!this.collapsedBreaks.isEmpty()) {
            collapsedLink.breakPoints.addAll(this.collapsedBreaks);
            collapsedLink.setCustomBreakPointsUsed(true);
        }
        return collapsedLink;
    }

    @Override
    public List getMenuItems() {
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        Action action = this.getAction("ACTION_DELETE");
        items.add(new JMenuItem(action));
        return items;
    }

    @Override
    public boolean isGhosted() {
        return this.ghosted;
    }

    @Override
    public void setGhosted(boolean b) {
        if (this.ghosted == b) {
            return;
        }
        this.ghosted = b;
        this.firePropertyChange("ghosted");
    }

    @Override
    public void bringToFront() {
        super.bringToFront();
        if (this.fromLabel != null) {
            this.fromLabel.bringToFront();
        }
        if (this.middleLabel != null) {
            this.middleLabel.bringToFront();
        }
        if (this.toLabel != null) {
            this.toLabel.bringToFront();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.segments = new Vector();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            this.segments.addElement(new Line2D.Double(this.getPoint((int)i).x, this.getPoint((int)i).y, this.getPoint((int)(i + 1)).x, this.getPoint((int)(i + 1)).y));
        }
        this.fromArrow = null;
        this.middleArrow = null;
        this.toArrow = null;
        this.arrowChanged();
        this.pending = new PropertyList();
    }

    public boolean applyPropertyChanges() {
        return false;
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending != null && this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 302: {
                if (this.toPort == null) {
                    return null;
                }
                if (this.toPort.getPFDItemId() == null) {
                    PFDGroup p = null;
                    if (this.toPort.getParent() != null) {
                        p = this.toPort.getParent();
                        while (p.getPFDItemId() == null) {
                            if (p.getParent() != null) {
                                p = p.getParent();
                                continue;
                            }
                            return null;
                        }
                        return p.getPFDItemId();
                    }
                    return null;
                }
                return this.toPort.getPFDItemId();
            }
            case 301: {
                if (this.fromPort == null) {
                    return null;
                }
                if (this.fromPort.getPFDItemId() == null) {
                    PFDGroup p = null;
                    if (this.fromPort.getParent() != null) {
                        p = this.fromPort.getParent();
                        while (p.getPFDItemId() == null) {
                            if (p.getParent() != null) {
                                p = p.getParent();
                                continue;
                            }
                            return null;
                        }
                        return p.getPFDItemId();
                    }
                    return null;
                }
                return this.fromPort.getPFDItemId();
            }
            case 303: {
                return this.getPFDItemId();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        switch (id) {
            case 301: 
            case 302: 
            case 303: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 301: 
            case 302: 
            case 303: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 302: {
                if (value instanceof String) break;
            }
            case 301: {
                if (value instanceof String) break;
            }
            case 303: {
                if (!(value instanceof String)) break;
                this.setPFDItemId((String)value);
            }
        }
    }
}

