/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDListInterface;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPrimitive;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class PFDLayer
implements PFDListInterface,
Serializable {
    Vector list = new Vector();
    Vector layoutOrderedList = new Vector();
    protected PFDModel model = null;
    private boolean useBringToFrontMethod = true;

    public PFDModel getModel() {
        return this.model;
    }

    protected void setModel(PFDModel m) {
        this.model = m;
    }

    @Override
    public int getNumPrimitives() {
        return this.list.size();
    }

    public Vector getCopyOfOrderedPrimitives() {
        return (Vector)this.list.clone();
    }

    @Override
    public boolean hasNoPrimitives() {
        return this.list.isEmpty();
    }

    @Override
    public boolean containsPrimitive(PFDPrimitive p) {
        return this.list.contains(p);
    }

    @Override
    public boolean addPrimitive(PFDPrimitive p) {
        p.setModel(this.model);
        p.setLayer(this);
        this.layoutOrderedList.add(p);
        return this.list.add(p);
    }

    @Override
    public void addPrimitive(int index, PFDPrimitive p) {
        p.setModel(this.model);
        p.setLayer(this);
        this.list.add(index, p);
        this.layoutOrderedList.add(index, p);
    }

    @Override
    public boolean removePrimitive(PFDPrimitive p) {
        p.setModel(null);
        p.setLayer(null);
        this.layoutOrderedList.remove(p);
        return this.list.remove(p);
    }

    @Override
    public PFDPrimitive removePrimitive(int index) {
        PFDPrimitive p = (PFDPrimitive)this.list.remove(index);
        this.layoutOrderedList.remove(p);
        p.setModel(null);
        p.setLayer(null);
        return p;
    }

    @Override
    public void removeAllPrimitives() {
        this.list.removeAllElements();
        this.layoutOrderedList.removeAllElements();
    }

    @Override
    public PFDPrimitive getPrimitive(int index) {
        return (PFDPrimitive)this.list.get(index);
    }

    public PFDPrimitive getOrderedPrimitive(int index) {
        return (PFDPrimitive)this.layoutOrderedList.get(index);
    }

    @Override
    public PFDPrimitive setPrimitive(int index, PFDPrimitive p) {
        PFDPrimitive rv = this.list.set(index, p);
        if (rv != null) {
            int idx = this.layoutOrderedList.indexOf(rv);
            this.layoutOrderedList.set(idx, p);
        }
        return rv;
    }

    @Override
    public int indexOfPrimitive(PFDPrimitive p) {
        return this.list.indexOf(p);
    }

    public void bringToFront(Enumeration primitives) {
        while (primitives.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)primitives.nextElement();
            if (!this.list.contains(p)) continue;
            this.list.remove(p);
            this.list.add(p);
        }
    }

    public void bringToFront(PFDPrimitive p) {
        if (this.useBringToFrontMethod && this.list.contains(p)) {
            this.list.remove(p);
            this.list.add(p);
        }
    }

    public void setBringToFront(boolean b) {
        this.useBringToFrontMethod = b;
    }

    public boolean getBringToFront() {
        return this.useBringToFrontMethod;
    }

    public void sendToBack(Enumeration primitives) {
        while (primitives.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)primitives.nextElement();
            if (!this.list.contains(p)) continue;
            this.list.remove(p);
            this.list.add(0, p);
        }
    }

    public void sendToBack(PFDPrimitive p) {
        if (this.list.contains(p)) {
            this.list.remove(p);
            this.list.add(0, p);
        }
    }
}

