/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableInterface;
import com.sas.graphics.components.pfd.interfaces.PFDGroupElementInterface;
import com.sas.graphics.components.pfd.ui.actions.PFDCollapseAction;
import com.sas.graphics.components.pfd.ui.actions.PFDExpandAction;
import com.sas.graphics.styles.Style;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;

public class PFDJobNode
extends PFDCompositeNode
implements PFDCollapsableInterface {
    private PFDPort dummyPort;
    private Vector inputNodes;
    private Vector outputNodes;
    private Vector childNodes;
    private PFDButton expandButton;
    private PFDButton collapseButton;
    private boolean forceShowPorts = false;
    private boolean isCollapsed = false;
    private int innerNodeSpaceX = 20;
    private int innerNodeSpaceY = 10;

    public PFDJobNode() {
        this.initialize();
    }

    private void initialize() {
        this.setEditable(true);
        this.nodeStyleContext = "NodeStyle3";
        this.dummyPort = new PFDPort();
        this.inputNodes = new Vector();
        this.outputNodes = new Vector();
        this.childNodes = new Vector();
        this.expandButton = new PFDButton();
        this.expandButton.setAction(new PFDExpandAction(this));
        this.collapseButton = new PFDButton();
        this.collapseButton.setAction(new PFDCollapseAction(this));
        this.setLocation(500, 500);
    }

    @Override
    protected void layoutChildren() {
        this.disableChangeUpdate();
        Point p = this.nodeShape.getSpotLocation(1, null);
        this.nodeWidth = this.preferredSize.width;
        int tempTopBorder = 6;
        this.updateInputNodes();
        this.updateOutputNodes();
        if (this.flowDirection.equalsIgnoreCase("left") || this.flowDirection.equalsIgnoreCase("right")) {
            this.nodeWidth = this.preferredSize.width;
            int inputOutputNodeHeight = 0;
            if (!this.isCollapsed) {
                int childNodeHeight = 0;
                if (this.inputNodes.size() > 0) {
                    childNodeHeight = ((PFDCompositeNode)this.inputNodes.get((int)0)).getPreferredSize().height;
                } else if (this.outputNodes.size() > 0) {
                    childNodeHeight = ((PFDCompositeNode)this.outputNodes.get((int)0)).getPreferredSize().height;
                }
                inputOutputNodeHeight = Math.max(this.inputNodes.size(), this.outputNodes.size()) * (childNodeHeight + this.innerNodeSpaceY);
            }
            this.nodeHeight = 30 + inputOutputNodeHeight + 6;
        } else {
            int inputOutputNodeWidth = 0;
            int childNodeHeight = 0;
            int childNodeWidth = 0;
            if (this.inputNodes.size() > 0) {
                childNodeHeight = ((PFDCompositeNode)this.inputNodes.get((int)0)).getPreferredSize().height;
                childNodeWidth = ((PFDCompositeNode)this.inputNodes.get((int)0)).getPreferredSize().width;
            } else if (this.outputNodes.size() > 0) {
                childNodeHeight = ((PFDCompositeNode)this.outputNodes.get((int)0)).getPreferredSize().height;
                childNodeWidth = ((PFDCompositeNode)this.outputNodes.get((int)0)).getPreferredSize().width;
            }
            inputOutputNodeWidth = Math.max(this.inputNodes.size(), this.outputNodes.size()) * (childNodeWidth + this.innerNodeSpaceX);
            this.nodeWidth = !this.isCollapsed ? Math.max(this.preferredSize.width, inputOutputNodeWidth + this.innerNodeSpaceX) : this.preferredSize.width;
            this.nodeHeight = childNodeHeight + 6 + 24 + 6;
            tempTopBorder = childNodeHeight / 2 + 6;
        }
        int titleWidth = this.nodeWidth - 22 - 6;
        if (this.titleText.isVisible() && this.titleText.getText() != null && this.titleText.getText().length() > 0) {
            this.titleText.setVerticalAlignment(0);
            this.titleText.setHorizontalAlignment(1);
            this.titleText.setMultiline(true);
            this.titleText.setWrapWidth(titleWidth);
            this.titleText.setClipHeight(24);
            this.titleText.setClipping(true);
            this.titleText.setBBox(p.x + 22, p.y + tempTopBorder + 12, 0, 0);
            this.titleText.forceUpdate();
        }
        this.preferredSize.setSize(this.nodeWidth, this.nodeHeight);
        this.nodeShape.setBBox(p.x, p.y, this.nodeWidth, this.nodeHeight);
        this.nodeIcon.setBBox(p.x - 6, p.y + tempTopBorder, 24, 24);
        this.layoutStatusButton();
        this.layoutExpandCollapseButton();
        this.layoutPorts();
        this.layoutInputNodes();
        this.layoutOutputNodes();
        this.layoutProgressBar();
        this.layoutButtons();
        this.layoutNodeNumber(p);
        this.enableChangeUpdate();
        this.calculateBBox();
    }

    protected void layoutExpandCollapseButton() {
        if (this.childNodes.size() > 0) {
            if (this.isCollapsed) {
                this.removePrimitive(this.collapseButton);
                if (!this.containsPrimitive(this.expandButton)) {
                    this.addPrimitive(this.expandButton);
                }
            } else {
                this.removePrimitive(this.expandButton);
                if (!this.containsPrimitive(this.collapseButton)) {
                    this.addPrimitive(this.collapseButton);
                }
            }
        } else {
            this.removePrimitive(this.expandButton);
            this.removePrimitive(this.collapseButton);
        }
        if (this.flowDirection.equalsIgnoreCase("left") || this.flowDirection.equalsIgnoreCase("right")) {
            Point p = this.nodeShape.getSpotLocation(6, null);
            this.expandButton.setLocation(p.x - this.expandButton.getWidth() / 2, p.y - 6);
            this.collapseButton.setLocation(p.x - this.collapseButton.getWidth() / 2, p.y - 6);
        } else {
            Point p = this.nodeShape.getSpotLocation(4, null);
            this.expandButton.setLocation(p.x - 6 + 1, p.y - this.expandButton.getHeight() / 2);
            this.collapseButton.setLocation(p.x - 6 + 1, p.y - this.collapseButton.getHeight() / 2);
        }
    }

    protected void layoutInputNodes() {
        if (this.inputNodes.size() == 0) {
            return;
        }
        Point p = this.nodeShape.getSpotLocation(1, null);
        Dimension size = ((PFDCompositeNode)this.inputNodes.get(0)).getPreferredSize();
        int xPos = 0;
        int yPos = 0;
        int deltaX = 0;
        int deltaY = 0;
        int spot = 0;
        if (this.flowDirection.equalsIgnoreCase("left")) {
            spot = 1;
            xPos = Math.max(p.x + this.nodeWidth / 2 + this.innerNodeSpaceX / 2, p.x + this.nodeWidth - size.width / 2);
            yPos = p.y + 6 + 24 + this.innerNodeSpaceY;
            deltaY = size.height + this.innerNodeSpaceY;
        } else if (this.flowDirection.equalsIgnoreCase("right")) {
            spot = 3;
            xPos = Math.min(p.x + this.nodeWidth / 2 - this.innerNodeSpaceX / 2, p.x + size.width / 2);
            yPos = p.y + 6 + 24 + this.innerNodeSpaceY;
            deltaY = size.height + this.innerNodeSpaceY;
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            spot = 8;
            xPos = p.x + this.innerNodeSpaceX;
            yPos = p.y + this.nodeHeight;
            deltaX = size.width + this.innerNodeSpaceX;
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            spot = 8;
            xPos = p.x + this.innerNodeSpaceX;
            yPos = p.y;
            deltaX = size.width + this.innerNodeSpaceX;
        }
        Point spotPoint = new Point();
        for (int i = 0; i < this.inputNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.inputNodes.get(i);
            node.setFlowDirection(this.flowDirection);
            if (!this.isCollapsed) {
                node.setVisible(true);
                if (!this.children.contains(node)) {
                    this.addPrimitive(node);
                }
                node.getSpotLocation(spot, spotPoint);
                int dx = xPos + deltaX * i - spotPoint.x;
                int dy = yPos + deltaY * i - spotPoint.y;
                node.setLocation(node.getX() + dx, node.getY() + dy);
                continue;
            }
            node.setVisible(false);
            if (!this.children.contains(node)) continue;
            this.removePrimitive(node);
        }
    }

    protected void layoutOutputNodes() {
        if (this.outputNodes.size() == 0) {
            return;
        }
        Point p = this.nodeShape.getSpotLocation(1, null);
        Dimension size = ((PFDCompositeNode)this.outputNodes.get(0)).getPreferredSize();
        int xPos = 0;
        int yPos = 0;
        int deltaX = 0;
        int deltaY = 0;
        int spot = 0;
        if (this.flowDirection.equalsIgnoreCase("left")) {
            spot = 3;
            xPos = Math.min(p.x + this.nodeWidth / 2 - this.innerNodeSpaceX / 2, p.x + size.width / 2);
            yPos = p.y + 6 + 24 + this.innerNodeSpaceY;
            deltaY = size.height + this.innerNodeSpaceY;
        } else if (this.flowDirection.equalsIgnoreCase("right")) {
            spot = 1;
            xPos = Math.max(p.x + this.nodeWidth / 2 + this.innerNodeSpaceX / 2, p.x + this.nodeWidth - size.width / 2);
            yPos = p.y + 6 + 24 + this.innerNodeSpaceY;
            deltaY = size.height + this.innerNodeSpaceY;
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            spot = 8;
            xPos = p.x + this.innerNodeSpaceX;
            yPos = p.y;
            deltaX = size.width + this.innerNodeSpaceX;
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            spot = 8;
            xPos = p.x + this.innerNodeSpaceX;
            yPos = p.y + this.nodeHeight;
            deltaX = size.width + this.innerNodeSpaceX;
        }
        Point spotPoint = new Point();
        for (int i = 0; i < this.outputNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.outputNodes.get(i);
            node.setFlowDirection(this.flowDirection);
            if (!this.isCollapsed) {
                node.setVisible(true);
                if (!this.children.contains(node)) {
                    this.addPrimitive(node);
                }
            } else {
                node.setVisible(false);
                if (this.children.contains(node)) {
                    this.removePrimitive(node);
                }
            }
            node.getSpotLocation(spot, spotPoint);
            int dx = xPos + deltaX * i - spotPoint.x;
            int dy = yPos + deltaY * i - spotPoint.y;
            node.setLocation(node.getX() + dx, node.getY() + dy);
        }
    }

    private void updateOutputNodes() {
        if (this.model == null) {
            return;
        }
        for (int i = 0; i < this.outputNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.outputNodes.get(i);
            if (!this.isCollapsed) {
                if (!this.children.contains(node)) {
                    this.addPrimitive(node);
                }
                PFDSubdiagram.expandLinks(node.getOutputLinks());
                node.setVisible(true);
                continue;
            }
            PFDSubdiagram.collapseOutputLinksToPort(node.getOutputLinks(), this.getOutputPort());
            node.setVisible(false);
            if (!this.children.contains(node)) continue;
            this.removePrimitive(node);
        }
    }

    private void updateInputNodes() {
        if (this.model == null) {
            return;
        }
        for (int i = 0; i < this.inputNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.inputNodes.get(i);
            if (!this.isCollapsed) {
                if (!this.children.contains(node)) {
                    this.addPrimitive(node);
                }
                PFDSubdiagram.expandLinks(node.getInputLinks());
                node.setVisible(true);
                continue;
            }
            PFDSubdiagram.collapseInputLinksToPort(node.getInputLinks(), this.getInputPort());
            node.setVisible(false);
            if (!this.children.contains(node)) continue;
            this.removePrimitive(node);
        }
    }

    @Override
    protected Vector getChildren() {
        Vector cv = super.getChildren();
        for (int i = 0; i < this.outputNodes.size(); ++i) {
            Vector cvi = ((PFDCompositeNode)this.outputNodes.get(i)).getChildren();
            for (int j = 0; j < cvi.size(); ++j) {
                Object o = cvi.get(i);
                if (cv.contains(o)) continue;
                cv.add(o);
            }
        }
        return cv;
    }

    @Override
    protected Vector getParents() {
        Vector pv = super.getParents();
        for (int i = 0; i < this.inputNodes.size(); ++i) {
            Vector pvi = ((PFDCompositeNode)this.inputNodes.get(i)).getChildren();
            for (int j = 0; j < pvi.size(); ++j) {
                Object o = pvi.get(i);
                if (pv.contains(o)) continue;
                pv.add(o);
            }
        }
        return pv;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.forceShowPorts;
    }

    @Override
    public void setForceShowPorts(boolean visible) {
        int i;
        if (this.forceShowPorts == visible) {
            return;
        }
        for (i = 0; i < this.inputNodes.size(); ++i) {
            ((PFDCompositeNode)this.inputNodes.get(i)).setForceShowPorts(this.forceShowPorts);
        }
        for (i = 0; i < this.outputNodes.size(); ++i) {
            ((PFDCompositeNode)this.outputNodes.get(i)).setForceShowPorts(this.forceShowPorts);
        }
        this.firePropertyChange("forceShowPorts");
    }

    public void addInputNode(PFDCompositeNode node) {
        this.addInputNode(this.inputNodes.size(), node);
    }

    public void addInputNode(int index, PFDCompositeNode node) {
        if (node == null || this.inputNodes.contains(node)) {
            return;
        }
        node.setParent(this);
        node.setDraggable(false);
        node.removeAllOutputPorts();
        this.inputNodes.add(index, node);
        this.childNodes.add(node);
        this.addPrimitive(node);
        this.firePropertyChange("inputNode");
    }

    public boolean removeInputNode(PFDCompositeNode node) {
        boolean retVal = this.inputNodes.remove(node);
        this.childNodes.remove(node);
        if (retVal) {
            node.setParent(null);
            this.firePropertyChange("inputNode");
        }
        return retVal;
    }

    public PFDCompositeNode removeInputNode(int index) {
        PFDCompositeNode node = (PFDCompositeNode)this.inputNodes.remove(index);
        if (node != null) {
            node.setParent(null);
            this.childNodes.remove(node);
            this.firePropertyChange("inputNode");
        }
        return node;
    }

    public void removeAllInputNodes() {
        if (this.inputNodes.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.inputNodes.size(); ++i) {
            PFDGroupElementInterface gei = (PFDGroupElementInterface)this.inputNodes.get(i);
            gei.setParent(null);
            this.childNodes.remove(gei);
        }
        this.inputNodes.clear();
        this.firePropertyChange("inputNode");
    }

    public int getNumInputNodes() {
        return this.inputNodes.size();
    }

    public PFDCompositeNode getInputNode(int index) {
        return (PFDCompositeNode)this.inputNodes.get(index);
    }

    public boolean isInputNode(PFDCompositeNode node) {
        return this.inputNodes.contains(node);
    }

    public int getInputNodeIndex(PFDCompositeNode node) {
        return this.inputNodes.indexOf(node);
    }

    public void addOutputNode(PFDCompositeNode node) {
        this.addOutputNode(this.outputNodes.size(), node);
    }

    public void addOutputNode(int index, PFDCompositeNode node) {
        if (node == null || this.outputNodes.contains(node)) {
            return;
        }
        node.setParent(this);
        node.setDraggable(false);
        node.removeAllInputPorts();
        this.outputNodes.add(index, node);
        this.childNodes.add(node);
        this.addPrimitive(node);
        this.firePropertyChange("outputNode");
    }

    public boolean removeOutputNode(PFDCompositeNode node) {
        boolean retVal = this.outputNodes.remove(node);
        this.childNodes.remove(node);
        if (retVal) {
            node.setParent(null);
            this.firePropertyChange("outputNode");
        }
        return retVal;
    }

    public PFDCompositeNode removeOutputNode(int index) {
        PFDCompositeNode node = (PFDCompositeNode)this.outputNodes.remove(index);
        if (node != null) {
            node.setParent(null);
            this.childNodes.remove(node);
            this.firePropertyChange("outputNode");
        }
        return node;
    }

    public void removeAllOutputNodes() {
        if (this.outputNodes.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.outputNodes.size(); ++i) {
            PFDGroupElementInterface gei = (PFDGroupElementInterface)this.outputNodes.get(i);
            gei.setParent(null);
            this.childNodes.remove(gei);
        }
        this.outputNodes.clear();
        this.firePropertyChange("outputNode");
    }

    public int getNumOutputNodes() {
        return this.outputNodes.size();
    }

    public PFDCompositeNode getOutputNode(int index) {
        return (PFDCompositeNode)this.outputNodes.get(index);
    }

    public boolean isOutputNode(PFDCompositeNode node) {
        return this.outputNodes.contains(node);
    }

    public int getOutputNodeIndex(PFDCompositeNode node) {
        return this.outputNodes.indexOf(node);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        PFDCompositeNode node;
        int i;
        if (!this.visible) {
            return;
        }
        this.nodeShape.renderOverview(g2d, v);
        this.inputPortGroup.renderOverview(g2d, v);
        this.outputPortGroup.renderOverview(g2d, v);
        for (i = 0; i < this.inputNodes.size(); ++i) {
            node = (PFDCompositeNode)this.inputNodes.get(i);
            node.renderOverview(g2d, v);
        }
        for (i = 0; i < this.outputNodes.size(); ++i) {
            node = (PFDCompositeNode)this.outputNodes.get(i);
            node.renderOverview(g2d, v);
        }
    }

    @Override
    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        this.nodeShape.paint(g);
        this.titleText.paint(g);
        this.contentText.paint(g);
        this.inputPortGroup.paint(g);
        this.outputPortGroup.paint(g);
        if (selected) {
            this.drawSelection(g);
        }
        this.nodeIcon.paint(g);
        this.drawStatusButton(g);
        if (this.noteButton != null) {
            this.noteButton.paint(g);
        }
        this.buttonGroup.paint(g);
        this.drawNodeNumber(g);
        this.drawExpandCollapseButton(g);
        this.drawChildNodes(g, v);
        if (this.progressBar != null) {
            this.progressBar.paint(g);
        }
        this.drawNotesAndStatus(g);
    }

    @Override
    protected void drawGhosted(Graphics2D g, PFDView v, boolean selected) {
        if (selected) {
            this.drawSelection(g);
        }
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        Rectangle bounds = this.getVisualRBBox();
        BufferedImage ghostImage = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D ghostGraphics = ghostImage.createGraphics();
        ghostGraphics.setRenderingHints(g.getRenderingHints());
        ghostGraphics.translate(-bounds.x, -bounds.y);
        this.nodeShape.paint(ghostGraphics);
        this.titleText.paint(ghostGraphics);
        this.contentText.paint(ghostGraphics);
        this.inputPortGroup.paint(ghostGraphics);
        this.outputPortGroup.paint(ghostGraphics);
        this.nodeIcon.paint(ghostGraphics);
        if (this.noteButton != null) {
            this.noteButton.paint(ghostGraphics);
        }
        this.buttonGroup.paint(ghostGraphics);
        this.drawNodeNumber(ghostGraphics);
        this.drawExpandCollapseButton(ghostGraphics);
        ghostGraphics.dispose();
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.drawImage((Image)ghostImage, bounds.x, bounds.y, v);
        g.setComposite(oldComposite);
        this.drawStatusButton(g);
        this.drawChildNodes(g, v);
        if (this.progressBar != null) {
            this.progressBar.paint(g);
        }
        this.drawNotesAndStatus(g);
    }

    protected void drawChildNodes(Graphics2D g, PFDView v) {
        if (this.isCollapsed) {
            return;
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            PFDCompositeNode node = (PFDCompositeNode)this.childNodes.get(i);
            node.paint(g, v);
        }
    }

    protected void drawExpandCollapseButton(Graphics2D g) {
        if (this.childNodes.size() > 0) {
            if (this.isCollapsed) {
                this.expandButton.paint(g);
            } else {
                this.collapseButton.paint(g);
            }
        }
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDCompositeNode copy;
        PFDCompositeNode n;
        int i;
        boolean collapsed = this.isCollapsed;
        if (collapsed) {
            this.setCollapsed(false);
        }
        PFDJobNode clone = new PFDJobNode();
        table.put(this, clone);
        this.copyObject(clone);
        for (i = 0; i < this.inputNodes.size(); ++i) {
            n = this.getInputNode(i);
            copy = (PFDCompositeNode)n.cloneObject(table);
            clone.addInputNode(copy);
        }
        for (i = 0; i < this.outputNodes.size(); ++i) {
            n = this.getOutputNode(i);
            copy = (PFDCompositeNode)n.cloneObject(table);
            clone.addOutputNode(copy);
        }
        if (collapsed) {
            this.setCollapsed(true);
        }
        return clone;
    }

    public void copyObject(PFDJobNode toObject) {
        super.copyObject(toObject);
        toObject.setCollapsed(this.isCollapsed());
    }

    @Override
    public void bringToFront(PFDPrimitive p) {
        if (this.model == null || !this.children.contains(p)) {
            return;
        }
        if (this.childNodes.contains(p)) {
            this.childNodes.remove(p);
            this.childNodes.add(p);
            this.children.remove(p);
            this.children.add(p);
        }
        this.bringToFront();
    }

    @Override
    public int getLayoutWidth() {
        return this.getLayoutBounds().width;
    }

    @Override
    public int getLayoutHeight() {
        return this.getLayoutBounds().height;
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        if (this.isCollapsed) {
            return super.getSpotLocation(spot, p);
        }
        if (p == null) {
            p = new Point();
        }
        Rectangle bounds = this.getLayoutBounds();
        switch (spot) {
            default: {
                this.nodeShape.getSpotLocation(spot, p);
                break;
            }
            case 1: {
                p.x = bounds.x;
                p.y = bounds.y;
                break;
            }
            case 2: {
                if (this.flowDirection.equalsIgnoreCase("right") || this.flowDirection.equalsIgnoreCase("left")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y;
                break;
            }
            case 3: {
                p.x = bounds.x + bounds.width;
                p.y = bounds.y;
                break;
            }
            case 4: {
                if (this.flowDirection.equalsIgnoreCase("up") || this.flowDirection.equalsIgnoreCase("down")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x + bounds.width;
                p.y = bounds.y + bounds.height / 2;
                break;
            }
            case 5: {
                p.x = bounds.x + bounds.width;
                p.y = bounds.y + bounds.height;
                break;
            }
            case 6: {
                if (this.flowDirection.equalsIgnoreCase("right") || this.flowDirection.equalsIgnoreCase("left")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x + bounds.width / 2;
                p.y = bounds.y + bounds.height;
                break;
            }
            case 7: {
                p.x = bounds.x;
                p.y = bounds.y + bounds.height;
                break;
            }
            case 8: {
                if (this.flowDirection.equalsIgnoreCase("up") || this.flowDirection.equalsIgnoreCase("down")) {
                    this.nodeShape.getSpotLocation(spot, p);
                    break;
                }
                p.x = bounds.x;
                p.y = bounds.y + bounds.height / 2;
            }
        }
        return p;
    }

    private Rectangle getLayoutBounds() {
        PFDCompositeNode node;
        int i;
        if (this.isCollapsed) {
            return this.nodeShape.getBBox();
        }
        Rectangle bounds = this.nodeShape.getBBox();
        Point p = new Point();
        for (i = 0; i < this.inputNodes.size(); ++i) {
            node = (PFDCompositeNode)this.inputNodes.get(i);
            node.getSpotLocation(1, p);
            bounds = bounds.union(new Rectangle(p.x, p.y, node.getLayoutWidth(), node.getLayoutHeight()));
        }
        for (i = 0; i < this.outputNodes.size(); ++i) {
            node = (PFDCompositeNode)this.outputNodes.get(i);
            node.getSpotLocation(1, p);
            bounds = bounds.union(new Rectangle(p.x, p.y, node.getLayoutWidth(), node.getLayoutHeight()));
        }
        return bounds;
    }

    @Override
    public void setGhosted(boolean b) {
        for (int i = 0; i < this.childNodes.size(); ++i) {
            PFDCompositeNode wtNode = (PFDCompositeNode)this.childNodes.get(i);
            wtNode.setGhosted(b);
        }
        super.setGhosted(b);
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        this.setCollapsedImpl(collapsed, true);
    }

    private void setCollapsedImpl(boolean collapsed, boolean doUpdate) {
        if (collapsed == this.isCollapsed) {
            return;
        }
        this.isCollapsed = collapsed;
        this.layoutChildren();
        if (doUpdate) {
            this.firePropertyChange("isCollapsed");
        }
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    @Override
    public void updateCollapsed() {
        if (this.isCollapsed) {
            this.setCollapsedImpl(false, false);
            this.setCollapsedImpl(true, false);
        }
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        this.updateExpandCollapseButtonStyle();
    }

    private void updateExpandCollapseButtonStyle() {
        if ("NodeStyle1".equals(this.nodeStyleContext)) {
            this.expandButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("ExpandNode_blue.gif"));
            this.collapseButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("CollapseNode_blue.gif"));
        } else if ("NodeStyle2".equals(this.nodeStyleContext)) {
            this.expandButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("ExpandNode_green.gif"));
            this.collapseButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("CollapseNode_green.gif"));
        } else if ("NodeStyle3".equals(this.nodeStyleContext)) {
            this.expandButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("ExpandNode_gold.gif"));
            this.collapseButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("CollapseNode_gold.gif"));
        } else if ("NodeStyle4".equals(this.nodeStyleContext)) {
            this.expandButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("ExpandNode_purple.gif"));
            this.collapseButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("CollapseNode_purple.gif"));
        } else {
            this.expandButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("ExpandNode_silver.gif"));
            this.collapseButton.getAction().putValue("SmallIcon", PFDIconManager.getIcon("CollapseNode_silver.gif"));
        }
    }

    @Override
    public void accumulateNodes(Vector v) {
        if (v == null || this.childNodes == null) {
            return;
        }
        v.addAll(this.childNodes);
    }

    @Override
    protected void build(PFDView v) {
        for (int i = 0; i < this.childNodes.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.childNodes.get(i);
            p.build(v);
        }
        super.build(v);
    }
}

