/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDLabeledNodeInterface;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PFDImageNode
extends PFDAbstractNode
implements PFDLabeledNodeInterface,
PFDDirectionalNodeInterface {
    public static final String RB_KEY = "PFDImageNode.";
    public static final String EAST = "east";
    public static final String WEST = "west";
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    private PFDImage icon = null;
    private PFDText label = null;
    private Vector ports = new Vector();
    private int labelPosition = 2;
    private Point location;
    private Dimension size;
    private transient Image image;
    private transient Image selectedImage;
    private transient Image focusedImage;
    private transient Hashtable stateMap;
    private String state = null;
    private String text;
    private boolean showPorts = true;
    private boolean fixedAnglePorts = true;
    private PFDPort eastPort;
    private PFDPort westPort;
    private PFDPort northPort;
    private PFDPort southPort;
    private PFDPort inputPort;
    private PFDPort outputPort;
    private String flowDirection = "Right";

    public PFDImageNode() {
        this(new Point(0, 0), new Dimension(0, 0), null, null);
    }

    public PFDImageNode(Point loc, Dimension size, Image image, String label) {
        this.setBreakable(false);
        this.location = loc;
        this.size = size;
        this.image = image;
        this.text = label;
        this.stateMap = new Hashtable();
        this.initialize();
    }

    public PFDText getLabel() {
        return this.label;
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(int position) {
        if (this.labelPosition == position) {
            return;
        }
        this.checkLabelPosition(position);
        this.labelPosition = position;
        this.layoutChildren();
    }

    private void checkLabelPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "label.ex.txt"));
            }
        }
    }

    public PFDImage getIcon() {
        return this.icon;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.showPorts;
    }

    @Override
    public void setForceShowPorts(boolean b) {
        if (this.showPorts == b) {
            return;
        }
        this.showPorts = b;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (p != this.inputPort && p != this.outputPort) continue;
            p.setVisible(this.showPorts);
        }
    }

    public boolean isForceFixedAngleConnectionPorts() {
        return this.fixedAnglePorts;
    }

    public void setForceFixedAngleConnectionPorts(boolean b) {
        if (this.fixedAnglePorts == b) {
            return;
        }
        this.fixedAnglePorts = b;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (this.fixedAnglePorts) {
                p.setFromLinkSpot(0);
                p.setToLinkSpot(0);
                continue;
            }
            p.setFromLinkSpot(9);
            p.setToLinkSpot(9);
            p.setFreeSpotOffsetX(3);
            p.setFreeSpotOffsetY(3);
        }
    }

    protected void initialize() {
        this.icon = new PFDImage(this.image);
        this.icon.setBBox(this.location, this.size);
        this.label = new PFDText(this.text);
        this.westPort = new PFDPort();
        this.westPort.setName(WEST);
        this.westPort.setType(5);
        this.westPort.getBrush().setColor(Color.gray);
        this.westPort.setFromLinkDirection(Math.PI);
        this.westPort.setToLinkDirection(0.0);
        this.ports.addElement(this.westPort);
        this.eastPort = new PFDPort();
        this.eastPort.setName(EAST);
        this.eastPort.setType(5);
        this.eastPort.getBrush().setColor(Color.gray);
        this.eastPort.setFromLinkDirection(0.0);
        this.eastPort.setToLinkDirection(Math.PI);
        this.ports.addElement(this.eastPort);
        this.northPort = new PFDPort();
        this.northPort.setName(NORTH);
        this.northPort.setType(5);
        this.northPort.getBrush().setColor(Color.gray);
        this.northPort.setFromLinkDirection(1.5707963267948966);
        this.northPort.setToLinkDirection(4.71238898038469);
        this.ports.addElement(this.northPort);
        this.southPort = new PFDPort();
        this.southPort.setName(SOUTH);
        this.southPort.setType(5);
        this.southPort.getBrush().setColor(Color.gray);
        this.southPort.setFromLinkDirection(4.71238898038469);
        this.southPort.setToLinkDirection(1.5707963267948966);
        this.ports.addElement(this.southPort);
        this.northPort.setVisible(false);
        this.southPort.setVisible(false);
        this.westPort.setToLinkSpot(8);
        this.westPort.setFromLinkSpot(8);
        this.eastPort.setToLinkSpot(4);
        this.eastPort.setFromLinkSpot(4);
        this.northPort.setToLinkSpot(2);
        this.northPort.setFromLinkSpot(2);
        this.southPort.setToLinkSpot(6);
        this.southPort.setFromLinkSpot(6);
        this.addPrimitive(this.icon);
        this.addPrimitive(this.label);
        this.addPrimitive(this.westPort);
        this.addPrimitive(this.eastPort);
        this.addPrimitive(this.northPort);
        this.addPrimitive(this.southPort);
        this.layoutChildren();
        this.inputPort = this.westPort;
        this.outputPort = this.eastPort;
    }

    protected void layoutChildren() {
        Rectangle r = this.icon.getRBBox();
        Point p = new Point();
        this.icon.getSpotLocation(8, p);
        this.westPort.setBBox(p.x - 6, p.y - 3, 6, 6);
        this.icon.getSpotLocation(4, p);
        this.eastPort.setBBox(p.x, p.y - 3, 6, 6);
        this.icon.getSpotLocation(2, p);
        this.northPort.setBBox(p.x - 3, p.y - 6, 6, 6);
        this.icon.getSpotLocation(6, p);
        this.southPort.setBBox(p.x - 3, p.y, 6, 6);
        switch (this.labelPosition) {
            default: {
                this.icon.getSpotLocation(0, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 1: {
                this.icon.getSpotLocation(2, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(2);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 2: {
                this.icon.getSpotLocation(6, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(1);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 3: {
                this.icon.getSpotLocation(8, p);
                this.label.setHorizontalAlignment(2);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 4: {
                this.icon.getSpotLocation(4, p);
                this.label.setHorizontalAlignment(1);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
            }
        }
        this.calculateBBox();
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDImageNode clone = new PFDImageNode(this.icon.getLocation(), this.icon.getSize(), this.icon.getImage(), this.label.getText());
        super.copyObject(clone);
        clone.setLabelPosition(this.getLabelPosition());
        clone.setFlowDirection(this.getFlowDirection());
        clone.setSelectedImage(this.getSelectedImage());
        clone.setFocusedImage(this.getFocusedImage());
        clone.setForceShowPorts(this.isForceShowPorts());
        Enumeration en = this.stateMap.keys();
        while (en.hasMoreElements()) {
            String st = (String)en.nextElement();
            clone.addStateImage(st, this.getStateImage(st));
        }
        clone.setState(this.getState());
        clone.setForceFixedAngleConnectionPorts(this.isForceFixedAngleConnectionPorts());
        this.icon.copyObject(clone.getIcon());
        this.label.copyObject(clone.getLabel());
        table.put(this, clone);
        table.put(this.icon, clone.icon);
        table.put(this.label, clone.label);
        for (int i = 0; i < this.ports.size(); ++i) {
            table.put(this.ports.elementAt(i), clone.ports.elementAt(i));
        }
        return clone;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        Rectangle r = this.getRBBox();
        if (r.x == x && r.y == y && r.width == w && r.height == h) {
            return;
        }
        this.location = this.icon.getLocation();
        this.size = this.icon.getSize();
        x = Math.max(0, x);
        y = Math.max(0, y);
        Dimension labelSize = this.label != null ? this.label.getSize() : new Dimension(0, 0);
        if (w < labelSize.width && !this.label.isMultiline()) {
            return;
        }
        if (h < labelSize.height) {
            return;
        }
        this.location.x += x - r.x;
        this.location.y += y - r.y;
        this.size.width += w - r.width;
        this.size.height += h - r.height;
        this.icon.setBBox(this.location, this.size);
        this.layoutChildren();
        this.firePropertyChange("bbox");
    }

    public PFDPort getPort(int i) {
        return (PFDPort)this.ports.elementAt(i);
    }

    @Override
    public PFDPort getPort(String name) {
        this.checkPortName(name);
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort port = this.getPort(i);
            if (!name.equals(port.getName())) continue;
            return port;
        }
        return null;
    }

    private void checkPortName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
        }
        if (name.equals(EAST) || name.equals(WEST) || name.equals(NORTH) || name.equals(SOUTH)) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    public Image getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(Image image) {
        this.selectedImage = image;
    }

    public Image getFocusedImage() {
        return this.focusedImage;
    }

    public void setFocusedImage(Image image) {
        this.focusedImage = image;
    }

    public Image getStateImage(String state) {
        if (state == null) {
            return null;
        }
        return (Image)this.stateMap.get(state);
    }

    public void addStateImage(String state, Image image) {
        if (state == null || image == null) {
            return;
        }
        this.stateMap.put(state, image);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        this.firePropertyChange("image");
    }

    public void removeState(String state) {
        if (state == null) {
            return;
        }
        this.stateMap.remove(state);
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.state == null) {
            super.render(g2d, v);
            return;
        }
        this.icon.disableChangeUpdate();
        this.icon.setImage(this.getStateImage(this.state));
        this.icon.enableChangeUpdate();
        super.render(g2d, v);
        this.icon.disableChangeUpdate();
        this.icon.setImage(this.image);
        this.icon.enableChangeUpdate();
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        if (this.selectedImage == null) {
            super.render(g2d, v);
            return;
        }
        this.icon.disableChangeUpdate();
        this.icon.setImage(this.selectedImage);
        this.icon.enableChangeUpdate();
        super.render(g2d, v);
        this.icon.disableChangeUpdate();
        this.icon.setImage(this.image);
        this.icon.enableChangeUpdate();
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        if (this.focusedImage == null) {
            super.render(g2d, v);
            return;
        }
        this.icon.disableChangeUpdate();
        this.icon.setImage(this.focusedImage);
        this.icon.enableChangeUpdate();
        super.render(g2d, v);
        this.icon.disableChangeUpdate();
        this.icon.setImage(this.image);
        this.icon.enableChangeUpdate();
    }

    @Override
    public Point getCenterLocation() {
        return this.icon.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        Point center = this.getCenterLocation();
        Dimension delta = new Dimension(p.x - center.x, p.y - center.y);
        this.setLocation(this.bbox.x + delta.width, this.bbox.y + delta.height);
    }

    @Override
    public PFDPort getInputPort() {
        return this.inputPort;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.outputPort;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        this.checkFlowDirection(direction);
        if (this.flowDirection.equals(direction)) {
            return;
        }
        this.flowDirection = direction;
        int numIns = 0;
        if (this.inputPort != null) {
            numIns = this.inputPort.getNumLinks();
        }
        int numOuts = 0;
        if (this.outputPort != null) {
            numOuts = this.outputPort.getNumLinks();
        }
        Object[] inLinks = new PFDLink[numIns];
        this.inputPort.links.copyInto(inLinks);
        Object[] outLinks = new PFDLink[numOuts];
        this.outputPort.links.copyInto(outLinks);
        if (this.flowDirection.equals("Right")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.westPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.eastPort);
            }
            this.inputPort.setVisible(false);
            this.outputPort.setVisible(false);
            this.inputPort = this.westPort;
            this.outputPort = this.eastPort;
            this.inputPort.setVisible(true);
            this.outputPort.setVisible(true);
        } else if (this.flowDirection.equals("Left")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.eastPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.westPort);
            }
            this.inputPort.setVisible(false);
            this.outputPort.setVisible(false);
            this.inputPort = this.eastPort;
            this.outputPort = this.westPort;
            this.inputPort.setVisible(true);
            this.outputPort.setVisible(true);
        } else if (this.flowDirection.equals("Up")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.southPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.northPort);
            }
            this.inputPort.setVisible(false);
            this.outputPort.setVisible(false);
            this.inputPort = this.southPort;
            this.outputPort = this.northPort;
            this.inputPort.setVisible(true);
            this.outputPort.setVisible(true);
        } else {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.northPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.southPort);
            }
            this.inputPort.setVisible(false);
            this.outputPort.setVisible(false);
            this.inputPort = this.northPort;
            this.outputPort = this.southPort;
            this.inputPort.setVisible(true);
            this.outputPort.setVisible(true);
        }
    }

    private void checkFlowDirection(String direction) {
        if (direction == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
        }
        if (direction.equals("Left") || direction.equals("Right") || direction.equals("Up") || direction.equals("Down")) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (!p.isValidToPort()) continue;
            Vector inLinks = p.getToLinks();
            for (int j = 0; j < inLinks.size(); ++j) {
                PFDLink l = (PFDLink)inLinks.elementAt(j);
                if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
                pv.addElement(l.getFromNode());
            }
        }
        return pv;
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (!p.isValidFromPort()) continue;
            Vector outLinks = p.getFromLinks();
            for (int j = 0; j < outLinks.size(); ++j) {
                PFDLink l = (PFDLink)outLinks.elementAt(j);
                if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
                cv.addElement(l.getToNode());
            }
        }
        return cv;
    }

    @Override
    public int getLayoutWidth() {
        return this.icon.getWidth();
    }

    @Override
    public int getLayoutHeight() {
        return this.icon.getHeight();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.image == null) {
            out.writeObject("null");
        } else {
            out.writeObject(new ImageIcon(this.image));
        }
        if (this.selectedImage == null) {
            out.writeObject("null");
        } else {
            out.writeObject(new ImageIcon(this.selectedImage));
        }
        if (this.focusedImage == null) {
            out.writeObject("null");
        } else {
            out.writeObject(new ImageIcon(this.focusedImage));
        }
        if (this.stateMap == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.stateMap.size());
            Enumeration keys = this.stateMap.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Image img = (Image)this.stateMap.get(key);
                out.writeObject(key);
                if (img == null) {
                    out.writeObject("null");
                    continue;
                }
                out.writeObject(new ImageIcon(img));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object obj = in.readObject();
        if (obj != null && obj instanceof ImageIcon) {
            this.image = ((ImageIcon)obj).getImage();
        }
        if ((obj = in.readObject()) != null && obj instanceof ImageIcon) {
            this.selectedImage = ((ImageIcon)obj).getImage();
        }
        if ((obj = in.readObject()) != null && obj instanceof ImageIcon) {
            this.focusedImage = ((ImageIcon)obj).getImage();
        }
        this.stateMap = new Hashtable();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object keyObj = in.readObject();
            Object valueObj = in.readObject();
            if (keyObj == null || !(keyObj instanceof String) || valueObj == null || !(valueObj instanceof ImageIcon)) continue;
            this.stateMap.put(keyObj, ((ImageIcon)valueObj).getImage());
        }
    }
}

