/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.RB;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class PFDImageFileFilter
extends FileFilter {
    public static final String RB_KEY = "PFDImageFileFilter.";
    public static final int OPEN_FILE = 0;
    public static final int SAVE_FILE = 1;
    protected int action = 0;
    public static final String SAVE_FILTER_DESCRIPTION = RB.getStringResource("PFDImageFileFilter.", "saveFilterDescription.txt");
    public static final String OPEN_FILTER_DESCRIPTION = RB.getStringResource("PFDImageFileFilter.", "openFilterDescription.txt");
    public static final String bmp = "bmp";
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";

    public PFDImageFileFilter(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = PFDImageFileFilter.getExtension(f);
        if (extension != null) {
            return this.action == 1 ? extension.equals(bmp) || extension.equals(gif) : this.action == 0 && (extension.equals(jpg) || extension.equals(jpeg) || extension.equals(gif));
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.action == 1) {
            return SAVE_FILTER_DESCRIPTION;
        }
        return OPEN_FILTER_DESCRIPTION;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File addFileExtention(File f, String extension) {
        if (f == null) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        name.append(f.getName());
        name.append('.');
        name.append(extension);
        return new File(f.getParent(), name.toString());
    }
}

