/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDFlowChartShapes;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDLabeledNodeInterface;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPolygon;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PFDIconNode
extends PFDAbstractNode
implements PFDLabeledNodeInterface,
PFDDirectionalNodeInterface {
    public static final String RB_KEY = "PFDShapeIconNode.";
    public static final String EAST = "east";
    public static final String WEST = "west";
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    private PFDDrawablePrimitive drawable = null;
    private PFDImage icon = null;
    private PFDText label = null;
    private Vector ports = new Vector();
    private int shape = 2;
    private int labelPosition = 2;
    private String text;
    private ImageIcon image;
    private Point location;
    private Dimension size;
    private boolean showPorts = true;
    private boolean fixedAnglePorts = true;
    private PFDPort eastPort;
    private PFDPort westPort;
    private PFDPort northPort;
    private PFDPort southPort;
    private PFDPort auxPort1;
    private PFDPort auxPort2;
    private PFDPort inputPort;
    private PFDPort outputPort;
    private String flowDirection = "Right";

    public PFDIconNode() {
        this(new Point(0, 0), new Dimension(0, 0), 2, null, null);
    }

    public PFDIconNode(Point loc, Dimension size, ImageIcon image, String s) {
        this(loc, size, 2, image, s);
    }

    public PFDIconNode(Point loc, Dimension size, int shape, ImageIcon image, String s) {
        this.checkShape(shape);
        this.setBreakable(false);
        this.location = loc;
        this.size = size;
        this.shape = shape;
        this.image = image;
        this.text = s;
        this.initialize();
    }

    public PFDDrawablePrimitive getDrawable() {
        return this.drawable;
    }

    public PFDImage getIcon() {
        return this.icon;
    }

    public void setIconImage(ImageIcon image) {
        this.image = image;
        this.icon.setImage(image.getImage());
        this.layoutChildren();
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        if (this.shape == shape) {
            return;
        }
        this.checkShape(shape);
        this.shape = shape;
        this.removePrimitive(this.drawable);
        this.createDrawable();
        this.addPrimitive(0, this.drawable);
        this.layoutChildren();
    }

    private void checkShape(int shape) {
        switch (shape) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "shape.ex.txt"));
            }
        }
    }

    public PFDText getLabel() {
        return this.label;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.showPorts;
    }

    @Override
    public void setForceShowPorts(boolean b) {
        if (this.showPorts == b) {
            return;
        }
        this.showPorts = b;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            p.setVisible(this.showPorts);
        }
    }

    public boolean isForceFixedAngleConnectionPorts() {
        return this.fixedAnglePorts;
    }

    public void setForceFixedAngleConnectionPorts(boolean b) {
        if (this.fixedAnglePorts == b) {
            return;
        }
        this.fixedAnglePorts = b;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (this.fixedAnglePorts) {
                p.setFromLinkSpot(0);
                p.setToLinkSpot(0);
                continue;
            }
            p.setFromLinkSpot(9);
            p.setToLinkSpot(9);
            p.setFreeSpotOffsetX(3);
            p.setFreeSpotOffsetY(3);
        }
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(int position) {
        if (this.labelPosition == position) {
            return;
        }
        this.checkLabelPosition(position);
        this.labelPosition = position;
        this.layoutChildren();
    }

    private void checkLabelPosition(int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "label.ex.txt"));
            }
        }
    }

    protected void initialize() {
        this.createDrawable();
        this.label = new PFDText(this.text);
        this.label.setMultiline(true);
        if (this.image != null) {
            this.icon = new PFDImage(this.image.getImage());
        }
        this.eastPort = new PFDPort();
        this.eastPort.setName(EAST);
        this.eastPort.setType(0);
        this.eastPort.setValidFromPort(true);
        this.eastPort.setValidToPort(true);
        this.eastPort.setFromLinkDirection(0.0);
        this.eastPort.setToLinkDirection(Math.PI);
        this.ports.addElement(this.eastPort);
        this.westPort = new PFDPort();
        this.westPort.setName(WEST);
        this.westPort.setType(0);
        this.westPort.setValidFromPort(true);
        this.westPort.setValidToPort(true);
        this.westPort.setFromLinkDirection(Math.PI);
        this.westPort.setToLinkDirection(0.0);
        this.ports.addElement(this.westPort);
        this.northPort = new PFDPort();
        this.northPort.setName(NORTH);
        this.northPort.setType(0);
        this.northPort.setFromLinkDirection(1.5707963267948966);
        this.northPort.setToLinkDirection(4.71238898038469);
        this.ports.addElement(this.northPort);
        this.southPort = new PFDPort();
        this.southPort.setName(SOUTH);
        this.southPort.setType(0);
        this.southPort.setFromLinkDirection(4.71238898038469);
        this.southPort.setToLinkDirection(1.5707963267948966);
        this.ports.addElement(this.southPort);
        this.label.setClipHeight(this.size.height);
        this.eastPort.setEndSegmentLength(10);
        this.westPort.setEndSegmentLength(12);
        this.northPort.setEndSegmentLength(12);
        this.southPort.setEndSegmentLength(10);
        this.addPrimitive(this.drawable);
        if (this.icon != null) {
            this.addPrimitive(this.icon);
        }
        this.addPrimitive(this.label);
        this.addPrimitive(this.eastPort);
        this.addPrimitive(this.westPort);
        this.addPrimitive(this.northPort);
        this.addPrimitive(this.southPort);
        this.layoutChildren();
        this.inputPort = this.westPort;
        this.outputPort = this.eastPort;
        this.auxPort1 = this.northPort;
        this.auxPort2 = this.southPort;
    }

    protected void createDrawable() {
        PFDBrush brush = null;
        PFDPen pen = null;
        if (this.drawable != null) {
            brush = this.drawable.getBrush();
            pen = this.drawable.getPen();
            this.location = this.drawable.getLocation();
            this.size = this.drawable.getSize();
        }
        switch (this.shape) {
            default: {
                this.drawable = new PFDRectangle();
                break;
            }
            case 3: {
                this.drawable = new PFDRoundRectangle();
                break;
            }
            case 5: {
                this.drawable = new PFDEllipse();
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                this.drawable = new PFDPolygon();
            }
        }
        this.drawable.setBBox(this.location, this.size);
        if (brush != null) {
            this.drawable.setBrush(brush);
        }
        if (pen != null) {
            this.drawable.setPen(pen);
        }
    }

    protected void layoutChildren() {
        switch (this.shape) {
            default: {
                break;
            }
            case 6: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createDiamond(new Rectangle(this.location, this.size)));
                break;
            }
            case 7: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createHexagon(new Rectangle(this.location, this.size)));
                break;
            }
            case 10: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createOctagon(new Rectangle(this.location, this.size)));
            }
        }
        Rectangle r = this.drawable.getRBBox();
        int iw = 0;
        int ih = 0;
        if (this.icon != null) {
            iw = this.image.getIconWidth();
            ih = this.image.getIconHeight();
            int dx = (r.width - iw) / 2;
            int dy = (r.height - ih) / 2;
            this.icon.setBBox(r.x + dx, r.y + dy, iw, ih);
        }
        Point p = new Point();
        switch (this.labelPosition) {
            default: {
                this.drawable.getSpotLocation(6, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(1);
                this.label.setBBox(p.x, p.y + 5, 0, 0);
                this.label.setWrapWidth(3 * r.width);
                break;
            }
            case 1: {
                this.drawable.getSpotLocation(2, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(2);
                this.label.setBBox(p.x, p.y - 5, 0, 0);
                this.label.setWrapWidth(3 * r.width);
                break;
            }
            case 3: {
                this.drawable.getSpotLocation(8, p);
                this.label.setHorizontalAlignment(2);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x - 5, p.y, 0, 0);
                this.label.setWrapWidth(3 * r.width);
                break;
            }
            case 4: {
                this.drawable.getSpotLocation(4, p);
                this.label.setHorizontalAlignment(1);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x + 5, p.y, 0, 0);
                this.label.setWrapWidth(3 * r.width);
            }
        }
        this.label.forceUpdate();
        PFDPort eastPort = this.getPort(EAST);
        PFDPort westPort = this.getPort(WEST);
        PFDPort northPort = this.getPort(NORTH);
        PFDPort southPort = this.getPort(SOUTH);
        this.drawable.getSpotLocation(8, p);
        westPort.setBBox(p.x - 2, p.y, 0, 0);
        this.drawable.getSpotLocation(4, p);
        eastPort.setBBox(p.x + 3, p.y, 0, 0);
        this.drawable.getSpotLocation(2, p);
        northPort.setBBox(p.x, p.y - 2, 0, 0);
        this.drawable.getSpotLocation(6, p);
        southPort.setBBox(p.x, p.y + 3, 0, 0);
        eastPort.setToLinkSpot(0);
        eastPort.setFromLinkSpot(0);
        westPort.setToLinkSpot(0);
        westPort.setFromLinkSpot(0);
        northPort.setToLinkSpot(0);
        northPort.setFromLinkSpot(0);
        southPort.setToLinkSpot(0);
        southPort.setFromLinkSpot(0);
        this.calculateBBox();
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDIconNode clone = new PFDIconNode(this.drawable.getLocation(), this.drawable.getSize(), this.image, this.text);
        super.copyObject(clone);
        clone.setShape(this.getShape());
        clone.setLabelPosition(this.getLabelPosition());
        clone.setFlowDirection(this.getFlowDirection());
        clone.setForceShowPorts(this.isForceShowPorts());
        clone.setForceFixedAngleConnectionPorts(this.isForceFixedAngleConnectionPorts());
        this.drawable.copyObject(clone.getDrawable());
        if (this.icon != null) {
            this.icon.copyObject(clone.getIcon());
        }
        if (this.label != null) {
            this.label.copyObject(clone.getLabel());
        }
        table.put(this, clone);
        table.put(this.drawable, clone.drawable);
        if (this.icon != null) {
            table.put(this.icon, clone.icon);
        }
        if (this.label != null) {
            table.put(this.label, clone.label);
        }
        for (int i = 0; i < this.ports.size(); ++i) {
            table.put(this.ports.elementAt(i), clone.ports.elementAt(i));
        }
        return clone;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        Rectangle r = this.getRBBox();
        if (r.x == x && r.y == y && r.width == w && r.height == h) {
            return;
        }
        this.location = this.drawable.getLocation();
        this.size = this.drawable.getSize();
        x = Math.max(0, x);
        y = Math.max(0, y);
        if (w < this.size.width + 10 || h < this.size.height + 10) {
            return;
        }
        this.location.x += x - r.x;
        this.location.y += y - r.y;
        this.drawable.setBBox(this.location, this.size);
        this.layoutChildren();
        switch (this.labelPosition) {
            default: {
                this.label.setWrapWidth(w);
                this.label.setClipHeight(h - this.size.height);
                break;
            }
            case 3: 
            case 4: {
                this.label.setWrapWidth(w - this.size.width);
                this.label.setClipHeight(h);
            }
        }
        this.firePropertyChange("bbox");
    }

    @Override
    public void customize(PFDView view) {
    }

    public PFDPort getPort(int i) {
        return (PFDPort)this.ports.elementAt(i);
    }

    @Override
    public PFDPort getPort(String name) {
        this.checkPortName(name);
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort port = this.getPort(i);
            if (!name.equals(port.getName())) continue;
            return port;
        }
        return null;
    }

    private void checkPortName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
        }
        if (name.equals(EAST) || name.equals(WEST) || name.equals(NORTH) || name.equals(SOUTH)) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public Point getCenterLocation() {
        return this.drawable.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        Point center = this.getCenterLocation();
        Dimension delta = new Dimension(p.x - center.x, p.y - center.y);
        this.setLocation(this.bbox.x + delta.width, this.bbox.y + delta.height);
    }

    @Override
    public PFDPort getInputPort() {
        return this.inputPort;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.outputPort;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        this.checkFlowDirection(direction);
        if (this.flowDirection.equals(direction)) {
            return;
        }
        this.flowDirection = direction;
        int numIns = 0;
        if (this.inputPort != null) {
            numIns = this.inputPort.getNumLinks();
        }
        int numOuts = 0;
        if (this.outputPort != null) {
            numOuts = this.outputPort.getNumLinks();
        }
        int numAux1s = 0;
        if (this.auxPort1 != null) {
            numAux1s = this.auxPort1.getNumLinks();
        }
        int numAux2s = 0;
        if (this.auxPort2 != null) {
            numAux2s = this.auxPort2.getNumLinks();
        }
        Object[] inLinks = new PFDLink[numIns];
        this.inputPort.links.copyInto(inLinks);
        Object[] outLinks = new PFDLink[numOuts];
        this.outputPort.links.copyInto(outLinks);
        Object[] aux1Links = new PFDLink[numAux1s];
        this.auxPort1.links.copyInto(aux1Links);
        Object[] aux2Links = new PFDLink[numAux2s];
        this.auxPort2.links.copyInto(aux2Links);
        if (this.flowDirection.equals("Right")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.westPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.eastPort);
            }
            for (i = 0; i < numAux1s; ++i) {
                if (((PFDLink)aux1Links[i]).getFromPort() == this.auxPort1) {
                    ((PFDLink)aux1Links[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)aux1Links[i]).setToPort(this.northPort);
            }
            for (i = 0; i < numAux2s; ++i) {
                if (((PFDLink)aux2Links[i]).getFromPort() == this.auxPort2) {
                    ((PFDLink)aux2Links[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)aux2Links[i]).setToPort(this.southPort);
            }
            this.setLabelPosition(2);
            this.inputPort = this.westPort;
            this.outputPort = this.eastPort;
            this.auxPort1 = this.northPort;
            this.auxPort2 = this.southPort;
        } else if (this.flowDirection.equals("Left")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.eastPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.westPort);
            }
            for (i = 0; i < numAux1s; ++i) {
                if (((PFDLink)aux1Links[i]).getFromPort() == this.auxPort1) {
                    ((PFDLink)aux1Links[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)aux1Links[i]).setToPort(this.northPort);
            }
            for (i = 0; i < numAux2s; ++i) {
                if (((PFDLink)aux2Links[i]).getFromPort() == this.auxPort2) {
                    ((PFDLink)aux2Links[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)aux2Links[i]).setToPort(this.southPort);
            }
            this.setLabelPosition(2);
            this.inputPort = this.eastPort;
            this.outputPort = this.westPort;
            this.auxPort1 = this.northPort;
            this.auxPort2 = this.southPort;
        } else if (this.flowDirection.equals("Up")) {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.southPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.northPort);
            }
            for (i = 0; i < numAux1s; ++i) {
                if (((PFDLink)aux1Links[i]).getFromPort() == this.auxPort1) {
                    ((PFDLink)aux1Links[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)aux1Links[i]).setToPort(this.westPort);
            }
            for (i = 0; i < numAux2s; ++i) {
                if (((PFDLink)aux2Links[i]).getFromPort() == this.auxPort2) {
                    ((PFDLink)aux2Links[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)aux2Links[i]).setToPort(this.eastPort);
            }
            this.setLabelPosition(4);
            this.inputPort = this.southPort;
            this.outputPort = this.northPort;
            this.auxPort1 = this.westPort;
            this.auxPort2 = this.eastPort;
        } else {
            int i;
            for (i = 0; i < numIns; ++i) {
                if (((PFDLink)inLinks[i]).getFromPort() == this.inputPort) {
                    ((PFDLink)inLinks[i]).setFromPort(this.northPort);
                    continue;
                }
                ((PFDLink)inLinks[i]).setToPort(this.northPort);
            }
            for (i = 0; i < numOuts; ++i) {
                if (((PFDLink)outLinks[i]).getFromPort() == this.outputPort) {
                    ((PFDLink)outLinks[i]).setFromPort(this.southPort);
                    continue;
                }
                ((PFDLink)outLinks[i]).setToPort(this.southPort);
            }
            for (i = 0; i < numAux1s; ++i) {
                if (((PFDLink)aux1Links[i]).getFromPort() == this.auxPort1) {
                    ((PFDLink)aux1Links[i]).setFromPort(this.westPort);
                    continue;
                }
                ((PFDLink)aux1Links[i]).setToPort(this.westPort);
            }
            for (i = 0; i < numAux2s; ++i) {
                if (((PFDLink)aux2Links[i]).getFromPort() == this.auxPort2) {
                    ((PFDLink)aux2Links[i]).setFromPort(this.eastPort);
                    continue;
                }
                ((PFDLink)aux2Links[i]).setToPort(this.eastPort);
            }
            this.setLabelPosition(4);
            this.inputPort = this.northPort;
            this.outputPort = this.southPort;
            this.auxPort1 = this.westPort;
            this.auxPort2 = this.eastPort;
        }
    }

    private void checkFlowDirection(String direction) {
        if (direction == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
        }
        if (direction.equals("Left") || direction.equals("Right") || direction.equals("Up") || direction.equals("Down")) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "direction.ex.txt"));
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (!p.isValidToPort()) continue;
            Vector inLinks = p.getToLinks();
            for (int j = 0; j < inLinks.size(); ++j) {
                PFDLink l = (PFDLink)inLinks.elementAt(j);
                if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
                pv.addElement(l.getFromNode());
            }
        }
        return pv;
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.elementAt(i);
            if (!p.isValidFromPort()) continue;
            Vector outLinks = p.getFromLinks();
            for (int j = 0; j < outLinks.size(); ++j) {
                PFDLink l = (PFDLink)outLinks.elementAt(j);
                if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
                cv.addElement(l.getToNode());
            }
        }
        return cv;
    }

    @Override
    public int getLayoutWidth() {
        return this.getWidth();
    }

    @Override
    public int getLayoutHeight() {
        return this.getHeight();
    }
}

