/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PFDIconManager {
    private static final Hashtable imageTable = new Hashtable();
    private static final String keyPrefix = "res/";

    private PFDIconManager() {
    }

    public static Icon getIcon(String key) {
        if (key == null) {
            return null;
        }
        Image image = PFDIconManager.getImage(key);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Icon getSizedIcon(String key, Dimension size) {
        if (key == null || size == null) {
            return null;
        }
        Image image = PFDIconManager.getSizedImage(key, size);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    private static String getSizeString(Dimension size) {
        return Integer.toString(size.width) + "x" + Integer.toString(size.height);
    }

    private static Icon createSizedIcon(String key, Dimension size) {
        Image image = PFDIconManager.createSizedImage(key, size);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    private static Image createSizedImage(String key, Dimension size) {
        Image image = PFDIconManager.getImage(key);
        if (image == null) {
            return null;
        }
        Image scaledImage = image.getScaledInstance(size.width, size.height, 4);
        imageTable.put(key + PFDIconManager.getSizeString(size), scaledImage);
        return scaledImage;
    }

    public static Image getImage(String key) {
        if (key == null) {
            return null;
        }
        Image image = (Image)imageTable.get(key);
        if (image != null) {
            return image;
        }
        URL url = PFDIconManager.class.getResource(keyPrefix + key);
        if (url == null) {
            return null;
        }
        image = Toolkit.getDefaultToolkit().createImage(url);
        imageTable.put(key, image);
        return image;
    }

    public static Image getSizedImage(String key, Dimension size) {
        if (key == null || size == null) {
            return null;
        }
        Image image = PFDIconManager.getImage(key);
        if (image == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(image);
        if (size.width == icon.getIconWidth() && size.height == icon.getIconHeight()) {
            return image;
        }
        image = (Image)imageTable.get(key + PFDIconManager.getSizeString(size));
        if (image != null) {
            return image;
        }
        return PFDIconManager.createSizedImage(key, size);
    }
}

