/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDControlNode;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PFDIconControlNode
extends PFDControlNode
implements ImageObserver {
    private static final long serialVersionUID = 1536897920026603672L;
    protected PFDImage nodeIcon;

    public PFDIconControlNode() {
        this.controlShape = new PFDRoundRectangle(new Rectangle(0, 0, PFDIconControlNode.defaultSize.width, PFDIconControlNode.defaultSize.height), 8, 8);
        this.selectionShape = new PFDRoundRectangle(new Rectangle(0, 0, PFDIconControlNode.defaultSize.width, PFDIconControlNode.defaultSize.height), 16, 16);
        this.nodeIcon = new PFDImage();
        this.addPrimitive(this.nodeIcon);
        this.init();
    }

    @Override
    protected void layoutChildren() {
        this.disableChangeUpdate();
        Rectangle bounds = this.controlShape.getRBBox();
        this.selectionShape.setBBox(bounds.x - 4, bounds.y - 4, bounds.width + 8, bounds.height + 8);
        this.layoutText();
        this.layoutStatusButton();
        this.layoutPorts();
        Image img = this.nodeIcon.getImage();
        Dimension imgSize = new Dimension(bounds.width, bounds.height);
        if (img != null) {
            imgSize.width = Math.min(imgSize.width, img.getWidth(this));
            imgSize.height = Math.min(imgSize.height, img.getHeight(this));
        }
        this.nodeIcon.setBBox(bounds.x + bounds.width / 2 - imgSize.width / 2, bounds.y + bounds.height / 2 - imgSize.height / 2, imgSize.width, imgSize.height);
        this.layoutNodeNumber(this.controlShape.getSpotLocation(1, null));
        this.enableChangeUpdate();
        this.calculateBBox();
    }

    @Override
    protected void layoutStatusButton() {
        Rectangle bounds = this.controlShape.getRBBox();
        this.statusButton.setLocation(bounds.x + bounds.width - this.statusButton.getWidth() / 2, bounds.y + bounds.height - this.statusButton.getHeight() / 2);
    }

    @Override
    protected void draw(Graphics2D g2d, PFDView v, boolean selected) {
        Rectangle bounds = this.controlShape.getRBBox();
        if (this.useGradientFill) {
            this.updateShapeGradient();
        }
        this.controlShape.paint(g2d);
        this.nodeIcon.paint(g2d);
        this.outputPortGroup.paint(g2d);
        if (selected) {
            this.drawSelection(g2d);
        }
        this.titleText.paint(g2d);
        this.drawNodeNumber(g2d);
        this.drawStatusButton(g2d);
        this.drawStatusWindow(g2d);
    }

    @Override
    protected void drawGhosted(Graphics2D g, PFDView v, boolean selected) {
        if (selected) {
            this.drawSelection(g);
        }
        if (this.useGradientFill) {
            this.updateShapeGradient();
        }
        BufferedImage primitiveImage = new BufferedImage(this.bbox.width, this.bbox.height, 2);
        Graphics2D imageGraphics = primitiveImage.createGraphics();
        imageGraphics.setRenderingHints(g.getRenderingHints());
        imageGraphics.translate(-this.bbox.x, -this.bbox.y);
        this.controlShape.paint(imageGraphics);
        this.nodeIcon.paint(imageGraphics);
        this.outputPortGroup.paint(imageGraphics);
        this.titleText.paint(imageGraphics);
        this.drawNodeNumber(imageGraphics);
        this.drawStatusButton(imageGraphics);
        imageGraphics.dispose();
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.drawImage((Image)primitiveImage, this.bbox.x, this.bbox.y, v);
        primitiveImage.flush();
        g.setComposite(oldComposite);
        this.drawStatusWindow(g);
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("nodeIcon")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    public void setNodeIcon(Icon icon) {
        if (icon == null) {
            this.nodeIcon.setImage(null);
        } else {
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            this.nodeIcon.setImage(image);
        }
        this.firePropertyChange("nodeIcon");
    }

    public Icon getNodeIcon() {
        Image img = this.nodeIcon.getImage();
        if (img == null) {
            return null;
        }
        return new ImageIcon(img);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDIconControlNode clone = new PFDIconControlNode();
        table.put(this, clone);
        this.copyObject(clone);
        this.clonePorts(table, clone);
        return clone;
    }

    public void copyObject(PFDIconControlNode toObject) {
        super.copyObject(toObject);
        toObject.setNodeIcon(this.getNodeIcon());
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        int flag = 3;
        if ((infoflags & flag) == flag) {
            this.layoutChildren();
            return false;
        }
        return true;
    }
}

