/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PFDIcon
extends PFDDrawablePrimitive
implements ImageObserver {
    private static final Color overviewColor = Color.gray;
    private transient Icon icon;
    public String resourceLocation = null;

    public PFDIcon() {
        this((Icon)null);
    }

    public PFDIcon(Icon icon) {
        this.icon = icon;
        this.resizable = false;
        this.shadowSize = 2;
        this.shadowShift = 2;
        this.shadowOpacity = 0.16f;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setResourceLocation(String location) {
        this.resourceLocation = location;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setIcon(Icon icon) {
        if (this.icon == icon) {
            return;
        }
        this.removeImageObserver(this.icon);
        this.icon = icon;
        this.addImageObserver(this.icon);
        this.firePropertyChange("icon");
        int w = 0;
        int h = 0;
        if (icon != null) {
            w = icon.getIconWidth();
            h = icon.getIconHeight();
        }
        super.setBBox(this.bbox.x, this.bbox.y, w, h);
    }

    @Override
    public void setBBox(int x, int y, int width, int height) {
        super.setBBox(x, y, this.bbox.width, this.bbox.height);
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.icon == null) {
            return;
        }
        if (this.shadowOn) {
            this.drawShadow(g2d, v);
        }
        this.icon.paintIcon(v, g2d, this.bbox.x, this.bbox.y);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDIcon clone = new PFDIcon();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDIcon toObject) {
        super.copyObject(toObject);
        toObject.setIcon(this.getIcon());
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        g2d.setColor(overviewColor);
        g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        g2d.setColor(Color.black);
        g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (this.theView == null || !this.doesIconReferenceImage(this.icon, img) || !this.isIconVisible()) {
            return false;
        }
        Rectangle bounds = this.getBBox();
        Rectangle viewRect = this.theView.getViewRect();
        if (viewRect.intersects(bounds)) {
            if ((infoflags & 0x30) != 0) {
                this.theView.ModelToView(bounds);
                this.theView.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            return (infoflags & 0xA0) == 0;
        }
        return false;
    }

    private boolean isIconVisible() {
        PFDPrimitive topPrimitive = this;
        for (PFDGroup g = this.group; g != null; g = g.getGroup()) {
            topPrimitive = g;
            if (g.isVisible()) continue;
            return false;
        }
        PFDModel m = topPrimitive.getModel();
        return m != null && this.theView.getModel() == m && m.containsPrimitive(topPrimitive);
    }

    private void addImageObserver(Icon icon) {
        if (icon instanceof ImageIcon) {
            ((ImageIcon)icon).setImageObserver(this);
        }
    }

    private void removeImageObserver(Icon icon) {
        if (icon instanceof ImageIcon) {
            ((ImageIcon)icon).setImageObserver(null);
        }
    }

    private boolean doesIconReferenceImage(Icon icon, Image image) {
        Image iconImage = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        return iconImage == image;
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        this.removeImageObserver(this.icon);
    }

    @Override
    protected void attachView(PFDView v) {
        super.attachView(v);
        this.addImageObserver(this.icon);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.icon == null ? null : this.createSerializableIcon());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.icon = (Icon)in.readObject();
    }

    private Icon createSerializableIcon() {
        if (this.icon instanceof Serializable) {
            return this.icon;
        }
        BufferedImage image = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(image);
    }
}

