/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class PFDHTMLParser
extends HTMLEditorKit.ParserCallback {
    Stack attributeStack;
    String text;
    Vector textRuns;
    Vector txtAttribute;
    Vector styledLineText;
    Font defaultFont = new Font("SansSerif", 0, 12);
    Color defaultColor = Color.black;

    public PFDHTMLParser() {
        this.attributeStack = new Stack();
        this.text = new String();
        this.textRuns = new Vector();
        this.txtAttribute = new Vector();
        this.styledLineText = new Vector();
    }

    @Override
    public void handleComment(char[] data, int pos) {
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.BR) {
            this.handleBR();
        } else if (t == HTML.Tag.BASEFONT) {
            this.handleBASEFONT(a);
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        Hashtable attributes = this.attributeStack.empty() ? new Hashtable() : new Hashtable((Hashtable)this.attributeStack.peek());
        if (t == HTML.Tag.FONT) {
            this.handleFONT(attributes, a);
        } else if (t == HTML.Tag.BODY) {
            this.handleBODY(attributes, a);
        } else if (t == HTML.Tag.B) {
            this.handleB(attributes);
        } else if (t == HTML.Tag.I) {
            this.handleI(attributes);
        } else if (t == HTML.Tag.U) {
            this.handleU(attributes);
        }
        this.attributeStack.push(attributes);
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (!this.attributeStack.empty()) {
            this.attributeStack.pop();
        }
    }

    @Override
    public void handleError(String errorMsg, int pos) {
    }

    @Override
    public void handleText(char[] data, int pos) {
        Hashtable currentStyle = this.attributeStack.empty() ? new Hashtable() : (Hashtable)this.attributeStack.peek();
        String dataString = new String(data);
        if (this.textRuns.size() > 0) {
            dataString = ' ' + dataString;
        }
        this.text = this.text + dataString;
        this.textRuns.add(dataString);
        this.txtAttribute.add(currentStyle);
    }

    @Override
    public void handleEndOfLineString(String eol) {
        this.createTextLine();
    }

    public Vector getStyledLineText() {
        return this.styledLineText;
    }

    protected void handleBR() {
        if (this.text == null || this.text.length() == 0) {
            this.createBlankLine();
        } else {
            this.createTextLine();
        }
        this.text = new String();
        this.textRuns.removeAllElements();
        this.txtAttribute.removeAllElements();
    }

    protected void createTextLine() {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        int numTextRuns = this.textRuns.size();
        int currentPosition = 0;
        int nextPosition = 0;
        AttributedString styledText = new AttributedString(this.text);
        for (int i = 0; i < numTextRuns; ++i) {
            String currRun = (String)this.textRuns.elementAt(i);
            Hashtable currStyle = (Hashtable)this.txtAttribute.elementAt(i);
            nextPosition = currentPosition + currRun.length();
            if (currRun == null || currRun.length() == 0 || currStyle == null) {
                currentPosition = nextPosition;
                continue;
            }
            if (currStyle.get(TextAttribute.FONT) == null) {
                currStyle.put(TextAttribute.FONT, this.defaultFont);
            }
            if (currStyle.get(TextAttribute.FOREGROUND) == null) {
                currStyle.put(TextAttribute.FOREGROUND, this.defaultColor);
            }
            styledText.addAttributes(currStyle, currentPosition, nextPosition);
            currentPosition = nextPosition;
        }
        this.styledLineText.add(styledText);
    }

    protected void createBlankLine() {
        Hashtable<TextAttribute, Font> style = (Hashtable<TextAttribute, Font>)this.attributeStack.peek();
        if (style == null) {
            style = new Hashtable<TextAttribute, Font>();
        }
        if (style.get(TextAttribute.FONT) == null) {
            style.put(TextAttribute.FONT, this.defaultFont);
        }
        this.styledLineText.add(new AttributedString(" ", style));
    }

    protected void handleFONT(Hashtable textAttributes, MutableAttributeSet tagAttributes) {
        Color textColor;
        int size;
        String faceString = (String)tagAttributes.getAttribute(HTML.Attribute.FACE);
        String sizeString = (String)tagAttributes.getAttribute(HTML.Attribute.SIZE);
        String colorString = (String)tagAttributes.getAttribute(HTML.Attribute.COLOR);
        Font parentFont = (Font)textAttributes.get(TextAttribute.FONT);
        if (parentFont == null) {
            parentFont = this.defaultFont;
        }
        String[] face = faceString == null ? new String[]{parentFont.getFamily()} : this.parseStringList(faceString);
        if (sizeString == null) {
            size = parentFont.getSize();
        } else {
            try {
                size = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException e) {
                size = parentFont.getSize();
            }
        }
        Font newFont = null;
        for (int i = 0; i < face.length && !face[i].equalsIgnoreCase((newFont = new Font(face[i], parentFont.getStyle(), size)).getFamily()); ++i) {
            newFont = null;
        }
        if (newFont == null) {
            newFont = new Font(parentFont.getFamily(), parentFont.getStyle(), size);
        }
        textAttributes.put(TextAttribute.FONT, newFont);
        if (colorString != null && (textColor = this.stringToColor(colorString)) != null) {
            textAttributes.put(TextAttribute.FOREGROUND, textColor);
        }
    }

    protected void handleBODY(Hashtable textAttributes, MutableAttributeSet tagAttributes) {
        Color textColor;
        String colorString = (String)tagAttributes.getAttribute(HTML.Attribute.TEXT);
        if (colorString != null && (textColor = this.stringToColor(colorString)) != null) {
            textAttributes.put(TextAttribute.FOREGROUND, textColor);
        }
    }

    protected void handleBASEFONT(MutableAttributeSet tagAttributes) {
        Color textColor;
        int size;
        String[] face;
        String faceString = (String)tagAttributes.getAttribute(HTML.Attribute.FACE);
        String sizeString = (String)tagAttributes.getAttribute(HTML.Attribute.SIZE);
        String colorString = (String)tagAttributes.getAttribute(HTML.Attribute.COLOR);
        if (faceString == null) {
            face = new String[1];
            face[1] = this.defaultFont.getFamily();
        } else {
            face = this.parseStringList(faceString);
        }
        if (sizeString == null) {
            size = this.defaultFont.getSize();
        } else {
            try {
                size = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException e) {
                size = this.defaultFont.getSize();
            }
        }
        Font newBaseFont = null;
        for (int i = 0; i < face.length; ++i) {
            newBaseFont = new Font(face[i], this.defaultFont.getStyle(), size);
            if (face[i].equalsIgnoreCase(newBaseFont.getFamily())) continue;
            newBaseFont = null;
        }
        if (newBaseFont == null) {
            newBaseFont = new Font(this.defaultFont.getFamily(), this.defaultFont.getStyle(), size);
        }
        this.defaultFont = newBaseFont;
        if (colorString != null && (textColor = this.stringToColor(colorString)) != null) {
            this.defaultColor = textColor;
        }
    }

    protected void handleB(Hashtable textAttributes) {
        Font parentFont = (Font)textAttributes.get(TextAttribute.FONT);
        if (parentFont == null) {
            parentFont = this.defaultFont;
        }
        Font newFont = parentFont.deriveFont(parentFont.getStyle() | 1);
        textAttributes.put(TextAttribute.FONT, newFont);
    }

    protected void handleI(Hashtable textAttributes) {
        Font parentFont = (Font)textAttributes.get(TextAttribute.FONT);
        if (parentFont == null) {
            parentFont = this.defaultFont;
        }
        Font newFont = parentFont.deriveFont(parentFont.getStyle() | 2);
        textAttributes.put(TextAttribute.FONT, newFont);
    }

    protected void handleU(Hashtable textAttributes) {
        textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
    }

    protected Color stringToColor(String colorString) {
        if (colorString == null) {
            return null;
        }
        if (colorString.indexOf(35) == 0) {
            Color retColor;
            if (colorString.length() <= 1) {
                return null;
            }
            try {
                retColor = Color.decode(colorString);
            }
            catch (NumberFormatException e) {
                retColor = null;
            }
            return retColor;
        }
        if (colorString.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (colorString.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (colorString.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (colorString.equalsIgnoreCase("darkgray")) {
            return Color.darkGray;
        }
        if (colorString.equalsIgnoreCase("dark_gray")) {
            return Color.darkGray;
        }
        if (colorString.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (colorString.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (colorString.equalsIgnoreCase("lightgray")) {
            return Color.lightGray;
        }
        if (colorString.equalsIgnoreCase("light_gray")) {
            return Color.lightGray;
        }
        if (colorString.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (colorString.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (colorString.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (colorString.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (colorString.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (colorString.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return null;
    }

    protected String[] parseStringList(String list) {
        Vector<String> buffer = new Vector<String>();
        while (list != null && list.length() > 0) {
            int commaIndex = list.indexOf(44);
            if (commaIndex == -1) {
                buffer.add(list.trim());
                list = null;
                continue;
            }
            String element = list.substring(0, commaIndex);
            if (element != null && element.length() > 0) {
                buffer.add(element.trim());
            }
            if (commaIndex + 1 >= list.length()) {
                list = null;
                continue;
            }
            list = list.substring(commaIndex + 1);
        }
        if (buffer.isEmpty()) {
            return new String[0];
        }
        return buffer.toArray(new String[0]);
    }

    public void setDefaultFont(Font font) {
        if (font != null) {
            this.defaultFont = font;
        }
    }

    public void setDefaultColor(Color color) {
        if (color != null) {
            this.defaultColor = color;
        }
    }
}

