/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSubdiagram;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDWindow;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDGroupElementInterface;
import com.sas.graphics.components.pfd.interfaces.PFDSubdiagramContainer;
import com.sas.graphics.components.pfd.interfaces.PFDUngroupable;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.text.MessageFormat;

public class PFDGroupWindow
extends PFDWindow
implements PFDSubdiagramContainer,
PFDGroupElementInterface,
PFDUngroupable,
PFDDirectionalNodeInterface {
    private static final int minTitleBarWidth = 100;
    private static final int minTruncatedTitleWidth = 100;
    private static final int subdiagramPadding = 3;
    private static final String RB_KEY = "PFDGroupWindow.";
    private PFDSubdiagram subdiagram;
    private Rectangle subdiagramBounds;
    private PFDText objectCountText;
    private String objectCountFormatPattern;
    private Rectangle titleBarDrawRect;
    private static final Color defaultOutlineColor = Color.black;
    private static final Color defaultFillColor = Color.gray;
    private static final int fillTransparency = 220;
    private Color subdiagramAltColor = defaultOutlineColor;
    private PFDCollapsableNodeGroup collapsableGroup;
    private boolean objectCountVisible = true;

    public PFDGroupWindow(PFDCollapsableNodeGroup group) {
        this.collapsableGroup = group;
        this.initialize();
    }

    private void initialize() {
        this.minWindowSize.setSize(230, 200);
        this.titleText.setFontStyle(1);
        this.titleText.setFontSize(10);
        this.titleText.setForeground(new Color(60, 60, 60));
        this.setParent(this.collapsableGroup);
        this.setEditable(true);
        this.setResizable(false);
        this.setBreakable(false);
        this.subdiagramBounds = new Rectangle(-1, -1, -1, -1);
        this.subdiagram = new PFDSubdiagram();
        this.subdiagram.getPen().setStyle(1);
        this.subdiagram.getPen().setColor(defaultOutlineColor);
        this.subdiagram.setBorderInsets(new Insets(5, 5, 5, 5));
        this.subdiagram.getBrush().setStyle(2);
        this.subdiagram.getBrush().setColor(defaultFillColor);
        this.subdiagram.setSelectable(false);
        this.objectCountText = new PFDText();
        this.objectCountText.setFontSize(10);
        this.objectCountText.setSelectable(false);
        this.objectCountFormatPattern = RB.getStringResource(RB_KEY, "objectCount.fmt");
        this.titleBarDrawRect = new Rectangle();
        this.addPrimitive(this.objectCountText);
        this.addPrimitive(this.subdiagram);
    }

    public void setObjectCountVisible(boolean objectCountVisible) {
        if (this.objectCountVisible == objectCountVisible) {
            return;
        }
        this.objectCountVisible = objectCountVisible;
        this.firePropertyChange("objectCountVisible", !objectCountVisible, objectCountVisible);
    }

    public boolean isObjectCountVisible() {
        return this.objectCountVisible;
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.backgroundRect.renderOverview(g2d, v);
        this.subdiagram.renderOverview(g2d, v);
    }

    @Override
    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        this.drawBackground(g);
        this.titleText.paint(g);
        this.objectCountText.paint(g);
        this.closeButton.paint(g);
        this.drawTitleBar(g);
        if (this.resizable) {
            this.drawResizeHandle(g);
        }
        if (selected) {
            this.drawSelection(g);
        }
        this.drawSubdiagram(g, v);
    }

    protected void drawSubdiagram(Graphics2D g, PFDView v) {
        if (this.subdiagram == null) {
            return;
        }
        this.subdiagram.paint(g, v);
        Rectangle bounds = this.subdiagram.getRBBox();
        if (g.hitClip(bounds.x, bounds.y, bounds.width, 1)) {
            g.setColor(this.subdiagramAltColor);
            g.setStroke(seperatorStroke);
            g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        }
    }

    protected void drawBackground(Graphics2D g) {
        if (this.subdiagram == null) {
            this.backgroundRect.paint(g);
        } else {
            Rectangle r = this.subdiagram.getRBBox();
            Shape oldClip = g.getClip();
            Area newClip = oldClip == null ? new Area(this.getVisualRBBox()) : new Area(oldClip);
            Area subArea = new Area(r);
            newClip.subtract(subArea);
            g.setClip(newClip);
            this.backgroundRect.paint(g);
            g.setClip(oldClip);
        }
    }

    protected void drawTitleBar(Graphics2D g) {
        int halfStrokeWidth = (int)Math.floor((double)seperatorStroke.getLineWidth() / 2.0);
        if (g.hitClip(this.titleBarDrawRect.x - halfStrokeWidth, this.titleBarDrawRect.y - halfStrokeWidth, this.titleBarDrawRect.width + halfStrokeWidth * 2, this.titleBarDrawRect.height + 1 + halfStrokeWidth * 2)) {
            g.setColor(this.lineColor);
            g.setStroke(seperatorStroke);
            int numLines = 4;
            int dy = this.titleBarDrawRect.height / (numLines - 1);
            for (int i = 0; i < numLines; ++i) {
                g.drawLine(this.titleBarDrawRect.x, this.titleBarDrawRect.y + i * dy, this.titleBarDrawRect.x + this.titleBarDrawRect.width - 1, this.titleBarDrawRect.y + i * dy);
            }
        }
    }

    @Override
    protected void closeWindow() {
        this.collapsableGroup.setCollapsed(true);
        if (this.theView != null) {
            this.theView.clearSelections();
            this.theView.selectPrimitive(this.collapsableGroup);
        }
    }

    @Override
    public PFDSubdiagram getSubdiagram() {
        return this.subdiagram;
    }

    @Override
    public PFDAbstractNode getCollapsedNode() {
        if (this.collapsable && this.collapsed instanceof PFDAbstractNode) {
            return (PFDAbstractNode)this.collapsed;
        }
        return null;
    }

    @Override
    protected void calculateBBox() {
        Rectangle bounds = this.subdiagram.getRBBox();
        if (bounds.equals(this.subdiagramBounds)) {
            super.calculateBBox();
        } else {
            this.layoutChildren();
        }
    }

    @Override
    protected void layoutChildren() {
        Dimension windowSize;
        Point windowLocation;
        Point point = new Point();
        if (this.subdiagram.hasNoPrimitives()) {
            windowLocation = this.bbox.getLocation();
            windowSize = this.minWindowSize;
        } else {
            windowLocation = this.getWindowLocation(this.subdiagram.getLocation());
            windowSize = this.getWindowSize(this.subdiagram.getSize());
        }
        this.subdiagramBounds.setBounds(this.subdiagram.getRBBox());
        this.backgroundRect.setLocation(windowLocation);
        this.backgroundRect.setSize(windowSize);
        this.windowIcon.setLocation(this.backgroundRect.getX() + 7, this.backgroundRect.getY() + 7);
        this.titleBar.setBBox(this.backgroundRect.getX(), this.backgroundRect.getY(), this.backgroundRect.getWidth(), this.getTitleBarHeight());
        this.backgroundRect.getSpotLocation(3, point);
        point.x -= this.closeButton.getWidth() + 7;
        point.y += 13 - this.closeButton.getHeight() / 2;
        this.closeButton.setLocation(point);
        int remainingWidth = this.backgroundRect.getWidth() - 14 - 4 - this.closeButton.getWidth();
        int centerY = this.backgroundRect.getY() + 7 + 6;
        this.layoutObjectCount(this.closeButton.getX() - 4, centerY);
        int objectCountWidth = this.objectCountText.getWidth();
        this.layoutTitle(this.backgroundRect.getX() + 7, centerY, 0, false);
        int titleWidth = this.titleText.getWidth();
        if (remainingWidth - titleWidth - objectCountWidth - 8 >= 100) {
            this.titleBarDrawRect.setRect(this.backgroundRect.getX() + 7 + titleWidth + 4, this.backgroundRect.getY() + 7, remainingWidth - titleWidth - objectCountWidth - 8, 12.0);
        } else if (remainingWidth - 100 - objectCountWidth - 8 >= 100) {
            this.titleBarDrawRect.setRect(this.closeButton.getX() - 8 - objectCountWidth - 100, this.backgroundRect.getY() + 7, 100.0, 12.0);
            int clipWidth = remainingWidth - objectCountWidth - 100 - 8;
            this.layoutTitle(this.backgroundRect.getX() + 7, centerY, clipWidth, true);
        } else if (remainingWidth - titleWidth - 4 >= 100) {
            this.titleBarDrawRect.setRect(this.backgroundRect.getX() + 7 + titleWidth + 4, this.backgroundRect.getY() + 7, remainingWidth - titleWidth - 4, 12.0);
            this.clearObjectCountText();
        } else if (remainingWidth - 100 - 4 >= 100) {
            this.titleBarDrawRect.setRect(this.closeButton.getX() - 4 - 100, this.backgroundRect.getY() + 7, 100.0, 12.0);
            int clipWidth = remainingWidth - 100 - 4;
            this.layoutTitle(this.backgroundRect.getX() + 7, centerY, clipWidth, true);
            this.clearObjectCountText();
        } else if (remainingWidth - titleWidth - 4 > 0) {
            this.titleBarDrawRect.setRect(this.backgroundRect.getX() + 7 + titleWidth + 4, this.backgroundRect.getY() + 7, remainingWidth - titleWidth - 4, 12.0);
            this.clearObjectCountText();
        } else if (remainingWidth - 100 - 4 > 0) {
            this.titleBarDrawRect.setRect(this.backgroundRect.getX() + 7 + 100 + 4, this.backgroundRect.getY() + 7, remainingWidth - 100 - 4, 12.0);
            this.layoutTitle(this.backgroundRect.getX() + 7, centerY, 100, true);
            this.clearObjectCountText();
        } else {
            this.titleBarDrawRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.layoutTitle(this.backgroundRect.getX() + 7, centerY, remainingWidth, true);
            this.clearObjectCountText();
        }
        this.resizeHotSpot.setBBox(this.backgroundRect.getX() + this.backgroundRect.getWidth() - 7 - 1, this.backgroundRect.getY() + this.backgroundRect.getHeight() - 7 - 1, 8, 8);
        super.calculateBBox();
    }

    protected void layoutObjectCount(int x, int y) {
        if (this.objectCountVisible) {
            int numObjects = this.subdiagram.getNumPrimitives();
            String s = MessageFormat.format(this.objectCountFormatPattern, new Integer(numObjects));
            this.objectCountText.disableChangeUpdate();
            this.objectCountText.setText(s);
            this.objectCountText.setVerticalAlignment(0);
            this.objectCountText.setHorizontalAlignment(2);
            this.objectCountText.setMultiline(false);
            this.objectCountText.setClipping(false);
            this.objectCountText.setBBox(x, y, 0, 0);
            this.objectCountText.forceUpdate();
            this.objectCountText.enableChangeUpdate();
        } else {
            this.clearObjectCountText();
        }
    }

    private void clearObjectCountText() {
        this.objectCountText.disableChangeUpdate();
        this.objectCountText.setText(null);
        this.objectCountText.forceUpdate();
        this.objectCountText.enableChangeUpdate();
    }

    protected void layoutTitle(int x, int y, int clipWidth, boolean clip) {
        this.titleText.disableChangeUpdate();
        this.titleText.setVerticalAlignment(0);
        this.titleText.setHorizontalAlignment(1);
        this.titleText.setMultiline(false);
        this.titleText.setClipping(clip);
        this.titleText.setWrapWidth(clipWidth);
        this.titleText.setBBox(x, y, 0, 0);
        this.titleText.forceUpdate();
        this.titleText.enableChangeUpdate();
    }

    @Override
    protected void layoutTitle(Rectangle r) {
        this.titleText.setVerticalAlignment(0);
        this.titleText.setHorizontalAlignment(1);
        this.titleText.setMultiline(true);
        this.titleText.setWrapWidth(r.width);
        this.titleText.setClipHeight(r.height);
        this.titleText.setClipping(true);
        this.titleText.setBBox(r.x, r.y, 0, 0);
        this.titleText.forceUpdate();
    }

    @Override
    protected int getTitleBarHeight() {
        return 24;
    }

    @Override
    protected Dimension getContentSize(Dimension windowSize) {
        return new Dimension(windowSize.width - 6, windowSize.height - this.getTitleBarHeight() - 3);
    }

    @Override
    protected Point getContentLocation(Point windowLocation) {
        return new Point(windowLocation.x + 3, windowLocation.y + this.getTitleBarHeight());
    }

    @Override
    protected Dimension getWindowSize(Dimension contentSize) {
        return new Dimension(contentSize.width + 6, contentSize.height + this.getTitleBarHeight() + 3);
    }

    protected Point getWindowLocation(Point contentLocation) {
        return new Point(contentLocation.x - 3, contentLocation.y - this.getTitleBarHeight());
    }

    @Override
    protected void updateStyle(Style style) {
        Color lineColor;
        Color fillColor;
        super.updateStyle(style);
        StyleElement se = style.getStyleElement("GroupWindowStyle");
        if (se != null) {
            fillColor = se.getColorAttribute("fillColor", defaultFillColor);
            lineColor = se.getColorAttribute("lineColor", defaultOutlineColor);
            Color contrastColor = se.getColorAttribute("altColor", defaultOutlineColor);
            Color textColor = se.getColorAttribute("textColor", defaultOutlineColor);
            this.setFillColor(fillColor);
            this.setOutlineColor(lineColor);
            this.setLineColor(contrastColor);
            this.objectCountText.setForeground(textColor);
        }
        if ((se = style.getStyleElement("GroupStyle")) != null) {
            fillColor = se.getColorAttribute("fillColor", defaultFillColor);
            lineColor = se.getColorAttribute("lineColor", defaultOutlineColor);
            this.subdiagramAltColor = se.getColorAttribute("altColor", defaultOutlineColor);
            this.subdiagram.getPen().setColor(lineColor);
            fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), 220);
            this.subdiagram.getBrush().setColor(fillColor);
        }
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("title") || property.equals("objectCountVisible")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public void collapse() {
        super.collapse();
        this.collapseLinks();
    }

    protected void collapseLinks() {
        if (this.collapsed instanceof PFDAbstractNode) {
            this.subdiagram.collapseLinks(((PFDAbstractNode)this.collapsed).getInputPort(), ((PFDAbstractNode)this.collapsed).getOutputPort());
        }
    }

    @Override
    protected void expandToPoint(int x, int y, PFDGroup g) {
        super.expandToPoint(x, y, g);
        this.subdiagram.expandLinks();
        this.bringToFront();
    }

    @Override
    protected void setCollapsed(PFDPrimitive p) {
        super.setCollapsed(p);
        super.collapse();
    }

    @Override
    public boolean canUngroup() {
        return this.collapsableGroup.canUngroup();
    }

    @Override
    public void ungroup() {
        this.collapsableGroup.ungroup();
    }

    @Override
    public String getFlowDirection() {
        return this.subdiagram.getFlowDirection();
    }

    @Override
    public void setFlowDirection(String direction) {
        this.subdiagram.setFlowDirection(direction);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        int mouseMode = this.theView.getMouseExtendedMode();
        this.theView.setMouseOverPrimitive(this, e);
        if (e.getSource() == this || e.getSource() == this.titleBar) {
            if (!this.selectable) {
                return;
            }
            switch (mouseMode) {
                case 4: {
                    if (this.theView.isSelected(this.collapsableGroup)) break;
                    this.theView.clearSelections();
                    this.theView.selectPrimitive(this.collapsableGroup);
                    break;
                }
                case 2: {
                    if (this.theView.isSelected(this.collapsableGroup)) {
                        this.theView.deselectPrimitive(this.collapsableGroup);
                        break;
                    }
                    this.theView.selectPrimitive(this.collapsableGroup);
                    if (!this.theView.isEditMode() || !this.isDraggable() || e.getSource() != this.titleBar) break;
                    this.theView.setDragMode(0);
                    break;
                }
                default: {
                    if (!this.theView.isSelected(this.collapsableGroup)) {
                        this.theView.clearSelections();
                        this.theView.selectPrimitive(this.collapsableGroup);
                    }
                    if (!this.theView.isEditMode() || !this.isDraggable() || e.getSource() != this.titleBar) break;
                    this.theView.setDragMode(0);
                }
            }
        }
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        if (spot == 10) {
            return this.subdiagram.getSpotLocation(spot, p);
        }
        return super.getSpotLocation(spot, p);
    }
}

