/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDListInterface;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PFDGroup
extends PFDPrimitive
implements PFDListInterface {
    protected boolean breakable = true;
    protected boolean editable = false;
    protected Vector children = new Vector();
    protected boolean bboxDirty = true;
    protected Insets borderInsets;
    protected boolean movesWithChildren = false;

    public PFDGroup() {
        this.brush.setStyle(0);
        this.pen.setStyle(0);
        this.borderInsets = new Insets(0, 0, 0, 0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public void setBreakable(boolean b) {
        if (this.breakable == b) {
            return;
        }
        this.breakable = b;
        this.firePropertyChange("breakable");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        if (this.editable == b) {
            return;
        }
        this.editable = b;
        this.firePropertyChange("editable");
    }

    public void setBorderInsets(Insets insets) {
        if (insets != null) {
            this.borderInsets.bottom = insets.bottom < 0 ? 0 : insets.bottom;
            this.borderInsets.top = insets.top < 0 ? 0 : insets.top;
            this.borderInsets.left = insets.left < 0 ? 0 : insets.left;
            this.borderInsets.right = insets.right < 0 ? 0 : insets.right;
        }
    }

    public Insets getBorderInsets() {
        return new Insets(this.borderInsets.top, this.borderInsets.left, this.borderInsets.bottom, this.borderInsets.right);
    }

    protected void markBBoxDirty() {
        this.bboxDirty = true;
    }

    @Override
    protected Rectangle getRBBox() {
        if (this.bboxDirty) {
            this.calculateBBox();
        }
        return super.getRBBox();
    }

    @Override
    protected Rectangle getVisualRBBox() {
        if (this.bboxDirty) {
            this.calculateBBox();
        }
        return super.getVisualRBBox();
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.brush.getStyle() == 2 || this.isCollapsable()) {
            return super.contains(x, y);
        }
        if (!super.contains(x, y)) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (!p.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean isChild(PFDPrimitive primitive) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDGroup g;
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p == primitive) {
                return true;
            }
            if (!(p instanceof PFDGroup) || !(g = (PFDGroup)p).isChild(primitive)) continue;
            return true;
        }
        return false;
    }

    public boolean isExpandedChild(PFDPrimitive primitive) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDGroup g;
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p == primitive) {
                return true;
            }
            if (!(p instanceof PFDGroup) || !(g = (PFDGroup)p).isExpandedChild(primitive)) continue;
            return true;
        }
        if (this.expandable) {
            if (primitive == this.expanded) {
                return true;
            }
            if (this.expanded instanceof PFDGroup) {
                return ((PFDGroup)this.expanded).isExpandedChild(primitive);
            }
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setChildrenVisible(visible);
        this.setIntradiagramLinksVisible(this, visible);
    }

    protected void setChildrenVisible(boolean visible) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = this.getPrimitive(i);
            if (!(p instanceof PFDComponentPrimitive) && !(p instanceof PFDGroup)) continue;
            p.setVisible(visible);
        }
    }

    public boolean hasComponentPrimitives() {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDGroup g;
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDComponentPrimitive) {
                return true;
            }
            if (!(p instanceof PFDGroup) || !(g = (PFDGroup)p).hasComponentPrimitives()) continue;
            return true;
        }
        return false;
    }

    public PFDPort pickPort(int x, int y) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDGroup g;
            PFDPort port;
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (!p.contains(x, y)) continue;
            if (p instanceof PFDPort && p.isVisible()) {
                return (PFDPort)p;
            }
            if (!(p instanceof PFDGroup) || (port = (g = (PFDGroup)p).pickPort(x, y)) == null) continue;
            return port;
        }
        return null;
    }

    @Override
    public int getNumPrimitives() {
        return this.children.size();
    }

    @Override
    public boolean hasNoPrimitives() {
        return this.children.isEmpty();
    }

    @Override
    public boolean containsPrimitive(PFDPrimitive p) {
        return this.children.contains(p);
    }

    @Override
    public boolean addPrimitive(PFDPrimitive p) {
        if (p == null) {
            return false;
        }
        boolean success = this.children.add(p);
        if (!success) {
            return false;
        }
        p.setModel(this.model);
        p.setLayer(this.layer);
        p.setGroup(this);
        if (this.model != null) {
            this.model.fireModelChange(13, null, p);
        }
        this.firePropertyChange("children");
        return true;
    }

    @Override
    public void addPrimitive(int index, PFDPrimitive p) {
        this.children.add(index, p);
        p.setModel(this.model);
        p.setLayer(this.layer);
        p.setGroup(this);
        if (this.model != null) {
            this.model.fireModelChange(13, null, p);
        }
        this.firePropertyChange("children");
    }

    @Override
    public boolean removePrimitive(PFDPrimitive p) {
        boolean success = this.children.remove(p);
        if (!success) {
            return false;
        }
        p.setModel(null);
        p.setLayer(null);
        p.setGroup(null);
        p.detachView(this.theView);
        if (this.model != null) {
            this.model.fireModelChange(14, null, p);
        }
        this.firePropertyChange("children");
        return true;
    }

    @Override
    public PFDPrimitive removePrimitive(int index) {
        PFDPrimitive p = (PFDPrimitive)this.children.remove(index);
        if (p == null) {
            return null;
        }
        p.setModel(null);
        p.setLayer(null);
        p.setGroup(null);
        p.removeAssociation();
        if (this.model != null) {
            this.model.fireModelChange(14, null, p);
        }
        this.firePropertyChange("children");
        return p;
    }

    @Override
    public void removeAllPrimitives() {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.setModel(null);
            p.setLayer(null);
            p.setGroup(null);
        }
        this.children.removeAllElements();
        this.firePropertyChange("children");
    }

    @Override
    public PFDPrimitive getPrimitive(int index) {
        return (PFDPrimitive)this.children.get(index);
    }

    @Override
    public PFDPrimitive setPrimitive(int index, PFDPrimitive p) {
        PFDPrimitive mp = this.children.set(index, p);
        this.firePropertyChange("children");
        return mp;
    }

    @Override
    public int indexOfPrimitive(PFDPrimitive p) {
        return this.children.indexOf(p);
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.brush.getStyle() != 0) {
            this.brush.apply(g2d);
            g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.paint(g2d, v);
        }
        if (this.pen.getStyle() != 0) {
            this.pen.apply(g2d);
            g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
        }
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.renderOverview(g2d, v);
        }
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        if (this.brush.getStyle() != 0) {
            this.brush.apply(g2d);
            g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width + 1, this.bbox.height + 1);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.paint(g2d, v, true, false);
        }
        if (this.pen.getStyle() != 0) {
            this.pen.apply(g2d);
            g2d.drawRect(this.bbox.x - 1, this.bbox.y - 1, this.bbox.width + 2, this.bbox.height + 2);
        }
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        if (this.brush.getStyle() != 0) {
            this.brush.apply(g2d);
            g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width + 1, this.bbox.height + 1);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.paint(g2d, v, true, true);
        }
        if (this.pen.getStyle() != 0) {
            this.pen.apply(g2d);
            g2d.drawRect(this.bbox.x - 1, this.bbox.y - 1, this.bbox.width + 2, this.bbox.height + 2);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        this.disableChangeUpdate();
        if (this.collapsable && !this.collapsed.isVisible()) {
            this.collapsed.setLocation(x, y);
        }
        Rectangle myBBox = this.getRBBox();
        int dx = x - myBBox.x;
        int dy = y - myBBox.y;
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.setLocation(p.getX() + dx, p.getY() + dy);
        }
        this.enableChangeUpdate();
        this.calculateBBox();
        this.firePropertyChange("bbox");
    }

    @Override
    protected void build(PFDView v) {
        Point pt = this.getSpotLocation(1, null);
        Vector myChildren = new Vector();
        myChildren.addAll(this.children);
        for (int i = 0; i < myChildren.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)myChildren.elementAt(i);
            p.setModel(this.model);
            p.setLayer(this.layer);
            p.build(v);
        }
        super.build(v);
        this.setSpotLocation(1, pt);
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("all") || property.equals("children")) {
            this.calculateBBox();
            if (this.getGroup() != null) {
                this.getGroup().firePropertyChange("bbox");
            }
        } else if (property.equals("bbox")) {
            this.calculateBBox();
        }
        super.update(property, v);
    }

    protected void calculateBBox() {
        this.oldVisualBBox.setBounds(this.visualBBox);
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (i == 0) {
                this.bbox.setBounds(p.getRBBox());
                this.visualBBox.setBounds(p.getVisualRBBox());
                continue;
            }
            if (p.getRBBox() != null && !p.getRBBox().isEmpty()) {
                this.bbox.add(p.getRBBox());
            }
            if (p.getVisualRBBox() == null || p.getVisualRBBox().isEmpty()) continue;
            this.visualBBox.add(p.getVisualRBBox());
        }
        this.bbox.x -= this.borderInsets.left;
        this.bbox.y -= this.borderInsets.top;
        this.bbox.width += this.borderInsets.left + this.borderInsets.right;
        this.bbox.height += this.borderInsets.top + this.borderInsets.bottom;
        this.visualBBox.add(this.bbox);
        if (this.isCustomSelection()) {
            this.visualBBox.add(this.getCustomSelectionBBox());
        }
        this.bboxDirty = false;
    }

    protected PFDPort getNearestPort(int x, int y) {
        if (!this.visible) {
            return null;
        }
        double d = Double.MAX_VALUE;
        PFDPort nearest = null;
        for (int i = this.getNumPrimitives() - 1; i >= 0; --i) {
            double temp;
            double dist;
            PFDGroup g;
            PFDPort port;
            PFDPrimitive p = this.getPrimitive(i);
            if (p instanceof PFDPort) {
                PFDPort port2 = (PFDPort)p;
                double temp2 = (x - port2.getX()) * (x - port2.getX()) + (y - port2.getY()) * (y - port2.getY());
                double dist2 = Math.sqrt(temp2);
                if (!(dist2 < d)) continue;
                d = dist2;
                nearest = port2;
                continue;
            }
            if (!(p instanceof PFDGroup) || (port = (g = (PFDGroup)p).getNearestPort(x, y)) == null || !((dist = Math.sqrt(temp = (double)((x - port.getX()) * (x - port.getX()) + (y - port.getY()) * (y - port.getY())))) < d)) continue;
            d = dist;
            nearest = port;
        }
        return nearest;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        if (!this.resizable) {
            return;
        }
        x = Math.max(0, x);
        y = Math.max(0, y);
        if (this.collapsable && !this.collapsed.isVisible()) {
            this.collapsed.setLocation(x, y);
        }
        double sx = (double)w / (double)this.bbox.width;
        double sy = (double)h / (double)this.bbox.height;
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p instanceof PFDLink) continue;
            Rectangle r = p.getRBBox();
            p.setForcedBBox(x + (int)Math.rint(sx * (double)(r.x - this.bbox.x)), y + (int)Math.rint(sy * (double)(r.y - this.bbox.y)), (int)Math.rint(sx * (double)r.width), (int)Math.rint(sy * (double)r.height));
        }
        this.bboxDirty = true;
        this.firePropertyChange("bbox");
    }

    @Override
    protected void attachView(PFDView v) {
        super.attachView(v);
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.attachView(v);
        }
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.detachView(v);
        }
    }

    @Override
    public PFDPrimitive pickPrimitive(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        if (!this.editable) {
            return this;
        }
        PFDPrimitive p = this.pickPrimitive(x, y, PFDPrimitive.class);
        if (p != null) {
            return p.pickPrimitive(x, y);
        }
        return this;
    }

    public PFDPrimitive pickPrimitive(int x, int y, Class c) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            PFDPrimitive pp;
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (c.isInstance(p) && p.contains(x, y)) {
                return p;
            }
            if (!(p instanceof PFDGroup) || (pp = ((PFDGroup)p).pickPrimitive(x, y, c)) == null) continue;
            return pp;
        }
        return null;
    }

    public PFDPrimitive pickTopPrimitive(int x, int y, Class c) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (!p.contains(x, y)) continue;
            if (c.isInstance(p)) {
                return p;
            }
            if (p instanceof PFDGroup) {
                return ((PFDGroup)p).pickTopPrimitive(x, y, c);
            }
            return null;
        }
        return null;
    }

    public PFDPrimitive pickPrimitive(int x, int y, int width, int height, Class c) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive pp;
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (c.isInstance(p) && p.intersects(x, y, width, height)) {
                return p;
            }
            if (!(p instanceof PFDGroup) || (pp = ((PFDGroup)p).pickPrimitive(x, y, width, height, c)) == null) continue;
            return pp;
        }
        return null;
    }

    public PFDPrimitive getNamedPrimitive(String name) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDGroup g;
            PFDPrimitive pr;
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (name.equals(p.getName())) {
                return p;
            }
            if (!(p instanceof PFDGroup) || (pr = (g = (PFDGroup)p).getNamedPrimitive(name)) == null) continue;
            return pr;
        }
        return null;
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDGroup clone = new PFDGroup();
        table.put(this, clone);
        this.copyObject(clone);
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            PFDPrimitive np = (PFDPrimitive)p.cloneObject(table);
            clone.addPrimitive(np);
        }
        clone.calculateBBox();
        return clone;
    }

    public void copyObject(PFDGroup toObject) {
        super.copyObject(toObject);
        toObject.setBreakable(this.isBreakable());
    }

    protected void redirectLinks(Hashtable table) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p instanceof PFDLink) {
                PFDLink ln = (PFDLink)p;
                PFDLink copiedLink = (PFDLink)table.get(ln);
                PFDPort copiedFromPort = (PFDPort)table.get(ln.getFromPort());
                PFDPort copiedToPort = (PFDPort)table.get(ln.getToPort());
                copiedLink.setFromPort(copiedFromPort);
                copiedLink.setToPort(copiedToPort);
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            g.redirectLinks(table);
        }
    }

    protected void buildInterdiagramLinkMaps(PFDGroup group, Hashtable linkMap, PFDPort in, PFDPort out) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p instanceof PFDPort) {
                PFDPort port = (PFDPort)p;
                if (port.hasNoLinks()) continue;
                Vector<PFDLink> modelRemoveList = new Vector<PFDLink>();
                for (int j = 0; j < port.getNumLinks(); ++j) {
                    boolean removeOldLink;
                    PFDLink l = port.getLink(j);
                    if (!l.isVisible()) continue;
                    PFDPort from = l.getFromPort();
                    PFDPort to = l.getToPort();
                    PFDLink collapsedLink = null;
                    if (from != port && !group.isChild(from)) {
                        collapsedLink = PFDGroup.getExistingLink(from, in, l.isControl());
                        if (collapsedLink == null) {
                            collapsedLink = l.createCollapsedLink();
                            collapsedLink.setToPort(in);
                            collapsedLink.setFromPort(from);
                            this.getModel().addPrimitive(collapsedLink);
                        }
                    } else if (to != port && !group.isChild(to) && (collapsedLink = PFDGroup.getExistingLink(out, to, l.isControl())) == null) {
                        collapsedLink = l.createCollapsedLink();
                        collapsedLink.setToPort(to);
                        collapsedLink.setFromPort(out);
                        this.getModel().addPrimitive(collapsedLink);
                    }
                    if (collapsedLink == null || !(removeOldLink = PFDGroup.putWithRecursion(linkMap, l, collapsedLink))) continue;
                    modelRemoveList.addElement(l);
                }
                this.getModel().disableChangeUpdate();
                for (int k = 0; k < modelRemoveList.size(); ++k) {
                    this.getModel().removePrimitive((PFDLink)modelRemoveList.elementAt(k));
                }
                this.getModel().enableChangeUpdate();
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            g.buildInterdiagramLinkMaps(group, linkMap, in, out);
        }
    }

    protected static PFDLink getExistingLink(PFDPort from, PFDPort to, boolean isControl) {
        if (from == null || to == null) {
            return null;
        }
        Vector fromLinks = from.getFromLinks();
        for (int i = 0; i < fromLinks.size(); ++i) {
            PFDLink l = (PFDLink)fromLinks.elementAt(i);
            if (to != l.getToPort() || l.isControl() != isControl) continue;
            return l;
        }
        return null;
    }

    protected static boolean putWithRecursion(Hashtable map, Object key, Object value) {
        if (map == null) {
            return false;
        }
        Vector keys = PFDGroup.getKeys(map, key);
        if (keys != null) {
            Enumeration e = keys.elements();
            while (e.hasMoreElements()) {
                map.put(e.nextElement(), value);
            }
            return true;
        }
        map.put(key, value);
        return false;
    }

    protected static Vector getKeys(Hashtable map, Object value) {
        if (map == null || !map.containsValue(value)) {
            return null;
        }
        Vector keys = new Vector();
        Enumeration en = map.keys();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            Object v = map.get(k);
            if (v == null || v != value) continue;
            keys.add(k);
        }
        if (keys.size() > 0) {
            return keys;
        }
        return null;
    }

    protected void setInterdiagramLinksVisible(PFDGroup group, boolean visible) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p instanceof PFDPort) {
                PFDPort port = (PFDPort)p;
                if (port.hasNoLinks()) continue;
                for (int j = 0; j < port.getNumLinks(); ++j) {
                    PFDLink l = port.getLink(j);
                    PFDPort from = l.getFromPort();
                    PFDPort to = l.getToPort();
                    if (from != port && !group.isChild(from)) {
                        l.setVisible(visible);
                        continue;
                    }
                    if (to == port || group.isChild(to)) continue;
                    l.setVisible(visible);
                }
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            g.setInterdiagramLinksVisible(group, visible);
        }
    }

    protected void setIntradiagramLinksVisible(PFDGroup group, boolean visible) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p instanceof PFDPort) {
                PFDPort port = (PFDPort)p;
                if (port.hasNoLinks()) continue;
                for (int j = 0; j < port.getNumLinks(); ++j) {
                    PFDLink l = port.getLink(j);
                    PFDPort from = l.getFromPort();
                    PFDPort to = l.getToPort();
                    if (from != port && group.isChild(from)) {
                        l.setVisible(visible);
                        continue;
                    }
                    if (to == port || !group.isChild(to)) continue;
                    l.setVisible(visible);
                }
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            g.setIntradiagramLinksVisible(group, visible);
        }
    }

    @Override
    protected void removeAssociation() {
        super.removeAssociation();
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            p.removeAssociation();
            p.setModel(null);
            p.setLayer(null);
        }
    }

    protected void primitiveRemoved(PFDPrimitive p) {
        this.removePrimitive(p);
        if (this.model != null && this.hasNoPrimitives()) {
            this.model.removePrimitive(this);
        }
    }

    protected void accumulatePrimitive(Vector v, Class c) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (c.isInstance(p)) {
                v.addElement(p);
            }
            if (!(p instanceof PFDGroup)) continue;
            ((PFDGroup)p).accumulatePrimitive(v, c);
        }
    }

    public void accumulateNodes(Vector v) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (PFDAbstractNode.class.isInstance(p)) {
                v.addElement(p);
            }
            if (!(p instanceof PFDGroup)) continue;
            ((PFDGroup)p).accumulateNodes(v);
        }
    }

    @Override
    protected boolean isRenderNeeded(PFDView v) {
        if (v == null || this.forceRender) {
            return true;
        }
        boolean needed = true;
        switch (v.renderMode) {
            case 0: {
                needed = true;
                break;
            }
            case 1: {
                if (!v.isDragged(this) && (!this.editable || !this.isChildDragged(v))) break;
                needed = false;
                break;
            }
            case 2: {
                needed = v.isDragged(this) || this.editable && this.isChildDragged(v) || this.getGroup() != null && this.getGroup().isRenderNeeded(v);
            }
        }
        return needed;
    }

    public boolean isChildDragged(PFDView v) {
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            PFDPrimitive p = (PFDPrimitive)e.nextElement();
            if (v.isDragged(p)) {
                return true;
            }
            if (!(p instanceof PFDGroup) || !((PFDGroup)p).isEditable() || !((PFDGroup)p).isChildDragged(v)) continue;
            return true;
        }
        return false;
    }

    protected void accumulateLinks(Vector v) {
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (p instanceof PFDPort) {
                PFDPort port = (PFDPort)p;
                for (int j = 0; j < port.getNumLinks(); ++j) {
                    PFDLink l = port.getLink(j);
                    if (v.contains(l)) continue;
                    v.add(l);
                }
                continue;
            }
            if (!(p instanceof PFDGroup)) continue;
            PFDGroup g = (PFDGroup)p;
            g.accumulateLinks(v);
        }
    }

    @Override
    public PFDGroup getTopLevelGroup() {
        if (this.group != null) {
            return this.group.getTopLevelGroup();
        }
        return this;
    }

    @Override
    public void dispatchEvent(MouseEvent e) {
        this.theView = (PFDView)e.getSource();
        for (int i = this.children.size() - 1; i >= 0 && !e.isConsumed(); --i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            if (!p.visible || !p.contains(e.getX(), e.getY())) continue;
            p.dispatchEvent(e);
        }
        if (!e.isConsumed()) {
            this.dispatchEventToSelf(e);
        }
    }

    public boolean getMovesWithChildren() {
        return this.movesWithChildren;
    }

    public void setMovesWithChildren(boolean b) {
        if (this.movesWithChildren == b) {
            return;
        }
        this.movesWithChildren = b;
        this.firePropertyChange("moveWithChildren");
    }

    public void bringToFront(PFDPrimitive p) {
        if (this.model == null || !this.children.contains(p)) {
            return;
        }
        this.bringToFront();
    }

    @Override
    public void bringToFront() {
        if (this.model == null) {
            return;
        }
        if (this.group != null) {
            this.group.bringToFront(this);
        } else {
            Vector links = new Vector();
            this.accumulateLinks(links);
            for (int i = 0; i < links.size(); ++i) {
                PFDLink l = (PFDLink)links.get(i);
                l.bringToFront();
            }
            this.model.bringToFront(this);
        }
    }
}

