/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.RB;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class PFDDrawableLabel
extends JComponent
implements ListCellRenderer {
    public static final String RB_KEY = "PFDDrawableLabel.";
    String drawable;
    Line2D line;
    String label;
    static final float[] dash = new float[]{5.0f};

    public PFDDrawableLabel() {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    public String getDrawable() {
        return this.drawable;
    }

    public void setDrawable(String s) {
        this.drawable = s;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(80, 20);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g2d);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(this.getForeground());
        if (this.drawable.equals("Solid Line")) {
            this.label = RB.getStringResource(RB_KEY, "solid.txt");
            this.line = new Line2D.Double();
            g2d.setStroke(new BasicStroke(1.0f));
        } else if (this.drawable.equals("Dashed Line")) {
            this.label = RB.getStringResource(RB_KEY, "dashed.txt");
            this.line = new Line2D.Double();
            BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
            g2d.setStroke(dashed);
        } else if (this.drawable.equals("No Line")) {
            this.label = RB.getStringResource(RB_KEY, "none.txt");
            this.line = null;
        } else if (this.drawable.equals("Line 1")) {
            this.label = "1";
            this.line = new Line2D.Double();
            g2d.setStroke(new BasicStroke(1.0f));
        } else if (this.drawable.equals("Line 2")) {
            this.label = "2";
            this.line = new Line2D.Double();
            g2d.setStroke(new BasicStroke(2.0f));
        } else if (this.drawable.equals("Line 3")) {
            this.label = "3";
            this.line = new Line2D.Double();
            g2d.setStroke(new BasicStroke(3.0f));
        } else if (this.drawable.equals("Line 4")) {
            this.label = "4";
            this.line = new Line2D.Double();
            g2d.setStroke(new BasicStroke(4.0f));
        }
        TextLayout layout = new TextLayout(this.label, this.getFont(), new FontRenderContext(null, false, false));
        float offset = ((float)this.getHeight() - layout.getAscent() - layout.getDescent()) / 2.0f;
        double labelWidth = layout.getBounds().getWidth();
        layout.draw(g2d, 5.0f, offset + layout.getAscent());
        if (this.line != null) {
            this.line.setLine(5.0 + labelWidth + 5.0, this.getHeight() / 2, this.getWidth() - 5, this.getHeight() / 2);
            g2d.draw(this.line);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = value.toString();
        this.setDrawable(s);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }
}

