/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;

public class PFDDragToolTipManager
extends MouseInputAdapter {
    private String toolTipText;
    private Timer enterTimer = new Timer(300, new insideTimerAction());
    private Timer insideTimer;
    private Timer exitTimer;
    static final PFDDragToolTipManager sharredInstance = new PFDDragToolTipManager();
    private Popup tipWindow;
    private JToolTip tip;
    private PFDView dragView;
    private boolean enabled = true;
    private Point preferredLocation;
    private MouseEvent mouseEvent;
    private Rectangle popupRect;
    private Window window;
    private boolean tipShowing;
    private boolean showImmediately = false;

    PFDDragToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(200, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
    }

    public static PFDDragToolTipManager sharedInstance() {
        return sharredInstance;
    }

    private void showTipWindow() {
        if (this.dragView == null || !this.dragView.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point screenLocation = this.dragView.getLocationOnScreen();
            Point location = new Point();
            Rectangle sBounds = this.dragView.getGraphicsConfiguration().getBounds();
            boolean leftToRight = this.dragView.getComponentOrientation().isLeftToRight();
            this.hideTipWindow();
            this.tip = this.dragView.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension size = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                location.x = screenLocation.x + this.preferredLocation.x;
                location.y = screenLocation.y + this.preferredLocation.y;
                if (!leftToRight) {
                    location.x -= size.width;
                }
            } else {
                location.x = screenLocation.x + this.mouseEvent.getX();
                location.y = screenLocation.y + this.mouseEvent.getY() + 20;
                if (!leftToRight && location.x - size.width >= 0) {
                    location.x -= size.width;
                }
            }
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(location.x, location.y, size.width, size.height);
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.dragView, this.tip, location.x, location.y);
            this.tipWindow.show();
            Window componentWindow = SwingUtilities.windowForComponent(this.dragView);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != componentWindow) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    private void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public void registerView(PFDView view) {
        view.removeMouseListener(this);
        view.addMouseListener(this);
        view.removeMouseMotionListener(this);
        view.addMouseMotionListener(this);
    }

    public void unregisterView(PFDView view) {
        view.removeMouseListener(this);
        view.removeMouseMotionListener(this);
    }

    private void checkForTipChange(MouseEvent event) {
        PFDView view = (PFDView)event.getSource();
        String newText = view.getDragTipText(event);
        Point newPreferredLocation = view.getToolTipLocation(event);
        if (newText != null || newPreferredLocation != null) {
            this.mouseEvent = event;
            if ((newText != null && newText.equals(this.toolTipText) || newText == null) && (newPreferredLocation != null && newPreferredLocation.equals(this.preferredLocation) || newPreferredLocation == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = newText;
                this.preferredLocation = newPreferredLocation;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragView = (PFDView)e.getSource();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragView == null) {
            this.dragView = (PFDView)e.getSource();
        }
        if (this.tipShowing) {
            this.checkForTipChange(e);
        } else if (this.showImmediately) {
            this.toolTipText = this.dragView.getDragTipText(e);
            if (this.toolTipText != null) {
                this.preferredLocation = this.dragView.getToolTipLocation(e);
                this.mouseEvent = e;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            String oldTipText = this.toolTipText;
            this.toolTipText = this.dragView.getDragTipText(e);
            if (this.toolTipText == null || !this.toolTipText.equals(oldTipText)) {
                this.mouseEvent = e;
                this.enterTimer.restart();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.exitTimer.stop();
        this.toolTipText = null;
        this.dragView = null;
        this.showImmediately = false;
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PFDDragToolTipManager.this.dragView != null && PFDDragToolTipManager.this.dragView.isShowing()) {
                if (PFDDragToolTipManager.this.toolTipText == null && PFDDragToolTipManager.this.mouseEvent != null) {
                    PFDDragToolTipManager.this.toolTipText = PFDDragToolTipManager.this.dragView.getDragTipText(PFDDragToolTipManager.this.mouseEvent);
                    PFDDragToolTipManager.this.preferredLocation = PFDDragToolTipManager.this.dragView.getToolTipLocation(PFDDragToolTipManager.this.mouseEvent);
                }
                if (PFDDragToolTipManager.this.toolTipText != null) {
                    PFDDragToolTipManager.this.showImmediately = true;
                    PFDDragToolTipManager.this.showTipWindow();
                } else {
                    PFDDragToolTipManager.this.toolTipText = null;
                    PFDDragToolTipManager.this.preferredLocation = null;
                    PFDDragToolTipManager.this.mouseEvent = null;
                    PFDDragToolTipManager.this.hideTipWindow();
                }
            }
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PFDDragToolTipManager.this.showImmediately = false;
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PFDDragToolTipManager.this.hideTipWindow();
            PFDDragToolTipManager.this.enterTimer.stop();
            PFDDragToolTipManager.this.showImmediately = false;
            PFDDragToolTipManager.this.mouseEvent = null;
        }
    }
}

