/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDMessageWindow;
import com.sas.graphics.components.pfd.PFDNodeNumber;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPortGroup;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.PFDStatusUtil;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDWindow;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDGhostablePrimitiveInterface;
import com.sas.graphics.components.pfd.interfaces.PFDHighlightInterface;
import com.sas.graphics.components.pfd.interfaces.PFDInputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDNodeOrderInterface;
import com.sas.graphics.components.pfd.interfaces.PFDOutputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDStatusInterface;
import com.sas.graphics.components.pfd.interfaces.PFDWindowContainerInterface;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.HyperlinkListener;

public abstract class PFDControlNode
extends PFDAbstractNode
implements PFDDirectionalNodeInterface,
PFDHighlightInterface,
PFDStatusInterface,
PFDGhostablePrimitiveInterface,
PFDWindowContainerInterface,
PFDInputInterface,
PFDOutputInterface,
PFDNodeOrderInterface {
    private static final long serialVersionUID = -7942402309952774696L;
    private static final Dimension statusDetailsOffset = new Dimension(-12, -12);
    private static final int textExtent = 20;
    protected PFDDrawablePrimitive controlShape;
    protected PFDDrawablePrimitive selectionShape;
    protected Color gradientColorTop = new Color(200, 200, 200);
    protected Color gradientColorBottom = new Color(200, 200, 200);
    protected boolean useGradientFill = false;
    protected PFDPortGroup inputPortGroup;
    protected PFDPortGroup outputPortGroup;
    protected String flowDirection = "Right";
    protected PFDButton statusButton;
    private PFDStatusUtil statusUtil;
    private PFDMessageWindow statusWindow;
    protected PFDText titleText;
    private boolean highlightOn = false;
    protected static final Dimension defaultSize = new Dimension(36, 36);
    private boolean ghosted = false;
    protected PFDNodeNumber nodeNumber;

    protected abstract void layoutChildren();

    protected void init() {
        this.setBreakable(false);
        this.setCustomSelection(true);
        this.setResizable(false);
        this.controlShape.getBrush().setColor(new Color(200, 200, 200));
        this.controlShape.getPen().setColor(new Color(128, 128, 128));
        this.controlShape.addMouseListener(this);
        this.controlShape.addMouseMotionListener(this);
        this.titleText = new PFDText();
        this.titleText.setFontSize(11);
        this.titleText.setSelectable(false);
        if (this.selectionShape != null) {
            this.selectionShape.getBrush().setStyle(0);
            this.selectionPen = this.selectionShape.getPen();
        }
        this.statusUtil = new PFDStatusUtil(this);
        this.statusButton = new PFDButton();
        this.inputPortGroup = new PFDPortGroup(0);
        this.inputPortGroup.addPort(new PFDPort(true));
        this.outputPortGroup = new PFDPortGroup(1);
        this.outputPortGroup.addPort(new PFDPort(true));
        this.addPrimitive(this.inputPortGroup);
        this.addPrimitive(this.controlShape);
        this.addPrimitive(this.selectionShape);
        this.addPrimitive(this.titleText);
        this.addPrimitive(this.outputPortGroup);
    }

    @Override
    public void setPreferredSize(Dimension d) {
        if (d == null || this.controlShape == null || d.equals(this.controlShape.getSize())) {
            return;
        }
        this.controlShape.setSize(d);
        this.firePropertyChange("preferredSize");
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.controlShape == null) {
            return null;
        }
        return this.controlShape.getSize();
    }

    protected void layoutPorts() {
        Rectangle bounds = this.controlShape.getRBBox();
        if (this.flowDirection.equalsIgnoreCase("right")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(3);
            this.inputPortGroup.setAnchorPoint(new Point(bounds.x, bounds.y + bounds.height / 2));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(4);
            this.outputPortGroup.setAnchorPoint(new Point(bounds.x + bounds.width, bounds.y + bounds.height / 2));
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("left")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(4);
            this.inputPortGroup.setAnchorPoint(new Point(bounds.x + bounds.width, bounds.y + bounds.height / 2));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(3);
            this.outputPortGroup.setAnchorPoint(new Point(bounds.x, bounds.y + bounds.height / 2));
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(1);
            this.inputPortGroup.setAnchorPoint(new Point(bounds.x + bounds.width / 2, bounds.y));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(2);
            this.outputPortGroup.setAnchorPoint(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height));
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(2);
            this.inputPortGroup.setAnchorPoint(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height));
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(1);
            this.outputPortGroup.setAnchorPoint(new Point(bounds.x + bounds.width / 2, bounds.y));
            this.outputPortGroup.enableChangeUpdate();
        }
    }

    protected void layoutText() {
        Rectangle bounds = this.controlShape.getRBBox();
        if (this.flowDirection.equalsIgnoreCase("right") || this.flowDirection.equalsIgnoreCase("left")) {
            this.titleText.setVerticalAlignment(1);
            this.titleText.setHorizontalAlignment(0);
            this.titleText.setMultiline(true);
            this.titleText.setWrapWidth(bounds.width + 40);
            this.titleText.setClipping(true);
            this.titleText.setMaxLines(2);
            this.titleText.setBBox(bounds.x + bounds.width / 2, bounds.y + bounds.height + 5, 0, 0);
            this.titleText.forceUpdate();
        } else {
            this.titleText.setVerticalAlignment(0);
            this.titleText.setHorizontalAlignment(1);
            this.titleText.setMultiline(true);
            this.titleText.setWrapWidth(bounds.width + 40);
            this.titleText.setClipping(true);
            this.titleText.setMaxLines(2);
            this.titleText.setBBox(bounds.x + bounds.width + 7, bounds.y + bounds.height / 2, 0, 0);
            this.titleText.forceUpdate();
        }
    }

    protected void layoutStatusButton() {
        Rectangle bounds = this.controlShape.getRBBox();
        this.statusButton.setLocation(bounds.x + bounds.width - this.statusButton.getWidth(), bounds.y + bounds.height - this.statusButton.getHeight());
    }

    protected void draw(Graphics2D g2d, PFDView v, boolean selected) {
        if (this.useGradientFill) {
            this.updateShapeGradient();
        }
        this.controlShape.paint(g2d);
        this.outputPortGroup.paint(g2d);
        if (selected) {
            this.drawSelection(g2d);
        }
        this.titleText.paint(g2d);
        this.drawNodeNumber(g2d);
        this.drawStatusButton(g2d);
        this.drawStatusWindow(g2d);
    }

    protected void drawGhosted(Graphics2D g, PFDView v, boolean selected) {
        if (selected) {
            this.drawSelection(g);
        }
        if (this.useGradientFill) {
            this.updateShapeGradient();
        }
        BufferedImage primitiveImage = new BufferedImage(this.bbox.width, this.bbox.height, 2);
        Graphics2D imageGraphics = primitiveImage.createGraphics();
        imageGraphics.setRenderingHints(g.getRenderingHints());
        imageGraphics.translate(-this.bbox.x, -this.bbox.y);
        this.controlShape.paint(imageGraphics);
        this.outputPortGroup.paint(imageGraphics);
        this.titleText.paint(imageGraphics);
        this.drawNodeNumber(imageGraphics);
        this.drawStatusButton(imageGraphics);
        imageGraphics.dispose();
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.drawImage((Image)primitiveImage, this.bbox.x, this.bbox.y, v);
        primitiveImage.flush();
        g.setComposite(oldComposite);
        this.drawStatusWindow(g);
    }

    protected void drawStatusButton(Graphics2D g) {
        if (this.statusButton != null && this.containsPrimitive(this.statusButton)) {
            this.statusButton.paint(g);
        }
    }

    protected void drawStatusWindow(Graphics2D g) {
        if (this.statusWindow != null && this.containsPrimitive(this.statusWindow)) {
            this.statusWindow.paint(g);
        }
    }

    protected void updateShapeGradient() {
        Rectangle bounds = this.controlShape.getRBBox();
        this.controlShape.getBrush().paint = new GradientPaint(new Point(bounds.x, bounds.y), this.gradientColorTop, new Point(bounds.x, bounds.y + bounds.height), this.gradientColorBottom, false);
    }

    protected void drawSelection(Graphics2D g) {
        if (this.selectionShape != null) {
            this.selectionShape.paint(g);
        } else {
            Rectangle bounds = this.controlShape.getRBBox();
            int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
            if (g.hitClip(bounds.x - 4 - halfStrokeWidth, bounds.y - 4 - halfStrokeWidth, bounds.width + 8 + halfStrokeWidth * 2, bounds.height + 8 + halfStrokeWidth * 2)) {
                this.selectionPen.apply(g);
                g.drawRect(bounds.x - 4, bounds.y - 4, bounds.width + 7, bounds.height + 7);
            }
        }
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            this.drawGhosted(g2d, v, false);
        } else {
            this.draw(g2d, v, false);
        }
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            this.drawGhosted(g2d, v, true);
        } else {
            this.draw(g2d, v, true);
        }
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.renderSelected(g2d, v);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.controlShape.renderOverview(g2d, v);
        this.inputPortGroup.renderOverview(g2d, v);
        this.outputPortGroup.renderOverview(g2d, v);
    }

    private void setFillColor(Color clr) {
        if (clr == null || clr.equals(this.controlShape.getBrush().getColor())) {
            return;
        }
        this.controlShape.getBrush().setColor(clr);
        this.firePropertyChange("fillColor");
    }

    private Color getFillColor() {
        return this.controlShape.getBrush().getColor();
    }

    private void setOutlineColor(Color clr) {
        if (clr == null || clr.equals(this.controlShape.getPen().getColor())) {
            return;
        }
        this.controlShape.getPen().setColor(clr);
        this.firePropertyChange("outlineColor");
    }

    private Color getOutlineColor() {
        return this.controlShape.getPen().getColor();
    }

    private void setOutlineWidth(float width) {
        if (width == this.controlShape.getPen().getLineWidth()) {
            return;
        }
        this.controlShape.getPen().setLineWidth(width);
        this.firePropertyChange("outlineWidth");
    }

    private float getOutlineWidth() {
        return this.controlShape.getPen().getLineWidth();
    }

    private Color getGradientColorBottom() {
        return this.gradientColorBottom;
    }

    private void setGradientColorBottom(Color clr) {
        if (clr == null || clr.equals(this.gradientColorBottom)) {
            return;
        }
        this.gradientColorBottom = clr;
        this.firePropertyChange("gradientBottomColor");
    }

    private Color getGradientColorTop() {
        return this.gradientColorTop;
    }

    private void setGradientColorTop(Color clr) {
        if (clr == null || clr.equals(this.gradientColorTop)) {
            return;
        }
        this.gradientColorTop = clr;
        this.firePropertyChange("gradientTopColor");
    }

    private boolean getUseGradientFill() {
        return this.useGradientFill;
    }

    private void setUseGradientFill(boolean useGradientFill) {
        if (useGradientFill != this.useGradientFill) {
            this.useGradientFill = useGradientFill;
            if (useGradientFill) {
                this.controlShape.getBrush().setStyle(1);
            } else {
                this.controlShape.getBrush().setStyle(2);
            }
            this.firePropertyChange("useGradientFill");
        }
    }

    public String getTitleText() {
        return this.titleText.getText();
    }

    public void setTitleText(String text) {
        String curText = this.titleText.getText();
        if (curText != null && curText.equals(text) || curText == null && text == null) {
            return;
        }
        this.titleText.setText(text);
        this.firePropertyChange("titleText");
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        if (this.outputPortGroup.getNumPorts() == 0) {
            return cv;
        }
        PFDPort outputPort = this.outputPortGroup.getPort(0);
        Vector outLinks = outputPort.getFromLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        if (this.inputPortGroup.getNumPorts() == 0) {
            return pv;
        }
        PFDPort inputPort = this.inputPortGroup.getPort(0);
        Vector inLinks = inputPort.getToLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        return this.controlShape.getSpotLocation(spot, p);
    }

    @Override
    public PFDPort getPort(String name) {
        return null;
    }

    @Override
    public boolean isForceShowPorts() {
        return false;
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setSpotLocation(0, p);
    }

    @Override
    public void setForceShowPorts(boolean visible) {
    }

    @Override
    public int getLayoutWidth() {
        if (this.flowDirection.equalsIgnoreCase("right") || this.flowDirection.equalsIgnoreCase("left")) {
            return this.controlShape.getWidth();
        }
        if (this.titleText.isEmpty()) {
            return this.controlShape.getWidth();
        }
        return this.controlShape.getWidth() + 7 + this.titleText.getWidth();
    }

    @Override
    public int getLayoutHeight() {
        if (this.flowDirection.equalsIgnoreCase("right") || this.flowDirection.equalsIgnoreCase("left")) {
            if (this.titleText.isEmpty()) {
                return this.controlShape.getHeight();
            }
            return this.controlShape.getHeight() + 5 + this.titleText.getHeight();
        }
        return this.controlShape.getHeight();
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("preferredSize") || property.equals("children") || property.equals("titleText") || property.equals("flowDirection") || property.equals("nodeNumber")) {
            this.layoutChildren();
        } else if (property.equals("all")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public PFDPort getInputPort() {
        if (this.inputPortGroup.getNumPorts() > 0) {
            return this.inputPortGroup.getPort(0);
        }
        return null;
    }

    @Override
    public PFDPort setInputPort(PFDPort port) {
        if (port == null) {
            throw new NullPointerException();
        }
        if (this.inputPortGroup.getNumPorts() > 0) {
            PFDPort rv = this.inputPortGroup.removePort(0);
            this.inputPortGroup.addPort(0, port);
            return rv;
        }
        this.inputPortGroup.addPort(port);
        return null;
    }

    @Override
    public PFDPort getOutputPort() {
        if (this.outputPortGroup.getNumPorts() > 0) {
            return this.outputPortGroup.getPort(0);
        }
        return null;
    }

    @Override
    public PFDPort setOutputPort(PFDPort port) {
        if (port == null) {
            throw new NullPointerException();
        }
        if (this.outputPortGroup.getNumPorts() > 0) {
            PFDPort rv = this.outputPortGroup.removePort(0);
            this.outputPortGroup.addPort(0, port);
            return rv;
        }
        this.outputPortGroup.addPort(port);
        return null;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        this.checkFlowDirection(direction);
        if (this.flowDirection == direction) {
            return;
        }
        this.flowDirection = direction;
        this.firePropertyChange("flowDirection");
    }

    private void checkFlowDirection(String direction) {
        if (direction == null) {
            throw new IllegalArgumentException(RB.getStringResource("PFDAbstractNode.", "direction.ex.txt"));
        }
        if (direction.equalsIgnoreCase("Left") || direction.equalsIgnoreCase("Right") || direction.equalsIgnoreCase("Up") || direction.equalsIgnoreCase("Down")) {
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource("PFDAbstractNode.", "direction.ex.txt"));
    }

    public void copyObject(PFDControlNode toObject) {
        super.copyObject(toObject);
        toObject.setPreferredSize(this.getPreferredSize());
        toObject.setTitleText(this.getTitleText());
        toObject.layoutChildren();
        toObject.setLocation(this.getLocation());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        int mouseMode = v.getMouseExtendedMode();
        v.setMouseOverPrimitive(this, e);
        if (e.getSource() == this.controlShape && this.isSelectable()) {
            if (mouseMode == 4) {
                if (!v.isSelected(this)) {
                    v.clearSelections();
                    v.selectPrimitive(this);
                }
            } else if (mouseMode == 2) {
                if (v.isSelected(this)) {
                    v.deselectPrimitive(this);
                } else {
                    v.selectPrimitive(this);
                    if (this.theView.isEditMode() && this.isDraggable()) {
                        v.setDragMode(0);
                    }
                }
            } else {
                if (!v.isSelected(this)) {
                    v.clearSelections();
                    v.selectPrimitive(this);
                }
                if (this.theView.isEditMode() && this.isDraggable()) {
                    v.setDragMode(0);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (!this.theView.isEditMode()) {
            return;
        }
        if (e.getSource() == this.controlShape) {
            if (this.outputPortGroup.hasValidInteractivePort()) {
                this.outputPortGroup.setRenderMode(1);
            }
            if (this.selectable && this.draggable) {
                v.setCursor(1);
            }
        } else {
            this.outputPortGroup.setRenderMode(0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (!this.theView.isEditMode()) {
            return;
        }
        if (e.getSource() == this.controlShape) {
            int mode = v.getDragMode();
            if (mode == 3 || mode == 1) {
                this.inputPortGroup.snapLinkToPort(v.getDraggedLink(), v);
            } else if (mode == 2) {
                this.outputPortGroup.snapLinkFromPort(v.getDraggedLink(), v);
            }
        } else {
            this.outputPortGroup.setRenderMode(0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.inputPortGroup.setRenderMode(0);
        this.outputPortGroup.setRenderMode(0);
    }

    @Override
    public void setHighlightOn(boolean highlightOn) {
        if (this.highlightOn == highlightOn) {
            return;
        }
        this.highlightOn = highlightOn;
        this.updateStatus();
        this.firePropertyChange("hightlightOn");
    }

    @Override
    public boolean getHighlightOn() {
        return this.highlightOn;
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(status, null, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip) {
        this.setStatus(status, tooltip, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip, String title, String content, HyperlinkListener listener) {
        PFDStatus newStatus = PFDStatus.getInstance(status);
        newStatus.putValue("Tooltip", tooltip);
        newStatus.putValue("MessageTitle", title);
        newStatus.putValue("MessgeContent", content);
        newStatus.putValue("MessageHyperlinkListener", listener);
        this.setStatus(newStatus);
    }

    @Override
    public void setStatus(PFDStatus status) {
        this.statusUtil.setStatus(status);
        PFDAbstractAction action = this.statusUtil.getAction();
        this.statusButton.setAction(action);
        if (action == null) {
            if (this.containsPrimitive(this.statusButton)) {
                this.removePrimitive(this.statusButton);
            }
        } else if (!this.containsPrimitive(this.statusButton)) {
            int index = this.indexOfPrimitive(this.titleText);
            if (index >= 0) {
                this.addPrimitive(index, this.statusButton);
            } else {
                this.addPrimitive(this.statusButton);
            }
        } else {
            this.layoutStatusButton();
            this.firePropertyChange("bbox");
        }
        PFDMessageWindow newWindow = this.statusUtil.getMessageWindow();
        if (this.statusWindow != null && this.containsPrimitive(this.statusWindow)) {
            this.removePrimitive(this.statusWindow);
        }
        this.statusWindow = newWindow;
        this.updateStatus();
        this.firePropertyChange("status");
    }

    @Override
    public int getStatus() {
        return this.statusUtil.getStatus();
    }

    @Override
    public PFDStatus getStatusObject() {
        return this.statusUtil.getStatusObject();
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        FillStyleElement fse = style.getFillStyleElement("NodeStyleControl");
        if (fse != null) {
            String hctString = System.getProperty("HIGH_CONTRAST_TESTING");
            if (hctString != null) {
                this.setUseGradientFill(false);
            } else {
                this.setUseGradientFill(fse.getFillType() == 1);
            }
            this.setFillColor(fse.getFillColor());
            this.setGradientColorTop(fse.getFillGradientStartColor());
            this.setGradientColorBottom(fse.getFillGradientEndColor());
        }
        this.updateStatus();
    }

    private void updateStatus() {
        if (this.model == null) {
            return;
        }
        Style style = this.model.getStyle();
        this.statusUtil.updateStatusObject(style);
        if (style == null) {
            return;
        }
        PFDStatus status = this.statusUtil.getStatusObject();
        Color statusLineColor = null;
        Number statusLineThickness = null;
        if (status != null) {
            statusLineColor = (Color)status.getValue("LineColor");
            statusLineThickness = (Number)status.getValue("LineThickness");
        }
        String context = this.highlightOn ? "Highlight" : "NodeStyleControl";
        LineStyleElement lse = style.getLineStyleElement(context);
        if (statusLineColor != null) {
            this.setOutlineColor(statusLineColor);
        } else if (lse != null) {
            this.setOutlineColor(lse.getLineColor());
        } else {
            this.setOutlineColor(Color.BLACK);
        }
        if (statusLineThickness != null) {
            this.setOutlineWidth(statusLineThickness.floatValue());
        } else if (lse != null) {
            this.setOutlineWidth(lse.getLineThickness().toPixels(0, 0));
        } else {
            this.setOutlineWidth(1.0f);
        }
    }

    @Override
    public boolean isGhosted() {
        return this.ghosted;
    }

    @Override
    public void setGhosted(boolean b) {
        if (this.ghosted == b) {
            return;
        }
        this.ghosted = b;
        this.firePropertyChange("ghosted");
    }

    @Override
    public void setWindowVisible(PFDWindow window, boolean visible) {
        if (window != this.statusWindow) {
            return;
        }
        if (visible) {
            if (!this.containsPrimitive(this.statusWindow)) {
                this.statusWindow.setLocation(this.statusButton.getX() + this.statusButton.getWidth() / 2 + PFDControlNode.statusDetailsOffset.width, this.statusButton.getY() + this.statusButton.getHeight() / 2 + PFDControlNode.statusDetailsOffset.height);
                this.addPrimitive(this.statusWindow);
            }
        } else {
            this.removePrimitive(this.statusWindow);
        }
    }

    protected void layoutNodeNumber(Point p) {
        if (this.nodeNumber != null) {
            this.nodeNumber.setSpotLocation(0, p);
        }
    }

    protected void drawNodeNumber(Graphics2D g) {
        if (this.nodeNumber != null && this.containsPrimitive(this.nodeNumber)) {
            this.nodeNumber.paint(g);
        }
    }

    protected void clonePorts(Hashtable table, PFDControlNode clone) {
        PFDPort oldPort = this.getInputPort();
        PFDPort newPort = (PFDPort)oldPort.cloneObject(table);
        clone.setInputPort(newPort);
        oldPort = this.getOutputPort();
        newPort = (PFDPort)oldPort.cloneObject(table);
        clone.setOutputPort(newPort);
    }

    @Override
    public void setNodeOrder(int order) {
        if (this.nodeNumber == null) {
            this.nodeNumber = new PFDNodeNumber();
        }
        if (this.nodeNumber.getNumber() == order) {
            return;
        }
        this.nodeNumber.setNumber(order);
        this.firePropertyChange("nodeNumber");
    }

    @Override
    public int getNodeOrder() {
        if (this.nodeNumber == null) {
            return 0;
        }
        return this.nodeNumber.getNumber();
    }

    @Override
    public void setNodeOrderVisible(boolean visible) {
        if (this.nodeNumber == null) {
            if (visible) {
                this.nodeNumber = new PFDNodeNumber();
                this.addPrimitive(this.nodeNumber);
            }
        } else {
            if (visible == this.nodeNumber.isVisible()) {
                return;
            }
            this.nodeNumber.setVisible(visible);
            if (visible) {
                this.addPrimitive(this.nodeNumber);
            } else {
                this.removePrimitive(this.nodeNumber);
            }
        }
        this.firePropertyChange("nodeNumber");
    }

    @Override
    public boolean isNodeOrderVisible() {
        if (this.nodeNumber == null) {
            return false;
        }
        return this.nodeNumber.isVisible();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setStatus(0);
    }
}

