/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

public class PFDCompoundRectangle
extends PFDRoundRectangle {
    private transient RoundRectangle2D.Double topRoundRect = new RoundRectangle2D.Double();
    private int topHeight = 0;
    private PFDBrush topBrush = new PFDBrush();
    private PFDPen topPen = new PFDPen();

    public PFDCompoundRectangle() {
    }

    public PFDCompoundRectangle(Point p, Dimension size) {
        super(p, size);
    }

    public PFDCompoundRectangle(Rectangle r) {
        super(r);
    }

    public PFDCompoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        super(r, arcWidth, arcHeight);
    }

    public PFDCompoundRectangle(Rectangle r, int topHeight, int arcWidth, int arcHeight) {
        super(r, arcWidth, arcHeight);
        this.topHeight = topHeight;
    }

    public void setTopHeight(int topHeight) {
        this.topHeight = topHeight;
    }

    public int getTopHeight() {
        return this.topHeight;
    }

    public PFDBrush getTopBrush() {
        return this.topBrush;
    }

    public void setTopBrush(PFDBrush brush) {
        this.topBrush = brush;
        this.firePropertyChange("top brush");
    }

    public PFDPen getTopPen() {
        return this.topPen;
    }

    public void setTopPen(PFDPen pen) {
        this.topPen = pen;
        this.firePropertyChange("top pen");
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        this.rr.setRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, this.arcWidth, this.arcHeight);
        if (this.shadowOn) {
            this.drawShadow(g2d, v);
        }
        this.brush.apply(g2d);
        g2d.fillRoundRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1, this.arcWidth, this.arcHeight);
        if (this.topHeight > this.arcHeight * 2) {
            this.topBrush.apply(g2d);
            g2d.fillRoundRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.topHeight, this.arcWidth, this.arcHeight);
            g2d.fillRect(this.bbox.x, this.bbox.y + this.topHeight - this.arcHeight, this.arcWidth, this.arcHeight);
            g2d.fillRect(this.bbox.x + this.bbox.width - 1 - this.arcWidth, this.bbox.y + this.topHeight - this.arcHeight, this.arcWidth, this.arcHeight);
            this.topPen.apply(g2d);
            g2d.drawLine(this.bbox.x, this.bbox.y + this.topHeight, this.bbox.x + this.bbox.width - 1, this.bbox.y + this.topHeight);
        }
        this.pen.apply(g2d);
        g2d.drawRoundRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1, this.arcWidth, this.arcHeight);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        g2d.setColor(this.topBrush.getColor());
        g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        g2d.setColor(this.pen.getColor());
        g2d.drawRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDCompoundRectangle clone = new PFDCompoundRectangle();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDCompoundRectangle toObject) {
        super.copyObject(toObject);
        toObject.setTopHeight(this.getTopHeight());
        this.topBrush.copyObject(toObject.getTopBrush());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.topRoundRect = new RoundRectangle2D.Double();
    }
}

