/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDButtonGroup;
import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDEmptyPrimitive;
import com.sas.graphics.components.pfd.PFDIcon;
import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDMessageWindow;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDNodeNumber;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPortGroup;
import com.sas.graphics.components.pfd.PFDProgressBar;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.PFDStatusUtil;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDWindow;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollectionParentInterface;
import com.sas.graphics.components.pfd.interfaces.PFDGhostablePrimitiveInterface;
import com.sas.graphics.components.pfd.interfaces.PFDHighlightInterface;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleInputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleOutputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDNodeOrderInterface;
import com.sas.graphics.components.pfd.interfaces.PFDPortStyleInterface;
import com.sas.graphics.components.pfd.interfaces.PFDStatusInterface;
import com.sas.graphics.components.pfd.interfaces.PFDTableNodeInterface;
import com.sas.graphics.components.pfd.interfaces.PFDWindowContainerInterface;
import com.sas.graphics.components.pfd.ui.PFDScrollPane;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleNodeTableVisibleAction;
import com.sas.graphics.components.pfd.ui.menu.PFDMenuUtil;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class PFDCompositeNode
extends PFDAbstractNode
implements PFDDirectionalNodeInterface,
PFDMultipleInputInterface,
PFDMultipleOutputInterface,
PFDHighlightInterface,
PFDStatusInterface,
PFDGhostablePrimitiveInterface,
ChangeListener,
PFDWindowContainerInterface,
PFDNodeOrderInterface,
PFDTableNodeInterface,
PFDPortStyleInterface,
PropertyChangeListener,
TableModelListener,
PropertyInterface,
PFDButtonCollectionParentInterface {
    private static final long serialVersionUID = -5000991487529517486L;
    protected static final int rightTitleTextBorder = 6;
    protected static final int leftTitleTextBorder = 22;
    protected static final int rightContentTextBorder = 6;
    protected static final int leftContentTextBorder = 6;
    protected static final int topContentTextBorder = 4;
    protected static final int topNodeBorder = 6;
    protected static final int bottomNodeBorder = 6;
    protected static final int iconHorizontalOffset = 6;
    protected static final int nodeIconSize = 24;
    protected int nodeWidth = 110;
    protected int nodeHeight = 48;
    protected static final int cornerRadius = 10;
    protected static final int numContentTextLines = 2;
    protected static final int statusButtonOffset = 0;
    protected PFDRoundRectangle nodeShape;
    protected PFDText titleText;
    protected PFDText contentText;
    protected PFDIcon nodeIcon;
    protected PFDButton statusButton;
    protected PFDPortGroup inputPortGroup;
    protected PFDPortGroup outputPortGroup;
    protected PFDPort inputCenterPort;
    protected PFDPort outputCenterPort;
    protected PFDEmptyPrimitive linkDragHotspot;
    protected PFDEmptyPrimitive nodeDragHotspot;
    protected boolean linkDragShadingVisible = false;
    private static final int linkDragShadingOpacity = 13;
    protected static final int linkHotspotOuterPadding = 5;
    protected static final int linkHotspotCornerRadius = 20;
    protected static final float dragHotspotSizePct = 0.25f;
    protected static final int nodeDragHotspotCornerRadius = 6;
    protected static final int linkClipNodePadding = 2;
    protected static final int linkClipIconPadding = 1;
    protected static final int linkClipStatusPadding = 1;
    protected static final int linkClipNodeCornerRadius = 14;
    protected int portStyle = 0;
    private static final int portOffset = 4;
    private static final int stubOffset = 2;
    protected Color gradientColorTop = new Color(200, 200, 200);
    protected Color gradientColorBottom = new Color(200, 200, 200);
    protected boolean useGradientFill = false;
    protected Dimension preferredSize;
    protected String flowDirection = "Right";
    protected String nodeStyleContext = "NodeStyle1";
    protected boolean highlightOn = false;
    protected PFDProgressBar progressBar;
    private static final int progressBarThickness = 4;
    private static final int progressBarOffset = 7;
    private static final int progressBarInsetStart = 5;
    private static final int progressBarInsetEnd = 10;
    private boolean ghosted = false;
    protected PFDButtonGroup buttonGroup;
    protected PFDButton noteButton;
    protected PFDStatusUtil statusUtil;
    protected PFDMessageWindow statusWindow;
    protected static final Dimension noteOffset = new Dimension(-9, -9);
    protected static final Dimension statusDetailsOffset = new Dimension(-12, -12);
    private transient JMenu noteMenu = null;
    protected PFDNodeNumber nodeNumber;
    protected transient JTable dataTable;
    protected PFDComponentPrimitive tablePrimitive = null;
    protected boolean tableVisible = true;
    protected static final int tableXPadding = 3;
    protected static final int tableYPadding = 10;
    protected int tableSize = 0;
    protected int tableRowCount = 0;
    protected int minTableRowCount = 3;
    protected int maxTableRowCount = Integer.MAX_VALUE;
    protected int preferredTableRowCount = 10;
    private boolean resetTableToPreferredSize = false;
    protected static final int resizeHandleIndex = 5;
    protected PFDEmptyPrimitive resizeHotSpot;
    private static final int multiPortOffset = 7;
    protected transient PropertyList pending = null;
    private Icon DEFAULT_icon = null;
    private Boolean DEFAULT_highlightOn = Boolean.FALSE;
    private String DEFAULT_style = "NodeStyle1";
    private int DEFAULT_portType = this.portStyle;
    private String DEFAULT_title = null;
    private String DEFAULT_details = null;
    private String DEFAULT_comments = null;
    private Boolean DEFAULT_commentsVisible = Boolean.FALSE;
    private BufferedImage ghostImage = null;
    private Graphics2D ghostGraphics = null;
    protected int pendingLocationX = -1000;
    protected int pendingLocationY = -1000;

    public PFDCompositeNode() {
        this.init();
    }

    private void init() {
        this.setCustomSelection(true);
        this.setBreakable(false);
        this.pending = new PropertyList();
        this.preferredSize = new Dimension(this.nodeWidth, this.nodeHeight);
        this.titleText = new PFDText();
        this.titleText.setFontSize(10);
        this.titleText.setSelectable(false);
        this.titleText.setFontStyle(1);
        this.titleText.setForeground(new Color(60, 60, 60));
        this.contentText = new PFDText();
        this.contentText.setFontSize(9);
        this.contentText.setSelectable(false);
        this.contentText.setForeground(new Color(60, 60, 60));
        this.nodeIcon = new PFDIcon();
        this.nodeIcon.setShadowOn(true);
        this.statusUtil = new PFDStatusUtil(this);
        this.statusButton = new PFDButton();
        this.nodeShape = new PFDRoundRectangle();
        this.nodeShape.getBrush().setColor(new Color(200, 200, 200));
        this.nodeShape.getPen().setColor(new Color(128, 128, 128));
        this.nodeShape.setArcHeight(10);
        this.nodeShape.setArcWidth(10);
        this.nodeShape.setBBox(6, 0, this.preferredSize.width, this.preferredSize.height);
        this.nodeShape.setShadowOn(true);
        this.nodeShape.addMouseListener(this);
        this.nodeShape.addMouseMotionListener(this);
        this.nodeIcon.addMouseListener(this);
        this.nodeIcon.addMouseMotionListener(this);
        this.inputPortGroup = this.createInputPortGroup();
        this.inputPortGroup.addPort(new PFDPort());
        this.outputPortGroup = this.createOutputPortGroup();
        this.outputPortGroup.addPort(new PFDPort());
        this.buttonGroup = new PFDButtonGroup();
        this.addPrimitive(this.inputPortGroup);
        this.addPrimitive(this.nodeShape);
        this.addPrimitive(this.titleText);
        this.addPrimitive(this.contentText);
        this.addPrimitive(this.nodeIcon);
        this.addPrimitive(this.outputPortGroup);
        this.addPrimitive(this.buttonGroup);
    }

    protected PFDPortGroup createInputPortGroup() {
        return new PFDPortGroup(0);
    }

    protected PFDPortGroup createOutputPortGroup() {
        return new PFDPortGroup(1);
    }

    protected void layoutChildren() {
        this.disableChangeUpdate();
        Point p = this.nodeShape.getSpotLocation(1, null);
        this.nodeWidth = this.preferredSize.width;
        int titleWidth = this.nodeWidth - 22 - 6;
        int contentWidth = this.nodeWidth - 6 - 6;
        if (this.titleText.isVisible() && this.titleText.getText() != null && this.titleText.getText().length() > 0) {
            this.titleText.setVerticalAlignment(0);
            this.titleText.setHorizontalAlignment(1);
            this.titleText.setMultiline(true);
            this.titleText.setWrapWidth(titleWidth);
            this.titleText.setClipping(true);
            this.titleText.setMaxLines(2);
            this.titleText.setBBox(p.x + 22, p.y + 6 + 12, 0, 0);
            this.titleText.forceUpdate();
        }
        int contentTextHeight = 0;
        if (this.contentText.isVisible() && this.contentText.getText() != null && this.contentText.getText().length() > 0) {
            contentTextHeight = (int)this.contentText.getLineHeight() * 2;
            this.contentText.setVerticalAlignment(0);
            this.contentText.setHorizontalAlignment(1);
            this.contentText.setMultiline(true);
            this.contentText.setWrapWidth(contentWidth);
            this.contentText.setClipping(true);
            this.contentText.setMaxLines(2);
            this.contentText.setBBox(p.x + 6, p.y + 6 + 24 + 4 + contentTextHeight / 2, 0, 0);
            this.contentText.forceUpdate();
            contentTextHeight += 4;
        }
        int tableHeight = 0;
        if (this.canShowTable() && this.tablePrimitive != null) {
            tableHeight = this.tableSize + 10;
        }
        this.nodeHeight = 30 + contentTextHeight + tableHeight + 6;
        this.preferredSize.setSize(this.nodeWidth, this.nodeHeight);
        this.nodeShape.setBBox(p.x, p.y, this.nodeWidth, this.nodeHeight);
        this.nodeIcon.setBBox(p.x - 6, p.y + 6, 24, 24);
        this.layoutStatusButton();
        this.layoutStatusWindow();
        this.layoutPorts();
        this.layoutProgressBar();
        this.layoutButtons();
        this.setNoteLocation();
        this.layoutNodeNumber(p);
        this.layoutTable();
        this.layoutResizeHotSpot();
        this.enableChangeUpdate();
        this.calculateBBox();
    }

    protected void layoutPorts() {
        switch (this.portStyle) {
            case 0: {
                this.layoutBidirectionalPorts();
                break;
            }
            case 1: {
                this.layoutOmnidirectionalPort();
            }
        }
    }

    protected void layoutOmnidirectionalPort() {
        Rectangle bounds = this.nodeShape.getRBBox();
        if (this.inputCenterPort != null) {
            this.inputCenterPort.setBBox((int)bounds.getCenterX(), (int)bounds.getCenterY(), 0, 0);
        }
        if (this.outputCenterPort != null) {
            this.outputCenterPort.setBBox((int)bounds.getCenterX(), (int)bounds.getCenterY(), 0, 0);
        }
        this.linkDragHotspot.setBBox(bounds.x - 5, bounds.y - 5, bounds.width + 10, bounds.height + 10);
        int tableHeight = 0;
        if (this.canShowTable() && this.tablePrimitive != null) {
            tableHeight = this.tableSize + 10;
        }
        int padding = (int)Math.min((float)bounds.width * 0.25f, (float)(bounds.height - tableHeight) * 0.25f);
        this.nodeDragHotspot.setBBox(bounds.x + padding, bounds.y + padding, bounds.width - padding * 2, bounds.height - padding * 2);
        Shape linkDragShape = this.linkDragHotspot.getShape();
        Rectangle linkDragBounds = this.linkDragHotspot.getRBBox();
        if (linkDragShape == null) {
            linkDragShape = new RoundRectangle2D.Float();
        }
        ((RoundRectangle2D)linkDragShape).setRoundRect(0.0, 0.0, linkDragBounds.width, linkDragBounds.height, 20.0, 20.0);
        this.linkDragHotspot.setShape(linkDragShape);
        Shape nodeDragShape = this.nodeDragHotspot.getShape();
        Rectangle nodeDragBounds = this.nodeDragHotspot.getRBBox();
        if (nodeDragShape == null) {
            nodeDragShape = new RoundRectangle2D.Float();
        }
        ((RoundRectangle2D)nodeDragShape).setRoundRect(0.0, 0.0, nodeDragBounds.width, nodeDragBounds.height, 6.0, 6.0);
        this.nodeDragHotspot.setShape(nodeDragShape);
        this.updatePortClipArea();
    }

    protected void updatePortClipArea() {
        Rectangle portBounds;
        Rectangle nodeBounds = this.nodeShape.getRBBox();
        Rectangle iconBounds = this.nodeIcon.getRBBox();
        Rectangle statusBounds = this.statusButton.getRBBox();
        if (this.inputCenterPort != null) {
            portBounds = this.inputCenterPort.getRBBox();
            RoundRectangle2D.Double inputNodeRect = new RoundRectangle2D.Double(nodeBounds.x - 2 - portBounds.x, nodeBounds.y - 2 - portBounds.y, nodeBounds.width - 1 + 4, nodeBounds.height - 1 + 4, 14.0, 14.0);
            Area inputNodeArea = new Area(inputNodeRect);
            Rectangle inputIconRect = new Rectangle(iconBounds.x - 1 - portBounds.x, iconBounds.y - portBounds.y, iconBounds.width - 1, iconBounds.height - 1);
            inputNodeArea.add(new Area(inputIconRect));
            if (this.containsPrimitive(this.statusButton)) {
                Rectangle inputStatusRect = new Rectangle(statusBounds.x - 1 - portBounds.x, statusBounds.y - 1 - portBounds.y, statusBounds.width - 1 + 2, statusBounds.height - 1 + 2);
                inputNodeArea.add(new Area(inputStatusRect));
            }
            this.inputCenterPort.setClipArea(inputNodeArea);
        }
        if (this.outputCenterPort != null) {
            portBounds = this.outputCenterPort.getRBBox();
            RoundRectangle2D.Double outputNodeRect = new RoundRectangle2D.Double(nodeBounds.x - portBounds.x, nodeBounds.y - portBounds.y, nodeBounds.width - 1, nodeBounds.height - 1, 10.0, 10.0);
            Area outputNodeArea = new Area(outputNodeRect);
            Rectangle outputIconRect = new Rectangle(iconBounds.x - portBounds.x, iconBounds.y - portBounds.y, iconBounds.width - 1, iconBounds.height - 1);
            outputNodeArea.add(new Area(outputIconRect));
            if (this.containsPrimitive(this.statusButton)) {
                Rectangle outputStatusRect = new Rectangle(statusBounds.x - portBounds.x, statusBounds.y - portBounds.y, statusBounds.width - 1, statusBounds.height - 1);
                outputNodeArea.add(new Area(outputStatusRect));
            }
            this.outputCenterPort.setClipArea(outputNodeArea);
        }
    }

    protected void layoutBidirectionalPorts() {
        Point p = this.nodeShape.getSpotLocation(1, null);
        if (this.flowDirection.equalsIgnoreCase("right")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(3);
            this.inputPortGroup.setAnchorPoint(new Point(p.x, p.y + 6 + 12));
            this.inputPortGroup.setPortMinBoundsOffset(18);
            this.inputPortGroup.setPortMaxBoundsOffset(this.nodeHeight - 6 - 12);
            this.inputPortGroup.setPortGroupOffset(4);
            this.inputPortGroup.setPortOffset(8);
            this.inputPortGroup.setMultiplePortOffset(7);
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(4);
            this.outputPortGroup.setAnchorPoint(new Point(p.x + this.nodeWidth, p.y + 6 + 12));
            this.outputPortGroup.setPortMinBoundsOffset(18);
            this.outputPortGroup.setPortMaxBoundsOffset(this.nodeHeight - 6 - 12);
            this.outputPortGroup.setPortGroupOffset(4);
            this.outputPortGroup.setPortOffset(2);
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("left")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(4);
            this.inputPortGroup.setAnchorPoint(new Point(p.x + this.nodeWidth, p.y + 6 + 12));
            this.inputPortGroup.setPortMinBoundsOffset(18);
            this.inputPortGroup.setPortMaxBoundsOffset(this.nodeHeight - 6 - 12);
            this.inputPortGroup.setPortGroupOffset(4);
            this.inputPortGroup.setPortOffset(2);
            this.inputPortGroup.setMultiplePortOffset(7);
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(3);
            this.outputPortGroup.setAnchorPoint(new Point(p.x, p.y + 6 + 12));
            this.outputPortGroup.setPortMinBoundsOffset(18);
            this.outputPortGroup.setPortMaxBoundsOffset(this.nodeHeight - 6 - 12);
            this.outputPortGroup.setPortGroupOffset(4);
            this.outputPortGroup.setPortOffset(8);
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("down")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(1);
            this.inputPortGroup.setAnchorPoint(new Point(p.x + this.nodeWidth / 2, p.y));
            this.inputPortGroup.setPortMinBoundsOffset(this.nodeWidth / 2);
            this.inputPortGroup.setPortMaxBoundsOffset(this.nodeWidth / 2);
            this.inputPortGroup.setPortGroupOffset(4);
            this.inputPortGroup.setPortOffset(2);
            this.inputPortGroup.setMultiplePortOffset(7);
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(2);
            this.outputPortGroup.setAnchorPoint(new Point(p.x + this.nodeWidth / 2, p.y + this.nodeHeight));
            this.outputPortGroup.setPortMinBoundsOffset(this.nodeWidth / 2);
            this.outputPortGroup.setPortMaxBoundsOffset(this.nodeWidth / 2);
            this.outputPortGroup.setPortGroupOffset(4);
            this.outputPortGroup.setPortOffset(2);
            this.outputPortGroup.enableChangeUpdate();
        } else if (this.flowDirection.equalsIgnoreCase("up")) {
            this.inputPortGroup.disableChangeUpdate();
            this.inputPortGroup.setDirection(2);
            this.inputPortGroup.setAnchorPoint(new Point(p.x + this.nodeWidth / 2, p.y + this.nodeHeight));
            this.inputPortGroup.setPortMinBoundsOffset(this.nodeWidth / 2);
            this.inputPortGroup.setPortMaxBoundsOffset(this.nodeWidth / 2);
            this.inputPortGroup.setPortGroupOffset(4);
            this.inputPortGroup.setPortOffset(2);
            this.inputPortGroup.setMultiplePortOffset(7);
            this.inputPortGroup.enableChangeUpdate();
            this.outputPortGroup.disableChangeUpdate();
            this.outputPortGroup.setDirection(1);
            this.outputPortGroup.setAnchorPoint(new Point(p.x + this.nodeWidth / 2, p.y));
            this.outputPortGroup.setPortMinBoundsOffset(this.nodeWidth / 2);
            this.outputPortGroup.setPortMaxBoundsOffset(this.nodeWidth / 2);
            this.outputPortGroup.setPortGroupOffset(4);
            this.outputPortGroup.setPortOffset(2);
            this.outputPortGroup.enableChangeUpdate();
        }
    }

    protected void layoutProgressBar() {
        if (this.progressBar == null) {
            return;
        }
        if (this.flowDirection.equalsIgnoreCase("left") || this.flowDirection.equalsIgnoreCase("right")) {
            Point p = this.nodeShape.getSpotLocation(7, null);
            this.progressBar.setPreferredSize(new Dimension(this.nodeWidth - 5 - 10, 4));
            this.progressBar.setLocation(p.x + 5, p.y + 7);
            this.progressBar.setOrientation(0);
        } else {
            Point p = this.nodeShape.getSpotLocation(3, null);
            this.progressBar.setPreferredSize(new Dimension(4, this.nodeHeight - 5 - 10));
            this.progressBar.setLocation(p.x + 7, p.y + 5);
            this.progressBar.setOrientation(1);
        }
    }

    protected void layoutButtons() {
        Point p = this.nodeShape.getSpotLocation(3, null);
        p.x -= 5;
        if (this.noteButton != null) {
            this.noteButton.setLocation(p.x - this.noteButton.getWidth(), p.y - this.noteButton.getHeight() / 2);
            p.x -= this.noteButton.getWidth() + this.buttonGroup.getButtonSpacing();
        }
        if (this.buttonGroup != null) {
            Dimension d = this.buttonGroup.getSize();
            this.buttonGroup.setLocation(p.x - d.width, p.y - d.height / 2);
        }
    }

    protected void layoutStatusButton() {
        Point p = this.nodeShape.getSpotLocation(5, null);
        this.statusButton.setLocation(p.x - this.statusButton.getWidth() / 2 - 0, p.y - this.statusButton.getHeight() / 2 - 0);
    }

    protected void layoutNodeNumber(Point p) {
        if (this.nodeNumber != null) {
            this.nodeNumber.setSpotLocation(0, p);
        }
    }

    protected void layoutTable() {
        if (this.canShowTable() && this.tablePrimitive != null) {
            Point p = this.nodeShape.getSpotLocation(7, null);
            int w = this.nodeWidth - 6;
            int h = this.tableSize;
            this.tablePrimitive.setBBox(p.x + 3, p.y - this.tableSize - 10, w, h);
        }
    }

    protected void layoutResizeHotSpot() {
        if (this.resizeHotSpot != null) {
            Point p = this.nodeShape.getSpotLocation(7, null);
            this.resizeHotSpot.setBBox(p.x, p.y - 10, this.nodeWidth, 10);
        }
    }

    @Override
    public void setPreferredSize(Dimension d) {
        if (d == null || d.equals(this.preferredSize)) {
            return;
        }
        this.preferredSize.setSize(d);
        this.firePropertyChange("preferredSize");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public void setNodeIcon(Icon icon) {
        this.nodeIcon.setIcon(icon);
        this.firePropertyChange("nodeIcon");
    }

    public Icon getNodeIcon() {
        return this.nodeIcon.getIcon();
    }

    protected void setNodeIconResourceLocation(String location) {
        this.nodeIcon.setResourceLocation(location);
    }

    protected String getNodeIconResourceLocation() {
        return this.nodeIcon.getResourceLocation();
    }

    public String getTitleText() {
        return this.titleText.getText();
    }

    public void setTitleText(String text) {
        String curText = this.titleText.getText();
        if (curText != null && curText.equals(text) || curText == null && text == null) {
            return;
        }
        this.titleText.setText(text);
        this.firePropertyChange("titleText");
    }

    public String getContentText() {
        return this.contentText.getText();
    }

    public void setContentText(String text) {
        String curText = this.contentText.getText();
        if (curText != null && curText.equals(text) || curText == null && text == null) {
            return;
        }
        this.contentText.setText(text);
        this.firePropertyChange("contentText");
    }

    private void setFillColor(Color clr) {
        if (clr == null || clr.equals(this.nodeShape.getBrush().getColor())) {
            return;
        }
        this.nodeShape.getBrush().setColor(clr);
        this.firePropertyChange("fillColor");
    }

    private Color getFillColor() {
        return this.nodeShape.getBrush().getColor();
    }

    private void setOutlineColor(Color clr) {
        if (clr == null || clr.equals(this.nodeShape.getPen().getColor())) {
            return;
        }
        this.nodeShape.getPen().setColor(clr);
    }

    private Color getOutlineColor() {
        return this.nodeShape.getPen().getColor();
    }

    private void setOutlineWidth(float width) {
        if (width == this.nodeShape.getPen().getLineWidth()) {
            return;
        }
        this.nodeShape.getPen().setLineWidth(width);
        this.firePropertyChange("outlineWidth");
    }

    private float getOutlineWidth() {
        return this.nodeShape.getPen().getLineWidth();
    }

    private Color getGradientColorBottom() {
        return this.gradientColorBottom;
    }

    private void setGradientColorBottom(Color clr) {
        if (clr == null || clr.equals(this.gradientColorBottom)) {
            return;
        }
        this.gradientColorBottom = clr;
        this.firePropertyChange("gradientBottomColor");
    }

    private Color getGradientColorTop() {
        return this.gradientColorTop;
    }

    private void setGradientColorTop(Color clr) {
        if (clr == null || clr.equals(this.gradientColorTop)) {
            return;
        }
        this.gradientColorTop = clr;
        this.firePropertyChange("gradientTopColor");
    }

    private boolean getUseGradientFill() {
        return this.useGradientFill;
    }

    private void setUseGradientFill(boolean useGradientFill) {
        if (useGradientFill != this.useGradientFill) {
            this.useGradientFill = useGradientFill;
            if (useGradientFill) {
                this.nodeShape.getBrush().setStyle(1);
            } else {
                this.nodeShape.getBrush().setStyle(2);
            }
            this.firePropertyChange("useGradientFill");
        }
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        Vector outLinks = this.getOutputLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        Vector inLinks = this.getInputLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public int getLayoutWidth() {
        return this.nodeShape.getWidth();
    }

    @Override
    public int getLayoutHeight() {
        return this.nodeShape.getHeight();
    }

    @Override
    public PFDPort getPort(String name) {
        return null;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.outputPortGroup.getForceShowPorts();
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setSpotLocation(0, p);
    }

    @Override
    public void setForceShowPorts(boolean visible) {
        this.inputPortGroup.setForceShowPorts(visible);
        this.outputPortGroup.setForceShowPorts(visible);
        this.calculateBBox();
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children") || property.equals("titleText") || property.equals("contentText") || property.equals("flowDirection") || property.equals("preferredSize") || property.equals("nodeNumber")) {
            this.layoutChildren();
        } else if (property.equals("nodeStyle")) {
            this.updateStyle();
        } else if (property.equals("status")) {
            this.updateStatusOutline();
        } else if (property.equals("highlightOn")) {
            this.updateStatusOutline();
        } else if (property.equals("progressBar")) {
            v.setCleanBufferDirty();
        } else if (property.equals("note")) {
            this.updateNotes();
        } else if (property.equals("tableHeight")) {
            this.layoutChildren();
        } else if (property.equals("table")) {
            this.updateTable();
        } else if (property.equals("tableVisible")) {
            this.updateTableVisibility();
        } else if (property.equals("minTableRowCount") || property.equals("maxTableRowCount")) {
            this.updateTableSize(false);
            this.updateTableResizability();
        } else if (property.equals("preferredTableRowCount")) {
            this.updateTableSize(true);
        } else if (property.equals("tableModel")) {
            this.updateTableSize(this.resetTableToPreferredSize);
            this.updateTableVisibility();
            this.layoutChildren();
        } else if (property.equals("all")) {
            this.updateNotes();
            this.updateTable();
            this.layoutChildren();
        }
        super.update(property, v);
    }

    protected Graphics2D preRender(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            Rectangle vbb = this.getVisualRBBox();
            this.ghostImage = new BufferedImage(vbb.width, vbb.height, 2);
            this.ghostGraphics = this.ghostImage.createGraphics();
            this.ghostGraphics.setRenderingHints(g2d.getRenderingHints());
            this.ghostGraphics.translate(-vbb.x, -vbb.y);
            return this.ghostGraphics;
        }
        return g2d;
    }

    protected void postRender(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            Rectangle vbb = this.getVisualRBBox();
            this.ghostGraphics.dispose();
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g2d.drawImage((Image)this.ghostImage, vbb.x, vbb.y, v);
            this.ghostImage.flush();
            g2d.setComposite(oldComposite);
        }
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            this.drawGhosted(g2d, v, false);
        } else {
            this.draw(g2d, v, false);
        }
    }

    @Override
    protected synchronized void renderSelected(Graphics2D g2d, PFDView v) {
        if (this.ghosted) {
            this.drawGhosted(g2d, v, true);
        } else {
            this.draw(g2d, v, true);
        }
    }

    @Override
    protected synchronized void renderFocused(Graphics2D g2d, PFDView v) {
        this.renderSelected(g2d, v);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        this.nodeShape.renderOverview(g2d, v);
        if (this.outputPortGroup != null) {
            this.outputPortGroup.renderOverview(g2d, v);
        }
        if (this.inputPortGroup != null) {
            this.inputPortGroup.renderOverview(g2d, v);
        }
    }

    protected void drawGhosted(Graphics2D g, PFDView v, boolean selected) {
        if (selected) {
            this.drawSelection(g);
        }
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        Rectangle bounds = this.getVisualRBBox();
        BufferedImage ghostImage = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D ghostGraphics = ghostImage.createGraphics();
        ghostGraphics.setRenderingHints(g.getRenderingHints());
        ghostGraphics.translate(-bounds.x, -bounds.y);
        this.nodeShape.paint(ghostGraphics);
        this.drawLinkDragShading(ghostGraphics);
        this.titleText.paint(ghostGraphics);
        this.contentText.paint(ghostGraphics);
        if (this.inputPortGroup != null) {
            this.inputPortGroup.paint(ghostGraphics);
        }
        if (this.outputPortGroup != null) {
            this.outputPortGroup.paint(ghostGraphics);
        }
        this.nodeIcon.paint(ghostGraphics);
        this.drawTable(ghostGraphics);
        if (this.noteButton != null) {
            this.noteButton.paint(ghostGraphics);
        }
        this.buttonGroup.paint(ghostGraphics);
        this.drawNodeNumber(ghostGraphics);
        ghostGraphics.dispose();
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.drawImage((Image)ghostImage, bounds.x, bounds.y, v);
        g.setComposite(oldComposite);
        this.drawStatusButton(g);
        if (this.progressBar != null) {
            this.progressBar.paint(g);
        }
        this.drawNotesAndStatus(g);
    }

    protected void draw(Graphics2D g, PFDView v, boolean selected) {
        if (this.useGradientFill) {
            this.updateNodeGradient();
        }
        this.nodeShape.paint(g);
        this.drawLinkDragShading(g);
        this.titleText.paint(g);
        this.contentText.paint(g);
        if (this.inputPortGroup != null) {
            this.inputPortGroup.paint(g);
        }
        if (this.outputPortGroup != null) {
            this.outputPortGroup.paint(g);
        }
        if (selected) {
            this.drawSelection(g);
        }
        this.nodeIcon.paint(g);
        this.drawTable(g);
        this.drawStatusButton(g);
        if (this.noteButton != null) {
            this.noteButton.paint(g);
        }
        this.buttonGroup.paint(g);
        this.drawNodeNumber(g);
        if (this.progressBar != null) {
            this.progressBar.paint(g);
        }
        this.drawNotesAndStatus(g);
    }

    protected void drawStatusButton(Graphics2D g) {
        if (this.statusButton != null && this.containsPrimitive(this.statusButton)) {
            this.statusButton.paint(g);
        }
    }

    protected void drawStatusWindow(Graphics2D g) {
        if (this.statusWindow != null && this.containsPrimitive(this.statusWindow)) {
            this.statusWindow.paint(g);
        }
    }

    protected void drawNotesAndStatus(Graphics2D g) {
        int statusIndex = -1;
        int notesIndex = -1;
        if (this.statusWindow != null) {
            statusIndex = this.indexOfPrimitive(this.statusWindow);
        }
        if (this.note != null) {
            notesIndex = this.indexOfPrimitive(this.note);
        }
        if (statusIndex < notesIndex) {
            if (statusIndex != -1) {
                this.statusWindow.paint(g);
            }
            if (notesIndex != -1) {
                this.note.paint(g);
            }
        } else {
            if (notesIndex != -1) {
                this.note.paint(g);
            }
            if (statusIndex != -1) {
                this.statusWindow.paint(g);
            }
        }
    }

    protected void drawNodeNumber(Graphics2D g) {
        if (this.nodeNumber != null && this.containsPrimitive(this.nodeNumber)) {
            this.nodeNumber.paint(g);
        }
    }

    protected void drawTable(Graphics2D g) {
        if (this.canShowTable() && this.tablePrimitive != null) {
            this.tablePrimitive.paint(g);
        }
    }

    protected void drawLinkDragShading(Graphics2D g) {
        if (this.linkDragShadingVisible) {
            RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(this.nodeShape.getX(), this.nodeShape.getY(), this.nodeShape.getWidth(), this.nodeShape.getHeight(), this.nodeShape.getArcWidth(), this.nodeShape.getArcHeight());
            Area area = new Area(roundRect);
            RoundRectangle2D.Float innerRect = new RoundRectangle2D.Float(this.nodeDragHotspot.getX(), this.nodeDragHotspot.getY(), this.nodeDragHotspot.getWidth(), this.nodeDragHotspot.getHeight(), 6.0f, 6.0f);
            area.subtract(new Area(innerRect));
            g.setColor(new Color(0, 0, 0, 13));
            g.fill(area);
        }
    }

    protected void updateNodeGradient() {
        Rectangle bounds = this.nodeShape.getRBBox();
        this.nodeShape.getBrush().paint = new GradientPaint(new Point(bounds.x, bounds.y), this.gradientColorTop, new Point(bounds.x, bounds.y + bounds.height), this.gradientColorBottom, false);
    }

    protected void drawSelection(Graphics2D g) {
        Rectangle bounds = this.nodeShape.getRBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        if (g.hitClip(bounds.x - 4 - halfStrokeWidth, bounds.y - 4 - halfStrokeWidth, bounds.width + 8 + halfStrokeWidth * 2, bounds.height + 8 + halfStrokeWidth * 2)) {
            Stroke stroke = g.getStroke();
            this.selectionPen.apply(g);
            g.drawRoundRect(bounds.x - 4, bounds.y - 4, bounds.width + 7, bounds.height + 7, 18, 18);
            g.setStroke(stroke);
        }
    }

    @Override
    protected Rectangle getCustomSelectionBBox() {
        Rectangle bounds = this.nodeShape.getBBox();
        int halfStrokeWidth = (int)Math.floor((double)this.selectionPen.getLineWidth() / 2.0);
        bounds.x -= 4 + halfStrokeWidth;
        bounds.y -= 4 + halfStrokeWidth;
        bounds.width += 8 + halfStrokeWidth * 2;
        bounds.height += 8 + halfStrokeWidth * 2;
        return bounds;
    }

    @Override
    public String getFlowDirection() {
        return this.flowDirection;
    }

    @Override
    public void setFlowDirection(String direction) {
        PFDModel.checkFlowDirection(direction);
        if (this.flowDirection == direction) {
            return;
        }
        this.flowDirection = direction;
        this.firePropertyChange("flowDirection");
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDCompositeNode clone = new PFDCompositeNode();
        table.put(this, clone);
        this.copyObject(clone);
        if (this.portStyle == 0) {
            PFDPort newPort;
            PFDPort oldPort;
            int i;
            clone.removeAllInputPorts();
            clone.removeAllOutputPorts();
            for (i = 0; i < this.inputPortGroup.getNumPorts(); ++i) {
                oldPort = this.inputPortGroup.getPort(i);
                newPort = (PFDPort)oldPort.cloneObject(table);
                clone.addInputPort(newPort);
            }
            for (i = 0; i < this.outputPortGroup.getNumPorts(); ++i) {
                oldPort = this.outputPortGroup.getPort(i);
                newPort = (PFDPort)oldPort.cloneObject(table);
                clone.addOutputPort(newPort);
            }
        } else {
            PFDPort oldIn = this.getInputPort();
            PFDPort oldOut = this.getOutputPort();
            PFDPort newIn = (PFDPort)oldIn.cloneObject(table);
            PFDPort newOut = oldIn == oldOut ? newIn : (PFDPort)oldOut.cloneObject(table);
            clone.setInputPort(newIn);
            clone.setOutputPort(newOut);
        }
        PFDButtonGroup newButtons = (PFDButtonGroup)this.buttonGroup.cloneObject(table);
        for (int i = 0; i < newButtons.getNumButtons(); ++i) {
            clone.getIndicatorButtons().addButton(newButtons.removeButton(i));
        }
        return clone;
    }

    public void copyObject(PFDCompositeNode toObject) {
        super.copyObject(toObject);
        toObject.setPreferredSize(this.getPreferredSize());
        toObject.setNodeStyleContext(this.getNodeStyleContext());
        toObject.setNodeIcon(this.getNodeIcon());
        toObject.setTitleText(this.getTitleText());
        toObject.setContentText(this.getContentText());
        toObject.setGhosted(this.isGhosted());
        toObject.layoutChildren();
        toObject.setLocation(this.getLocation());
        toObject.setPortStyle(this.getPortStyle());
    }

    protected void setPortsOpen(boolean open, boolean forceImmediate) {
        if (this.portStyle != 0) {
            return;
        }
        if (open) {
            if (this.outputPortGroup.hasValidInteractivePort()) {
                if (!this.outputPortGroup.canShowPorts()) {
                    if (this.theView.isEditMode()) {
                        this.outputPortGroup.setRenderMode(1, forceImmediate);
                    }
                } else {
                    this.outputPortGroup.setRenderMode(2, forceImmediate);
                }
            }
            if (this.inputPortGroup.hasValidInteractivePort() && this.inputPortGroup.canShowPorts()) {
                this.inputPortGroup.setRenderMode(2, forceImmediate);
            }
        } else {
            this.inputPortGroup.setRenderMode(0, forceImmediate);
            this.outputPortGroup.setRenderMode(0, forceImmediate);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        int mouseMode = v.getMouseExtendedMode();
        v.setMouseOverPrimitive(this, e);
        if (e.getSource() == this.nodeShape || e.getSource() == this.nodeIcon || e.getSource() == this.nodeDragHotspot) {
            if (this.isSelectable()) {
                if (mouseMode == 4) {
                    if (!v.isSelected(this)) {
                        v.clearSelections();
                        v.selectPrimitive(this);
                    }
                } else if (mouseMode == 2) {
                    if (v.isSelected(this)) {
                        v.deselectPrimitive(this);
                    } else {
                        v.selectPrimitive(this);
                        if (this.theView.isEditMode() && this.isDraggable()) {
                            v.setDragMode(0);
                            this.setPortsOpen(false, true);
                        }
                    }
                } else {
                    if (!v.isSelected(this)) {
                        v.clearSelections();
                        v.selectPrimitive(this);
                    }
                    if (this.theView.isEditMode() && this.isDraggable()) {
                        v.setDragMode(0);
                    }
                }
            }
        } else if (e.getSource() == this.resizeHotSpot && this.isResizable() && this.theView.isEditMode()) {
            if (mouseMode == 0) {
                this.theView.setResizePrimitive(this, 5);
                this.theView.setDragMode(4);
            }
        } else if (e.getSource() == this.linkDragHotspot) {
            if (mouseMode == 4) {
                if (!v.isSelected(this)) {
                    v.clearSelections();
                    v.selectPrimitive(this);
                }
            } else if (this.theView.isEditMode() && this.outputCenterPort != null && this.outputCenterPort.canDragNewLink()) {
                if (v.getMouseExtendedMode() == 2) {
                    v.dragNewLink(this.outputCenterPort, true);
                } else {
                    v.dragNewLink(this.outputCenterPort, false);
                }
            }
            this.setLinkDragShadingVisible(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (e.getSource() == this.nodeShape || e.getSource() == this.nodeIcon || e.getSource() == this.nodeDragHotspot) {
            this.setPortsOpen(true, false);
            if (this.theView.isEditMode() && this.selectable && this.draggable) {
                v.setCursor(1);
            }
            this.setLinkDragShadingVisible(false);
        } else if (e.getSource() == this.resizeHotSpot && this.isResizable() && this.theView.isEditMode()) {
            this.setPortsOpen(false, false);
            this.theView.setCursor(Cursor.getPredefinedCursor(9));
            this.setLinkDragShadingVisible(false);
        } else if (e.getSource() == this.linkDragHotspot) {
            if (this.theView.isEditMode() && this.outputCenterPort != null && this.outputCenterPort.canDragNewLink()) {
                v.setCursor(2);
                this.setLinkDragShadingVisible(true);
            } else {
                this.setLinkDragShadingVisible(false);
            }
        } else {
            this.setPortsOpen(false, false);
            this.setLinkDragShadingVisible(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        PFDView v = this.theView;
        v.setMouseOverPrimitive(this, e);
        if (!this.theView.isEditMode()) {
            return;
        }
        if (e.getSource() == this.nodeShape || e.getSource() == this.nodeIcon) {
            int mode = v.getDragMode();
            if (mode == 3 || mode == 1) {
                this.inputPortGroup.snapLinkToPort(v.getDraggedLink(), v);
            } else if (mode == 2) {
                this.outputPortGroup.snapLinkFromPort(v.getDraggedLink(), v);
            }
        } else if (e.getSource() == this.linkDragHotspot || e.getSource() == this.nodeDragHotspot) {
            int mode = v.getDragMode();
            if (mode == 3 || mode == 1) {
                PFDLink l = v.getDraggedLink();
                if (this.inputCenterPort != null && this.inputCenterPort.canDropToLink(l)) {
                    v.snapLinkToPort(this.inputCenterPort);
                } else {
                    v.rejectLinkDrag(this, this.inputCenterPort);
                }
            } else if (mode == 2) {
                PFDLink l = v.getDraggedLink();
                if (this.outputCenterPort != null && this.outputCenterPort.canDropFromLink(l)) {
                    v.snapLinkToPort(this.outputCenterPort);
                } else {
                    v.rejectLinkDrag(this, this.outputCenterPort);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setPortsOpen(false, false);
        this.setLinkDragShadingVisible(false);
    }

    @Override
    public Vector getInputLinks() {
        if (this.portStyle == 0) {
            Vector inputLinks = new Vector();
            for (int i = 0; i < this.getNumInputPorts(); ++i) {
                PFDPort p = this.getInputPort(i);
                if (p == null) continue;
                inputLinks.addAll(p.getToLinks());
            }
            return inputLinks;
        }
        if (this.inputCenterPort == null) {
            return new Vector();
        }
        return this.inputCenterPort.getToLinks();
    }

    @Override
    public Vector getOutputLinks() {
        if (this.portStyle == 0) {
            Vector outputLinks = new Vector();
            for (int i = 0; i < this.getNumOutputPorts(); ++i) {
                PFDPort p = this.getOutputPort(i);
                if (p == null) continue;
                outputLinks.addAll(p.getFromLinks());
            }
            return outputLinks;
        }
        if (this.outputCenterPort == null) {
            return new Vector();
        }
        return this.outputCenterPort.getFromLinks();
    }

    @Override
    public PFDPort getInputPort() {
        if (this.portStyle == 0) {
            if (this.inputPortGroup.getNumPorts() > 0) {
                return this.inputPortGroup.getPort(0);
            }
            return null;
        }
        return this.inputCenterPort;
    }

    @Override
    public PFDPort setInputPort(PFDPort port) {
        if (this.portStyle == 0) {
            if (port == null) {
                throw new IllegalArgumentException("The specified port can not be null");
            }
            if (this.getNumInputPorts() > 0) {
                PFDPort rv = this.removeInputPort(0);
                this.addInputPort(0, port);
                return rv;
            }
            this.addInputPort(port);
            return null;
        }
        if (this.inputCenterPort == port) {
            return port;
        }
        PFDPort oldPort = this.inputCenterPort;
        if (oldPort != null) {
            this.removePrimitive(oldPort);
        }
        this.inputCenterPort = port;
        if (this.inputCenterPort != null) {
            this.addPrimitive(0, this.inputCenterPort);
        }
        this.firePropertyChange("inputPort");
        return oldPort;
    }

    @Override
    public void addInputPort(PFDPort port) {
        if (port == null) {
            throw new IllegalArgumentException("The specified port can not be null");
        }
        if (this.portStyle == 1) {
            throw new IllegalStateException("PORT_STYLE_OMNIDIRECTIONAL does not support multiple input ports");
        }
        if (this.inputPortGroup.containsPort(port)) {
            return;
        }
        this.inputPortGroup.addPort(port);
        this.firePropertyChange("inputPort");
    }

    @Override
    public void addInputPort(int index, PFDPort port) {
        if (port == null) {
            throw new IllegalArgumentException("The specified port can not be null");
        }
        if (this.portStyle == 1) {
            throw new IllegalStateException("PORT_STYLE_OMNIDIRECTIONAL does not support multiple input ports");
        }
        if (this.inputPortGroup.containsPort(port)) {
            return;
        }
        this.inputPortGroup.addPort(index, port);
        this.firePropertyChange("inputPort");
    }

    @Override
    public boolean removeInputPort(PFDPort port) {
        if (port == null) {
            throw new IllegalArgumentException("The specified port can not be null");
        }
        if (this.portStyle == 0) {
            boolean retVal = this.inputPortGroup.removePort(port);
            if (retVal) {
                this.firePropertyChange("inputPort");
            }
            return retVal;
        }
        if (this.inputCenterPort == port) {
            this.setInputPort(null);
            return true;
        }
        return false;
    }

    @Override
    public PFDPort removeInputPort(int index) {
        if (this.portStyle == 0) {
            PFDPort retVal = this.inputPortGroup.removePort(index);
            this.firePropertyChange("inputPort");
            return retVal;
        }
        if (index == 0 && this.inputCenterPort != null) {
            return this.setInputPort(null);
        }
        throw new IllegalStateException("There is no input port at specified index");
    }

    @Override
    public void removeAllInputPorts() {
        if (this.portStyle == 0) {
            if (this.inputPortGroup.getNumPorts() == 0) {
                return;
            }
            this.inputPortGroup.removeAllPorts();
            this.firePropertyChange("inputPort");
        } else {
            this.setInputPort(null);
        }
    }

    @Override
    public int getNumInputPorts() {
        if (this.portStyle == 0) {
            return this.inputPortGroup.getNumPorts();
        }
        return this.inputCenterPort == null ? 0 : 1;
    }

    @Override
    public PFDPort getInputPort(int index) {
        if (this.portStyle == 0) {
            return this.inputPortGroup.getPort(index);
        }
        if (index == 0 && this.inputCenterPort != null) {
            return this.inputCenterPort;
        }
        throw new IllegalStateException("There is no input port at specified index");
    }

    @Override
    public boolean isInputPort(PFDPort port) {
        if (this.portStyle == 0) {
            return this.inputPortGroup.containsPort(port);
        }
        return port != null && port == this.inputCenterPort;
    }

    @Override
    public int getInputPortIndex(PFDPort port) {
        if (this.portStyle == 0) {
            return this.inputPortGroup.getPortIndex(port);
        }
        if (port != null && port == this.inputCenterPort) {
            return 0;
        }
        return -1;
    }

    @Override
    public PFDPort getOutputPort() {
        if (this.portStyle == 0) {
            if (this.outputPortGroup.getNumPorts() > 0) {
                return this.outputPortGroup.getPort(0);
            }
            return null;
        }
        return this.outputCenterPort;
    }

    @Override
    public PFDPort setOutputPort(PFDPort port) {
        if (this.portStyle == 0) {
            if (port == null) {
                throw new IllegalArgumentException("The specified port can not be null");
            }
            if (this.getNumOutputPorts() > 0) {
                PFDPort rv = this.removeOutputPort(0);
                this.addOutputPort(0, port);
                return rv;
            }
            this.addOutputPort(port);
            return null;
        }
        if (this.outputCenterPort == port) {
            return port;
        }
        PFDPort oldPort = this.outputCenterPort;
        if (oldPort != null) {
            this.removePrimitive(oldPort);
        }
        this.outputCenterPort = port;
        if (this.outputCenterPort != null) {
            this.addPrimitive(this.indexOfPrimitive(this.inputCenterPort) + 1, this.outputCenterPort);
        }
        this.firePropertyChange("outputPort");
        return oldPort;
    }

    @Override
    public void addOutputPort(PFDPort port) {
        if (port == null) {
            throw new IllegalArgumentException("The specified port can not be null");
        }
        if (this.portStyle == 1) {
            throw new IllegalStateException("PORT_STYLE_OMNIDIRECTIONAL does not support multiple output ports");
        }
        if (this.outputPortGroup.containsPort(port)) {
            return;
        }
        this.outputPortGroup.addPort(port);
        this.firePropertyChange("outputPort");
    }

    @Override
    public void addOutputPort(int index, PFDPort port) {
        if (port == null) {
            throw new IllegalArgumentException("The specified port can not be null");
        }
        if (this.portStyle == 1) {
            throw new IllegalStateException("PORT_STYLE_OMNIDIRECTIONAL does not support multiple output ports");
        }
        if (this.outputPortGroup.containsPort(port)) {
            return;
        }
        this.outputPortGroup.addPort(index, port);
        this.firePropertyChange("outputPort");
    }

    @Override
    public boolean removeOutputPort(PFDPort port) {
        if (port == null) {
            throw new IllegalArgumentException("The specified port can not be null");
        }
        if (this.portStyle == 0) {
            boolean retVal = this.outputPortGroup.removePort(port);
            if (retVal) {
                this.firePropertyChange("outputPort");
            }
            return retVal;
        }
        if (this.outputCenterPort == port) {
            this.setOutputPort(null);
            return true;
        }
        return false;
    }

    @Override
    public PFDPort removeOutputPort(int index) {
        if (this.portStyle == 0) {
            PFDPort retVal = this.outputPortGroup.removePort(index);
            this.firePropertyChange("outputPort");
            return retVal;
        }
        if (index == 0 && this.outputCenterPort != null) {
            return this.setOutputPort(null);
        }
        throw new IllegalStateException("There is no output port at specified index");
    }

    @Override
    public void removeAllOutputPorts() {
        if (this.portStyle == 0) {
            if (this.outputPortGroup.getNumPorts() == 0) {
                return;
            }
            this.outputPortGroup.removeAllPorts();
            this.firePropertyChange("outputPort");
        } else {
            this.setOutputPort(null);
        }
    }

    @Override
    public int getNumOutputPorts() {
        if (this.portStyle == 0) {
            return this.outputPortGroup.getNumPorts();
        }
        return this.outputCenterPort == null ? 0 : 1;
    }

    @Override
    public PFDPort getOutputPort(int index) {
        if (this.portStyle == 0) {
            return this.outputPortGroup.getPort(index);
        }
        if (index == 0 && this.outputCenterPort != null) {
            return this.outputCenterPort;
        }
        throw new IllegalStateException("There is no output port at specified index");
    }

    @Override
    public boolean isOutputPort(PFDPort port) {
        if (this.portStyle == 0) {
            return this.outputPortGroup.containsPort(port);
        }
        return port != null && port == this.outputCenterPort;
    }

    @Override
    public int getOutputPortIndex(PFDPort port) {
        if (this.portStyle == 0) {
            return this.outputPortGroup.getPortIndex(port);
        }
        if (port != null && port == this.outputCenterPort) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setHighlightOn(boolean highlightOn) {
        if (this.highlightOn == highlightOn) {
            return;
        }
        this.highlightOn = highlightOn;
        this.firePropertyChange("highlightOn");
    }

    @Override
    public boolean getHighlightOn() {
        return this.highlightOn;
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(status, null, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip) {
        this.setStatus(status, tooltip, null, null, null);
    }

    @Override
    public void setStatus(int status, String tooltip, String title, String content, HyperlinkListener listener) {
        PFDStatus newStatus = PFDStatus.getInstance(status);
        newStatus.putValue("Tooltip", tooltip);
        newStatus.putValue("MessageTitle", title);
        newStatus.putValue("MessgeContent", content);
        newStatus.putValue("MessageHyperlinkListener", listener);
        this.setStatus(newStatus);
    }

    @Override
    public void setStatus(PFDStatus status) {
        this.statusUtil.setStatus(status);
        PFDAbstractAction action = this.statusUtil.getAction();
        this.statusButton.setAction(action);
        if (action == null) {
            if (this.containsPrimitive(this.statusButton)) {
                this.removePrimitive(this.statusButton);
            }
        } else if (!this.containsPrimitive(this.statusButton)) {
            int index = this.indexOfPrimitive(this.buttonGroup);
            this.addPrimitive(index, this.statusButton);
            this.statusButton.setVisible(this.visible);
        } else {
            this.layoutStatusButton();
            this.updatePortClipArea();
            this.firePropertyChange("bbox");
        }
        PFDMessageWindow newWindow = this.statusUtil.getMessageWindow();
        if (this.statusWindow != null && this.containsPrimitive(this.statusWindow)) {
            this.removePrimitive(this.statusWindow);
        }
        this.statusWindow = newWindow;
        if (status.getValue("MessageVisible") instanceof Boolean && ((Boolean)status.getValue("MessageVisible")).booleanValue()) {
            this.setWindowVisible(this.statusWindow, true);
        }
        this.firePropertyChange("status");
    }

    @Override
    public int getStatus() {
        return this.statusUtil.getStatus();
    }

    @Override
    public PFDStatus getStatusObject() {
        return this.statusUtil.getStatusObject();
    }

    public void setNodeStyleContext(String styleContext) {
        if (styleContext == null || styleContext.equals(this.nodeStyleContext)) {
            return;
        }
        this.nodeStyleContext = styleContext;
        this.firePropertyChange("nodeStyle");
    }

    public String getNodeStyleContext() {
        return this.nodeStyleContext;
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        FillStyleElement fse = style.getFillStyleElement(this.nodeStyleContext);
        if (fse != null) {
            String hctString = System.getProperty("HIGH_CONTRAST_TESTING");
            if (hctString != null) {
                this.setUseGradientFill(false);
            } else {
                this.setUseGradientFill(fse.getFillType() == 1);
            }
            this.setFillColor(fse.getFillColor());
            Color top = fse.getFillGradientStartColor();
            Color bottom = fse.getFillGradientEndColor();
            this.setGradientColorTop(top);
            this.setGradientColorBottom(bottom);
            Color blend = PFDUtil.blend(top, bottom, 0.5);
            if (this.inputPortGroup != null) {
                this.inputPortGroup.setPortColor(blend);
            }
            if (this.outputPortGroup != null) {
                this.outputPortGroup.setPortColor(blend);
            }
        }
        this.updateProgressBarStyle();
        this.updateStatusOutline();
    }

    private void updateStatusOutline() {
        if (this.model == null) {
            return;
        }
        Style style = this.model.getStyle();
        this.statusUtil.updateStatusObject(style);
        if (style == null) {
            return;
        }
        PFDStatus status = this.statusUtil.getStatusObject();
        Color statusLineColor = null;
        Number statusLineThickness = null;
        if (status != null) {
            statusLineColor = (Color)status.getValue("LineColor");
            statusLineThickness = (Number)status.getValue("LineThickness");
        }
        String context = this.highlightOn ? "Highlight" : this.nodeStyleContext;
        LineStyleElement lse = style.getLineStyleElement(context);
        if (statusLineColor != null) {
            this.setOutlineColor(statusLineColor);
        } else if (lse != null) {
            this.setOutlineColor(lse.getLineColor());
        } else {
            this.setOutlineColor(Color.BLACK);
        }
        if (statusLineThickness != null) {
            this.setOutlineWidth(statusLineThickness.floatValue());
        } else if (lse != null) {
            this.setOutlineWidth(lse.getLineThickness().toPixels(0, 0));
        } else {
            this.setOutlineWidth(1.0f);
        }
    }

    public void updateNotes() {
        if (this.note == null) {
            if (this.noteButton != null) {
                this.removePrimitive(this.noteButton);
                this.noteButton = null;
            }
        } else if (this.noteButton == null) {
            this.noteButton = new PFDButton();
            this.noteButton.setAction(this.getAction("ACTION_OPEN_QUICK_NOTE"));
            this.noteButton.setIcon(PFDIconManager.getIcon("StickyNote_yellow8.gif"));
            this.noteButton.setRolloverIcon(PFDIconManager.getIcon("StickyNote_yellow12.gif"));
            this.noteButton.setRolloverEnabled(true);
            this.addPrimitive(this.noteButton);
        }
    }

    @Override
    public Point getSpotLocation(int spot, Point p) {
        return this.nodeShape.getSpotLocation(spot, p);
    }

    public PFDProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(PFDProgressBar bar) {
        if (bar == this.progressBar) {
            return;
        }
        if (this.progressBar != null) {
            this.progressBar.removeChangeListener(this);
            this.removePrimitive(this.progressBar);
        }
        this.progressBar = bar;
        if (this.progressBar != null) {
            this.progressBar.addChangeListener(this);
            this.addPrimitive(this.progressBar);
            this.updateProgressBarStyle();
        }
        this.firePropertyChange("progressBar");
    }

    private void updateProgressBarStyle() {
        Style s;
        if (this.progressBar == null || this.model == null || (s = this.model.getStyle()) == null) {
            return;
        }
        StyleElement se = s.getStyleElement("ProgressBar");
        if (se != null) {
            this.progressBar.getBrush().setColor(se.getColorAttribute("fillColor", Color.black));
            this.progressBar.getPen().setColor(se.getColorAttribute("lineColor", Color.black));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.progressBar) {
            this.firePropertyChange("progressBar");
        }
    }

    @Override
    public boolean isGhosted() {
        return this.ghosted;
    }

    @Override
    public void setGhosted(boolean b) {
        if (this.ghosted == b) {
            return;
        }
        this.ghosted = b;
        this.firePropertyChange("ghosted");
    }

    @Override
    public PFDButtonCollection getIndicatorButtons() {
        return this.buttonGroup;
    }

    @Override
    protected void setNoteLocation() {
        if (this.noteButton == null) {
            super.setNoteLocation();
        } else if (this.note != null) {
            this.note.setLocation(this.noteButton.getX() + PFDCompositeNode.noteOffset.width, this.noteButton.getY() + PFDCompositeNode.noteOffset.height);
        }
    }

    @Override
    public void setWindowVisible(PFDWindow window, boolean visible) {
        if (window != this.statusWindow) {
            return;
        }
        if (visible) {
            if (!this.containsPrimitive(this.statusWindow)) {
                this.addPrimitive(this.statusWindow);
                this.statusUtil.getStatusObject().putValue("MessageVisible", Boolean.TRUE);
            }
        } else {
            this.removePrimitive(this.statusWindow);
            this.statusUtil.getStatusObject().putValue("MessageVisible", null);
        }
    }

    protected void layoutStatusWindow() {
        if (this.statusWindow != null) {
            this.statusWindow.setLocation(this.statusButton.getX() + this.statusButton.getWidth() / 2 + PFDCompositeNode.statusDetailsOffset.width, this.statusButton.getY() + this.statusButton.getHeight() / 2 + PFDCompositeNode.statusDetailsOffset.height);
        }
    }

    @Override
    public List getMenuItems() {
        List items = super.getMenuItems();
        items.add(new JPopupMenu.Separator());
        if (this.noteMenu == null) {
            this.noteMenu = this.createNoteMenu();
        }
        items.add(this.noteMenu);
        if (this.hasTableData()) {
            Action action = this.getAction("ACTION_TOGGLE_NODE_TABLE_VISIBLE");
            items.add(PFDMenuUtil.createCheckBoxMenuItem(action));
        }
        return items;
    }

    @Override
    public void setNodeOrder(int order) {
        if (this.nodeNumber == null) {
            this.nodeNumber = new PFDNodeNumber();
        }
        if (this.nodeNumber.getNumber() == order) {
            return;
        }
        this.nodeNumber.setNumber(order);
        this.firePropertyChange("nodeNumber");
    }

    @Override
    public int getNodeOrder() {
        if (this.nodeNumber == null) {
            return 0;
        }
        return this.nodeNumber.getNumber();
    }

    @Override
    public void setNodeOrderVisible(boolean visible) {
        if (this.nodeNumber == null) {
            if (visible) {
                this.nodeNumber = new PFDNodeNumber();
                this.addPrimitive(this.nodeNumber);
            }
        } else {
            if (visible == this.nodeNumber.isVisible()) {
                return;
            }
            this.nodeNumber.setVisible(visible);
            if (visible) {
                this.addPrimitive(this.nodeNumber);
            } else {
                this.removePrimitive(this.nodeNumber);
            }
        }
        this.firePropertyChange("nodeNumber");
    }

    @Override
    public boolean isNodeOrderVisible() {
        if (this.nodeNumber == null) {
            return false;
        }
        return this.nodeNumber.isVisible();
    }

    public PFDPortGroup getOutputPortGroup() {
        return this.outputPortGroup;
    }

    public PFDPortGroup getInputPortGroup() {
        return this.inputPortGroup;
    }

    @Override
    public void selectArea(PFDView v, Rectangle area) {
        if (this.isVisible() && this.isSelectable() && area.contains(this.nodeShape.getRBBox())) {
            v.selectPrimitive(this);
        }
    }

    @Override
    public void setTable(JTable table) {
        if (table == this.dataTable) {
            return;
        }
        if (this.dataTable != null) {
            this.dataTable.removePropertyChangeListener(this);
            if (this.dataTable.getModel() != null) {
                this.dataTable.getModel().removeTableModelListener(this);
            }
        }
        this.dataTable = table;
        if (this.dataTable != null) {
            this.dataTable.addPropertyChangeListener(this);
            if (this.dataTable.getModel() != null) {
                this.dataTable.getModel().addTableModelListener(this);
            }
        }
        this.firePropertyChange("table");
    }

    @Override
    public JTable getTable() {
        return this.dataTable;
    }

    private boolean hasTableData() {
        if (this.dataTable == null) {
            return false;
        }
        TableModel m = this.dataTable.getModel();
        if (m == null) {
            return false;
        }
        return m.getColumnCount() != 0 && m.getRowCount() != 0;
    }

    protected boolean canShowTable() {
        return this.tableVisible && this.hasTableData();
    }

    @Override
    public boolean isTableVisible() {
        return this.tableVisible;
    }

    @Override
    public void setTableVisible(boolean tableVisible) {
        if (this.tableVisible == tableVisible) {
            return;
        }
        this.tableVisible = tableVisible;
        this.firePropertyChange("tableVisible");
    }

    @Override
    public void setPreferredTableRowCount(int numRows) {
        if (this.preferredTableRowCount == numRows) {
            return;
        }
        this.preferredTableRowCount = numRows;
        this.firePropertyChange("preferredTableRowCount");
    }

    @Override
    public int getPreferredTableRowCount() {
        return this.preferredTableRowCount;
    }

    @Override
    public void setMinTableRowCount(int numRows) {
        if (this.minTableRowCount == numRows) {
            return;
        }
        this.minTableRowCount = numRows;
        this.firePropertyChange("minTableRowCount");
    }

    @Override
    public int getMinTableRowCount() {
        return this.minTableRowCount;
    }

    @Override
    public void setMaxTableRowCount(int numRows) {
        if (this.maxTableRowCount == numRows) {
            return;
        }
        this.maxTableRowCount = numRows;
        this.firePropertyChange("maxTableRowCount");
    }

    @Override
    public int getMaxTabeRowCount() {
        return this.maxTableRowCount;
    }

    private void updateTable() {
        if (this.tablePrimitive != null) {
            if (this.dataTable == null) {
                this.tablePrimitive.setComponent(null);
                this.resizeHotSpot.removeMouseListener(this);
                this.resizeHotSpot.removeMouseMotionListener(this);
                this.disableChangeUpdate();
                this.removePrimitive(this.tablePrimitive);
                this.tablePrimitive = null;
                this.enableChangeUpdate();
                this.removePrimitive(this.resizeHotSpot);
                this.resizeHotSpot = null;
            } else {
                this.tablePrimitive.setComponent(new PFDScrollPane(this.dataTable));
            }
        } else if (this.dataTable != null) {
            this.tablePrimitive = new PFDComponentPrimitive(new PFDScrollPane(this.dataTable));
            this.resizeHotSpot = new PFDEmptyPrimitive();
            this.resizeHotSpot.addMouseListener(this);
            this.resizeHotSpot.addMouseMotionListener(this);
        }
        this.updateTableSize(true);
        this.updateTableVisibility();
    }

    private void updateTableVisibility() {
        boolean visible = this.canShowTable();
        Action a = this.getAction("ACTION_TOGGLE_NODE_TABLE_VISIBLE");
        a.putValue("pfdAbstractAction.selected", new Boolean(visible));
        if (visible) {
            this.setResizable(true);
            if (!this.containsPrimitive(this.tablePrimitive)) {
                this.addPrimitive(this.tablePrimitive);
            }
            if (!this.containsPrimitive(this.resizeHotSpot)) {
                int index = this.portStyle == 0 ? this.indexOfPrimitive(this.outputPortGroup) : this.indexOfPrimitive(this.nodeDragHotspot) + 1;
                index = Math.min(index, this.getNumPrimitives());
                this.addPrimitive(index, this.resizeHotSpot);
            }
        } else if (this.tablePrimitive != null) {
            this.removePrimitive(this.tablePrimitive);
            this.removePrimitive(this.resizeHotSpot);
        }
        this.updateTableResizability();
    }

    private void updateTableResizability() {
        if (this.canShowTable() && this.getTableMinHeight() < this.getTableMaxHeight()) {
            this.setResizable(true);
        } else {
            this.setResizable(false);
        }
    }

    private void setTableHeight(int height) {
        JComponent comp;
        if (this.dataTable != null && this.tablePrimitive != null && (comp = this.tablePrimitive.getComponent()) != null) {
            Dimension minSize = comp.getMinimumSize();
            Dimension maxSize = comp.getMaximumSize();
            height = Math.max(height, minSize.height);
            height = Math.min(height, maxSize.height);
        }
        if (this.tableSize == height) {
            return;
        }
        this.tableSize = height;
        this.firePropertyChange("tableHeight");
    }

    private int getTableHeight() {
        return this.tableSize;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        if (!this.resizable) {
            return;
        }
        int dy = h - this.bbox.height;
        this.setTableHeight(this.getTableHeight() + dy);
    }

    private void updateTableSize(boolean setPreferred) {
        JComponent comp;
        if (this.dataTable == null || this.tablePrimitive == null || (comp = this.tablePrimitive.getComponent()) == null) {
            return;
        }
        this.tableRowCount = this.dataTable.getRowCount();
        int min = this.getTableMinHeight();
        int max = this.getTableMaxHeight();
        int pref = this.getTablePreferredHeight();
        if (max < min) {
            max = min;
        }
        if (pref < min) {
            pref = min;
        }
        if (pref > max) {
            pref = max;
        }
        JScrollPane scrollPane = (JScrollPane)comp;
        Insets insets = scrollPane.getInsets();
        int height = insets.top + insets.bottom;
        Border viewportBorder = scrollPane.getViewportBorder();
        if (viewportBorder != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(scrollPane);
            height += vpbInsets.top + vpbInsets.bottom;
        }
        pref += height;
        comp.setMinimumSize(new Dimension(this.nodeWidth - 6, min += height));
        comp.setMaximumSize(new Dimension(this.nodeWidth - 6, max += (height += this.getTableHeaderHeight())));
        if (setPreferred) {
            this.tableSize = pref;
        } else if (this.tableSize < min) {
            this.tableSize = min;
        } else if (this.tableSize > max) {
            this.tableSize = max;
        }
    }

    private int getTableHeaderHeight() {
        if (this.dataTable == null) {
            return 0;
        }
        JTableHeader header = this.dataTable.getTableHeader();
        int headerHeight = 0;
        if (header != null) {
            headerHeight += header.getPreferredSize().height;
        }
        return headerHeight;
    }

    private int getTableMinHeight() {
        if (this.dataTable == null) {
            return 0;
        }
        int numRows = Math.max(0, Math.min(this.dataTable.getRowCount(), this.minTableRowCount));
        int rowHeight = this.dataTable.getRowHeight();
        int minHeight = numRows * rowHeight;
        return minHeight;
    }

    private int getTableMaxHeight() {
        if (this.dataTable == null) {
            return 0;
        }
        int numRows = Math.max(0, Math.min(this.dataTable.getRowCount(), this.maxTableRowCount));
        int rowHeight = this.dataTable.getRowHeight();
        int maxHeight = numRows * rowHeight;
        return maxHeight;
    }

    private int getTablePreferredHeight() {
        if (this.dataTable == null) {
            return 0;
        }
        int numRows = Math.max(0, Math.min(this.dataTable.getRowCount(), this.preferredTableRowCount));
        int rowHeight = this.dataTable.getRowHeight();
        int maxHeight = numRows * rowHeight;
        return maxHeight;
    }

    @Override
    protected Action createAction(String actionKey) {
        if (actionKey == null) {
            return null;
        }
        if (actionKey.equals("ACTION_TOGGLE_NODE_TABLE_VISIBLE")) {
            return new PFDToggleNodeTableVisibleAction(this);
        }
        return super.createAction(actionKey);
    }

    public void setTitleTextWrapEnabled(boolean b) {
        this.titleText.setTruncateLines(!b);
    }

    public boolean isTitleTextWrapEnabled() {
        return !this.titleText.isTruncateLines();
    }

    public void setContentTextWrapEnabled(boolean b) {
        this.contentText.setTruncateLines(!b);
    }

    public boolean isContentTextWrapEnabled() {
        return !this.contentText.isTruncateLines();
    }

    @Override
    public void setPortStyle(int portStyle) {
        if (this.portStyle == portStyle) {
            return;
        }
        if (portStyle != 0 && portStyle != 1) {
            throw new IllegalArgumentException("Specified portStyle is not supported");
        }
        this.portStyle = portStyle;
        this.initPortStyle();
        this.layoutChildren();
        this.firePropertyChange("portStyle");
    }

    @Override
    public int getPortStyle() {
        return this.portStyle;
    }

    private void initPortStyle() {
        if (this.portStyle == 1) {
            PFDLink link;
            int i;
            PFDPort port;
            int j;
            this.inputCenterPort = new PFDPort();
            this.inputCenterPort.removeMouseListener(this.inputCenterPort);
            this.inputCenterPort.removeMouseMotionListener(this.inputCenterPort);
            this.inputCenterPort.setFromLinkSpot(9);
            this.inputCenterPort.setToLinkSpot(9);
            this.inputCenterPort.setValidFromPort(false);
            this.inputCenterPort.setValidToPort(true);
            this.inputCenterPort.setType(0);
            this.outputCenterPort = new PFDPort();
            this.outputCenterPort.removeMouseListener(this.outputCenterPort);
            this.outputCenterPort.removeMouseMotionListener(this.outputCenterPort);
            this.outputCenterPort.setFromLinkSpot(9);
            this.outputCenterPort.setToLinkSpot(9);
            this.outputCenterPort.setValidFromPort(true);
            this.outputCenterPort.setValidToPort(false);
            this.outputCenterPort.setType(0);
            for (j = 0; j < this.inputPortGroup.getNumPorts(); ++j) {
                port = this.inputPortGroup.getPort(j);
                for (i = 0; i < port.getNumLinks(); ++i) {
                    link = port.getLink(i);
                    link.setToPort(this.inputCenterPort);
                }
            }
            for (j = 0; j < this.outputPortGroup.getNumPorts(); ++j) {
                port = this.outputPortGroup.getPort(j);
                for (i = 0; i < port.getNumLinks(); ++i) {
                    link = port.getLink(i);
                    link.setFromPort(this.outputCenterPort);
                }
            }
            this.addPrimitive(0, this.inputCenterPort);
            this.addPrimitive(1, this.outputCenterPort);
            int iconIndex = this.indexOfPrimitive(this.nodeIcon);
            this.linkDragHotspot = new PFDEmptyPrimitive();
            this.addPrimitive(iconIndex + 1, this.linkDragHotspot);
            this.nodeDragHotspot = new PFDEmptyPrimitive();
            this.addPrimitive(iconIndex + 2, this.nodeDragHotspot);
            this.linkDragHotspot.addMouseListener(this);
            this.linkDragHotspot.addMouseMotionListener(this);
            this.nodeDragHotspot.addMouseListener(this);
            this.nodeDragHotspot.addMouseMotionListener(this);
            this.removePrimitive(this.inputPortGroup);
            this.removePrimitive(this.outputPortGroup);
            this.inputPortGroup.removeAllPorts();
            this.inputPortGroup = null;
            this.outputPortGroup.removeAllPorts();
            this.outputPortGroup = null;
            this.nodeShape.removeMouseListener(this);
            this.nodeShape.removeMouseMotionListener(this);
            this.nodeIcon.removeMouseListener(this);
            this.nodeIcon.removeMouseMotionListener(this);
        } else {
            this.inputPortGroup = new PFDPortGroup(0);
            this.inputPortGroup.addPort(new PFDPort());
            this.outputPortGroup = new PFDPortGroup(1);
            this.outputPortGroup.addPort(new PFDPort());
            this.addPrimitive(0, this.inputPortGroup);
            this.addPrimitive(this.indexOfPrimitive(this.nodeIcon) + 1, this.outputPortGroup);
            this.removePrimitive(this.inputCenterPort);
            this.removePrimitive(this.outputCenterPort);
            this.removePrimitive(this.linkDragHotspot);
            this.removePrimitive(this.nodeDragHotspot);
            this.inputCenterPort = null;
            this.outputCenterPort = null;
            this.linkDragHotspot = null;
            this.nodeDragHotspot = null;
            this.nodeShape.addMouseListener(this);
            this.nodeShape.addMouseMotionListener(this);
            this.nodeIcon.addMouseListener(this);
            this.nodeIcon.addMouseMotionListener(this);
        }
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        if (this.dataTable != null) {
            this.dataTable.removePropertyChangeListener(this);
            if (this.dataTable.getModel() != null) {
                this.dataTable.getModel().removeTableModelListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.dataTable && evt.getPropertyName() == "model") {
            Object newModel;
            Object oldModel = evt.getOldValue();
            if (oldModel instanceof TableModel) {
                ((TableModel)oldModel).removeTableModelListener(this);
            }
            if ((newModel = evt.getNewValue()) instanceof TableModel) {
                ((TableModel)newModel).addTableModelListener(this);
            }
            this.resetTableToPreferredSize = true;
            this.firePropertyChange("tableModel");
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean sizeChanged = false;
        TableModel m = (TableModel)e.getSource();
        this.resetTableToPreferredSize = m.getRowCount() > this.tableRowCount && this.tableRowCount < this.preferredTableRowCount;
        this.firePropertyChange("tableModel");
    }

    protected void setLinkDragShadingVisible(boolean visible) {
        if (this.linkDragShadingVisible == visible) {
            return;
        }
        this.linkDragShadingVisible = visible;
        if (this.theView != null) {
            this.theView.repaint(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setStatus(0);
        this.pending = new PropertyList();
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 400: {
                return this.getNodeIconResourceLocation();
            }
            case 401: {
                return this.highlightOn;
            }
            case 402: {
                return this.nodeStyleContext;
            }
            case 403: {
                if (this.portStyle == 0) {
                    return "bidirectional";
                }
                return "omnidirectional";
            }
            case 404: {
                return this.titleText.getText();
            }
            case 405: {
                return this.contentText.getText();
            }
            case 406: {
                return this.note.getText();
            }
            case 407: {
                return this.note.isVisible();
            }
            case 410: {
                return this.getPFDItemId();
            }
            case 408: {
                return this.getSpotLocation((int)1, null).x;
            }
            case 409: {
                return this.getSpotLocation((int)1, null).y;
            }
            case 411: {
                return this.getStatus();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean userSet = false;
        switch (id) {
            case 400: {
                if (this.getNodeIcon() == this.DEFAULT_icon) break;
                userSet = true;
                break;
            }
            case 401: {
                if (this.highlightOn == this.DEFAULT_highlightOn) break;
                userSet = true;
                break;
            }
            case 402: {
                if (this.nodeStyleContext.equalsIgnoreCase(this.DEFAULT_style)) break;
                userSet = true;
                break;
            }
            case 403: {
                if (this.portStyle == this.DEFAULT_portType) break;
                userSet = true;
                break;
            }
            case 404: {
                if (this.titleText.getText() == this.DEFAULT_title) break;
                userSet = true;
                break;
            }
            case 405: {
                if (this.contentText.getText() == this.DEFAULT_details) break;
                userSet = true;
                break;
            }
            case 406: {
                if (this.note.getText() == this.DEFAULT_comments) break;
                userSet = true;
                break;
            }
            case 407: {
                if (this.isNoteVisible() == this.DEFAULT_commentsVisible.booleanValue()) break;
                userSet = true;
                break;
            }
            case 411: {
                if (this.getStatusObject() == null) break;
                return true;
            }
            case 408: 
            case 409: 
            case 410: {
                userSet = true;
            }
        }
        return userSet;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 400: {
                URL imgURL;
                if (value instanceof ImageIcon) {
                    this.setNodeIcon((ImageIcon)value);
                    break;
                }
                if (!(value instanceof String) || (imgURL = this.getClass().getResource((String)value)) == null) break;
                ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL));
                ImageIcon scaledIcon = new ImageIcon(icon.getImage().getScaledInstance(16, 16, 4));
                this.setNodeIconResourceLocation((String)value);
                this.setNodeIcon(scaledIcon);
                break;
            }
            case 402: {
                if (!(value instanceof String)) break;
                this.setNodeStyleContext((String)value);
                break;
            }
            case 403: {
                if (!(value instanceof String)) break;
                if (((String)value).equalsIgnoreCase("bidirectional")) {
                    this.setPortStyle(0);
                    break;
                }
                if (!((String)value).equalsIgnoreCase("omnidirectional")) break;
                this.setPortStyle(1);
                break;
            }
            case 405: {
                if (!(value instanceof String)) break;
                this.setContentText((String)value);
                break;
            }
            case 406: {
                if (!(value instanceof String)) break;
                this.setNoteText((String)value);
                break;
            }
            case 407: {
                if (!(value instanceof Boolean)) break;
                this.setNoteVisible((Boolean)value);
                break;
            }
            case 404: {
                if (!(value instanceof String)) break;
                this.setTitleText((String)value);
                break;
            }
            case 401: {
                if (!(value instanceof Boolean)) break;
                this.setHighlightOn((Boolean)value);
                break;
            }
            case 410: {
                if (!(value instanceof String)) break;
                this.setPFDItemId((String)value);
                break;
            }
            case 408: {
                if (!(value instanceof Integer)) break;
                if (this.pendingLocationY != -1000) {
                    this.setSpotLocation(1, new Point((Integer)value, this.pendingLocationY));
                    this.pendingLocationY = -1000;
                    break;
                }
                this.pendingLocationX = (Integer)value;
                break;
            }
            case 409: {
                if (!(value instanceof Integer)) break;
                if (this.pendingLocationX != -1000) {
                    this.setSpotLocation(1, new Point(this.pendingLocationX, (Integer)value));
                    this.pendingLocationX = -1000;
                    break;
                }
                this.pendingLocationY = (Integer)value;
                break;
            }
            case 411: {
                if (!(value instanceof PFDStatus)) break;
                this.setStatus((PFDStatus)value);
            }
        }
    }
}

