/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class PFDComponentPrimitive
extends PFDPrimitive
implements ComponentListener {
    private static final long serialVersionUID = -3553709915521217068L;
    private static final Color overviewColor = Color.gray;
    private transient Component draggedComponent;
    private transient Component mouseOverComponent;
    protected transient JComponent comp;
    protected Dimension prefSize;

    public PFDComponentPrimitive() {
        this((JComponent)null);
    }

    public PFDComponentPrimitive(JComponent c) {
        this.initializeComponent(c);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public PFDComponentPrimitive(JComponent c, Point p, Dimension size) {
        super(new Rectangle(p, size));
        this.initializeComponent(c);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public PFDComponentPrimitive(JComponent c, Rectangle r) {
        super(r);
        this.initializeComponent(c);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void initializeComponent(JComponent c) {
        Container parent;
        if (this.comp != null && (parent = this.comp.getParent()) instanceof PFDView) {
            parent.remove(this.comp);
            parent.removeComponentListener(this);
        }
        this.comp = c;
        if (this.comp != null) {
            if (this.theView != null && this.theView != this.comp.getParent()) {
                this.theView.add((Component)this.comp, this);
                this.theView.addComponentListener(this);
            }
            this.prefSize = this.comp.getPreferredSize();
            this.unregisterToolTips(this.comp);
        }
    }

    private void unregisterToolTips(Component c) {
        if (c instanceof JComponent) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)c);
        }
        if (c instanceof Container) {
            Container container = (Container)c;
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.unregisterToolTips(container.getComponent(i));
            }
        }
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void setComponent(JComponent c) {
        if (this.comp == c) {
            return;
        }
        this.initializeComponent(c);
        this.firePropertyChange("component");
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.comp.setVisible(b);
    }

    @Override
    public String getToolTipText() {
        if (this.comp != null) {
            return this.comp.getToolTipText();
        }
        return super.getToolTipText();
    }

    @Override
    public void setToolTipText(String text) {
        this.comp.setToolTipText(text);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.comp == null) {
            return null;
        }
        MouseEvent componentEvent = this.convertMouseEvent(event);
        Component dest = this.mouseOverComponent;
        if (dest instanceof JComponent) {
            MouseEvent componentMouseEvent = SwingUtilities.convertMouseEvent(this.comp, componentEvent, dest);
            return ((JComponent)dest).getToolTipText(componentMouseEvent);
        }
        return super.getToolTipText(event);
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        g2d.translate(this.bbox.x, this.bbox.y);
        this.pen.apply(g2d);
        this.comp.paint(g2d);
        g2d.translate(-this.bbox.x, -this.bbox.y);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible) {
            return;
        }
        g2d.setColor(overviewColor);
        g2d.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
    }

    @Override
    protected void update(String property, PFDView v) {
        if ((property.equals("all") || property.equals("bbox") || property.equals("component")) && this.comp != null) {
            boolean sizeChanged;
            this.attachView(v);
            Dimension cs = this.comp.getSize();
            Dimension ps = this.getSize();
            boolean bl = sizeChanged = cs.width != ps.width || cs.height != ps.height;
            if (sizeChanged) {
                this.comp.addNotify();
                this.comp.setBounds(v.getWidth() * 2, v.getHeight() * 2, ps.width, ps.height);
                this.comp.validate();
            }
        }
        super.update(property, v);
    }

    @Override
    protected void attachView(PFDView v) {
        super.attachView(v);
        if (v != null && this.comp != null && v != this.comp.getParent()) {
            v.add((Component)this.comp, this);
            v.addComponentListener(this);
        }
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        if (v != null && this.comp != null) {
            v.remove(this.comp);
            v.removeComponentListener(this);
        }
    }

    @Override
    protected void removeAssociation() {
        super.removeAssociation();
        Container parent = this.getComponent().getParent();
        if (parent instanceof PFDView) {
            this.detachView((PFDView)parent);
        }
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDComponentPrimitive clone = new PFDComponentPrimitive();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDComponentPrimitive toObject) {
        super.copyObject(toObject);
        toObject.setComponent(this.getComponent());
    }

    private MouseEvent convertMouseEvent(MouseEvent e) {
        MouseEvent componentEvent = new MouseEvent(this.comp, e.getID(), e.getWhen(), e.getModifiers(), e.getX() - this.bbox.x, e.getY() - this.bbox.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return componentEvent;
    }

    private void fireComponentMouseEvent(MouseEvent e) {
        Component dest;
        if (this.comp == null) {
            return;
        }
        MouseEvent componentEvent = this.convertMouseEvent(e);
        this.draggedComponent = dest = this.getMouseoverComponent(componentEvent);
        if (dest != null) {
            MouseEvent componentMouseEvent = SwingUtilities.convertMouseEvent(this.comp, componentEvent, dest);
            dest.dispatchEvent(componentMouseEvent);
        }
    }

    private Component getMouseoverComponent(MouseEvent e) {
        Component newComponent = SwingUtilities.getDeepestComponentAt(this.comp, e.getX(), e.getY());
        if (this.mouseOverComponent != newComponent) {
            if (this.mouseOverComponent != null) {
                Point exitPoint = SwingUtilities.convertPoint(this.comp, e.getX(), e.getY(), this.mouseOverComponent);
                MouseEvent exitEvent = new MouseEvent(this.mouseOverComponent, 505, e.getWhen(), e.getModifiers(), exitPoint.x, exitPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                this.mouseOverComponent.dispatchEvent(exitEvent);
            }
            this.mouseOverComponent = newComponent;
            if (this.mouseOverComponent != null) {
                Point enterPoint = SwingUtilities.convertPoint(this.comp, e.getX(), e.getY(), this.mouseOverComponent);
                MouseEvent enterEvent = new MouseEvent(this.mouseOverComponent, 504, e.getWhen(), e.getModifiers(), enterPoint.x, enterPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                this.mouseOverComponent.dispatchEvent(enterEvent);
            }
        }
        return this.mouseOverComponent;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.theView.setMouseOverPrimitive(this, e);
        this.fireComponentMouseEvent(e);
        this.theView.setDragMode(8);
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.theView.setMouseOverPrimitive(this, e);
        this.fireComponentMouseEvent(e);
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.theView.setMouseOverPrimitive(this, e);
        this.fireComponentMouseEvent(e);
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        MouseEvent componentEvent = this.convertMouseEvent(e);
        if (this.mouseOverComponent != null) {
            MouseEvent exitEvent = SwingUtilities.convertMouseEvent(this.comp, componentEvent, this.mouseOverComponent);
            this.mouseOverComponent.dispatchEvent(exitEvent);
            this.mouseOverComponent = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.theView.setMouseOverPrimitive(this, e);
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.theView.setMouseOverPrimitive(this, e);
        this.fireComponentMouseEvent(e);
        if (this.mouseOverComponent != null) {
            this.theView.setCursor(this.mouseOverComponent.getCursor());
        }
        e.consume();
    }

    public void fireDraggedComponentMouseEvent(MouseEvent e) {
        if (this.draggedComponent != null) {
            MouseEvent componentEvent = this.convertMouseEvent(e);
            this.getMouseoverComponent(componentEvent);
            this.draggedComponent.dispatchEvent(SwingUtilities.convertMouseEvent(this.comp, componentEvent, this.draggedComponent));
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.theView == null || this.theView != e.getSource()) {
            return;
        }
        this.comp.setBounds(this.theView.getWidth() * 2, this.theView.getHeight() * 2, this.getWidth(), this.getHeight());
        this.comp.validate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

