/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import java.awt.image.RGBImageFilter;

public class PFDColorFilter
extends RGBImageFilter {
    private int filterRed;
    private int filterGreen;
    private int filterBlue;
    private double filterAlpha;

    public PFDColorFilter(int filterColor) {
        this.filterAlpha = (double)((filterColor & 0xFF000000) >> 24) / 255.0;
        this.filterRed = (filterColor & 0xFF0000) >> 16;
        this.filterGreen = (filterColor & 0xFF00) >> 8;
        this.filterBlue = filterColor & 0xFF;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int a = rgb & 0xFF000000;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        r = (int)((double)r * this.filterAlpha + (double)this.filterRed * (1.0 - this.filterAlpha)) << 16;
        g = (int)((double)g * this.filterAlpha + (double)this.filterGreen * (1.0 - this.filterAlpha)) << 8;
        b = (int)((double)b * this.filterAlpha + (double)this.filterBlue * (1.0 - this.filterAlpha));
        return a | r | g | b;
    }
}

